<?php
	class SaleReturn{
	//conexion	
		private $link;
	//variables del sistema
		private $system_type;
		private $store_id;
		private $teller_id;//id de cajero
		private $teller_session_id;//id sesion de caja
		private $user;
		private $principal_warehouse;
		private $external_warehouse;
		private $store_return_prefix;

	//variables de la nota de venta
		private $was_payed;
		private $internal_counter = 0;
		private $internal_products = array();
		private $external_counter = 0;
		private $external_products = array();
		private $sale_amount;

		private $products_to_return;

		private $auxDesc;//descuento
		private $porcDesc;//porcentaje de descuento
		private $sale_id;

	//variables de la devolucion
		private $internal_return_id =-1;
		private $external_return_id =-1;
		private $internal_return_amount = 0;
		private $external_return_amount = 0;
		private $total_abonado = 0;

	//variables de los movimientos de almacen
	    private $internal_return_movement_id = -1;
	    private $external_return_movement_id = -1;

		function __construct( $connection, $store_id, $user ){
			$this->link = $connection;
			$this->store_id = $store_id;
			$this->user = $user;
			$this->getConfig();
		}
		public function getConfig(){
		//consulta sesion de cajero
			try{
				$sql="SELECT 
						IF(multicajero=1,0,
							(SELECT 
								id_cajero 
							FROM ec_sesion_caja 
							WHERE id_sucursal = {$this->store_id} 
							AND fecha=DATE_FORMAT(now(),'%Y-%m-%d') 
							AND hora_fin='00:00:00') 
						), 
						IF(multicajero=1,0,
							(SELECT 
								id_sesion_caja 
							FROM ec_sesion_caja 
							WHERE id_sucursal = {$this->store_id} 
							AND fecha=DATE_FORMAT(now(),'%Y-%m-%d') 
							AND hora_fin='00:00:00') 
						)
				FROM ec_configuracion_sucursal 
				WHERE id_sucursal = {$this->store_id}";
				$eje = $this->link->query( $sql );
				$r_c = $eje->fetch(PDO::FETCH_NUM);//_row
				$this->teller_id = $r_c[0];
				$this->teller_session_id = $r_c[1];
			}catch(PDOException $error){
				die( "Error al consultar si la sucursal es multicajero : {$sql} : {$error}" );
			}
		//consulta sucursal de acceso
			try{
				$sql_cons="SELECT id_sucursal FROM sys_sucursales WHERE acceso = 1";
				$eje_cons = $this->link->query( $sql_cons );
				$res_cons =  $eje_cons->fetch(PDO::FETCH_NUM);//_row
				$this->system_type = $res_cons[0];
			}catch(PDOException $error){
				die( "Error al consultar el tipo de sistema  : {$sql} : {$error}" );
			}
		//almacen principal de la sucursal 
			try{
				$sql="SELECT id_almacen FROM ec_almacen WHERE es_almacen=1 AND id_sucursal={$this->store_id}";
				$eje = $this->link->query($sql);
				$alm = $eje->fetch(PDO::FETCH_NUM);//_row
				$this->principal_warehouse = $alm[0];//almacén principal de la sucursal
			}catch(PDOException $error){
				die( "Error al consultar almacén principal : {$sql} : {$error}" );
			}
		//almacen externo de la sucursal y prefijo de la sucursal
			try{
				$sql="SELECT almacen_externo, 
							CONCAT('DEV',prefijo)  
					FROM sys_sucursales 
					WHERE id_sucursal = {$this->store_id}";
				$eje = $this->link->query($sql);
				$alm = $eje->fetch(PDO::FETCH_NUM);//_row
				$this->external_warehouse = $alm[0];//almacén principal de la sucursal
				$this->store_return_prefix = $alm[1];
			}catch(PDOException $error){
				die( "Error al consultar almacén principal : {$sql} : {$error}" );
			}
		}

		public function getProductsToReturnSinceValidation( $ticket_id ){
			$this->sale_id = $ticket_id;
			try{
				$sql = "SELECT 
							pd.id_pedido_detalle AS sale_detail_id,
							p.id_productos AS product_id,
							p.es_maquilado AS is_maquiled,
							SUM( IF( pvu.id_proveedor_producto IS NULL, pvu.piezas_devueltas, 0 ) ) AS return_quantity,
							sp.es_externo AS is_external
						FROM ec_pedidos_detalle pd
						LEFT JOIN ec_productos p
						ON p.id_productos = pd.id_producto
						LEFT JOIN sys_sucursales_producto sp
						ON sp.id_producto = pd.id_producto
						AND sp.id_sucursal = {$this->store_id}
						LEFT JOIN ec_pedidos_validacion_usuarios pvu
						ON pvu.id_pedido_detalle = pd.id_pedido_detalle
						WHERE pd.id_pedido = {$ticket_id}
						AND pvu.id_proveedor_producto IS NULL/*habilitado por Oscar 3 Noviembre 2022*/
						GROUP BY pd.id_pedido_detalle";
			//die  ( 'error|' . $sql );
				$stm = $this->link->query( $sql );
				$resp = array();
				while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
					if( $row['is_external'] == 0 ){
						array_push($this->internal_products, $row );
					}else{
						array_push($this->external_products, $row );
					}
				}
				$this->internal_counter = sizeof( $this->internal_products );
				$this->external_counter = sizeof( $this->external_products );
				return $resp;
			}catch(PDOException $error){
				die( "Error al consultar el detalle de la venta por devolver : {$sql} : {$error}" );
			}
		}

		public function setTicketData( $ticket_id ){
		//verifica si el pedido esta pagado
			try{
				$sql = "SELECT pagado FROM ec_pedidos WHERE id_pedido = {$ticket_id}";
				$eje = $this->link->query($sql);
				$pg = $eje->fetch(PDO::FETCH_NUM);//_row
				$this->was_payed = $pg[0];
			}catch(PDOException $error){
				die( "Error al consultar si el pedido ya está pagado : {$sql} : {$error}" );
			}
		}

	/*	public function getSaleInfo(  ){
		//verificamos si hay productos externos
		    $sql="SELECT 
		                SUM(IF(pd.id_pedido_detalle IS NULL,0,IF(pd.es_externo=0,1,0))) AS internos,
		                SUM(IF(pd.id_pedido_detalle IS NULL,0,IF(pd.es_externo=1,1,0))) AS externos,
		                ped.pagado
		            FROM ec_pedidos_detalle pd 
		            LEFT JOIN ec_pedidos ped ON pd.id_pedido=ped.id_pedido
		            WHERE ped.id_pedido='$idp'
		            GROUP BY pd.id_pedido_detalle";
		//si ya esta pagado el pedido           
		    if($esta_pagado==1){
		        $sql.=" AND pd.id_producto IN(";       
		        for($i=0;$i<$nitems;$i++){
		            $sql.=$_GET["idp{$i}"];
		            if($i<$nitems-1){
		                $sql.=",";//concatenamos coma
		            }else{
		                $sql.=")";//concatenamos cierre de paréntesis
		            }
		        }//fin de for $i
		    }
		    $eje = $this->link->query( $sql )or die("Error al consultar si hay productos externos por devolver : {$this->link->error}");
		    $dats = $eje->fetch_row();
		    $this->internal_counter = $dats[0];
		    $this->external_counter = $dats[1];
		    $this->was_payed = $dats[2];
		}*/

		public function insertReturnHeader( $ticket_id ){
		    for($i=0;$i<=1;$i++){
		        if( ( ($i == 0 && $this->internal_counter > 0) || ($i == 1 && $this->external_counter > 0) ) 
		        	|| $this->was_payed == 0 ){
		            $return_folio = $this->getNewFolio();
					try{
						$insD="INSERT INTO ec_devolucion(id_devolucion,id_usuario,id_sucursal,fecha,hora,id_pedido,folio,es_externo,observaciones,tipo_sistema,id_status_agrupacion)
								VALUES(NULL,'{$this->user}','{$this->store_id}',NOW(),NOW(),'{$ticket_id}','{$return_folio}',";
						if($i==0){
							$insD.="'0',";
						}else if($i==1){
							$insD.="'1',";
						}
						$insD.="'','".$this->system_type."',-1)";
						$dev = $this->link->query( $insD );
					//guarda id(s) de la(s) cabecera(s)
						if($i==0){
							$this->internal_return_id = $this->link->lastInsertId();//insert_id
						}else if($i==1){
							$this->external_return_id = $this->link->lastInsertId();//insert_id
						}
					}catch(PDOException $error){
						die( "Error al insertar encabezado de la devolución " . ( $i == 0 ? 'interna' : 'externa' ) . " : {$insD} : {$error}" );
					}
		        }
		    }//fin de for $i
		    return $this->link->lastInsertId();//insert_id;
		}
		public function getNewFolio(){
			try{
				$sql_fol = "SELECT
							CONCAT('{$this->store_return_prefix}',
								IF(
									ISNULL(MAX(CAST(REPLACE(folio, '{$this->store_return_prefix}', '') AS SIGNED INT))),
									1,
									MAX(CAST(REPLACE(folio, '{$this->store_return_prefix}', '') AS SIGNED INT))+1
								)
							) AS folio
							FROM ec_devolucion
							WHERE REPLACE(folio, '{$this->store_return_prefix}', '') REGEXP ('[0-9]')
							AND id_sucursal = '{$this->store_id}'";
				$eje_fol = $this->link->query( $sql_fol );
				$row_fol = $eje_fol->fetch(PDO::FETCH_ASSOC);//_assoc
				$new_folio = $row_fol['folio'];
				return $new_folio;
			}catch(PDOException $error){
				die("Error al generar el folio de la devolución : {$sql_fol} : {$error}" );
			}
		}

		public function insertReturnMovementHeader(  ){
			for($i=0;$i<=1;$i++){
		        if( ( $i == 0 && $this->internal_counter > 0 ) || ( $i == 1 && $this->external_counter > 0 ) ){
					$almacen_id = 0;
		            if($i==0){
		                $almacen_id = $this->principal_warehouse;
		            }else if($i==1){
		                $almacen_id = $this->external_warehouse;
		            }
					try{
						$insMov = "CALL spMovimientoAlmacen_inserta ( {$this->user}, 'DEVOLUCION', {$this->store_id}, {$almacen_id}, 12, -1, -1, -1, -1, 14, NULL )";
						$this->link->query( $insMov );
						if($i==0){
							try{
								$sql = "SELECT MAX( id_movimiento_almacen ) AS id_movimiento_almacen FROM ec_movimiento_almacen";
								$ma_stm = $this->link->query( $sql );
								$id_mov = $ma_stm->fetch(PDO::FETCH_ASSOC);//_assoc
								$this->internal_return_movement_id = $id_mov['id_movimiento_almacen'];//id asignado al movimiento de devolución
							}catch(PDOException $error){
								die( "Error al recuperar id ma insertado : {$sql} : {$error}" );
							}
						}
						if($i==1){
							try{
								$sql = "SELECT MAX( id_movimiento_almacen ) AS id_movimiento_almacen FROM ec_movimiento_almacen";
								$ma_stm = $this->link->query( $sql );
								$id_mov = $ma_stm->fetch(PDO::FETCH_ASSOC);//_assoc
								$this->external_return_movement_id = $id_mov['id_movimiento_almacen'];
							}catch(PDOException $error){
								die( "Error al recuperar id ma insertado : {$sql} : {$error}" );
							}
						}
					}catch(PDOException $error){
						die( "error|Error al insertar el encabezado de movimiento de almacén con entrada por devolución : {$insMov} : {$error}");
					}
		        }
    		}
		}
	
		public function insertReturnDetail(){
			$row = null;
			$ins_det = null;
			try{
				$sql = "SELECT pagado AS was_payed FROM ec_pedidos WHERE id_pedido = {$this->sale_id}";
				$stm = $this->link->query( $sql );
				$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
				$this->was_payed = $row['was_payed'];
			}catch(PDOException $error){
				die( "Error al verificar si la venta esta pagada : {$sql} : {$error}" );
			}

			if( $this->was_payed == 0 ){
				try{
					$sql = "SELECT pagado FROM ec_pedidos WHERE id_pedido = {$this->sale_id}";
					$stm = $this->link->query( $sql );
					$row = $stm->fetch(PDO::FETCH_NUM);//_row
					if( $row[0] == 1 ){
						die( "La nota esta pagada y no debe de entrar en esta condicion." );
					}
				}catch(PDOException $error){
					die( "Error al consultar si el pedido esta pagado : {$sql} : {$error}" );
				}
				try{
					$sql ="SELECT 
								IF( pd.es_externo = 1,
									{$this->external_return_movement_id},
									{$this->internal_return_movement_id}
								) AS movement_header_id,
								IF(p.id_producto_ordigen IS NULL,pd.id_producto,p.id_producto_ordigen) AS product_id,
								IF(p.id_producto_ordigen IS NULL,pd.cantidad,(pd.cantidad*p.cantidad)) AS quantity
							FROM ec_pedidos_detalle pd
							LEFT JOIN ec_productos_detalle p 
							ON p.id_producto=pd.id_producto
							WHERE pd.id_pedido = {$this->sale_id}";
					$stm = $this->link->query( $sql ) or die( "Error al consultar todo el detalle de movimiento devolución : {$this->link->error}" );
					while( $dev_row = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc
						try{
							$sql = "CALL spMovimientoAlmacenDetalle_inserta ( {$dev_row['movement_header_id']}, {$dev_row['product_id']}, {$dev_row['quantity']}, 
								{$dev_row['quantity']}, -1, -1, NULL, 14, NULL )";
							$this->link->query( $sql );
						}catch(PDOException $error){
							die("Error al insertar detalle de movimeinto de alamcen : {$sql} : {$error}");
						}
					}
				}catch(PDOException $error){
					die( "Error al mandar llamar procedure spMovimientoAlmacenDetalle_inserta : {$sql} : {$error}" );
				}	
			}else{
				try{
					$sql = "SELECT pagado FROM ec_pedidos WHERE id_pedido = {$this->sale_id}";
					$stm = $this->link->query( $sql );
					$row = $stm->fetch(PDO::FETCH_NUM);//_row
					if( $row[0] == 0 ){
						die( "La nota esta pagada y no debe de entrar en esta condicion." );
					}
				}catch(PDOException $error){
					die( "Error al consultar si el pedido esta pagado : {$sql} : {$error}" );
				}
			}
			//die( 'Deter' );
			foreach ($this->internal_products as $key => $product ) { //actualizamos el detalle del pedido
				$r = null;
			//consulta datos del detalle del pedido
				try{
					$sql = "SELECT pd.cantidad,
									pd.id_pedido_detalle,
									pd.es_externo,
									ROUND(((pd.monto-pd.descuento)/pd.cantidad)-IF(pd.descuento>0,0,(pd.precio)*(IF(pe.descuento=0,0,(pe.descuento*100/pe.subtotal))/100)),6)*{$product['return_quantity']}
									FROM ec_pedidos_detalle pd
									LEFT JOIN ec_pedidos pe ON pd.id_pedido=pe.id_pedido 
									WHERE pd.id_pedido_detalle ='{$product['sale_detail_id']}'
									GROUP BY pd.id_pedido_detalle";//die( $sql );
					$eje1 = $this->link->query( $sql );
					$r = $eje1->fetch(PDO::FETCH_NUM);//_row
				}catch(PDOException $error){
					die("Error al consultar la cantidad de productos a devolver 1 : {$sql} : {$error}");
				}
	    		try{
					$sql2 = "UPDATE ec_pedidos_detalle SET 
							cantidad = ( cantidad - {$product['return_quantity']} ),
							monto = cantidad*precio,
							monto_facturacion = (cantidad * precio_facturacion),
							modificado = 1
							WHERE id_pedido_detalle = '{$product['sale_detail_id']}'";
					$this->link->query( $sql2 );
				}catch(PDOException $error){
					die("Error al actualizar el detalle de pedido : {$sql2} : {$error}");
				}
	    	//comprueba si el producto es maquilado
				try{
					$sql = "SELECT 
								id_producto_ordigen,
								cantidad 
							FROM ec_productos_detalle 
							WHERE id_producto='{$product['product_id']}'"; 
					$eje_maq = $this->link->query($sql);
					if( $eje_maq->rowCount() > 0 ){//num_rows
						$r_maq = $eje_maq->fetch(PDO::FETCH_NUM);//_row
						$product['product_id'] = $r_maq[0];
						$product['return_quantity'] = ( $r_maq[1] * $product['return_quantity'] );
					}//inserta el detalle de la devolucion
				}catch(PDOException $error){
					die("Error al consultar el origen de la maquila : {$sql} : {$error}");
				}
				try{
					$ins_det = "INSERT INTO ec_devolucion_detalle(id_devolucion_detalle,id_devolucion,id_producto,cantidad, id_pedido_detalle)
								SELECT NULL,IF( {$product['is_external']} = 0, {$this->internal_return_id}, {$this->external_return_id} ),
								'{$product['product_id']}','{$product['return_quantity']}', '{$product['sale_detail_id']}'";////VALUES(NULL,'$id_dev','{$_GET["idp{$i}"]}','{$_GET["can{$i}"]}')
					$this->link->query( $ins_det );
				}catch(PDOException $error){
					die("Error al insertar detalle de la devolución : {$ins_det} : {$error}");
				}
				try{
		        	$sql = "UPDATE ec_temporal_exhibicion te 
		                INNER JOIN ec_temporal_exhibicion_proveedor_producto tepp
		                ON te.id_temporal_exhibicion = tepp.id_temporal_exhibicion
		                SET te.tiene_devolucion = 1, tepp.tiene_devolucion = 1
		                WHERE te.id_pedido = {$this->sale_id}
		                AND tepp.id_producto = {$product['product_id']}";
		        	$this->link->query( $sql );
				}catch(PDOException $error){
					die( "Error al marcar exhibicion con devolucion : {$sql} : {$error}" );
				}
		    //si la nota esta pagada inserta el detalle del movimiento por devolución de los productos devueltos
				if( $this->was_payed == 1 ){
					try{
						$movement_header_id = ( $product['is_external'] == 0 ? $this->internal_return_movement_id : $this->external_return_movement_id );
						$ins_mov_det = "CALL spMovimientoAlmacenDetalle_inserta ( {$movement_header_id}, {$product['product_id']}, {$product['return_quantity']}, 
						{$product['return_quantity']}, -1, -1, NULL, 14, NULL )";
						$this->link->query( $ins_mov_det );
					}catch(PDOException $error){
						die( "Error al insertar el detalle de movimiento por devolución 1 : {$ins_mov_det} {$error} " );
					}
				}
		    //suma los pagos
		        if( $product['is_external']== 0 ){//si es producto interno
		            $this->internal_return_amount += $r[3];
		        }else if( $product['is_external']== 1 ){//si es producto externo
		            $this->external_return_amount += $r[3];
		        }
			}

			foreach ($this->external_products as $key => $product ) { //actualizamos el detalle del pedido
				//consulta datos del detalle del pedido
				try{
					$sql = "SELECT 
								pd.cantidad,
								pd.id_pedido_detalle,
								pd.es_externo,
								ROUND(((pd.monto-pd.descuento)/pd.cantidad)-IF(pd.descuento>0,0,(pd.precio)*(IF(pe.descuento=0,0,(pe.descuento*100/pe.subtotal))/100)),6)*{$product['return_quantity']}
							FROM ec_pedidos_detalle pd
							LEFT JOIN ec_pedidos pe ON pd.id_pedido=pe.id_pedido 
							WHERE pd.id_pedido_detalle ='{$product['sale_detail_id']}'";
					$eje1 = $this->link->query( $sql );
					$r = $eje1->fetch(PDO::FETCH_NUM);//_row

					try{
						$sql2="UPDATE ec_pedidos_detalle SET 
								cantidad = ( cantidad - {$product['return_quantity']} ),
								monto = cantidad*precio,
								monto_facturacion = (cantidad * precio_facturacion),
								modificado = 1
								WHERE id_pedido_detalle = '{$product['sale_detail_id']}'";//-{$_GET["can{$i}"]}//descuento = (IF(descuento=0,0,$des[0]*cantidad)),
						$this->link->query( $sql2 );
					}catch(PDOException $error){
						die("Error al actualizar el detalle de pedido : {$sql2} : {$error}");
					}
				//comprueba si el producto es maquilado
					try{
						$sql = "SELECT 
									id_producto_ordigen,
									cantidad 
								FROM ec_productos_detalle 
								WHERE id_producto='{$product['product_id']}'"; 
						$eje_maq = $this->link->query($sql);
						if( $eje_maq->rowCount() > 0 ){//num_rows
							$r_maq = $eje_maq->fetch(PDO::FETCH_NUM);//_row
							$product['product_id'] = $r_maq[0];
							$product['return_quantity'] = ( $r_maq[1] * $product['return_quantity'] );
						}//inserta el detalle de la devolucion
					}catch(PDOException $error){
						die("Error al consultar el origen de la maquila : {$sql} : {$error}");
					}
					try{
						$ins_det="INSERT INTO ec_devolucion_detalle(id_devolucion_detalle,id_devolucion,id_producto,cantidad, id_pedido_detalle)
									SELECT NULL,IF( {$product['is_external']} = 0, {$this->internal_return_id}, {$this->external_return_id} ),
									'{$product['product_id']}','{$product['return_quantity']}', '{$product['sale_detail_id']}'";////VALUES(NULL,'$id_dev','{$_GET["idp{$i}"]}','{$_GET["can{$i}"]}')
						$this->link->query( $ins_det );
					}catch(PDOException $error){
						die("Error al insertar detalle de la devolución : {$ins_det} {$error} ");
					}
				//si la nota esta pagada inserta el detalle del movimiento por devolución de los productos devueltos
					if( $this->was_payed == 1 ){
						try{
							$movement_header_id = ( $product['is_external'] == 0 ? $this->internal_return_movement_id : $this->external_return_movement_id );
							$ins_mov_det = "CALL spMovimientoAlmacenDetalle_inserta ( {$movement_header_id}, {$product['product_id']}, {$product['return_quantity']}, 
							{$product['return_quantity']}, -1, -1, NULL, 14, NULL )";
							$this->link->query( $ins_mov_det );
						}catch(PDOException $error){
							die( "Error al insertar el detalle de movimiento por devolución 2 : {$sql} : {$error}" );
						}
					}
				//suma los pagos
					if( $product['is_external']==0 ){//si es producto interno
						$this->internal_return_amount += $r[3];
					}else if( $product['is_external']==1 ){//si es producto externo
						$this->external_return_amount += $r[3];
					}
				}catch(PDOException $error){
					die("Error al consultar la cantidad de productos a devolver 2 : {$sql} : {$error}");
				}
			}	
		}

		public function insertReturnPayment(){
	//insertamos el pago de la devolucion
			$this->total_abonado=0;
			if( $this->was_payed == 1 ){
			//externa
			    if( $this->external_return_amount > 0 ){
					try{
						$sql = "UPDATE ec_devolucion SET monto_devolucion = {$this->external_return_amount} WHERE id_devolucion = {$this->external_return_id}";
						$eje = $this->link->query($sql);
					}catch(PDOException $error){
						die("Error al actualizar pago de cebecera devolución externa : {$sql} : {$error}");
					}
			    }
			//interna
			    if( $this->internal_return_amount > 0 ){
					try{
						$sql = "UPDATE ec_devolucion SET monto_devolucion = {$this->internal_return_amount} WHERE id_devolucion = {$this->internal_return_id}";
						$eje = $this->link->query($sql);//or die(" : {$sql} {$this->link->error}");
					}catch(PDOException $error){
						die("Error al actualizar pago de cebecera devolución interna : {$sql} : {$error}");
					}
			    }   
			    //$this->total_abonado=$datos_1[2];  
			}else{
				try{
					$sql = "SELECT 
							SUM(IF(pp.es_externo=1,pp.monto,0))-IF(ax.devExternos IS NULL,0,ax.devExternos) as externos,
							SUM(IF(pp.es_externo=0,pp.monto,0))-IF(ax.devInternos is null,0,ax.devInternos )as internos,
							SUM(pp.monto)-IF(ax.totalDev is null,0,ax.totalDev) as total 
						FROM(
							SELECT 
								{$this->sale_id} as id_pedido,
								SUM(IF(dev.id_devolucion is null,0,IF(dp.es_externo=1,dp.monto,0))) as devExternos,
								SUM(IF(dev.id_devolucion is null,0,IF(dp.es_externo=0,dp.monto,0))) as devInternos,
								SUM(IF(dev.id_devolucion IS NULL,0,dp.monto)) as totalDev
								FROM ec_devolucion dev
								LEFT JOIN ec_devolucion_pagos dp ON dev.id_devolucion=dp.id_devolucion
								WHERE dev.id_pedido = {$this->sale_id}
							)ax
						LEFT JOIN ec_pedido_pagos pp ON pp.id_pedido=ax.id_pedido
						WHERE pp.id_pedido = {$this->sale_id}";// die($sql);
					$eje = $this->link->query($sql);
					$datos_1 = $eje->fetch(PDO::FETCH_NUM);//_row
				//inserta las devoluciones completas
					if($datos_1[0]>0){//externa
						try{
							$sql = "UPDATE ec_devolucion SET monto_devolucion = {$datos_1[0]} WHERE id_devolucion = {$this->external_return_id}";
							$eje = $this->link->query($sql);
						}catch(PDOException $error){
							die("Error al actualizar pago de cebecera devolución externa : {$sql} : {$error}");
						}
					}
					if($datos_1[1]>0){//interna
						try{
							$sql = "UPDATE ec_devolucion SET monto_devolucion = {$datos_1[1]} WHERE id_devolucion = {$this->internal_return_id}";
							$eje = $this->link->query($sql);
						}catch(PDOException $error){
							die("Error al actualizar pago de cebecera devolución interna : {$sql} : {$error}");
						}
					}
					$this->total_abonado=$datos_1[2];
				}catch(PDOException $error){
					die("Error al consultar pago de la devolución 2 : {$sql} : {$error}");
				}
			}//fin de si no esta pagada la nota de venta
		}


		public function finishReturn(){
			$porcDesc = 0;
			$subTotal = array();
			try{
				$sql = "SELECT 
							ROUND( 1 - (total/subtotal), 6 ) AS discount
						FROM ec_pedidos
						WHERE id_pedido = {$this->sale_id}";
				$stm = $this->link->query( $sql );
				$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
				$porcDesc = $row['discount'];
			}catch(PDOException $error){
				die( "Error al consultar descuento del ticket : {$sql} {$this->link->error}" );
			}
			//Actualiza el monto del pedio anterior y genera ticket
			try{
				$subTotal = "SELECT 
			    			SUM( monto ),
			    			SUM( descuento ) 
			    		FROM ec_pedidos_detalle 
			    		WHERE id_pedido = '{$this->sale_id}'";//consultamos las sumas de los productos del pedido
			    $calc = $this->link->query($subTotal);
			    $subTotal = $calc->fetch(PDO::FETCH_NUM);//_row
			}catch(PDOException $error){
				die("Error al calcular el nuevo monto del pedido : {$sql} : {$error}");
			}    
			//verifica si hay descuento
			if($subTotal[1]==0){
				$descFinal=$subTotal[0]*$porcDesc;
				$auxz=$subTotal[0];
				$subTotal[0]=$auxz;
			}else{
				$descFinal=$subTotal[1];
			}
		//recupera datos de la devolución
			try{
				$sql = "SELECT 
							p.id_pedido AS sale_id,
							SUM( devP.monto ) AS amount,
							IF( p.pagado = 1, 0, 1 ) AS is_not_payed,
							IF( p.tipo_pedido = 0 , '', CONCAT( '&tv=1&aWRfcHJlY2lv=', p.tipo_pedido ) ) AS sale_type,
							p.descuento AS discount
						FROM ec_pedidos p
						LEFT JOIN ec_devolucion dev
						ON dev.id_pedido = p.id_pedido
						LEFT JOIN ec_devolucion_pagos devP
						ON devP.id_devolucion = dev.id_devolucion
						WHERE p.id_pedido = {$this->sale_id}";
				$stm_url = $this->link->query( $sql );
				$row = $stm_url->fetch(PDO::FETCH_ASSOC);//_assoc
			//oscar 2023 para enviar datos de la devolucion
				$row['returns_ids'] = "{$this->internal_return_id}~{$this->external_return_id}";
		
				$extra = "&es_apart={$row['is_not_payed']}&id_ped={$row['sale_id']}&dsc={$row['discount']}"; 
				$extra .= "&id_dev=" . $row['returns_ids'] . $row['sale_type'];//implementacion Oscar 2023 para que respete el precio de lista si es mayoreo
				$row['amount'] = round( $this->internal_return_amount + $this->external_return_amount, 6 );
				$extra = str_replace("*", "&", $extra);
				$url_recarga = '../../touch_desarrollo/index.php?scr=nueva-venta&s_f_c=' . $row['amount'];
				$url_recarga .= $extra . "&abonado=".$this->total_abonado;
				$url_recarga .= "&oculta_venta=1";

				$url_db = '../touch_desarrollo/index.php?scr=nueva-venta&s_f_c=' . $row['amount'];
				$url_db .= $extra . "&abonado=".$this->total_abonado;
				$url_db .= "&oculta_venta=1";
				
				try{
					$sql="UPDATE ec_devolucion SET observaciones='$url_db' WHERE id_pedido = {$this->sale_id}";
					$eje = $this->link->query($sql);
				}catch(PDOException $error){
					die("Error al actualizar observaciones en las devoluciones : {$sql} : {$error}" );
				}
			//actualiza monto del pedido y marca que este fue modificado
				try{
					$actPed="UPDATE ec_pedidos SET descuento = '{$descFinal}',subtotal='$subTotal[0]',total=($subTotal[0]-descuento),modificado=1 WHERE id_pedido = '{$this->sale_id}'";
					$this->link->query( $actPed );
				}catch(PDOException $error){
					die( "Error al actualizar cabecera de Pedido : {$sql} : {$error}" );
				}
				try{
					$sql = "UPDATE ec_pedidos_referencia_devolucion 
								SET total_venta = ( total_venta - ( {$this->internal_return_amount} + {$this->external_return_amount} ) )
							WHERE id_pedido = {$this->sale_id}";
					$this->link->query( $sql );
				}catch(PDOException $error){
					die( "Error al actualizar la referencia de la devolucion : {$sql} : {$error}");
				}
				return $url_recarga;
			}catch(PDOException $error){
				die( "Error al consultar detalles finales de la devolución : {$sql} : {$error}" );
			}
		}
	}
?>