    let socket;
    let reconnectInterval = 3000; // ms
    let maxReconnectAttempts = 300;
    let reconnectAttempts = 0;
    let isManuallyClosed = false;

    function conectarWebSocket() {
        socket = new WebSocket(`${websocket_URL}?user_id=${websocket_user}&store_id=${sucursal_logueo}&user_type=seller`);

        socket.onopen = function () {
            $('#websocket_status_icon').html(`<i class=\"icon-toggle-on text-success\">WS Conectado</i>`);
            console.log("Conexión establecida con el servidor.");
            agregarMensaje("Conectado al servidor");

            // Reinicia contador de reconexión
            reconnectAttempts = 0;
        };

        socket.onmessage = function (event) {
            var json = null;
            console.log(event.data);
            try {
                json = JSON.parse(event.data);
            } catch (e) {
                console.log("ENTRA EN NO ES JSON.");
            }

            if (json != null && json.action && (json.action == "notify_updated" || json.action == "notification_delivered")) {
                $("#emer_avisos").click();
                if (json.data.result.notifications.length <= 0) {
                    cerrarNotificaciones();
                    return true;
                }
                var content = `<div class="p-3 bg-white" style="max-height:70%; overflow:auto;">
                    <div class="text-end" style="position:fixed; top :0;width:95%;">
                        <button type="button" class="btn btn-danger" onclick="cerrarNotificaciones();"><b>X</b></button>
                    </div>`;
                for (const key in json.data.result.notifications) {
                    var class_color = (json.data.result.notifications[key].supplied_counter > 0 ? "text-success" : "text-danger");
                    content += `<div class="p-2 m-2" style="box-shadow : 3px 3px 15px rgba(0,0,0,.4);">
                        <h3 class="text-center">Pedido # ${json.data.result.notifications[key].supply_id} Surtido</h3>
                        <h5 class="text-center">Surtido por : ${json.data.result.notifications[key].supplier_name}</h5>
                        <h5 class="text-center ${class_color}">Productos Surtidos : ${json.data.result.notifications[key].supplied_counter}</h5>`;
                    if (json.data.result.notifications[key].supplied_counter > 0) {
                        content += `<h6 class="text-center">Pasa a recogerlo.</h6>`;
                    }
                    content += `<button type="button" class="btn btn-primary form-control" onclick="marcarNotificacionVista(${json.data.result.notifications[key].supply_range_id});">
                            <i class="icon-ok-circled">Aceptar y marcar como visto</i>
                        </button>
                    </div>`;
                }
                content += `</div>`;
                $("#emer_avisos").html(content);
                $("#emer_avisos").css("display", "block");
                alert_scann('supply_finished');
            }
        };

        socket.onerror = function (error) {
            console.error("Error en la conexión:", error);
            agregarMensaje("Error en la conexión");
        };

        socket.onclose = function () {
            $('#websocket_status_icon').html(`<i class=\"icon-toggle-off text-danger\">WS Desconectado</i>`);
            console.log("Conexión cerrada");
            agregarMensaje("Conexión cerrada");

            // Reconectar solo si no fue cerrada manualmente
            if (!isManuallyClosed && reconnectAttempts < maxReconnectAttempts) {
                setTimeout(() => {
                    console.log(`Intentando reconexión #${reconnectAttempts + 1}...`);
                    reconnectAttempts++;
                    conectarWebSocket();
                }, reconnectInterval);
            } else if (reconnectAttempts >= maxReconnectAttempts) {
                console.warn("Límite de reconexiones alcanzado.");
            }
        };
    }

    function agregarMensaje(texto) {
        console.log(texto);//alert(texto);
    }
    function enviarMensajeWS() {
        var mensaje = {"type" : "new_supply", "user_type" : "seller", "store_id" : sucursal_logueo};
        mensaje = JSON.stringify(mensaje);
        //const input = document.getElementById("mensaje");
        //const mensaje = input.value;
        if (socket.readyState === WebSocket.OPEN) {
            socket.send(mensaje);
            //agregarMensaje(mensaje);
            //input.value = "";
        } else {
            alert("La conexión no está abierta.");
        }
    }

    function cerrarNotificaciones(){
        $("#emer_avisos").html('');//cargamos respuesta
        $("#emer_avisos").css("display","none");//hacemos visible la ventana emergente    
    }

    function marcarNotificacionVista(supply_range_id){
        var mensaje = {"type" : "notification_viewed", 
            "supply_range_id" : supply_range_id,
            "user_id" : websocket_user,
            "user_type" : "seller"
        };
        mensaje = JSON.stringify(mensaje);
        //const input = document.getElementById("mensaje");
        //const mensaje = input.value;
        if (socket.readyState === WebSocket.OPEN) {
            socket.send(mensaje);
            //agregarMensaje(mensaje);
            //input.value = "";
        } else {
            alert("La conexión no está abierta.");
        }

    }
   
   /*const socket = new WebSocket(`${websocket_URL}?user_id=${websocket_user}&store_id=${sucursal_logueo}&user_type=seller`);//ws://localhost:8080//wss://192.168.1.253:8443/seller
    
    socket.onopen = function () {
        $('#websocket_status_icon').html(`<i class=\"icon-toggle-on text-success\">WS Conectado</i>`);
        console.log("Conexión establecida con el servidor.");
        agregarMensaje("Conectado al servidor");
    };

    socket.onmessage = function (event) {
        var json = null;
        console.log(event.data);
        try{
            json = JSON.parse(event.data);
            //alert(json.action);
        }catch(e){
            console.log("ENTRA EN NO ES JSON.");
        }
        //alert(event.action);
        if(json != null && json.action && ( json.action == "notify_updated" || json.action == "notification_delivered")){
            $("#emer_avisos").click();
            if(json.data.result.notifications.length <= 0){
                cerrarNotificaciones();
                return true;
            }
            var content = `<div class="p-3 bg-white" style="max-height:70%; overflow:auto;">
                <div class="text-end" style="position:fixed; top :0;width:95%;">
                    <button
                        type="button"
                        class="btn btn-danger"
                        onclick="cerrarNotificaciones();"

                    >  
                        <b>X</b>
                    </button>
                </div>`;
            for (const key in json.data.result.notifications) {//border border-warning bg-light
                var class_color = (json.data.result.notifications[key].supplied_counter > 0 ? "text-success" : "text-danger");
                content += `<div class="p-2 m-2" style="box-shadow : 3px 3px 15px rgba(0,0,0,.4);">
                    <h3 class="text-center">Pedido # ${json.data.result.notifications[key].supply_id} Surtido</h3>
                    <h5 class="text-center">Surtido por : ${json.data.result.notifications[key].supplier_name}</h5>
                    <h5 class="text-center ${class_color}">Productos Surtidos : ${json.data.result.notifications[key].supplied_counter}</h5>`;
                if(json.data.result.notifications[key].supplied_counter > 0){
                    content += `<h6 class="text-center">Pasa a recogerlo.</h6>`;
                }
                content += `<button
                        type="button"
                        class="btn btn-primary form-control"
                        onclick="marcarNotificacionVista(${json.data.result.notifications[key].supply_range_id});"
                    >
                        <i class="icon-ok-circled">Aceptar y marcar como visto</i>
                    </button>
                </div>`;
            }
            content += `</div>`;
            $("#emer_avisos").html(content);//cargamos respuesta
            $("#emer_avisos").css("display","block");//hacemos visible la ventana emergente
            alert_scann('supply_finished');
        }else{
            //console.log("Mensaje recibido:", event.data);
            //agregarMensaje("Servidor: " + event.data);
        }
    };

    socket.onerror = function (error) {
        console.error("Error en la conexión:", error);
        agregarMensaje("Error en la conexión");
    };

    socket.onclose = function () {
        $('#websocket_status_icon').html(`<i class=\"icon-toggle-off text-danger\">WS Desconectado</i>`);
        console.log("Conexión cerrada");
        agregarMensaje("Conexión cerrada");
    };

    }
    }

    function marcarNotificacionVista(supply_range_id){
        var mensaje = {"type" : "notification_viewed", 
            "supply_range_id" : supply_range_id,
            "user_id" : websocket_user,
            "user_type" : "seller"
        };
        mensaje = JSON.stringify(mensaje);
        //const input = document.getElementById("mensaje");
        //const mensaje = input.value;
        if (socket.readyState === WebSocket.OPEN) {
            socket.send(mensaje);
            //agregarMensaje(mensaje);
            //input.value = "";
        } else {
            alert("La conexión no está abierta.");
        }

    }

    function agregarMensaje(texto) {
        console.log(texto);//alert(texto);
    }

    function cerrarNotificaciones(){
        $("#emer_avisos").html('');//cargamos respuesta
        $("#emer_avisos").css("display","none");//hacemos visible la ventana emergente    
    }*/