<?php
	/*
		Version Oscar 2024-11-04 Para seccionar tickets en tamaño carta
	*/
	define('FPDF_FONTPATH','../include/fpdf186/font/');
	
	include("../include/fpdf186/fpdf.php");
	$tv = (isset($_GET['tv']) ? $_GET['tv'] : NULL);
	$printPan = ( (isset($_GET['printPan'])) ? $_GET['printPan'] : 0);
	$_GET['es_apartado'] = ( (isset($_GET['es_apartado'])) ? $_GET['es_apartado'] : 0);
/*implementación Oscar 25.01.2019 para sacar rutas de tickets*/
	$archivo_path = "../conexion_inicial.txt";
	$carpeta_path = "";
	if(file_exists($archivo_path)){
		$file = fopen($archivo_path,"r");
		$line=fgets($file);
		fclose($file);
	    $config=explode("<>",$line);
	    $tmp=explode("~",$config[2]);
	    $ruta_or=$tmp[0];
	    $ruta_des=$tmp[1];
		$tmp_=explode("~",$config[0]);
		$carpeta_path = base64_decode( $tmp_[1] );
	}else{
		die("No hay archivo de configuración.");
	}
/*Implementacion Oscar 2025-10-06 para no imprimir ventas sin productos*/
	try{
		$sql = "SELECT SUM(cantidad) AS products_quantity FROM ec_pedidos_detalle WHERE id_pedido = {$_GET["idp"]} AND cantidad > 0";
		$stm = $link->query($sql);
		$row = $stm->fetch(PDO::FETCH_ASSOC);
		if($row['products_quantity'] == 0){
			die("Esta venta fue cancelada y no tiene productos para reiprimir.");
		}
	}catch(PDOException $error){
		die(json_encode(array("status"=>"302", "message"=>"Error al consultar si la venta no es vacia.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
	}
/**/
/*Fin de cambio Oscar 25.01.2018*/
    if( isset(  $_GET['id_venta_origen'] ) ){
		$id_venta_origen = $_GET['id_venta_origen'];
		$id_sesion_cajero = $_GET['id_sesion_caja'];
		if( $id_venta_origen != '' && $id_venta_origen != null && $id_venta_origen != 0 ){
			try{
				$sql = "UPDATE ec_pedidos_referencia_devolucion 
							SET monto_venta_mas_ultima_devolucion = total_venta
						WHERE id_pedido = {$id_venta_origen}";
				$stm = $link->query( $sql );
			}catch(PDOException $error){
				die( "Error al actualizar el monto de venta original : {$sql} : {$error}" ); 
			}
			try{
				$sql = "UPDATE ec_devolucion 
							SET id_cajero = {$user_id}, 
							id_sesion_caja = {$id_sesion_cajero}
						WHERE id_pedido = {$id_venta_origen}
						AND id_cajero = 0
						AND id_sesion_caja = 0";
				$stm = $link->query( $sql );
			}catch(PDOException $error){
				die( "Error al actualizar la sesion de caja de devolucion de venta original : {$sql} : {$error}" );
			} 
		}
	}

    if(!isset($_GET["noImp"])){
        $_GET["noImp"]=1;
    }

//implementado por Oscar 29-12-2017
    $diferencia='';
    $s_f_i=0;
    if(isset($_GET["sald_fav_cl"])){
    	$diferencia=1;//
    	$saldo_cliente=$_GET["sald_fav_cl"];//recibimos saldo a favor del cliente

    	if($saldo_cliente==0){
    		$accion="Saldo liquidado";
    		$monto_=0;
    	}
    	if($saldo_cliente<0){
    		$accion="Cobrar:";
    		$monto_=round($saldo_cliente*-1,2);
    		$mensaje_nota="Se Cobró al cliente: $".$saldo_cliente;
    	}
    	if($saldo_cliente>0){
    		$accion="Devolver:";
    		$monto_=round($saldo_cliente,2);
    		$mensaje_nota="Se Regresó al cliente: $".$saldo_cliente;
    	}

    	if($monto_<1){
    		$monto_=0;
    	}	

    	$s_f_i=$_GET["favOrig"];
    }
//fin de cambio
	$id_pedido = $_GET["idp"];	
	$sucursal = "";
	$folio = "";
	$prefijo = "";
	$subtotal = "0";
	$total = "0";
	$productos = array();
	$productosP = array();
	$pagos = array();
	$vendedor = "N/A";
	$lineas_productos = 0;
	$lineas_pagos = 0;
	$total_pagos = "0";
	$tipofolio = "PEDIDO";
//consulta datos del vendedor
	try{
		$cs = "SELECT 
					CONCAT(u.nombre, ' ', u.apellido_paterno) AS vendedor
				FROM ec_pedidos p
				LEFT JOIN sys_users u 
				ON p.id_usuario = u.id_usuario
				WHERE p.id_pedido = '{$id_pedido}'";
		$rs = $link->query($cs);
		$dr = $rs->fetch(PDO::FETCH_ASSOC);
		$vendedor = $dr["vendedor"];
	}catch(PDOException $error){
		die("Error al consultar datos del vendedor : {$sql} : {$error}");
	}
	
	try{
		$cs = "SELECT 
				s.nombre AS sucursal, 
				s.prefijo,
				REPLACE(s.descripcion,'*','\n') as descripcion,
				sc.mostrar_descuento_ticket 
			FROM sys_sucursales s 
			LEFT JOIN ec_configuracion_sucursal sc ON s.id_sucursal = sc.id_sucursal
			WHERE s.id_sucursal = '{$user_sucursal}'";
		$rs = $link->query($cs);
		$dr = $rs->fetch(PDO::FETCH_ASSOC);
		$sucursal = $dr["sucursal"];
		$prefijo = $dr["prefijo"];
		$datos_fiscales = $dr["descripcion"];//armamos los datos Fiscales
		$show_discount = $dr["mostrar_descuento_ticket"];//ver descuento del ticket
		$rs = null;//mysql_free_result($rs);
	}catch(PDOException){
		die("Error al consultar datos de la sucursal : {$sql} : {$error}");
	}
	
	try{
		$cs = "SELECT
			IF(ISNULL(folio_nv),
			folio_pedido, folio_nv) AS folio,
			IF(ISNULL(folio_nv), 'PEDIDO', 'FOLIO') AS tipofolio,
			subtotal,
			iva,
			ieps,
			total,
			descuento,
			pagado,
			folio_abono as folioA,
			DATE_FORMAT(NOW(), '%d/%m/%Y %H:%i:%s') as fecha_ticket
			FROM ec_pedidos
			WHERE id_pedido = '{$id_pedido}' ";

		$rs = $link->query($cs);
		$dr = $rs->fetch(PDO::FETCH_ASSOC);//mysql_fetch_assoc($rs);
		$tipofolio = $dr["tipofolio"];
		$folio = $dr["folio"];
		$total = $dr["total"];
		$subtotal = $dr["subtotal"];
		$total = $dr["total"];
		$pagado = $dr["pagado"];
		$descuentoGen= $dr["descuento"];
		$folioA = "A$prefijo".$dr["folioA"];
		$fecha_tkt = $dr["fecha_ticket"];
	}catch(PDOException $error){
		die("Error al consultar datos de cabecera de a nota de venta : {$sql} : {$error}");
	}


/*implementacion Oscar 16.06.2019 para codigo de barras

//		echo '<img src="../include/barcode/barcode.php?filepath=12er.png&text=12er&size=50&orientation=horizontal&codeType=Code30&print=true">';

Fin de cambio Oscar 25.06.2019*/
	
	$cs="SELECT
			ax.id_producto,
			ax.producto AS producto,
			ax.cantidad,
	       	ax.precio,
	       	ax.monto,
	       	ax.descuentoProds,
		/*implementación Oscar 10.10.2018 para mostrar ubicacion y alfanumerico*/
	       	IF(s.mostrar_ubicacion=1 OR s.mostrar_alfanumericos=1,1,0) as infoAdicional,
          	CONCAT(
          		IF(s.mostrar_ubicacion=1,
                	IF($user_sucursal=1,
                  		CONCAT('Ubicación: ',ax.ubicacion_almacen,' '),
                  		IF(sp.ubicacion_almacen_sucursal!='',
                      		CONCAT('Ubicacion: ',sp.ubicacion_almacen_sucursal,'  '),
                    		''
                  		)
                	),
                	''
              	),
            	IF(s.mostrar_alfanumericos=0,'',CONCAT('Clave: ',ax.clave))
          )as info,
          IF( ax.id_producto = 2758
			OR ax.id_producto = 2854
			OR ax.id_producto = 2759
			OR ax.id_producto = 1918
			OR ax.id_producto = 3317
			OR ax.id_producto = 1820
			OR ax.id_producto = 2760
			OR ax.id_producto = 2761
			OR ax.id_producto = 2767
			OR ax.id_producto =	2768
			OR ax.id_producto = 1956
			OR ax.id_producto = 3813
			OR ax.id_producto = 3814
			OR ax.id_producto = 2769
			OR ax.id_producto = 3628
			OR ax.id_producto = 2736
			OR ax.id_producto = 4118
			OR ax.id_producto = 2007
			OR ax.id_producto = 2764
			OR ax.id_producto = 2008
			OR ax.id_producto = 2113
			OR ax.id_producto = 3318
			OR ax.id_producto = 1826
			OR ax.id_producto = 2762
			OR ax.id_producto = 2763
			OR ax.id_producto = 4104
			OR ax.id_producto = 4105
			OR ax.id_producto = 2770
			OR ax.id_producto = 2771
			OR ax.id_producto = 2715
			OR ax.id_producto = 3821
			OR ax.id_producto = 3822
			OR ax.id_producto = 2772
			OR ax.id_producto = 3629
			OR ax.id_producto = 2735
			OR ax.id_producto = 4117,
			( SELECT 
				DATE_SUB(CURDATE(), INTERVAL -1 DAY) 
			),
			'' 
		) AS is_special
		/*Fin de cambio 10.10.2018*/
		FROM(
			SELECT
	       		P.id_productos AS id_producto,
	       		P.nombre AS producto,
	       		P.clave,
       			PD.cantidad,
	       		PD.precio,
	       		PD.monto,
	       		PD.descuento AS descuentoProds,
	       		P.ubicacion_almacen
	       FROM ec_productos P
	       INNER JOIN ec_pedidos_detalle PD ON PD.id_producto = P.id_productos
	       WHERE PD.id_pedido = '{$id_pedido}'
	       GROUP BY PD.id_pedido_detalle/*P.id_productos*/
	       ORDER BY PD.id_pedido_detalle
	    )ax
		LEFT JOIN sys_sucursales_producto sp ON ax.id_producto=sp.id_producto
		JOIN sys_sucursales s ON sp.id_sucursal=s.id_sucursal AND s.id_sucursal IN($user_sucursal)";
	//die( $cs );
	$descProds=0;
//implementacion Oscar 2023/12/03 para imprimir ticket de productos que se entregan al dia siguiente
	$special_products = 0;
	try{
		$rs = $link->query($cs);
		while( $dr = $rs->fetch(PDO::FETCH_ASSOC) ){//mysql_fetch_assoc($rs)
			
			if($dr["producto"] == "Pocas piezas"){
				$dr["producto"] .= " \${$dr["precio"]}";
				$lineas_productos += ceil(strlen($dr["producto"])/32.0);
				array_push($productosP,$dr);

			}else{
				// Concatenar precio unitario en la descripción
				$dr["producto"] .= " \${$dr["precio"]}";
				$lineas_productos += ceil(strlen($dr["producto"])/32.0);
				array_push($productos, $dr);
			}
			$descProds+=$dr['descuentoProds'];	
		/*implementación Oscar 10.10.2018 para imprimir ubicación y calve_proveedor en ticket*/
			if($dr["infoAdicional"]==1){
				$lineas_productos+=.8;
			}

			if($dr["is_special"] != '' ){
				$lineas_productos+=2;
				$special_products ++;//implementacion Oscar 2023/12/03 para imprimir ticket de productos que se entregan al dia siguiente
			}
		/*fin de cambio 10.10.2018*/	
		}
		$rs = null;//mysql_free_result($rs);
	}catch(PDOException $error){
		die("Error al consultar el detalle de la nota de venta : {$cs} : {$error}");
	}
	
	$cs = "SELECT 
				CONCAT(PP.fecha,' ',TP.nombre,'(pagos)') as nombre, sum(monto) as monto 
			FROM ec_pedido_pagos PP
			INNER JOIN ec_tipos_pago TP ON PP.id_tipo_pago = TP.id_tipo_pago
			WHERE PP.id_pedido = '{$id_pedido}' AND (referencia='' OR referencia=null)
			GROUP BY CONCAT(PP.fecha,' ',PP.hora)
			ORDER BY PP.id_pedido_pago ASC";
	try{
		$rs = $link->query($cs);
		while ($dr = $rs->fetch(PDO::FETCH_ASSOC)){//mysql_fetch_assoc($rs)
			++$lineas_pagos;
			$total_pagos += $dr["monto"];
			array_push($pagos, $dr);
		}
	}catch(PDOException $error){
		die("Error al consultar pagos de la nota de venta : {$sql} : {$error}");
	}
	$res_dev = null;
	try{
		$sql = "SELECT 
					SUM( IF(dev.id_devolucion IS NULL,0,IF(referencia='' OR referencia=null,dp.monto,0) ) )
				FROM ec_devolucion_pagos dp 
				LEFT JOIN ec_devolucion dev 
				ON dp.id_devolucion = dev.id_devolucion
				WHERE dev.id_pedido = {$id_pedido}";
		$eje = $link->query($sql);
		$res_dev = $eje->fetch(PDO::FETCH_NUM);//mysql_fetch_row($eje);
	}catch(PDOException $error){
		die("Error al calcular monto de devoluciones : {$sql} : {$error}");
	}
	$monto_devolucion = (isset($res_dev[0]) ? $res_dev[0] : 0);//aqui capturamos el monto de la devolucion
//indicador de lineas de devolución
	$lineas_dev = 0;
	if($monto_devolucion > 0){
		$lineas_dev = 5;
	}
/*fin de cambio 06.09.2018*/


	class TicketPDF extends FPDF {
		// Members
		var $sucursal = "";
		var $pedido = "";
		var $inicio = 32;
	
		// Constructor
		function TicketPDF($orientation='P', $unit='mm', $size = 0, $sucursal='', $pedido='', $inicio=10) {
			parent::FPDF($orientation, $unit, $size);
				
			$this->AddFont('Arial');
			$this->SetMargins(7, 0, 7);
			$this->SetDisplayMode("real", "continuous");
			#$this->SetAutoPageBreak(false);
			$this->SetAutoPageBreak(true, -5);
				
			$this->sucursal = mb_convert_encoding($sucursal, 'ISO-8859-1', 'UTF-8');//utf8_decode($sucursal);
			$this->pedido = mb_convert_encoding($pedido, 'ISO-8859-1', 'UTF-8');//utf8_decode($pedido);
			$this->inicio = $inicio;
		}
	
		// Cabecera de página
		function Header() {
		}
	
		function Footer() {
			//$this->SetY(-15);
			//$this->SetFont('Arial','I',8);
			// Número de página
			//$this->Cell(0,10, utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
		}
	
		function AcceptPageBreak() {
			$x = $this->GetX();
			$this->AddPage();
			//$this->SetXY($x, $this->inicio);
			$this->SetXY($x, 1);
			#$this->SetY($this->inicio);
			return false;
		}
	}
	
	//50+$lineas_dev+50+$lineas_productos*6+($total!=$subtotal?12:0)+($pagado>0?14:30)+(count($pagos)>0?($lineas_pagos+1)*6:0)+40+40
	$ticket = new TicketPDF("P", "mm", array(80,(277+70 + ($lineas_productos*6) + ($special_products*40))), "{$sucursal}", "{$folio}", 10);
	$ticket->AliasNbPages();
	$ticket->AddPage();
	
	$bF=10;
	$stm = null;
	try{
		$sql = "SELECT
					cc.id_cajero_cobro As payment_id,
					cc.monto AS amount,
					tp.nombre AS payment_type,
					CONCAT( cc.fecha, ' ', cc.hora ) AS datetime
				FROM ec_cajero_cobros cc
				LEFT JOIN ec_tipos_pago tp
				ON cc.id_tipo_pago = tp.id_tipo_pago
				WHERE cc.id_pedido = {$id_pedido}";
		$stm = $link->query( $sql );
	}catch(PDOException $error){
		die( "Error al consultar pagos para generacion de Ticket : {$sql} : {$error}" );
	}
    $payments_total = 0;

	$ticket->SetFont('Arial','B',$bF+4);
	$ticket->SetXY(5, $ticket->GetY()+1);
	if($pagado == 0){
		$ticket->SetFont('Arial','B',$bF+4);
		//$ticket->SetXY(5, $ticket->GetY()+1);
		$ticket->Cell(66, 3, mb_convert_encoding("ABONO EN APARTADO", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");//utf8_decode("ABONO EN APARTADO")
	}

    while( $row = $stm->fetch(PDO::FETCH_ASSOC) ){//mysql_fetch_assoc( $stm )
        $payments_total +=  $row['amount'];
    }
/*fin de cambio Oscar 2023/10/12*/
/*Implementacion Oscar 2023/10/12*/

    /*$comprobacion_cobro = round( $total - $payments_total );
    if( ( $comprobacion_cobro == 1 || $comprobacion_cobro == 0 || $comprobacion_cobro == -1 ) || $pagado == 0 ){
	//if( $payments_total == $total ){
        $ticket->Image("../img/especiales/pagado.jpeg", 5, 2, 70);
		$ticket->SetXY(5, $ticket->GetY()+8);
		$comprobacion_cobro = round( $total - $payments_total );
    //generacion de codigo de barras
        include('../include/barcode/barcode.php');
        $barcode_name = str_replace(' ', '', $folio );
        $barcodePath = "../img/codigos_barra/{$barcode_name}.png";
        barcode( $barcodePath, base64_encode( $folio ), '60', 'horizontal', 'code128', false, 1);
    //se incrustra el codigo de barras en el ticket
        $ticket->Image( $barcodePath, 6, $ticket->GetY()+10, 70);
		$ticket->SetXY(5, $ticket->GetY()+30);
   // die( $folio );
	}*/
/*Fin de cambio Oscar 2023/10/12*/
	$comprobacion_cobro = round( $total - $payments_total, 2 );//modificado Oscar 2024-10-31 para dar margen de 50 centavos en cobro
    if( abs($comprobacion_cobro) <= 0.5 || $pagado == 0 ){//modificado Oscar 2024-10-31 para dar margen de 50 centavos en cobro//( $comprobacion_cobro == 1 || $comprobacion_cobro == 0 || $comprobacion_cobro == -1 )
	//if( $payments_total == $total ){
        $ticket->Image("../img/especiales/pagado.jpeg", 5, 2, 70);
		$ticket->SetXY(5, $ticket->GetY()+8);
		//generacion de codigo de barras
        include('../include/barcode/barcode.php');
        $barcode_name = str_replace(' ', '', $folio );
        $barcodePath = "../img/codigos_barra/{$barcode_name}.png";
        barcode( $barcodePath, base64_encode( $folio ), '60', 'horizontal', 'code128', false, 1);
    //se incrustra el codigo de barras en el ticket
        $ticket->Image( $barcodePath, 6, $ticket->GetY()+10, 70);

//implementacion Oscar 2025-09-24 para imprimir codigo QR en ticket de venta
		include "../code/especiales/facturacion/clientes/phpqrcode/qrlib.php";
		$barcode_name_qr = "{$barcode_name}_qr";
		$ruta_imagen_qr = "../img/codigos_barra/{$barcode_name_qr}.png";
		// Generar el código QR y guardarlo como imagen
		QRcode::png(base64_encode( $folio ), $ruta_imagen_qr, QR_ECLEVEL_L, 10);
		if(file_exists("../img/codigos_barra/".$barcode_name_qr.".png")){
	    	$ticket->SetXY(5, $ticket->GetY()+36);
	    	$ticket->Image("../img/codigos_barra/".$barcode_name_qr.".png", 15, $ticket->GetY()+5,46);
	    }
		$ticket->SetXY(5, $ticket->GetY()+34);
//fin de cambio Oscar 2025-09-24
	}
	if($tv==1){
		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(5, $ticket->GetY()+1);
		$ticket->Cell(66, 3, mb_convert_encoding("VENTA POR MAYOREO", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	}
/*implementacion Oscar 2021 para mostrar descuento de ticket*/
	if( ($total!=$subtotal) && $show_discount == 1 ){
		$ticket->SetFont('Arial','B',$bF);
		$ticket->SetXY(15, $ticket->GetY()+14);
		$ticket->Cell(66, 3, mb_convert_encoding("DESCUENTO : ", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");

		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(32, $ticket->GetY());
		$ticket->Cell(66, 3, mb_convert_encoding( " $ {$descuentoGen}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	}
/*fin de cambio Oscar 2021*/

/*implementación de Oscar 10.09.2018 para */
	if(!isset($_GET['es_apartado'])){//si la nota de venta esta pagada
		/*$ticket->Image("img/logo-casa-fondo-blanco.png", 28, 5, 22);
		
		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(5, $ticket->GetY()+40);
		$ticket->Cell(66, 6, utf8_decode("CASA DE LAS LUCES"), "" ,0, "C");*/
	}else if($_GET['es_apartado']==1){//si es apartado
		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(5, $ticket->GetY()+2);
		$ticket->Cell(66, 6, mb_convert_encoding("REIMPRESIÓN DE TICKET", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");//utf8_decode()

		$ticket->SetXY(5, $ticket->GetY()+4);
		$ticket->Cell(66, 6, mb_convert_encoding("POR CAMBIO", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");//utf8_decode()
	}
/*fin de cambio 10.09.2018*/

	$ticket->SetXY(5, $ticket->GetY()+14);
	$ticket->Cell(66, 3, "", "TB" ,0, "C");
	

$ticket->SetFont('Arial','',$bF-2);
$ticket->SetXY(5, $ticket->GetY()+4);
//$ticket->MultiCell(66, 6, utf8_decode('datos:'.$datos_fiscales), "" ,0, "C");
	
	$ticket->MultiCell(66, 4, mb_convert_encoding("RFC : ", 'ISO-8859-1', 'UTF-8'), "", "L", false);
	$ticket->SetXY(5, $ticket->GetY()+4);
	$ticket->MultiCell(66, 4, mb_convert_encoding("DIRECCION : ", 'ISO-8859-1', 'UTF-8'), "", "L", false);
	$ticket->SetXY(5, $ticket->GetY()+4);
	$ticket->MultiCell(66, 4, mb_convert_encoding("OTRO : ", 'ISO-8859-1', 'UTF-8'), "", "L", false);
	
	$ticket->SetFont('Arial','',$bF+2);
	
	$ticket->SetXY(5, $ticket->GetY()+4);
	$ticket->Cell(66*0.6, 6, mb_convert_encoding("{$tipofolio}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	
	$ticket->SetX(5+66*0.6);
	$ticket->Cell(66*0.4, 6, mb_convert_encoding("{$folio}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	
	$ticket->SetXY(5, $ticket->GetY()+6);
	$ticket->Cell(66, 3, "", "TB" ,0, "C");
	
	$ticket->SetFont('Arial','',$bF);
	
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66, 6, mb_convert_encoding("FECHA Y HORA DE EMISIÓN:", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	
	$ticket->SetXY(5, $ticket->GetY()+4.5);
/*implementación Oscar 28.02.2019 para que la hora del ticket sea tomada de la MySQL*/
	$ticket->Cell(66, 6, mb_convert_encoding("Estado de México $fecha_tkt", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
/*Fin de cambio Oscar 28.02.2019*/
	
	$ticket->SetXY(5, $ticket->GetY()+4);
	$ticket->Cell(66, 6, mb_convert_encoding("VENDEDOR:  {$vendedor}", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
	
	$ticket->SetXY(5, $ticket->GetY()+5.5);
	$ticket->Cell(66, 3, "", "TB" ,0, "C");
	
	$ticket->SetFont('Arial','',$bF);
	
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66*0.63, 6, mb_convert_encoding("DESCRIPCIÓN", 'ISO-8859-1', 'UTF-8'), "B" ,0, "L");
	
	$ticket->SetXY(5+66*0.63, $ticket->GetY());
	$ticket->Cell(66*0.12, 6, mb_convert_encoding("CANT", 'ISO-8859-1', 'UTF-8'), "B" ,0, "L");
	
	$ticket->SetXY(5+66*0.75, $ticket->GetY());
	$ticket->Cell(66*0.25, 6, mb_convert_encoding("PRECIO", 'ISO-8859-1', 'UTF-8'), "B" ,0, "R");
	
	$ticket->SetFont('Arial','',$bF-2);
	$ticket->SetXY(5, $ticket->GetY()+8);
	
	foreach ($productos as $producto) {
	    	   
	    $y = $ticket->GetY();	
		$ticket->SetXY(5+66*0.75, $y);
		$ticket->MultiCell(66*0.25, 4, "$ " . number_format($producto["monto"], 2), "", "R", false);
	
		$ticket->SetXY(5+66*0.63, $y);
		$ticket->MultiCell(66*0.12, 4, $producto["cantidad"], "", "C", false);
	
		$ticket->SetXY(5, $y);
		$ticket->MultiCell(66*0.63, 4, mb_convert_encoding("{$producto["producto"]}", 'ISO-8859-1', 'UTF-8'), "", "L", false);
	
	/*implementación Oscar 10.10.2018 para imprimir ubicación y calve_proveedor en ticket*/
		if($producto['infoAdicional']==1){
			$ticket->SetFont('Arial','',$bF-3.5);
			$ticket->SetXY(5,($ticket->GetY()-1.5));
			$ticket->MultiCell(66*0.63, 4, mb_convert_encoding("{$producto["info"]}", 'ISO-8859-1', 'UTF-8'), "", "L", false);
		}

		

		if( $producto["is_special"] != '' ){
			$ticket->SetXY(5, $ticket->GetY() + 2 );
			$ticket->MultiCell(35, 4, mb_convert_encoding( "Fecha entrega : \n {$producto["is_special"]} 18:30 hrs", 'ISO-8859-1', 'UTF-8'), "1", "C", false);
			$ticket->SetXY(40, $ticket->GetY() - 8 );
			$ticket->MultiCell(35, 4, mb_convert_encoding("\n\n", 'ISO-8859-1', 'UTF-8'), "1", "C", false);
			$ticket->SetXY(5, $ticket->GetY() + 4 );
		}

//http://localhost/pruebas_etiquetas/touch_desarrollo/index.php?scr=ticket&idp=425108

		$ticket->SetFont('Arial','',$bF-2);
	/*fin de cambio 10.10.2018*/
	}
	
	foreach ($productosP as $productoP) {
	    	   
	    $y = $ticket->GetY();	

		$ticket->SetXY(5+66*0.75, $y);
		$ticket->MultiCell(66*0.25, 4, "$ " . number_format($productoP["monto"], 2), "", "R", false);
	
		$ticket->SetXY(5+66*0.63, $y);
		$ticket->MultiCell(66*0.12, 4, $productoP["cantidad"], "", "C", false);
	
		$ticket->SetXY(5, $y);
		$ticket->MultiCell(66*0.63, 4, mb_convert_encoding("{$productoP["producto"]}", 'ISO-8859-1', 'UTF-8'), "", "L", false);


		

		if( $productoP["is_special"] != '' ){
			$ticket->SetXY(5, $ticket->GetY() + 4 );
			$ticket->MultiCell(35, 4, mb_convert_encoding("Fecha entrega", 'ISO-8859-1', 'UTF-8'), "", "C", false);
			$ticket->MultiCell(35, 39, mb_convert_encoding("{$productoP["is_special"]}", 'ISO-8859-1', 'UTF-8'), "", "C", false);
		}



		

	}

	$ticket->SetY($ticket->GetY()-2);
	$ticket->SetXY(5+66*0.40, $ticket->GetY()+3);
	$ticket->Cell(66*0.32, 2, "", "T" ,0, "C");
	
	$ticket->SetXY(5+66*0.75, $ticket->GetY());
	$ticket->Cell(66*0.25, 2, "", "T" ,0, "C");
	$ticket->SetY($ticket->GetY()-5);
	
//apartado de descuentos
	if($total != $subtotal) {
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Subtotal", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
		 
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "$ " . number_format($subtotal, 2), "" ,0, "R");
	
//AQUI ENTRA DETALLE DE DESCUENTOS
	//DESCUENTO POR PRODUCTOS
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Desc en prod:", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");

		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "-$ ".number_format($descProds, 2), "" ,0, "R");
	//DECUENTO DIRECTO EN MONTO
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Descuento directo:", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");

		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "-$ ".number_format(($descuentoGen-$descProds), 2), "" ,0, "R");
	//DESCUENTO GENERAL
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.25, 6, mb_convert_encoding("Descuento Total:", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
	
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "-$ " . number_format($descuentoGen, 2), "" ,0, "R");
	}
	
	$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
	$ticket->Cell(66*0.3, 6, mb_convert_encoding("Total", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
	
	$ticket->SetXY(5+66*0.75, $ticket->GetY());
	$ticket->Cell(66*0.25, 6, "$ " . number_format( round( $total, 2 ), 2), "" ,0, "R");
	
	/*$ticket->SetY($ticket->GetY()+4);
	$ticket->SetXY(7+66*0.40, $ticket->GetY()+3);
	$ticket->Cell(66*0.32, 2, "DEscuento", "T" ,0, "C");
	
	$ticket->SetXY(7+66*0.75, $ticket->GetY());
	$ticket->Cell(66*0.25, 2, "$descuento", "T" ,0, "C");
	$ticket->SetY($ticket->GetY()-5);*/
	
	if (count($pagos)) {
		
		$ticket->SetXY(/*5+*/66*0.1, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Fecha de pago", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");//utf8_decode()

		$ticket->SetXY(/*5+*/66*0.45, $ticket->GetY());
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Forma de pago", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");//utf8_decode()
			
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, mb_convert_encoding("Monto", 'ISO-8859-1', 'UTF-8'), "" ,0, "R");//utf8_decode()
		
		$ticket->SetY($ticket->GetY()+3);
		$ticket->SetXY(/*5+*/66*0.10, $ticket->GetY()+3);
		$ticket->Cell(66*0.32, 2, "", "T" ,0, "C");		

		$ticket->SetY($ticket->GetY());
		$ticket->SetXY(/*5+*/66*0.45, $ticket->GetY());
		$ticket->Cell(66*0.32, 2, "", "T" ,0, "C");
		
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 2, "", "T" ,0, "C");
		$ticket->SetY($ticket->GetY()-5);
		
		foreach ($pagos as $pago) {
			$ticket->SetXY(/*5+*/66*0.1, $ticket->GetY()+5);//66*0.4
			$ticket->Cell(66*0.5, 6, mb_convert_encoding("{$pago["nombre"]}", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
			
			$ticket->SetXY(5+66*0.75, $ticket->GetY());
			$ticket->Cell(66*0.25, 6, "$ " . number_format($pago["monto"], 2), "" ,0, "R");
		}

		if($lineas_dev>0){
			$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
			$ticket->Cell(66*0.3, 6, mb_convert_encoding("- Devoluciones", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
			$ticket->SetXY(5+66*0.75, $ticket->GetY());
			$ticket->Cell(66*0.25, 6, "$ " . number_format($monto_devolucion, 2), "" ,0, "R");

		}
	/**/

		$resta = $total - $total_pagos;
		if($resta < 0)
		{
			$resta = 0;
		}	    
	   
		}

	$ticket->SetFont('Arial','',$bF-2);
	if($pagado == 1) {
	//implementado por Oscar 29-12-2017
		if($diferencia!=''){
		//
			$ticket->SetFont('Arial','B',$bF+2);
			$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->Cell(5, 6, mb_convert_encoding("Total", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
				
			$ticket->SetXY(5+66*0.75, $ticket->GetY());
			$ticket->Cell(66*0.25, 6, "$ " . number_format($total_pagos-$monto_devolucion, 2), "" ,0, "R");
		//
			//$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->Cell(5, 6, mb_convert_encoding("Saldo a favor:", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");

			$ticket->SetXY(5+66*0.75, $ticket->GetY());
			$ticket->Cell(66*0.25, 6, "$ " . number_format($s_f_i, 2), "" ,0, "R");

		//
			$ticket->SetFont('Arial','B',20);
			$ticket->SetXY(5, $ticket->GetY()+7);
			$ticket->Cell(66, 6, mb_convert_encoding("{$accion}", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");

			$ticket->SetXY(5+66*0.75, $ticket->GetY());
			$ticket->Cell(66*0.25, 6, "$ ".$monto_, "" ,0, "R");

		}else{
			$ticket->SetFont('Arial','B',20);
			$ticket->SetXY(5, $ticket->GetY()+10);
			$ticket->Cell(5, 6, mb_convert_encoding("Total", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
				
			$ticket->SetXY(5+66*0.75, $ticket->GetY());
			//$ticket->Cell(66*0.25, 6, "$ " . number_format($total_pagos-$monto_devolucion, 2), "" ,0, "R");
			$ticket->Cell(66*0.25, 6, "$ " . number_format($total, 2), "" ,0, "R");

			$V=new EnLetras();
			$ticket->SetFont('Arial','',$bF-2);
			$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->Cell(66, 6, mb_convert_encoding($V->ValorEnLetras($total, "Pesos"), 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
		}
	//
		$ticket->SetFont('Arial','',$bF-2);
		$ticket->SetXY(5, $ticket->GetY()+8);
		$ticket->Cell(66, 6, mb_convert_encoding("Para cualquier aclaración, presentar su ticket.", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	//fin de cambio

	}else{
		$ticket->SetFont('Arial','B',$bF+5);
		$ticket->SetXY(3, $ticket->GetY()+6);
	    $ticket->Cell(74, 6, mb_convert_encoding("Resta : $" . number_format($resta, 2), 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
		
		$ticket->SetFont('Arial','',$bF-2);
		$ticket->SetXY(5, $ticket->GetY()+5);
		$ticket->Cell(66, 6, mb_convert_encoding("Fecha límite para recoger y liquidar sus apartados", 'ISO-8859-1', 'UTF-8'), "", 0, 'C');
	
		$ticket->SetXY(5, $ticket->GetY()+4);
		$ticket->Cell(66, 6, mb_convert_encoding("10 de Diciembre.", 'ISO-8859-1', 'UTF-8'), "", 0, 'C');
	
		$ticket->SetXY(5, $ticket->GetY()+5);
		$ticket->Cell(66, 6, mb_convert_encoding("En apartados NO hay cambios NI devoluciones.", 'ISO-8859-1', 'UTF-8'), "", 0, 'C');
  		
  		$ticket->SetFont('Arial','B',$bF+3);
		$ticket->SetXY(5, $ticket->GetY()+8);
		$ticket->Cell(70, 5, mb_convert_encoding("FOLIO APARTADO : {$folioA}", 'ISO-8859-1', 'UTF-8'), "", 0, 'C');
	
	}

	$ar = fopen("../leyenda_ticket/leyenda.txt","r") or die ('No se pudo abrir el archivo');

	 
    while(!feof($ar))
    {
        $linea=fgets($ar);
    }
    fclose($ar);
    $acotado = substr($linea,0,165);

    $ticket->SetFont('Arial','',$bF-2);
    $ticket->SetXY(10, $ticket->GetY()+6);
    $ticket-> MultiCell(60,5, mb_convert_encoding("{$acotado}", 'ISO-8859-1', 'UTF-8'), 0 ,'J',false);


/*Implementacion de liga de facturacion 2025-07-21*/
	$qr_image_path = "";
	try{
		$sql = "SELECT qr_liga_facturacion FROM sys_configuracion_sistema LIMIT 1";
		$QR_stm = $link->query($sql);
		$QR_row = $QR_stm->fetch(PDO::FETCH_ASSOC);
		$qr_image_path = $QR_row['qr_liga_facturacion'];
		$qr_image_path = str_replace("../../../", "../../", $qr_image_path);
	}catch(PDOException $error){
		die(json_encode(array("status"=>"302", "message"=>"Error al consultar ruita de QR facturacion.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
	}
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66, 6, mb_convert_encoding("SIN NECESITAS FACTURA SOLICITALA", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66, 6, mb_convert_encoding("DENTRO DEL MES DE TU COMPRA", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66, 6, mb_convert_encoding("ESCANEANDO EL SIGUIENTE CÔDIGO", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	//$ticket->SetXY(5, $ticket->GetY()+8);
	$ticket->Image("{$qr_image_path}", 20, $ticket->GetY()+4, 40);//../../../img_productos/sys_configuracion_sistema_qr_liga_facturacion_7980_1.png

	$ticket->SetXY(5, $ticket->GetY()+42);
    $ticket->SetFont('Arial','',$bF+2);
	$ticket->Cell(66, 6, mb_convert_encoding("lacasadelasluces.com", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	$ticket->SetXY(5, $ticket->GetY()+4);
    $ticket->SetFont('Arial','',$bF-2);
	$ticket->Cell(66, 6, mb_convert_encoding("TU FOLIO PARA FACTURAR ES", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66, 6, mb_convert_encoding("{$folio}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
/*Fin de cambio Oscar 2025-07-21*/

    $ticket->SetXY(5, $ticket->GetY()+3);
    $ticket->Cell(66, 6, mb_convert_encoding("Comprobante Simplificado de Operación", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");

    $ticket->SetXY(5, $ticket->GetY()+4);
    $ticket->Cell(66, 6, mb_convert_encoding("con público en general de acuerdo a la", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");

    $ticket->SetXY(5, $ticket->GetY()+4);
    $ticket->Cell(66, 6, mb_convert_encoding("regla 2.7.1.24 de la resolución miselanea", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");

    $ticket->SetXY(5, $ticket->GetY()+4);
    $ticket->Cell(66, 6, mb_convert_encoding("fiscal para 2025.", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");//
	
	if( $special_products > 0 ){
		//$ticket = null;
		include( 'ajax/ticket_dia_siguiente.php' );
	}
/*fin de cambio Oscar 2023/10/12*/
    if($printPan == 1) {
    	ob_end_clean();
	   $ticket->Output();
    }else{
/*implementacion Oscar 2024-02-01 para ruta especifica de ticket*/
	/*instancia clases*/
//include( '../conexionMysqli.php' );
		include( '../code/especiales/controladores/SysArchivosDescarga.php' );
		$SysArchivosDescarga = new SysArchivosDescarga( $link );
		include( '../code/especiales/controladores/SysModulosImpresionUsuarios.php' );
		$SysModulosImpresionUsuarios = new SysModulosImpresionUsuarios( $link );
		include( '../code/especiales/controladores/SysModulosImpresion.php' );
		$SysModulosImpresion = new SysModulosImpresion( $link );

/*implementación Oscar 17.09.2018 para impresión de tickets de acuerdo a la configuración de la sucursal*/
		try{
			$sql="SELECT IF($pagado=1,ticket_venta,ticket_apartado) FROM sys_sucursales WHERE id_sucursal=$user_sucursal";
			$eje = $link->query($sql);	
			$numero = $eje->fetch(PDO::FETCH_NUM);//mysql_fetch_row($eje);
			for($cont=1;$cont<=$numero[0];$cont++){
				$nombre_ticket="ticket_".$user_sucursal."_" . date("YmdHis") . "_" . strtolower($tipofolio) . "_" . $folio . "_".$cont.".pdf";

				$ruta_salida = '';
				$ruta_salida = $SysModulosImpresionUsuarios->obtener_ruta_modulo_usuario( $user_id, 5, $rootpath );//ticket de impresion
				if( $ruta_salida == 'no' ){
					$ruta_salida = "cache/" . $SysModulosImpresion->obtener_ruta_modulo( $user_sucursal, 5, $rootpath );//ticket de impresion
				}
				$ticket->Output( "../{$ruta_salida}/{$nombre_ticket}", "F" );
			/*Sincronización remota de tickets*/
				if( $user_tipo_sistema == 'linea' ){/*registro sincronizacion impresion remota*/
					$registro_sincronizacion = $SysArchivosDescarga->crea_registros_sincronizacion_archivo(5, 'pdf', $nombre_ticket, $ruta_or, $ruta_salida, $user_sucursal, $user_id, true );
				}else{//impresion por red local
					$enviar_por_red = $SysArchivosDescarga->crea_registros_sincronizacion_archivo_por_red_local( 5, 'pdf', $nombre_ticket, '', $ruta_salida, $user_sucursal, $user_id, $carpeta_path );
				}
			}//fin de for $cont
		}catch(PDOException $error){
			die("Error al consultar número de impresiones : {$sql} : {$error}");
		}
    	//die( "here" );
/*fin de cambio Oscar 17.09.2018*/

/*Implementación Oscar 07.03.2019 para finalzar el satus de la devolución*/
    if(isset($_GET["id_pedido_original"]) || $_GET['es_apartado']==1){
		try{
			$sql = "UPDATE ec_devolucion SET status = 3, observaciones = '$mensaje_nota' WHERE id_pedido = {$id_pedido_original}";
			$eje = $link->query($sql);
		}catch(PDOException $error){
			die("Error al actualizar el status de la devolución : {$sql} : {$error}");
		}
	}
/*Fin de cambio Oscar 07.03.2019*/
       	
      //deshabilitado por Oscare 2023/10/12 para no redireccionar	header ("location: index.php?scr=evaluation"); 
    }
		
	exit (0);

class EnLetras
{
  var $Void = "";
  var $SP = " ";
  var $Dot = ".";
  var $Zero = "0";
  var $Neg = "Menos";

	function ValorEnLetras($x, $Moneda ) 
	{
    $s="";
    $Ent="";
    $Frc="";
    $Signo="";
        
    if(floatVal($x) < 0)
     $Signo = $this->Neg . " ";
    else
     $Signo = "";
    
    if(intval(number_format($x,2,'.','') )!=$x) //<- averiguar si tiene decimales
      $s = number_format($x,2,'.','');
    else
      $s = number_format($x,0,'.','');
       
    $Pto = strpos($s, $this->Dot);
        
    if ($Pto === false)
    {
      $Ent = $s;
      $Frc = $this->Void;
    }
    else
    {
      $Ent = substr($s, 0, $Pto );
      $Frc =  substr($s, $Pto+1);
    }

    if($Ent == $this->Zero || $Ent == $this->Void)
       $s = "Cero ";
    elseif( strlen($Ent) > 7)
    {
       $s = $this->SubValLetra(intval( substr($Ent, 0,  strlen($Ent) - 6))) . 
             "Millones " . $this->SubValLetra(intval(substr($Ent,-6, 6)));
    }
    else
    {
      $s = $this->SubValLetra(intval($Ent));
    }

    if (substr($s,-9, 9) == "Millones " || substr($s,-7, 7) == "Millón ")
       $s = $s . "de ";

    $s = $s . $Moneda;

    if($Frc != $this->Void)
    {
       //$s = $s . " Con " . $this->SubValLetra(intval($Frc)) . "Centavos";
       $s = $s . " " . $Frc . "/100";
    }
    return ($Signo . $s . " M.N.");
   
}

function SubValLetra($numero) 
{
    $Ptr="";
    $n=0;
    $i=0;
    $x ="";
    $Rtn ="";
    $Tem ="";

    $x = trim("$numero");
    $n = strlen($x);

    $Tem = $this->Void;
    $i = $n;
    
    while( $i > 0)
    {
       $Tem = $this->Parte(intval(substr($x, $n - $i, 1). 
                           str_repeat($this->Zero, $i - 1 )));
       If( $Tem != "Cero" )
          $Rtn .= $Tem . $this->SP;
       $i = $i - 1;
    }

    
    //--------------------- GoSub FiltroMil ------------------------------
    $Rtn=str_replace(" Mil Mil", " Un Mil", $Rtn );
    while(1)
    {
       $Ptr = strpos($Rtn, "Mil ");       
       If(!($Ptr===false))
       {
          If(! (strpos($Rtn, "Mil ",$Ptr + 1) === false ))
            $this->ReplaceStringFrom($Rtn, "Mil ", "", $Ptr);
          Else
           break;
       }
       else break;
    }

    //--------------------- GoSub FiltroCiento ------------------------------
    $Ptr = -1;
    do{
       $Ptr = strpos($Rtn, "Cien ", $Ptr+1);
       if(!($Ptr===false))
       {
          $Tem = substr($Rtn, $Ptr + 5 ,1);
          if( $Tem == "M" || $Tem == $this->Void)
             ;
          else          
             $this->ReplaceStringFrom($Rtn, "Cien", "Ciento", $Ptr);
       }
    }while(!($Ptr === false));

    //--------------------- FiltroEspeciales ------------------------------
    $Rtn=str_replace("Diez Un", "Once", $Rtn );
    $Rtn=str_replace("Diez Dos", "Doce", $Rtn );
    $Rtn=str_replace("Diez Tres", "Trece", $Rtn );
    $Rtn=str_replace("Diez Cuatro", "Catorce", $Rtn );
    $Rtn=str_replace("Diez Cinco", "Quince", $Rtn );
    $Rtn=str_replace("Diez Seis", "Dieciseis", $Rtn );
    $Rtn=str_replace("Diez Siete", "Diecisiete", $Rtn );
    $Rtn=str_replace("Diez Ocho", "Dieciocho", $Rtn );
    $Rtn=str_replace("Diez Nueve", "Diecinueve", $Rtn );
    $Rtn=str_replace("Veinte Un", "Veintiun", $Rtn );
    $Rtn=str_replace("Veinte Dos", "Veintidos", $Rtn );
    $Rtn=str_replace("Veinte Tres", "Veintitres", $Rtn );
    $Rtn=str_replace("Veinte Cuatro", "Veinticuatro", $Rtn );
    $Rtn=str_replace("Veinte Cinco", "Veinticinco", $Rtn );
    $Rtn=str_replace("Veinte Seis", "Veintiseís", $Rtn );
    $Rtn=str_replace("Veinte Siete", "Veintisiete", $Rtn );
    $Rtn=str_replace("Veinte Ocho", "Veintiocho", $Rtn );
    $Rtn=str_replace("Veinte Nueve", "Veintinueve", $Rtn );

    //--------------------- FiltroUn ------------------------------
    If(substr($Rtn,0,1) == "M") $Rtn = "Un " . $Rtn;
    //--------------------- Adicionar Y ------------------------------
    for($i=65; $i<=88; $i++)
    {
      If($i != 77)
         $Rtn=str_replace("a " . Chr($i), "* y " . Chr($i), $Rtn);
    }
    $Rtn=str_replace("*", "a" , $Rtn);
    return($Rtn);
}

function ReplaceStringFrom(&$x, $OldWrd, $NewWrd, $Ptr)
{
  $x = substr($x, 0, $Ptr)  . $NewWrd . substr($x, strlen($OldWrd) + $Ptr);
}


function Parte($x)
{
    $Rtn='';
    $t='';
    $i='';
    Do
    {
      switch($x)
      {
         Case 0:  $t = "Cero";break;
         Case 1:  $t = "Un";break;
         Case 2:  $t = "Dos";break;
         Case 3:  $t = "Tres";break;
         Case 4:  $t = "Cuatro";break;
         Case 5:  $t = "Cinco";break;
         Case 6:  $t = "Seis";break;
         Case 7:  $t = "Siete";break;
         Case 8:  $t = "Ocho";break;
         Case 9:  $t = "Nueve";break;
         Case 10: $t = "Diez";break;
         Case 20: $t = "Veinte";break;
         Case 30: $t = "Treinta";break;
         Case 40: $t = "Cuarenta";break;
         Case 50: $t = "Cincuenta";break;
         Case 60: $t = "Sesenta";break;
         Case 70: $t = "Setenta";break;
         Case 80: $t = "Ochenta";break;
         Case 90: $t = "Noventa";break;
         Case 100: $t = "Cien";break;
         Case 200: $t = "Doscientos";break;
         Case 300: $t = "Trescientos";break;
         Case 400: $t = "Cuatrocientos";break;
         Case 500: $t = "Quinientos";break;
         Case 600: $t = "Seiscientos";break;
         Case 700: $t = "Setecientos";break;
         Case 800: $t = "Ochocientos";break;
         Case 900: $t = "Novecientos";break;
         Case 1000: $t = "Mil";break;
         Case 1000000: $t = "Millón";break;
      }

      If($t == $this->Void)
      {
        $i = (int)$i + 1;
        $x = $x / 1000;
        If($x== 0) $i = 0;
      }
      else
         break;
           
    }while($i != 0);
   
    $Rtn = $t;
    Switch($i)
    {
       Case 0: $t = $this->Void;break;
       Case 1: $t = " Mil";break;
       Case 2: $t = " Millones";break;
       Case 3: $t = " Billones";break;
    }
    return($Rtn . $t);
}
}
?>