<?php
//Version Oscar 2025-02-04 (Migracion a PHP 8.2)
//Version Oscar 2025-09-02
	#header("Content-Type: text/plain;charset=utf-8");
	//die('here');
	define('FPDF_FONTPATH','../include/fpdf186/font/');
	$logger = false;
	//consulta si el log esta habilitado
	try{
		$sql = "SELECT habilitar_log FROM sys_logs_archivos WHERE id_log_archivo = 2";
		$stm = $link->query($sql);
		if($stm->rowCount() > 0){
			$row = $stm->fetch(PDO::FETCH_ASSOC);
			$logger = ($row['habilitar_log'] == 1 || $row['habilitar_log'] == '1' ? true : false);
		}
	}catch(PDOException $error){
		die("Error al consultar si el log esta habilitado : {$sql} : {$error->getMessage()}");
	}
	include("../include/fpdf186/fpdf.php");
/*implementación Oscar 25.01.2019 para sacar rutas de tickets*/
	$archivo_path = "../conexion_inicial.txt";
	$carpeta_path = "";
	if(file_exists($archivo_path)){
		$file = fopen($archivo_path,"r");
		$line=fgets($file);
		fclose($file);
	    $config=explode("<>",$line);
	    $tmp=explode("~",$config[2]);
	    $ruta_or=$tmp[0];
	    $ruta_des=$tmp[1];
	    $tmp_=explode("~",$config[0]);
		$carpeta_path = base64_decode( $tmp_[1] );
if($logger){
	error_log("Se obtiene configuracion desde ../conexion_inicial.txt y se obtieen las siguientes variables :");
	error_log("ruta_or = {$ruta_or}\nruta_des = {$ruta_des}\ncarpeta_path = {$carpeta_path}");
}
	}else{
if($logger){
	error_log("No hay archivo de configuracion en : ../conexion_inicial.txt");
}
		die("No hay archivo de configuración!!!");
	}
/*Fin de cambio Oscar 25.01.2018*/
    
	$devolucion = array();
	$id_pedido_devolucion = null;
	$numero = 1;
	$printPan = ( isset($_GET['printPan']) ? $_GET['printPan'] : 0 );
	$mensaje_nota = ( isset($_GET['mensaje_nota']) ? $_GET['mensaje_nota'] : '' );
if($logger){
	error_log("mensaje nota : {$mensaje_nota}");
}
    if(!isset($_GET["noImp"])){
        $_GET["noImp"] = 1;
    }
	$_GET['id_pedido_original'] = ( isset($_GET['id_pedido_original']) ? $_GET['id_pedido_original'] : '' );
	//consulta si tiene devolucion pendientes de pasar por la pantalla de cobros
	try{
		$sql = "SELECT
					d.folio AS folio_devolucion,
					p.folio_nv AS folio_venta_original,
					p.total AS total_actual,
					CONCAT( u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno ) AS vendedor
				FROM ec_devolucion d
				LEFT JOIN ec_devolucion_detalle dd
				ON dd.id_devolucion = d.id_devolucion
				LEFT JOIN ec_pedidos p 
				ON p.id_pedido = d.id_pedido
				LEFT JOIN sys_users u 
				ON u.id_usuario = p.id_usuario
				WHERE d.id_pedido = '{$_GET['id_pedido_original']}'
				AND d.id_cajero = 0
				AND d.id_sesion_caja = 0
				GROUP BY d.id_pedido";
		$stm = $link->query( $sql );
if($logger){
	error_log("Consulta si tiene devolucion pendientes de pasar por la pantalla de cobros : {$sql}");
}
		if( $stm->rowCount() <= 0 ){//mysql_num_rows( $stm )

			try{
				$sql = "SELECT
							d.folio AS folio_devolucion,
							p.folio_nv AS folio_venta_original,
							CONCAT( u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno ) AS vendedor
						FROM ec_devolucion d
						LEFT JOIN ec_devolucion_detalle dd
						ON dd.id_devolucion = d.id_devolucion
						LEFT JOIN ec_pedidos p 
						ON p.id_pedido = d.id_pedido
						LEFT JOIN sys_users u 
						ON u.id_usuario = p.id_usuario
						WHERE d.id_pedido = '{$_GET['idp']}'
						AND d.id_cajero = 0
						AND d.id_sesion_caja = 0
						GROUP BY d.id_pedido";//die( $sql );
				$stm = $link->query( $sql );
				$id_pedido_devolucion = $_GET['idp'];
if($logger){
	error_log("No encuentra devolucion pendiente y vuelve a consultar devolucon relacionada a la nota de venta : {$sql}");
}
			}catch(PDOException $error){
				die( "Error al consultar si hay devolucion pendientes : {$sql} : {$error}" );
			}
		}else{
			$id_pedido_devolucion = $_GET['id_pedido_original'];
		}
		if( $stm->rowCount() > 0 ){//mysql_num_rows( $stm )
			$row = $stm->fetch(PDO::FETCH_ASSOC);//mysql_fetch_assoc( $stm );
			$devolucion = $row;
		//consulta el detalle
			try{
				$dev_detail = "SELECT 
						aux.id_producto,
						aux.producto,
						aux.cantidad,
						aux.precio,
						aux.monto,
						aux.descuento,
						aux.porc_desc,
						IF(s.mostrar_ubicacion=1 Or s.mostrar_alfanumericos=1,1,0) as infoAdicional,
						CONCAT(
						IF(s.mostrar_ubicacion=1 AND sp.ubicacion_almacen_sucursal!='',CONCAT('Ubicación: ',sp.ubicacion_almacen_sucursal,' | '),''),
							IF(s.mostrar_alfanumericos=1,CONCAT('Clave: ',aux.clave),'')
						) as info
					FROM(
						SELECT
						P.id_productos AS id_producto,
						P.nombre AS producto,
						P.clave,
						IF(prd.id_producto IS NULL, dd.cantidad , ROUND( dd.cantidad / prd.cantidad ) ) AS cantidad,
						dp.precio AS precio,
						( IF(prd.id_producto IS NULL, dd.cantidad , ROUND( dd.cantidad / prd.cantidad ) )*dp.precio)
							-((IF(prd.id_producto IS NULL, dd.cantidad , ROUND( dd.cantidad / prd.cantidad ) )*dp.precio)
							*
							(IF(pe.descuento=0,0,(pe.descuento*100/pe.subtotal))/100)) AS monto,
						IF(dp.descuento=0,0,dp.descuento/dp.cantidad) AS descuento,
						(IF(pe.descuento=0,0,(pe.descuento*100/pe.subtotal)/100)*(dd.cantidad*dp.precio)) AS porc_desc
						FROM ec_devolucion_detalle dd 
						INNER JOIN ec_devolucion d  
						ON dd.id_devolucion = d.id_devolucion
						INNER JOIN ec_pedidos_detalle dp  
						ON dp.id_pedido_detalle = dd.id_pedido_detalle
						LEFT JOIN ec_pedidos pe ON pe.id_pedido=dp.id_pedido
						INNER JOIN  ec_productos P
						ON dp.id_producto = P.id_productos
						LEFT JOIN ec_productos_detalle prd
						ON prd.id_producto = dp.id_producto
						WHERE d.id_pedido IN( {$id_pedido_devolucion} )
						AND d.id_sesion_caja = 0
						AND d.id_cajero = 0
					)aux
					LEFT JOIN sys_sucursales_producto sp ON aux.id_producto=sp.id_producto
					JOIN sys_sucursales s ON sp.id_sucursal=s.id_sucursal AND sp.id_sucursal={$user_sucursal}";
				$dev_stm = $link->query( $dev_detail );
if($logger){
	error_log("Consulta el detalle de la devolucion : {$sql}");
}
				if( $dev_stm->rowCount() > 0 ){//mysql_num_rows( $dev_stm )
					$devolucion['detail'] = array();
					while( $dev_row = $dev_stm->fetch(PDO::FETCH_ASSOC) ){//$dev_row = mysql_fetch_assoc( $dev_stm )
						array_push( $devolucion['detail'], $dev_row );
					}
					//$dev_row['detail']
				}
			}catch(PDOException $error){ 
				die( "Error al consultar el detalle de los productos devueltos : {$dev_detail} : {$error}" );
			}
		//consulta pagos
			try{
				$sql = "SELECT
							ax.total_pedido_pagos,
							SUM( IF( dp.id_devolucion_pago IS NULL, 0, dp.monto ) ) AS total_devolucion_pagos
						FROM(
							SELECT
								p.id_pedido,
								SUM( IF( pp.id_pedido_pago IS NULL, 0, pp.monto ) ) AS total_pedido_pagos
							FROM ec_pedidos p
							LEFT JOIN ec_pedido_pagos pp
							ON pp.id_pedido = p.id_pedido
							WHERE p.id_pedido = {$id_pedido_devolucion}
							GROUP BY p.id_pedido
						)ax
						LEFT JOIN ec_devolucion d
						ON d.id_pedido = ax.id_pedido
						LEFT JOIN ec_devolucion_pagos dp
						ON dp.id_devolucion = d.id_devolucion
						GROUP BY ax.id_pedido";
				$payment_stm = $link->query( $sql );
				$payment_row = $payment_stm->fetch(PDO::FETCH_ASSOC);//mysql_fetch_assoc( $payment_stm );
				$devolucion['pagos_realizados'] = $payment_row['total_pedido_pagos'] - $payment_row['total_devolucion_pagos'];
if($logger){
	error_log("Consulta pagos de la devolucion : {$sql}");
	error_log("Valores obtenidos : \n(devolucion['pagos_realizados']) {$devolucion['pagos_realizados']} = {$payment_row['total_pedido_pagos']} - {$payment_row['total_devolucion_pagos']};");
}
//error_log("SQL : {$sql}");
//error_log("PAGOS RESULTADO : {$devolucion['pagos_realizados']}");
			}catch(PDOException $error){
				die("Error al consultar monto pagado : {$sql} : {$error}");
			}
		}
	}catch(PDOException $error){
		die( "Error al consultar si hay devolucion pendiente : {$sql} : {$error}" );
	}
		//die( "here : {$ruta_or}" );
	//}
//var_dump( $devolucion );
//die(json_encode( $devolucion ));
//implementado por Oscar 29-12-2017
    $diferencia='';
    $s_f_i=0;
    if(isset($_GET["sald_fav_cl"])){
    	$diferencia=1;//
    	$saldo_cliente=$_GET["sald_fav_cl"];//recibimos saldo a favor del cliente

    	if($saldo_cliente==0){
    		$accion="Saldo liquidado";
    		$monto_=0;
    	}
    	if($saldo_cliente<0){
    		$accion="Cobrar:";
    		$monto_=round($saldo_cliente*-1,2);
    		$mensaje_nota="Se Cobró al cliente: $".$saldo_cliente;
    	}
    	if($saldo_cliente>0){
    		$accion="Devolver:";
    		$monto_=round($saldo_cliente,2);
    		$mensaje_nota="Se Regresó al cliente: $".$saldo_cliente;
    	}

    	if($monto_<1){
    		$monto_=0;
    	}	

    	$s_f_i=$_GET["favOrig"];
    }
//fin de cambio
	$id_pedido = $_GET["idp"];	
	$sucursal = "";
	$folio = "";
	$prefijo = "";
	$subtotal = "0";
	$total = "0";
	$descuentoGen = 0;
	$productos = array();
	$productosP = array();
	$pagos = array();
	$vendedor = "N/A";
	$lineas_productos = 0;
	$lineas_pagos = 0;
	$total_pagos = 0;
	$tipofolio = "PEDIDO";
	$datos_fiscales = null;
	$show_discount = null;
	$folioA = null;
	$fecha_tkt = null;
	$monto_devolucion = 0;
	$lineas_dev = 0;
//datos del vendedor	
	try{
		$cs = "SELECT
					CONCAT(nombre, ' ', apellido_paterno) AS vendedor 
				FROM sys_users 
				WHERE id_usuario = '{$user_id}'";
		$rs = $link->query($cs);
		$dr = $rs->fetch(PDO::FETCH_ASSOC);//mysql_fetch_assoc($rs)
		$vendedor = $dr["vendedor"];
		$rs = null;//mysql_free_result($rs);
	}catch(PDOException $error){
		die("Error al consultar datos del vendedor : {$cs} : {$error}");
	}
//datos de la sucursal
	try{
		$cs = "SELECT 
				s.nombre AS sucursal, 
				s.prefijo,
				REPLACE(s.descripcion,'*','\n') as descripcion,
				sc.mostrar_descuento_ticket 
			FROM sys_sucursales s 
			LEFT JOIN ec_configuracion_sucursal sc ON s.id_sucursal = sc.id_sucursal
			WHERE s.id_sucursal = '{$user_sucursal}' ";
		$rs = $link->query($cs);
		$dr = $rs->fetch(PDO::FETCH_ASSOC);
		$sucursal = $dr["sucursal"];//Nombre de sucursal
		$prefijo = $dr["prefijo"];//Prefijo de la sucursal
		$datos_fiscales = $dr["descripcion"];//Datos Fiscales
		$show_discount = $dr["mostrar_descuento_ticket"];//Ver descuento del ticket
		$rs = null;//mysql_free_result($rs);
if($logger){
	error_log("Consulta datos de la sucursal : {$cs}");
	error_log("Resultados obtenidos : sucursal = {$sucursal}\nprefijo = {$prefijo}\ndatos_fiscales = {$datos_fiscales}\nshow_discount = {$show_discount}");
}
	}catch(PDOException $error){
		die( "Error al consultar datos de la sucursal : {$cs} : {$error}" );
	}
//datos de la venta
	try{
		$cs = "SELECT
				IF(ISNULL(folio_nv),
				folio_pedido, folio_nv) AS folio,
				IF(ISNULL(folio_nv), 'PEDIDO', 'FOLIO') AS tipofolio,
				subtotal,
				iva,
				ieps,
				total,
				descuento,
				pagado,
				folio_abono as folioA,
				DATE_FORMAT(NOW(), '%d/%m/%Y %H:%i:%s') as fecha_ticket
			FROM ec_pedidos
			WHERE id_pedido = '{$id_pedido}'";
		$rs = $link->query($cs);
		$dr = $rs->fetch(PDO::FETCH_ASSOC);//){//mysql_fetch_assoc($rs)
		$tipofolio = $dr["tipofolio"];
		$folio = $dr["folio"];
		$total = $dr["total"];
		$subtotal = $dr["subtotal"];
		$pagado = $dr["pagado"];
		$descuentoGen= $dr["descuento"];
		$folioA = "A{$prefijo}{$dr["folioA"]}";
		$fecha_tkt = $dr["fecha_ticket"];
		$rs = null;//mysql_free_result($rs);
if($logger){
	error_log("Consulta datos de la venta : {$cs}");
	error_log("Resultados obtenidos : tipofolio = {$tipofolio}\nfolio = {$folio}\ntotal = {$total}\nsubtotal = {$subtotal}\pagado = {$pagado}\ndescuentoGen = {$descuentoGen}\nfolioA = {$folioA}\nfecha_tkt = {$fecha_tkt}");
}
	}catch(PDOException $error){
		die("Error al consultar datos de la nota de venta : {$cs} : {$error}");
	}
	try{
		$cs = "SELECT 
					CONCAT(PP.fecha,' ',TP.nombre,'(pagos)') AS nombre, 
					SUM(monto) AS monto 
				FROM ec_pedido_pagos PP
				INNER JOIN ec_tipos_pago TP ON PP.id_tipo_pago = TP.id_tipo_pago
				WHERE PP.id_pedido = '{$id_pedido}' AND (referencia='' OR referencia=null)
				GROUP BY CONCAT(PP.fecha,' ',PP.hora)
				ORDER BY PP.id_pedido_pago ASC";//TP.nombre
		$rs = $link->query($cs);
if($logger){
	error_log("Consulta pagos de la venta : {$sql}");
}
		while ( $dr = $rs->fetch(PDO::FETCH_ASSOC) ){//mysql_fetch_assoc
			// Concatenar precio unitario en la descripción
			++$lineas_pagos;
			$total_pagos += $dr["monto"];
if($logger){
	error_log("total_pagos : {$total_pagos}");
}
			array_push($pagos, $dr);
		}
		$rs = null;//mysql_free_result($rs);
	}catch(PDOException $error){
		die("Error al consultar los pagos de la nota de venta : {$sql} : {$error}");
	}
/*implementación de Oscar 19.11.2018 para restar devoluciones*/
	try{
		$sql="SELECT 
				SUM( IF(dev.id_devolucion IS NULL,0,IF(referencia='' OR referencia=null,dp.monto,0) ) )
			FROM ec_devolucion_pagos dp 
			LEFT JOIN ec_devolucion dev ON dp.id_devolucion=dev.id_devolucion
			WHERE dev.id_pedido = '{$id_pedido}'";
		$eje = $link->query($sql);
if($logger){
	error_log("Consulta devoluciones pagos : {$sql}");
}
		if( $eje->rowCount() > 0 ){
			$res_dev = $eje->fetch(PDO::FETCH_NUM);//mysql_fetch_row($eje);
			$monto_devolucion = $res_dev[0];//aqui se guarda el monto de la devolucion
if($logger){
	error_log("monto_devolucion : {$monto_devolucion}");
}
			if($monto_devolucion > 0){
				$lineas_dev = 5;//indicador de lineas de devolución
			}
		}
	}catch(PDOException $error){
		die("Error al calcular monto de devoluciones : {$sql} : {$error}");
	}
/*fin de cambio 06.09.2018*/
	
	class TicketPDF extends FPDF {
		// Members
		var $sucursal = "";
		var $pedido = "";
		var $inicio = 32;
	
		// Constructor
		function TicketPDF($orientation='P', $unit='mm', $size = 0, $sucursal='', $pedido='', $inicio=10) {
			parent::FPDF($orientation, $unit, $size);
				
			$this->AddFont('Arial');
			$this->SetMargins(7, 0, 7);
			$this->SetDisplayMode("real", "continuous");
			#$this->SetAutoPageBreak(false);
			$this->SetAutoPageBreak(true, -5);
				
			$this->sucursal = mb_convert_encoding($sucursal, "ISO-8859-1", "UTF-8");//utf8_decode($sucursal);
			$this->pedido = mb_convert_encoding($pedido, "ISO-8859-1", "UTF-8");//utf8_decode($pedido);
			$this->inicio = $inicio;
		}
	
		// Cabecera de página
		function Header() {
		}
	
		function Footer() {
			//$this->SetY(-15);
			//$this->SetFont('Arial','I',8);
			// Número de página
			//$this->Cell(0,10, utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
		}
	
		function AcceptPageBreak() {
			$x = $this->GetX();
			$this->AddPage();
			//$this->SetXY($x, $this->inicio);
			$this->SetXY($x, 1);
			#$this->SetY($this->inicio);
			return false;
		}
	}
	$espacio_devolucion = ( ( isset($devolucion['folio_devolucion']) && $devolucion['folio_devolucion'] != null ) ? 30 : 0 );
	//+40+130
	$ticket = new TicketPDF("P", "mm", array(80,80+$espacio_devolucion+$lineas_dev+50+$lineas_productos*6+($total!=$subtotal?12:0)+($pagado>0?14:30)+(count($pagos)>0?($lineas_pagos+1)*6:0)+40+40+20), "{$sucursal}", "{$folio}", 10);
	$ticket->AliasNbPages();
	$ticket->AddPage();
	
	$bF=10;
	if($tv==1){
		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(5, $ticket->GetY()+1);
		$ticket->Cell(66, 3, mb_convert_encoding("VENTA POR MAYOREO", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("VENTA POR MAYOREO")
	}
/*implementacion Oscar 2021 para mostrar descuento de ticket*/
	if( ($total!=$subtotal) && $show_discount == 1 ){
		$ticket->SetFont('Arial','B',$bF);
		$ticket->SetXY(15, $ticket->GetY()+1);
		$ticket->Cell(66, 3, mb_convert_encoding("DESCUENTO", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("DESCUENTO : ")

		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(32, $ticket->GetY()+1);
		$ticket->Cell(66, 3, mb_convert_encoding(" $ {$descuentoGen}", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode(" $ {$descuentoGen}")
	}
/*fin de cambio Oscar 2021*/

/*implementación de Oscar 10.09.2018 para */
	if( isset($_GET['es_apartado']) && $_GET['es_apartado'] == 1 ){//si es apartado
		$ticket->SetFont('Arial','B',$bF+4);
		$ticket->SetXY(5, $ticket->GetY()+2);
		$ticket->Cell(66, 6, mb_convert_encoding("REIMPRESIÓN DE TICKET", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("REIMPRESIÓN DE TICKET")

		$ticket->SetXY(5, $ticket->GetY()+4);
		$ticket->Cell(66, 6, mb_convert_encoding("POR CAMBIO", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("POR CAMBIO")
	}
/*fin de cambio 10.09.2018*/

	$ticket->SetXY(5, $ticket->GetY()+6);
	$ticket->Cell(66, 3, "", "TB" ,0, "C");
	
	$ticket->SetFont('Arial','',$bF-2);
	$ticket->SetXY(5, $ticket->GetY()+4);
	//$ticket->MultiCell(66, 6, utf8_decode('datos:'.$datos_fiscales), "" ,0, "C");
//$ticket->MultiCell(66, 4, utf8_decode($datos_fiscales), "", "C", false);
	
	$ticket->SetFont('Arial','B',$bF+4);
	$ticket->SetXY(5, $ticket->GetY()+6);
	$ticket->Cell(66, 6, mb_convert_encoding("VENDEDOR", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("VENDEDOR:")
	$ticket->SetXY(5, $ticket->GetY()+8);
	$ticket->SetFont('Arial','B',$bF+8);
	$ticket->Cell(66, 6, mb_convert_encoding("{$vendedor}", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("{$vendedor}")

	$ticket->SetFont('Arial','B',$bF);
	$ticket->SetXY(5, $ticket->GetY()+12);
	$ticket->Cell(66, 6, mb_convert_encoding("FOLIO : {$folio}", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("FOLIO : {$ticket->pedido}")
	$ticket->SetXY(5, $ticket->GetY()+4);
	//$ticket->Cell(66*0.6, 6, utf8_decode("{$tipofolio}"), "" ,0, "C");
	
	//$ticket->SetX(5+66*0.6);
	//$ticket->Cell(66, 6, utf8_decode("{$ticket->pedido}"), "" ,0, "C");
	
	$ticket->SetXY(5, $ticket->GetY()+6);
	$ticket->Cell(66, 3, "", "TB" ,0, "C");
	
	$ticket->SetFont('Arial','',$bF);
	
	$ticket->SetXY(5, $ticket->GetY()+3);
	$ticket->Cell(66, 6, mb_convert_encoding("FECHA Y HORA DE EMISIÓN:", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("FECHA Y HORA DE EMISIÓN:")
	
	$ticket->SetXY(5, $ticket->GetY()+4.5);
/*implementación Oscar 28.02.2019 para que la hora del ticket sea tomada de la MySQL*/
	$ticket->Cell(66, 6, mb_convert_encoding("Estado de México {$fecha_tkt}", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("Estado de México ") . utf8_decode($fecha_tkt)
/*Fin de cambio Oscar 28.02.2019*/
	
	
	$ticket->SetXY(5, $ticket->GetY()+5.5);
	$ticket->Cell(66, 3, "", "TB" ,0, "C");
	
/*implementacion Oscar 2024-03-07 para adjuntar devolucion en ticket de talon de pago*/
	if( sizeof($devolucion) > 0 ){
		if($total != 0 ){//&& $total_pagos != 0
			$ticket->SetFont('Arial','B',$bF+8);
			$ticket->SetXY(5, $ticket->GetY()+6);
			$ticket->Cell(66, 6, mb_convert_encoding("DEVOLUCION:", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("DEVOLUCION:")
			$ticket->SetFont('Arial','B',$bF );
			$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->Cell(66, 6, mb_convert_encoding("Folio devolución : {$devolucion['folio_devolucion']}", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Folio devolución : {$devolucion['folio_devolucion']}")
			$ticket->SetFont('Arial','B',$bF );
			$ticket->SetXY(5, $ticket->GetY()+4);
			$ticket->Cell(66, 6, mb_convert_encoding("Folio pedido : {$devolucion['folio_venta_original']}", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Folio pedido : {$devolucion['folio_venta_original']}")
		//tabla de productos devueltos
			$ticket->SetXY(7, $ticket->GetY()+5.5);
			$ticket->Cell(66, 3, "", "TB" ,0, "C");
			
			$ticket->SetFont('Arial','',$bF);
			
			$ticket->SetXY(7, $ticket->GetY()+6);
			$ticket->Cell(66*0.63, 6, mb_convert_encoding("DESCRIPCIÓN", "ISO-8859-1", "UTF-8"), "B" ,0, "L");//utf8_decode("DESCRIPCIÓN")
			$ticket->SetXY(7+66*0.63, $ticket->GetY());
			$ticket->Cell(66*0.12, 6, mb_convert_encoding("CANT", "ISO-8859-1", "UTF-8"), "B" ,0, "L");//utf8_decode("CANT")
			$ticket->SetXY(7+66*0.75, $ticket->GetY());
			$ticket->Cell(66*0.25, 6, mb_convert_encoding("PRECIO", "ISO-8859-1", "UTF-8"), "B" ,0, "R");//utf8_decode("PRECIO")		
			$ticket->SetFont('Arial','',$bF-2);
			$ticket->SetXY(7, $ticket->GetY()+8);
	
			$total_de_devolucion=0;
			foreach ($devolucion['detail'] as $producto) {
					$y = $ticket->GetY();
					
					$ticket->SetXY(7+66*0.75, $y);
					//$totReal+=$producto["monto"];
					
					$ticket->MultiCell(66*0.25, 4, "$ " . number_format($producto["monto"], 2), "", "R", false);
					
					$ticket->SetXY(7+66*0.63, $y);
					$ticket->MultiCell(66*0.12, 4, $producto["cantidad"], "", "C", false);
					
					$ticket->SetXY(7, $y);
					$ticket->MultiCell(66*0.63, 4, mb_convert_encoding("{$producto["producto"]}", "ISO-8859-1", "UTF-8"), "", "L", false);//utf8_decode("{$producto["producto"]}")
			/*implementación Oscar 10.10.2018 para imprimir ubicación y clave_proveedor en ticket*/
				if($producto['infoAdicional']==1){
					$ticket->SetFont('Arial','',$bF-3.5);
					$ticket->SetXY(5,($ticket->GetY()-1.5));
					$ticket->MultiCell(66*0.63, 4, mb_convert_encoding("{$producto["info"]}", "ISO-8859-1", "UTF-8"), "", "L", false);//utf8_decode("{$producto["info"]}")
				}
				$ticket->SetFont('Arial','',$bF-2);
			/*fin de cambio 10.10.2018*/
				$total_de_devolucion+=$producto["monto"];
			}
			/*$ticket->SetXY(7+66*0.40, $ticket->GetY()+3);
			$ticket->Cell(66*0.32, 2, "", "T" ,0, "C");*/
			$ticket->SetFont('Arial','',$bF);
			$ticket->SetXY(7+66*0.40, $ticket->GetY()+3);
			$ticket->Cell(100*0.40, 2, "", "T" ,0, "C");
			$ticket->SetXY(7+66*0.40, $ticket->GetY()+1);
			$ticket->Cell(100*0.40, 6, "Total Devolucion : $ " . number_format(round($total_de_devolucion,2), 2), "" ,0, "R"); 
	}else{
		$ticket->SetFont('Arial','B',$bF+20);
		$ticket->SetXY(5, $ticket->GetY()+8);
		$ticket->Cell(66, 6, mb_convert_encoding("NOTA", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("TOTAL")
		$ticket->SetXY(5, $ticket->GetY()+8);
		$ticket->Cell(66, 6, mb_convert_encoding("CANCELADA", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("TOTAL")
	} 
		//die( "here" );
	}else{
		//die( "not_here" );
	}
/*Fin de implementacion Oscar 2024-03-07 para adjuntar devolucion en ticket de talon de pago*/

	$ticket->SetFont('Arial','',$bF);

	/*$ticket->SetY($ticket->GetY()-2);
	$ticket->SetXY(5+66*0.40, $ticket->GetY()+3);
	$ticket->Cell(66*0.32, 2, "", "T" ,0, "C");
	
	$ticket->SetXY(5+66*0.75, $ticket->GetY());
	$ticket->Cell(66*0.25, 2, "", "T" ,0, "C");
	$ticket->SetY($ticket->GetY()-5);*/
	
//apartado de descuentos
	if($total != $subtotal) {
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Subtotal", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Subtotal")
		 
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "$ " . number_format($subtotal, 2), "" ,0, "R");
	
//AQUI ENTRA DETALLE DE DESCUENTOS
	//DESCUENTO POR PRODUCTOS
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Desc en prod:", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Desc en prod:")
		$descProds = 0;
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "-$ ".number_format($descProds, 2), "" ,0, "R");
	//DECUENTO DIRECTO EN MONTO
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.3, 6, mb_convert_encoding("Descuento directo:", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Descuento directo:")

		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "-$ ".number_format(($descuentoGen-$descProds), 2), "" ,0, "R");
	//DESCUENTO GENERAL
		$ticket->SetXY(5+66*0.4, $ticket->GetY()+5);
		$ticket->Cell(66*0.25, 6, mb_convert_encoding("Descuento Total:", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Descuento Total:")
	
		$ticket->SetXY(5+66*0.75, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "-$ " . number_format($descuentoGen, 2), "" ,0, "R");
	}
	
	$ticket->SetFont('Arial','',$bF-2);
	if($pagado == 1) {
			if( isset($devolucion['pagos_realizados']) && $devolucion['pagos_realizados'] > 0 ){
				$devolucion['pagos_realizados'] = number_format( $devolucion['pagos_realizados'], 2);
				$devolucion['total_actual'] = number_format( $devolucion['total_actual'],2);
				$ticket->SetFont('Arial','B',$bF+2);
				$ticket->SetXY(5, $ticket->GetY()+6);
				$ticket->Cell(66, 6, mb_convert_encoding("TOTAL PAGADO : $ {$devolucion['pagos_realizados']}", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("TOTAL PAGADO : $ {$devolucion['pagos_realizados']}")
				$ticket->SetXY(5, $ticket->GetY()+6);
				$ticket->Cell(66, 6, mb_convert_encoding("NUEVO TOTAL : {$total}", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("NUEVO TOTAL : {$devolucion['total_actual']}")
			}
		if($diferencia!=''){
		//
			$ticket->SetFont('Arial','B',$bF+20);
			$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->Cell(66, 6, mb_convert_encoding("TOTAL", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("TOTAL")
				
			$ticket->SetXY(5, $ticket->GetY() + 9);
			$ticket->Cell(66, 6, "$ " . number_format( abs( $total ), 2), "" ,0, "C");
			
		//
			//$ticket->SetXY(5, $ticket->GetY()+8);
			$ticket->SetXY(5, $ticket->GetY()+15);
			$ticket->Cell(5, 6, mb_convert_encoding("Saldo a favor:", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Saldo a favor:")

			$ticket->SetXY(5, $ticket->GetY()+15);/*+66*0.75*/
			$ticket->Cell(66, 6, "$ " . number_format( abs( $s_f_i ), 2), "" ,0, "C");/*66*0.25*/

		//
			$ticket->SetFont('Arial','B',30);
			$ticket->SetXY(5, $ticket->GetY()+15);
			$ticket->Cell(66, 6, mb_convert_encoding("{$accion}", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode($accion)

			$ticket->SetXY(5, $ticket->GetY()+15);
			$ticket->Cell(66, 6, "$ ".number_format( abs( $s_f_i - $total ), 2), "" ,0, "C");//C R

		}else{
			$ticket->SetFont('Arial','B',30);
			$ticket->SetXY(5, $ticket->GetY()+15);
			$ticket->Cell(66, 6, mb_convert_encoding("TOTAL", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("TOTAL")

			$ticket->SetXY(5, $ticket->GetY()+15);
			$ticket->Cell(66, 6, "$ " . number_format( abs( $total ), 2), "" ,0, "C");
				
			/*$ticket->SetXY(5+66*0.75, $ticket->GetY() + 8);
			$ticket->Cell(66, 6, "$ " . number_format($total_pagos-$monto_devolucion, 2), "" ,0, "C");*/

			$V=new EnLetras();
			$ticket->SetFont('Arial','',$bF-2);
			$ticket->SetXY(5, $ticket->GetY()+8);
			//$ticket->Cell(66, 6, mb_convert_encoding($V->ValorEnLetras( abs( $total ), "Pesos"), "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode($V->ValorEnLetras( abs( $total ), "Pesos"))
		}
	//
		//$ticket->SetFont('Arial','',$bF-2);
		//$ticket->SetXY(5, $ticket->GetY()+8);
		//$ticket->Cell(66, 6, utf8_decode("Para cualquier aclaración, presentar su ticket."), "" ,0, "C");
	//fin de cambio

	}else{
		$resta = $total - $_GET['initial_payment'];
	//initial_payment
		$ticket->SetFont('Arial','B',25);
		$ticket->SetXY(5, $ticket->GetY()+15);
		$ticket->Cell(66, 6, mb_convert_encoding("Monto de Abono", "ISO-8859-1", "UTF-8"), "" ,0, "C");//utf8_decode("Monto de Abono")

		$ticket->SetFont('Arial','B',32);
		$ticket->SetXY(5, $ticket->GetY()+15);
		$ticket->Cell(66, 6, "$ " . number_format( abs( $_GET['initial_payment'] ), 2), "" ,0, "C");
			
		/*$ticket->SetXY(5+66*0.75, $ticket->GetY() + 8);
		$ticket->Cell(66, 6, "$ " . number_format($total_pagos-$monto_devolucion, 2), "" ,0, "C");*/

		$V=new EnLetras();
		$ticket->SetFont('Arial','',$bF-2);
		$ticket->SetXY(5, $ticket->GetY()+8);
		//$ticket->Cell(66, 6, mb_convert_encoding($V->ValorEnLetras( abs( $total ), "Pesos"), "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode($V->ValorEnLetras( abs( $total ), "Pesos"))

		$ticket->SetFont('Arial','B',$bF+5);
		$ticket->SetXY(2, $ticket->GetY()+6);
	    $ticket->Cell(66*0.40, 6, mb_convert_encoding("Resta", "ISO-8859-1", "UTF-8"), "" ,0, "L");//utf8_decode("Resta")

		$ticket->SetXY(25, $ticket->GetY());
		$ticket->Cell(66*0.35, 6, "$" . number_format( abs( $resta ), 2), "" ,0, "R");
	/*
		$ticket->SetXY(5, $ticket->GetY()+6);
	    $ticket->Cell(66*0.25, 6, utf8_decode("Resta"), "" ,0, "L");
	  
		$ticket->SetXY(20, $ticket->GetY());
		$ticket->Cell(66*0.25, 6, "$" . number_format($resta, 2), "" ,0, "R");
	*/
		
		$ticket->SetFont('Arial','',$bF-2);
		$ticket->SetXY(5, $ticket->GetY()+5);
		$ticket->Cell(66, 6, mb_convert_encoding("Fecha límite para recoger y liquidar sus apartados", "ISO-8859-1", "UTF-8"), "", 0, 'C');//utf8_decode("Fecha límite para recoger y liquidar sus apartados")
	
		$ticket->SetXY(5, $ticket->GetY()+4);
		$ticket->Cell(66, 6, mb_convert_encoding("10 de Diciembre.", "ISO-8859-1", "UTF-8"), "", 0, 'C');//utf8_decode("10 de Diciembre.")
	
		$ticket->SetXY(5, $ticket->GetY()+5);
		$ticket->Cell(66, 6, mb_convert_encoding("En apartados NO hay cambios NI devoluciones.", "ISO-8859-1", "UTF-8"), "", 0, 'C');//utf8_decode("En apartados NO hay cambios NI devoluciones.")
  		
  		$ticket->SetFont('Arial','B',$bF+3);
		$ticket->SetXY(1, $ticket->GetY()+8);
		$ticket->Cell(66, 6, mb_convert_encoding("FOLIO APARTADO: {$folioA}", "ISO-8859-1", "UTF-8"), "", 0, 'C');//utf8_decode("FOLIO APARTADO: ".$folioA)
	
	}	
	if($total != 0 || $total_pagos > 0){
    //generacion de codigo de barras 
        include('../include/barcode/barcode.php');
        $barcode_name = str_replace(' ', '', $folio );
        $barcodePath = "../img/codigos_barra/{$barcode_name}.png";
	    if( file_exists( $barcodePath ) ){
	   		unlink( $barcodePath );
	    }
        barcode( $barcodePath, $folio, '60', 'horizontal', 'code128', true, 1);
    //se incrustra el codigo de barras en el ticket
        //$ticket->Image( $barcodePath, 6, $ticket->GetY()+10, 70);

	    if(file_exists("../img/codigos_barra/".$folio.".png")){
	    	$ticket->SetXY(5, $ticket->GetY()+8);
	    	$ticket->Image("../img/codigos_barra/".$folio.".png", 15, $ticket->GetY()+5,46);
	    }

	//implementacion Oscar 2025-09-24 para poner codigo QR del folio de la nota
		include "../code/especiales/facturacion/clientes/phpqrcode/qrlib.php";
		$barcode_name_qr = "{$barcode_name}_qr";
		$ruta_imagen_qr = "../img/codigos_barra/{$barcode_name_qr}.png";
		// Generar el código QR y guardarlo como imagen
		QRcode::png($barcode_name, $ruta_imagen_qr, QR_ECLEVEL_L, 10);
		if(file_exists("../img/codigos_barra/".$barcode_name_qr.".png")){
	    	$ticket->SetXY(5, $ticket->GetY()+28);
	    	$ticket->Image("../img/codigos_barra/".$barcode_name_qr.".png", 15, $ticket->GetY()+5,46);
	    }
	//fin de cambio Oscar 2025-09-24

  		$ticket->SetFont('Arial','B',$bF+3);
		$ticket->SetXY(1, $ticket->GetY()+50);
		$ticket->Cell(66, 6, mb_convert_encoding("PASE A CAJA A PAGAR", "ISO-8859-1", "UTF-8"), "", 0, 'C');//utf8_decode("PASE A CAJA A PAGAR")
	}
    if($printPan == 1) {
    	ob_end_clean();
	   $ticket->Output();
    }else{
	/*Implementación Oscar 07.03.2019 para finalzar el satus de la devolución*/
		if(isset($_GET["id_pedido_original"]) || $_GET['es_apartado']==1){
			try{
				$sql = "UPDATE ec_devolucion SET status = 3, observaciones = '{$mensaje_nota}' WHERE id_pedido = '{$_GET['id_pedido_original']}'";
				$eje = $link->query($sql);
			}catch(PDOException $error){
				die("Error al actualizar el status de la devolución : {$sql} : {$error}");
			}
		}
/*implementacion Oscar 2024-02-01 para ruta especifica de ticket*/
	/*instancia clases*/
		//include( '../conexionMysqli.php' );
		include( '../code/especiales/controladores/SysArchivosDescarga.php' );
		$SysArchivosDescarga = new SysArchivosDescarga( $link );
		include( '../code/especiales/controladores/SysModulosImpresionUsuarios.php' );
		$SysModulosImpresionUsuarios = new SysModulosImpresionUsuarios( $link );
		include( '../code/especiales/controladores/SysModulosImpresion.php' );
		$SysModulosImpresion = new SysModulosImpresion( $link );

	/*implementación Oscar 17.09.2018 para impresión de tickets de acuerdo a la configuración de la sucursal*/
		try{
			$sql = "SELECT IF( {$pagado} = 1,ticket_venta,ticket_apartado) FROM sys_sucursales WHERE id_sucursal = {$user_sucursal}";
			$eje = $link->query($sql);	
			$numero = $eje->fetch(PDO::FETCH_NUM);//mysql_fetch_row($eje);
		}catch(PDOException $error){
			die("Error al consultar número de impresiones : {$sql} : {$error}");
		}
    //itera el numero de impresiones
    	for($cont=1;$cont<=$numero[0];$cont++){
    		$nombre_ticket="ticket_".$user_sucursal."_" . date("YmdHis") . "_" . strtolower($tipofolio) . "_" . $folio . "_".$cont.".pdf";
			$ruta_salida = '';
			$ruta_salida = $SysModulosImpresionUsuarios->obtener_ruta_modulo_usuario( $user_id, 2, $rootpath );//talon de pago
			if( $ruta_salida == 'no' ){
				$ruta_salida = "cache/" . $SysModulosImpresion->obtener_ruta_modulo( $user_sucursal, 2, $rootpath );//talon de pago
			}
	    	$ticket->Output( "../{$ruta_salida}/{$nombre_ticket}", "F" );

        /*Sincronización remota de tickets*/
    		if( $user_tipo_sistema == 'linea' ){/*registro sincronizacion impresion remota*/
				$registro_sincronizacion = $SysArchivosDescarga->crea_registros_sincronizacion_archivo( 2, 'pdf', $nombre_ticket, $ruta_or, $ruta_salida, $user_sucursal, $user_id, true );
    		}else{//impresion por red local
				$enviar_por_red = $SysArchivosDescarga->crea_registros_sincronizacion_archivo_por_red_local( 2, 'pdf', $nombre_ticket, '', $ruta_salida, $user_sucursal, $user_id, 
				$carpeta_path, '../', 'location="index.php?";' );
			}
    	}//fin de for $cont
	/*fin de cambio Oscar 17.09.2018*/
       	die( "ok" );
       	//header ("location: index.php?scr=evaluation"); 
    }
		
	exit (0);

class EnLetras
{
  var $Void = "";
  var $SP = " ";
  var $Dot = ".";
  var $Zero = "0";
  var $Neg = "Menos";

	function ValorEnLetras($x, $Moneda ) 
	{
    $s="";
    $Ent="";
    $Frc="";
    $Signo="";
        
    if(floatVal($x) < 0)
     $Signo = $this->Neg . " ";
    else
     $Signo = "";
    
    if(intval(number_format($x,2,'.','') )!=$x) //<- averiguar si tiene decimales
      $s = number_format($x,2,'.','');
    else
      $s = number_format($x,0,'.','');
       
    $Pto = strpos($s, $this->Dot);
        
    if ($Pto === false)
    {
      $Ent = $s;
      $Frc = $this->Void;
    }
    else
    {
      $Ent = substr($s, 0, $Pto );
      $Frc =  substr($s, $Pto+1);
    }

    if($Ent == $this->Zero || $Ent == $this->Void)
       $s = "Cero ";
    elseif( strlen($Ent) > 7)
    {
       $s = $this->SubValLetra(intval( substr($Ent, 0,  strlen($Ent) - 6))) . 
             "Millones " . $this->SubValLetra(intval(substr($Ent,-6, 6)));
    }
    else
    {
      $s = $this->SubValLetra(intval($Ent));
    }

    if (substr($s,-9, 9) == "Millones " || substr($s,-7, 7) == "Millón ")
       $s = $s . "de ";

    $s = $s . $Moneda;

    if($Frc != $this->Void)
    {
       //$s = $s . " Con " . $this->SubValLetra(intval($Frc)) . "Centavos";
       $s = $s . " " . $Frc . "/100";
    }
    return ($Signo . $s . " M.N.");
   
}

function SubValLetra($numero) 
{
    $Ptr="";
    $n=0;
    $i=0;
    $x ="";
    $Rtn ="";
    $Tem ="";

    $x = trim("$numero");
    $n = strlen($x);

    $Tem = $this->Void;
    $i = $n;
    
    while( $i > 0)
    {
       $Tem = $this->Parte(intval(substr($x, $n - $i, 1). 
                           str_repeat($this->Zero, $i - 1 )));
       If( $Tem != "Cero" )
          $Rtn .= $Tem . $this->SP;
       $i = $i - 1;
    }

    
    //--------------------- GoSub FiltroMil ------------------------------
    $Rtn=str_replace(" Mil Mil", " Un Mil", $Rtn );
    while(1)
    {
       $Ptr = strpos($Rtn, "Mil ");       
       If(!($Ptr===false))
       {
          If(! (strpos($Rtn, "Mil ",$Ptr + 1) === false ))
            $this->ReplaceStringFrom($Rtn, "Mil ", "", $Ptr);
          Else
           break;
       }
       else break;
    }

    //--------------------- GoSub FiltroCiento ------------------------------
    $Ptr = -1;
    do{
       $Ptr = strpos($Rtn, "Cien ", $Ptr+1);
       if(!($Ptr===false))
       {
          $Tem = substr($Rtn, $Ptr + 5 ,1);
          if( $Tem == "M" || $Tem == $this->Void)
             ;
          else          
             $this->ReplaceStringFrom($Rtn, "Cien", "Ciento", $Ptr);
       }
    }while(!($Ptr === false));

    //--------------------- FiltroEspeciales ------------------------------
    $Rtn=str_replace("Diez Un", "Once", $Rtn );
    $Rtn=str_replace("Diez Dos", "Doce", $Rtn );
    $Rtn=str_replace("Diez Tres", "Trece", $Rtn );
    $Rtn=str_replace("Diez Cuatro", "Catorce", $Rtn );
    $Rtn=str_replace("Diez Cinco", "Quince", $Rtn );
    $Rtn=str_replace("Diez Seis", "Dieciseis", $Rtn );
    $Rtn=str_replace("Diez Siete", "Diecisiete", $Rtn );
    $Rtn=str_replace("Diez Ocho", "Dieciocho", $Rtn );
    $Rtn=str_replace("Diez Nueve", "Diecinueve", $Rtn );
    $Rtn=str_replace("Veinte Un", "Veintiun", $Rtn );
    $Rtn=str_replace("Veinte Dos", "Veintidos", $Rtn );
    $Rtn=str_replace("Veinte Tres", "Veintitres", $Rtn );
    $Rtn=str_replace("Veinte Cuatro", "Veinticuatro", $Rtn );
    $Rtn=str_replace("Veinte Cinco", "Veinticinco", $Rtn );
    $Rtn=str_replace("Veinte Seis", "Veintiseís", $Rtn );
    $Rtn=str_replace("Veinte Siete", "Veintisiete", $Rtn );
    $Rtn=str_replace("Veinte Ocho", "Veintiocho", $Rtn );
    $Rtn=str_replace("Veinte Nueve", "Veintinueve", $Rtn );

    //--------------------- FiltroUn ------------------------------
    If(substr($Rtn,0,1) == "M") $Rtn = "Un " . $Rtn;
    //--------------------- Adicionar Y ------------------------------
    for($i=65; $i<=88; $i++)
    {
      If($i != 77)
         $Rtn=str_replace("a " . Chr($i), "* y " . Chr($i), $Rtn);
    }
    $Rtn=str_replace("*", "a" , $Rtn);
    return($Rtn);
}

function ReplaceStringFrom(&$x, $OldWrd, $NewWrd, $Ptr)
{
  $x = substr($x, 0, $Ptr)  . $NewWrd . substr($x, strlen($OldWrd) + $Ptr);
}


function Parte($x)
{
    $Rtn='';
    $t='';
    $i='';
    Do
    {
      switch($x)
      {
         Case 0:  $t = "Cero";break;
         Case 1:  $t = "Un";break;
         Case 2:  $t = "Dos";break;
         Case 3:  $t = "Tres";break;
         Case 4:  $t = "Cuatro";break;
         Case 5:  $t = "Cinco";break;
         Case 6:  $t = "Seis";break;
         Case 7:  $t = "Siete";break;
         Case 8:  $t = "Ocho";break;
         Case 9:  $t = "Nueve";break;
         Case 10: $t = "Diez";break;
         Case 20: $t = "Veinte";break;
         Case 30: $t = "Treinta";break;
         Case 40: $t = "Cuarenta";break;
         Case 50: $t = "Cincuenta";break;
         Case 60: $t = "Sesenta";break;
         Case 70: $t = "Setenta";break;
         Case 80: $t = "Ochenta";break;
         Case 90: $t = "Noventa";break;
         Case 100: $t = "Cien";break;
         Case 200: $t = "Doscientos";break;
         Case 300: $t = "Trescientos";break;
         Case 400: $t = "Cuatrocientos";break;
         Case 500: $t = "Quinientos";break;
         Case 600: $t = "Seiscientos";break;
         Case 700: $t = "Setecientos";break;
         Case 800: $t = "Ochocientos";break;
         Case 900: $t = "Novecientos";break;
         Case 1000: $t = "Mil";break;
         Case 1000000: $t = "Millón";break;
      }

      If($t == $this->Void)
      {
        $i = (int)$i + 1;
        $x = $x / 1000;
        If($x== 0) $i = 0;
      }
      else
         break;
           
    }while($i != 0);
   
    $Rtn = $t;
    Switch($i)
    {
       Case 0: $t = $this->Void;break;
       Case 1: $t = " Mil";break;
       Case 2: $t = " Millones";break;
       Case 3: $t = " Billones";break;
    }
    return($Rtn . $t);
}
}
?>