<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
	* Endpoint: send_file
	* Path: /send_file
	* Método: POST
	* Descripción: Envia mensaje por Telegram
*/
$app->post('/send_message', function (Request $request, Response $response){
	//include( '../../conexionMysqli.php' );
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
	$files = array();
	//die( 'one' );
	//$file_id = $request->getParam( 'file_id' );
//recibe id de la sucursal//$store_id = $request->getParam( 'destinity_store_id' );
	$body = $request->getBody();
	$params = json_decode( $body, true);
	$module_id = ( isset($params['id_modulo']) ? $params['id_modulo'] : null );
	$message = ( isset($params['mensaje']) ? $params['mensaje'] : null );
	if($module_id == null){
		$payload = json_encode(array("status"=>400,"message"=>"El atributo 'id_modulo' no puede ser vacio."));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
	if($message == null){
		$payload = json_encode(array("status"=>400,"message"=>"El atributo 'mensaje' no puede ser vacio."));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
//obtiene los archivos pendientes de descargar
	try{
		$sql = "SELECT
					mt.id_modulo_telegram,
					mt.nombre_modulo,
					ct.id_conversacion,
					et.token
				FROM ec_modulos_telegram mt
				LEFT JOIN ec_modulos_avisos_telegram_detalle matd
				ON mt.id_modulo_telegram = matd.id_modulo_aviso_telegram
				LEFT JOIN ec_conversaciones_telegram ct
				ON matd.id_conversacion_telegram = ct.id_conversacion_telegram
				LEFT JOIN ec_emisores_telegram et
				ON et.id_emisor_telegram = ct.id_emisor_telegram
				WHERE mt.id_modulo_telegram = {$module_id}";
		$stm = $link->query( $sql );
		if($stm->rowCount() <= 0){
			$payload = json_encode(array("status"=>400,"message"=>"No hay chats configurados para el modulo : '{$module_id}'."));
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
		while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
			$token = $row['token'];//"7983316779:AAFicMUajamZ_ZFnJqXH8wHsFkleXBCeCZA";
			$chat_id = $row['id_conversacion'];//"8069252818";
			// URL para enviar documento
			$url = "https://api.telegram.org/bot$token/sendMessage";
			// Prepara los datos
			$post_fields = [
				'chat_id' => $chat_id,
				'text' => "ASUNTO : {$row['nombre_modulo']}\nMENSAJE : {$message}"
			];
			// Inicializa cURL
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				"Content-Type:multipart/form-data"
			]);
			curl_setopt($ch, CURLOPT_URL, $url); 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields); 
			$result = curl_exec($ch);
			// Mostrar respuesta (útil para debug)
			echo $result;
			curl_close($ch);
		}
	}catch(PDOException $error){
		$payload = json_encode(array("status"=>400,"message"=>"Error al enviar mensaje por telegram.", "error_detail"=>$result));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
	$payload = json_encode(array("status"=>400,"message"=>"Mensaje enviado exitosamente."));
	$response->getBody()->write($payload);
	return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>
