<?php
//Version Oscar 2025-02-03 (Migracion a PHP 8.2)
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: surtePedido
* Path: /surte/Pedido
* Método: POST
* Descripción: Servicio para solicitar pedido
  *Consulta para saber si el producto no tiene ubicacion pero tiene habilitado el check de surtir : 
    SELECT
      sp.id_producto
    FROM sys_sucursales_producto sp
    LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
    ON spua.id_producto = sp.id_producto
    AND spua.id_sucursal = sp.id_sucursal
    WHERE sp.id_sucursal = 4
    AND sp.surtir = 1
    AND spua.id_producto IS NULL
*/
$app->post('/surte/Pedido', function (Request $request, Response $response){
  $db = new db("../../");//Instancia BD General
  $link = $db->conectDB();
  $rs = new manageResponse();
  $vt = new tokenValidation();

//error_log("_______________________________________________");
//Recibe token
  $token =  (empty($request->getHeader('Token'))) ? '' : implode(" ",$request->getHeader('Token'));
  if (empty($token) || strlen($token)<36 ) {//valida estructura de token
  
    return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Requerido', 'Se requiere el uso de un token', 400);
  }else{
  //Consulta vigencia
    try{
      $resultadoToken = $vt->validaToken($token);
      if ($resultadoToken->rowCount()==0) {
          return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Invalido', 'El token proporcionado no es válido', 400);
      }
    }catch (PDOException $e) {
      return $rs->errorMessage($request->getParsedBody(),$response, 'CL_Error', $e->getMessage(), 500);
    }
  }
//parametros de entrada
  $body = $request->getBody();
  $params = json_decode($body, true);
  if($params == null){
    $params = $request->getParsedBody();
  }
//Recuperar parámetros de entrada
  $productos = ( isset($params['productos']) ? $params['productos'] : null );
  $vendedor = ( isset($params['vendedor']) ? $params['vendedor'] : null );
  $pedido = ( isset($params['pedido']) ? $params['pedido'] : null );
  $sucursal = ( isset($params['sucursal']) ? $params['sucursal'] : null );
  $cancelados = ( isset($params['productosEliminados']) ? $params['productosEliminados'] : null );
  $es_muestra = ( isset($params['es_muestra']) ? $params['es_muestra'] : null );


  $id_surtimiento = null;
  $supply_ranges = array();
  $contador_positivos = 0;//contador de cambio reales para indicador de notificar al WS
//var_dump($cancelados);
  //Validar elementos requeridos para crear surtimiento
  if (empty($vendedor)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de vendedor para solicitar pedido', 400);
  }
  if (empty($pedido)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de pedido para solicitar pedido', 400);
  }
  if (empty($productos) && empty($cancelados) ) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de productos para solicitar pedido', 400);
  }
  if (empty($sucursal)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de sucursal para solicitar pedido', 400);
  }
  if (empty($es_muestra)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información para saber si es Muestra o Pedido', 400);
  }
  //Validar elementos requerido para nodo productos
  if (count($productos)>0) {
    //Itera y valida productos
    $productRow=0;
    $idProductos = "'0'";
    foreach($productos as $producto) {
      if (empty($producto['id'])) {
        return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información para crear producto(s)', 400);
      }
      if ($producto['cantidad'] > 0) {
        $idProductos = $idProductos . ",'".$producto['id']."'";
        $productRow ++;
      }
    }
  }

//Cancela surtimiento de partidas
  if(!empty($cancelados)){//count($cancelados) > 0
    foreach($cancelados as $producto) {
      try{
        $sql = "UPDATE ec_surtimiento_detalle sd
                INNER JOIN ec_productos p 
                ON p.id_productos = sd.id_producto
                INNER JOIN ec_surtimiento s 
                ON s.id = sd.id_surtimiento
                SET sd.fecha_creacion = NOW(),
                  sd.fecha_modificacion = NOW(),
                  sd.modificado_por = '{$vendedor}',
                  sd.estado = 5
                WHERE p.orden_lista = '{$producto['id']}'
                AND s.no_pedido = '{$pedido}'
                AND s.id_vendedor = '{$vendedor}'";//AND sd.estado IN ('1','2','4') sd.estado = '5'
//error_log("Actualizacion de cancelados : {$sql}");
        $link->query($sql);
      }catch(PDOException $error){
        die(json_encode(array("status"=>"302", "message"=>"Error al actualizar a ceros los productos cancelados.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
      }
    }
    //if(!count($productosSurtir)>0){
      $insertsProd['resultado']='Solicitado';
      $insertsProd['descripcion']='Se ha(n) removido '. count($cancelados) . ' partida(s)';
    //}
  }
  
  
  //Ejecuta lógica para surtimiento
  try{
    //Consulta productos disponibles para surtimiento
    $productosSurtir=[];
    $productosSurtirString = "";
    $productosSurtirSinUbicacion = [];
    $productosSurtirResponse=[];
    $productosNoSurtir=[];
    if($idProductos){
      $sql = "SELECT 
              sp.id_producto, 
              sp.surtir, 
              p.orden_lista, 
              p.nombre AS nombre_producto, 
              sp.id_sucursal 
            FROM ec_productos p
            LEFT JOIN sys_sucursales_producto sp
            ON p.id_productos = sp.id_producto
            WHERE p.orden_lista IN ( {$idProductos} )
            AND sp.id_sucursal = '{$sucursal}'
            AND surtir = 1";
      $stm = $link->query($sql);
      while($row = $stm->fetch(PDO::FETCH_ASSOC)){
        $productosSurtir[] = $row['orden_lista'];
        $productosSurtirString .= ($productosSurtirString == "" ? "" : ",");
        $productosSurtirString .= $row['id_producto'];
        $productosSurtirResponse[]= array( "orden_lista" => $row['orden_lista'], "nombre_producto" => $row['nombre_producto'] );
      }



/////////////////////////////////////////implementacion Oscar 2025-08-28 para consultar si hay productos sin ubicacion/////////////////////////////////////////
      $stm_without_location = null;
      if($productosSurtirString != ""){
        try{
          $sql = "SELECT
                    sp.id_producto,
                    p.nombre
                  FROM sys_sucursales_producto sp
                  LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
                  ON spua.id_producto = sp.id_producto
                  AND spua.id_sucursal = sp.id_sucursal
                  LEFT JOIN ec_productos p
                  ON p.id_productos = sp.id_producto
                  WHERE sp.id_sucursal = {$sucursal}
                  AND sp.surtir = 1
                  AND sp.id_producto IN({$productosSurtirString})
                  AND spua.numero_ubicacion_desde = 0";/*AND spua.id_producto IS NULL*/
          $stm_without_location = $link->query($sql);
        }catch(PDOException $error){//die($sql);
          die(json_encode(array("status"=>"302", "query"=>"{$sql}")));
        }
        if($stm_without_location->rowCount() > 0){
          $products_without_location_string = "Los siguientes productos tienen ubicacion en 0 y tienen habilitado el indicador de surtimiento :";
          while($row = $stm_without_location->fetch(PDO::FETCH_ASSOC)){
            $productosSurtirSinUbicacion[] = $row;
            $products_without_location_string .= "\n{$row['nombre']}";
          }
          $without_location_data = array("id_modulo"=>"1", "mensaje"=>"{$products_without_location_string}");
          $post_data = json_encode($without_location_data);
        //consulta url de API
          $sql = "SELECT `value` AS api_path FROM `api_config` WHERE `key` = 'api'";
          $api_stm = $link->query($sql);
          $row = $api_stm->fetch(PDO::FETCH_ASSOC);
          $url = "{$row['api_path']}/rest_v2/telegram/send_message";

  error_log("URL : {$url}");
  error_log("POST_DATA : {$post_data}");
          
          $resp = "";
          $crl = curl_init( $url );
          curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($crl, CURLINFO_HEADER_OUT, true);
          curl_setopt($crl, CURLOPT_POST, true);
          curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
          curl_setopt($crl, CURLOPT_TIMEOUT, 10);
          curl_setopt($crl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json', 'token: ' . "" )
          );
          $resp = curl_exec($crl);//envia peticion
          curl_close($crl);
        }
      }
/////////////////////////////////////////fin de cambio Oscar 2025-08-28/////////////////////////////////////////

    //Agrega Query para obtener productos que no están habilitados para surtir
      $sql = "SELECT 
              sp.id_producto, 
              sp.surtir, 
              p.orden_lista, 
              p.nombre nombre_producto, 
              sp.id_sucursal 
            FROM ec_productos p
            LEFT JOIN sys_sucursales_producto sp 
            ON p.id_productos = sp.id_producto
            WHERE p.orden_lista IN ({$idProductos})
            AND sp.id_sucursal = '{$sucursal}'
            AND orden_lista != 0
            AND surtir = 0";
      $stm = $link->query($sql);//"SET NAMES 'utf8'"
      while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {
        $productosNoSurtir[] = array( "orden_lista" => $row['orden_lista'], "nombre_producto" => $row['nombre_producto'] );
      }
    }
    //Inserta Surtimiento
    if(count($productosSurtir) > 0){
    //Consulta solicitud existente; Pendiente o Proceso
      $solicitudActual = [];
      $solicitudActual['id_surtimiento'] = '';
      $solicitudActual['lineas'] = [];
      $sql = "SELECT 
              s.no_pedido,
              s.id id_surtimiento,
              sd.id id_detalle,
              sd.id_producto,
              sd.id_surtimiento,
              sd.id_asignado,
              p.orden_lista,
              sd.cantidad_solicitada,
              sd.estado
          FROM ec_surtimiento_detalle sd
          LEFT JOIN ec_productos p ON p.id_productos = sd.id_producto
          INNER JOIN ec_surtimiento s ON s.id = sd.id_surtimiento
          WHERE s.id_vendedor = '{$vendedor}'
          AND s.no_pedido = '{$pedido}'";
//error_log("Consulta los detalles : {$sql}");
      $stm = $link->query($sql);
      while($row = $stm->fetch(PDO::FETCH_ASSOC)) {
        $solicitudActual['id_surtimiento'] = $row['id_surtimiento'];
        $solicitudActual['lineas'][$row['orden_lista']] = [];
        $solicitudActual['lineas'][$row['orden_lista']]['id_detalle'] = $row['id_detalle'];
        $solicitudActual['lineas'][$row['orden_lista']]['cantidad_solicitada'] = $row['cantidad_solicitada'];
      }
      //Valida crear o actualizar
      if(empty($solicitudActual['id_surtimiento'])){
          //$idSurtido = gen_uuid();
          $sqlInsert = "INSERT INTO ec_surtimiento (id, id_sucursal, no_pedido,  tipo, estado, id_vendedor, prioridad, fecha_creacion, creado_por, fecha_modificacion, modificado_por) 
              VALUES (NULL, '{$sucursal}', '{$pedido}', '2', '1', '{$vendedor}', '3', now(), '{$vendedor}', now(), '{$vendedor}');";
//error_log("Inserta surtimiento : {$sql}");
          $link->query($sqlInsert);
        //recupera el id insertado
          $sql = "SELECT LAST_INSERT_ID() AS last_id";
          $stm = $link->query($sql);
          $id_row = $stm->fetch(PDO::FETCH_ASSOC);
          $id_surtimiento = $id_row['last_id'];
      }else{
        $id_surtimiento = $solicitudActual['id_surtimiento'];
      }
      //Itera lista de productos para insertar detalle
      $idSurtidor = '';
      foreach($productos as $producto) {
        if(in_array($producto['id'], $productosSurtir)){
//error_log('proceso prod.'.$producto['id']);
          if(isset($solicitudActual['lineas'][$producto['id']])){
              $idDetalle = $solicitudActual['lineas'][$producto['id']]['id_detalle'];
              $cantidad_solicitada_previamente = $solicitudActual['lineas'][$producto['id']]['cantidad_solicitada'];
              $cantidad = $producto['cantidad'];//$solicitudActual['lineas'][$producto['id']]['cantidad_solicitada'] + 
              $diferencia = $cantidad - $cantidad_solicitada_previamente;
              $sql = "UPDATE ec_surtimiento_detalle
                    SET cantidad_solicitada = IF( {$diferencia} > 0 , '{$cantidad}', cantidad_solicitada),
                    fecha_creacion = NOW(),
                    fecha_modificacion = NOW(),
                    modificado_por = '{$vendedor}',
                    estado = IF( {$diferencia} > 0 AND no_se_surte = 0 AND surtido_parcialmente = 0, 1, estado)
                  WHERE id = '{$idDetalle}'";
/*                    
no_se_surte = IF( {$diferencia} > 0, 0, no_se_surte),
surtido_parcialmente = IF( {$diferencia} > 0, 0, surtido_parcialmente),
*/
              $link->query($sql);
//error_log("actualiza surtimiento detalle: {$sql}");
            //valida si la cantidad es negativa
              if( $diferencia > 0 ){
                $contador_positivos ++;//incrementa el contador de positivos
              }

          }else{
              //$idDetalle = gen_uuid();
              $sql = "INSERT INTO ec_surtimiento_detalle (id, id_surtimiento, id_producto, cantidad_solicitada, estado, id_asignado, fecha_creacion, creado_por, 
              fecha_modificacion, modificado_por, no_se_surte, surtido_parcialmente, se_solicita_muestra) 
                      SELECT  
                        NULL, 
                        '{$id_surtimiento}', 
                        p.id_productos, 
                        '{$producto['cantidad']}', 
                        '1', 
                        '{$idSurtidor}', 
                        NOW(), 
                        '{$vendedor}', 
                        NOW(), 
                        '{$vendedor}',
                        0,
                        0,
                        IF( '{$es_muestra}' = 'no', 0, 1 )
                      FROM ec_productos p where p.orden_lista='{$producto['id']}'";
              $link->query($sql);
              $contador_positivos ++;//incrementa el contador de positivos
//error_log("inserta surtimiento detalle: {$sql}");
          }
        }
      }

    //Consulta los rangos de surtimiento del pedido
      $supply_ranges_ids = "";
      $supply_ranges_condition = "";
      try{
        $sql = "SELECT
                spr.id_surtimiento_por_rango AS supply_range_id,
                spr.id_rango_ubicacion_sucursal AS store_location_range_id,
                IF(spr.id_usuario_asignado IS NULL, 'null', spr.id_usuario_asignado ) AS assigned_user_id,
                spr.id_status_surtimiento_pedidos
              FROM ec_surtimiento_por_rangos spr
              WHERE spr.id_surtimiento = {$id_surtimiento}";
//error_log("Consulta surtimientos de rangos : {$sql}");
        foreach($link->query($sql) AS $range){
          $supply_ranges[] = $range;
          $supply_ranges_ids .= ($supply_ranges_ids == "" ? "" : ",");
          $supply_ranges_ids .= $range['supply_range_id'];
        //actualiza status detalles
          try{
            $sql = "UPDATE ec_surtimiento_detalle sd
                    LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
                    ON sd.id_producto = spua.id_producto
                    LEFT JOIN ec_rangos_ubicaciones_sucursales rus
                    ON spua.numero_ubicacion_desde BETWEEN rus.desde AND rus.hasta
                    AND rus.id_sucursal = {$sucursal}
                      SET sd.id_surtimiento_por_rango = {$range['supply_range_id']},
                      sd.id_asignado = IF( '{$range['assigned_user_id']}' = 'null', NULL, {$range['assigned_user_id']} )
                    WHERE rus.id_rango_ubicacion_sucursal = {$range['store_location_range_id']}
                    AND sd.id_surtimiento_por_rango = 0
                    AND spua.id_sucursal = {$sucursal}";
            $link->query($sql);
//error_log("Actualiza rangos de detalles de surtimiento : {$sql}");
          }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al actualizar status de detalle de surtimiento", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
          }
        //actualiza status rango
          try{
            $sql = "UPDATE ec_surtimiento_por_rangos spr
                    SET id_status_surtimiento_pedidos = IF( (SELECT COUNT(*) FROM ec_surtimiento_detalle sd WHERE sd.id_surtimiento_por_rango = {$range['supply_range_id']} AND sd.estado <= 3 AND (sd.cantidad_surtida < sd.cantidad_solicitada OR sd.cantidad_surtida IS NULL)) <=0 ,id_status_surtimiento_pedidos, 1 ),
                    notificacion_vista = IF( (SELECT COUNT(*) FROM ec_surtimiento_detalle sd WHERE sd.id_surtimiento_por_rango = {$range['supply_range_id']} AND sd.estado <= 3 AND (sd.cantidad_surtida < sd.cantidad_solicitada OR sd.cantidad_surtida IS NULL)) <=0 ,notificacion_vista, 0 )
                    WHERE spr.id_surtimiento_por_rango = {$range['supply_range_id']}";
            $link->query($sql);
//error_log("Actualiza status de rango de surtimiento : {$sql}");
          }catch(PDOException $error){
              die(json_encode(array("status"=>"302", "message"=>"Error al actualizar status de rango de surtimiento", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
          }
        }
        if($supply_ranges_ids != ""){
          $supply_ranges_condition = "AND rus.id_rango_ubicacion_sucursal NOT IN({$supply_ranges_ids})";
        }
      }catch(PDOException $error){
        die(json_encode(array("status"=>"302", "message"=>"Error al consultar rangos de surtimiento.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
      }
    //se inserta el bloque de surtimiento por rangos que faltan
      try{
        $sql = "SELECT
                  rus.id_rango_ubicacion_sucursal,
                  COUNT(spua.id_ubicacion_sucursal) AS products_counter,
                  GROUP_CONCAT( sd.id SEPARATOR ',') AS details_ids
                FROM ec_surtimiento_detalle sd
                LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
                ON sd.id_producto = spua.id_producto
                LEFT JOIN ec_rangos_ubicaciones_sucursales rus
                ON spua.numero_ubicacion_desde BETWEEN rus.desde AND rus.hasta
                AND rus.id_sucursal = {$sucursal}
                WHERE spua.id_sucursal = {$sucursal}
                AND sd.id_surtimiento = {$id_surtimiento}
                AND sd.id_surtimiento_por_rango = 0
                {$supply_ranges_condition}
                GROUP BY rus.id_rango_ubicacion_sucursal";
//error_log("Consulta rangos de surtimiento faltantes : " . $sql);
        foreach($link->query($sql) as $row){
          try{
            $sql = "INSERT INTO ec_surtimiento_por_rangos(id_surtimiento, id_rango_ubicacion_sucursal, id_usuario_asignado, id_status_surtimiento_pedidos, fecha_alta) 
                VALUES ('{$id_surtimiento}','{$row['id_rango_ubicacion_sucursal']}', NULL, 1, NOW())";
            $link->query($sql);
//error_log("Inserta rangos de surtimiento faltantes : " . $sql);
          //recupera el id insertado
            $id_surtimiento_por_rango = null;
            try{
              $sql = "SELECT LAST_INSERT_ID() AS last_id";
              $stm = $link->query($sql);
              $row2 = $stm->fetch(PDO::FETCH_ASSOC);
              $id_surtimiento_por_rango = $row2['last_id'];
//$supply_ranges[] = $row2['last_id'];
            }catch(PDOException $error){
              die(json_encode(array("status"=>"302", "message"=>"Error al insertar ragnos de surtimiento por ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            }
          //actualiza el detalle para relacionar el id de surtimiento por rangos
            try{
              $sql = "UPDATE ec_surtimiento_detalle SET id_surtimiento_por_rango = {$id_surtimiento_por_rango} WHERE id IN({$row['details_ids']})";
//error_log("Actualiza detalle de surtimiento por rango : " . $sql);
              $link->query($sql);
            }catch(PDOException $error){
              die(json_encode(array("status"=>"302", "message"=>"Error al actualizar deatalle de surtimiento por ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            }
          }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al insertar ragnos de surtimiento por ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
          }
        }
      }catch(PDOException $error){
        die(json_encode(array("status"=>"302", "message"=>"Error al consultar los rangos de ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
      }

    //actualiza status de surtimiento dependiento del status minimo de sus rangos
      try{
        $status = array();
        $sql = "SELECT MIN(id_status_surtimiento_pedidos) AS min_status FROM ec_surtimiento_por_rangos WHERE id_surtimiento = {$id_surtimiento} LIMIT 1";//error_log($sql);
        $stm = $link->query($sql);
        $status = $stm->fetch(PDO::FETCH_ASSOC);
        try{
            $sql = "UPDATE ec_surtimiento SET estado = IF( '{$status['min_status']}' = '', '1', '{$status['min_status']}' ), fecha_creacion = NOW(), fecha_modificacion = NOW() WHERE id = {$id_surtimiento}";//error_log($sql);
            $link->query($sql);//error_log("Inserta surtimiento a pendiente de surtir: {$sql}");
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al actualizar cabecera de surtimiento", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
      }catch(PDOException $error){
        die(json_encode(array("status"=>"302", "message"=>"Error al consultasr status de rangos de surtimiento", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
      }

      $strResponse = "Se ha solicitado el pedido de los siguientes productos:";

      for ($i=0; $i < count($productosSurtirResponse); $i++) { 
        $strResponse .= "\n". "(" . $productosSurtirResponse[$i]['orden_lista']. ") ". $productosSurtirResponse[$i]['nombre_producto'];
      }
      
      if( count($productosNoSurtir) > 0 ){
        $strResponse .= "\n\nLos siguientes productos no se han solicitado debido a que no se encuentran habilitados para surtimiento:";
        for ($i=0; $i < count($productosNoSurtir); $i++) {
          if( !empty($productosNoSurtir[$i]) && $productosNoSurtir[$i] != '0'  ){
            //$strResponse .= "\n".$productosNoSurtir[$i];
            $strResponse .= "\n". "(" . $productosNoSurtir[$i]['orden_lista']. ") ". $productosNoSurtir[$i]['nombre_producto'];
          }
        }
      }
      /*if($contador_positivos <=0 ){
        $insertsProd['resultado'] = 'Solicitado';
        $insertsProd['descripcion'] = 'No notificar.';
      }else{*/
    //Regresa resultado
        $insertsProd['resultado'] = 'Solicitado';
        $insertsProd['supply_id'] = $id_surtimiento;//id de surtimiento
        $insertsProd['supply_ranges'] = $supply_ranges;//rangos de surtimiento
  // $insertsProd['descripcion']='Se ha solicitado el pedido de '. count($productosSurtir) . ' producto(s)';
        $insertsProd['descripcion'] = $strResponse;
        $insertsProd['noSolicitados'] = $productosNoSurtir;
        $insertsProd['notificacion'] = ($contador_positivos > 0 ? "notificar" : "no_notificar" );
      //}
    }else{
    //Regresa resultado no hay productos por surtir
      $insertsProd['resultado'] = 'Solicitado';
      $insertsProd['descripcion'] = 'No hay productos habilitados para surtir';
    }
  }catch (PDOException $e) {
    $insertsProd['resultado']='Error';
    $insertsProd['descripcion']= $e->getMessage();
  }
//error_log("_______________________________________________");
  $link = null;//Limpia variables
  return $rs->successMessage($request->getParsedBody(),$response, $insertsProd);//Regresa resultado
});

?>