<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: surteMuestra
* Path: /surte/Muestra
* Método: POST
* Descripción: Servicio para solicitar muestra
*/
$app->post('/surte/Muestra', function (Request $request, Response $response){
  //Init
  $db = new db("../../");//Instancia BD General
  $link = $db->conectDB();
  $rs = new manageResponse();
  $vt = new tokenValidation();

  //Valida token
  $token =  (empty($request->getHeader('Token'))) ? '' : implode(" ",$request->getHeader('Token'));
  if (empty($token) || strlen($token)<36 ) {
    //Define estructura de salida: Token requerido
    return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Requerido', 'Se requiere el uso de un token', 400);
  }else{
    //Consulta vigencia
    try{
      $resultadoToken = $vt->validaToken($token);
      if ($resultadoToken->rowCount()==0) {
          return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Invalido', 'El token proporcionado no es válido', 400);
      }
    }catch (PDOException $e) {
      return $rs->errorMessage($request->getParsedBody(),$response, 'CL_Error', $e->getMessage(), 500);
    }
  }
//parametros de entrada
  $body = $request->getBody();
  $params = json_decode($body, true);
  if($params == null){
    $params = $request->getParsedBody();
  }
//Recuperar parámetros de entrada
  $productos = ( isset($params['productos']) ? $params['productos'] : null );
  $vendedor = ( isset($params['vendedor']) ? $params['vendedor'] : null );
  $pedido = ( isset($params['pedido']) ? $params['pedido'] : null );
  $sucursal = ( isset($params['sucursal']) ? $params['sucursal'] : null );
  //No maneja productos canelados, como lo hace el servicio de pedido
  
  //Validar elementos requeridos para crear surtimiento
  if (empty($vendedor)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de vendedor para solicitar muestras', 400);
  }
  if (empty($pedido)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de pedido para solicitar muestras', 400);
  }
  if (empty($productos)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de productos para solicitar muestras', 400);
  }
  if (empty($sucursal)) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información de sucursal para solicitar muestras', 400);
  }
  //Validar elementos requerido para nodo productos
  if (count($productos)>0) {
    //Itera y valida productos
    $productRow=0;
    $idProductos = "'0'";
    foreach($productos as $producto) {
      if (empty($producto['id'])) {
        return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información para crear producto(s)', 400);
      }
      $idProductos = $idProductos . ",'".$producto['id']."'";
      $productRow ++;
    }
  }
  
  //Ejecuta lógica para surtimiento
  try{
    //Consulta productos disponibles para surtimiento
    $resultado = 0;
    $productosSurtir=[];
    if($idProductos){
      $sql = "SELECT 
              sp.id_producto, 
              sp.surtir, 
              p.orden_lista, 
              sp.id_sucursal 
            FROM ec_productos p
            LEFT JOIN sys_sucursales_producto sp
            ON p.id_productos = sp.id_producto
            WHERE p.orden_lista IN ( {$idProductos} )
            AND sp.id_sucursal = '{$sucursal}'
            AND surtir = 1";
      //error_log('query:'.$sqlConsultaProds);
      $stm = $link->query($sql);
      while($row = $stm->fetch( PDO::FETCH_ASSOC ) ) {
        $productosSurtir[] = $row['orden_lista'];
      }
    }
    //error_log('count:'.count($productosSurtir));
    //Inserta Surtido
    if(count($productosSurtir)>0){
      //Consulta solicitud existente; Pendiente o Proceso
      $solicitudActual=[];
      $productosSolicitados = [];
      $productosNoSolicitados = [];
      $productosNoHabilitados = [];
      $solicitudActual['id_surtimiento'] = '';
      $solicitudActual['lineas'] = [];
      $sql = "SELECT 
				        s.no_pedido,
                s.id id_surtimiento,
                sd.id id_detalle,
                sd.id_producto,
                sd.id_surtimiento,
                p.orden_lista,
                sd.cantidad_solicitada,
                sd.estado
            FROM ec_surtimiento_detalle sd
            LEFT JOIN ec_productos p 
            ON p.id_productos = sd.id_producto
            INNER JOIN ec_surtimiento s 
            ON s.id = sd.id_surtimiento
            WHERE s.id_vendedor = '{$vendedor}'
            AND s.no_pedido ='{$pedido}'
            AND s.tipo = '1'
            AND sd.estado IN (1,2)
            AND s.estado IN (1,2)";
      //$link->query("SET NAMES 'utf8'");
      foreach ($link->query($sql) as $row) {
          $solicitudActual['id_surtimiento'] = $row['id_surtimiento'];
          $solicitudActual['lineas'][$row['orden_lista']] = [];
          $solicitudActual['lineas'][$row['orden_lista']]['id_detalle'] = $row['id_detalle'];
          $solicitudActual['lineas'][$row['orden_lista']]['cantidad_solicitada'] = $row['cantidad_solicitada'];
      }
      
      $id_surtimiento = null;
      //Valida crear o actualizar
      if(empty($solicitudActual['id_surtimiento'])){
        // Inserta nueva muestra
        $sqlInsert = "INSERT INTO ec_surtimiento (id, id_sucursal, no_pedido, tipo, estado, id_vendedor, prioridad, fecha_creacion, creado_por, fecha_modificacion, modificado_por) 
            VALUES ('{$id_surtimiento}', '{$sucursal}', '{$pedido}', '1', '1', '{$vendedor}', '3', now(), '{$vendedor}', now(), '{$vendedor}')";
        $link->query($sqlInsert);
        try{
        //recupera el id insertado
          $sql = "SELECT LAST_INSERT_ID() AS last_id";
          $stm = $link->query($sql);
          $id_row = $stm->fetch(PDO::FETCH_ASSOC);
          $id_surtimiento = $id_row['last_id'];
        }catch(PDOException $error){
          die("Error al consultar el id insertado : {$sql} : {$error->getMessage()}");
        }
      }else{
          //toma muestra existente
          $id_surtimiento = $solicitudActual['id_surtimiento'];
      }
      
      //Itera lista de productos para insertar detalle
      $idSurtidor = '';
      foreach($productos as $producto) {
        if(in_array($producto['id'], $productosSurtir)){
          //error_log('proceso prod.'.$producto['id']);
          if(isset($solicitudActual['lineas'][$producto['id']])){
              //No se solicita producto por que no ya hay una muestra en proceso
              $productosNoSolicitados[] = $producto['id'];
          }else{
              $idDetalle = null;
              $sqlInsert = "INSERT INTO ec_surtimiento_detalle (id, id_surtimiento, id_producto, cantidad_solicitada, estado, id_asignado, fecha_creacion, creado_por, fecha_modificacion, modificado_por) 
                SELECT  '{$idDetalle}', '{$id_surtimiento}', p.id_productos, '1', '1', '{$idSurtidor}', now(), '{$vendedor}', now(), '{$vendedor}'  from ec_productos p where p.orden_lista='{$producto['id']}';";
              $link->query($sqlInsert);
              //Se agrega a solicitud de muestra
              $productosSolicitados[] = $producto['id'];
              $resultado = 1;
          }
        }else {
          //No se solicita producto por que no está habilitado para surtimiento
          $productosNoHabilitados[] = $producto['id'];
          $productosNoSolicitados[] = $producto['id'];
        }
      }


      //se inserta el bloque de surtimiento por rangos
      try{
        $sql = "SELECT
                  rus.id_rango_ubicacion_sucursal,
                  COUNT(spua.id_ubicacion_sucursal) AS products_counter,
                  GROUP_CONCAT( sd.id SEPARATOR ',') AS details_ids
                FROM ec_surtimiento_detalle sd
                LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
                ON sd.id_producto = spua.id_producto
                LEFT JOIN ec_rangos_ubicaciones_sucursales rus
                ON spua.numero_ubicacion_desde BETWEEN rus.desde AND rus.hasta
                AND rus.id_sucursal = {$sucursal}
                WHERE spua.id_sucursal = {$sucursal}
                AND sd.id_surtimiento = {$id_surtimiento}
                AND sd.id_surtimiento_por_rango = 0/**/
                GROUP BY rus.id_rango_ubicacion_sucursal";
        foreach($link->query($sql) as $row){
          try{
            $sql = "INSERT INTO ec_surtimiento_por_rangos(id_surtimiento, id_rango_ubicacion_sucursal, id_usuario_asignado, id_status_surtimiento_pedidos, fecha_alta) 
                VALUES ('{$id_surtimiento}','{$row['id_rango_ubicacion_sucursal']}', NULL, 1, NOW())";
            $link->query($sql);
          //recupera el id insertado
            $id_surtimiento_por_rango = null;
            try{
              $sql = "SELECT LAST_INSERT_ID() AS last_id";
              $stm = $link->query($sql);
              $row2 = $stm->fetch(PDO::FETCH_ASSOC);
              $id_surtimiento_por_rango = $row2['last_id'];
            }catch(PDOException $error){
              die(json_encode(array("status"=>"302", "message"=>"Error al insertar ragnos de surtimiento por ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            }
          //actualiza el detalle para relacionar el id de surtimiento por rangos
            try{
              $sql = "UPDATE ec_surtimiento_detalle SET id_surtimiento_por_rango = {$id_surtimiento_por_rango} WHERE id IN({$row['details_ids']})";
              $link->query($sql);
            }catch(PDOException $error){
              die(json_encode(array("status"=>"302", "message"=>"Error al actualizar deatalle de surtimiento por ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            }
          }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al insertar ragnos de surtimiento por ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
          }
        }
      }catch(PDOException $error){
        die(json_encode(array("status"=>"302", "message"=>"Error al consultar los rangos de ubicaciones", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
      }
      
      //Valida surtimiento en proceso
      if(count($productosSolicitados) == 0 && count($productosNoSolicitados) > 0 && ( count($productosNoSolicitados) > count($productosNoHabilitados) ) ){
         $resultado = 2;
      }
    }
    
    //No hay productos para surtir
    if($resultado == 0){
      //Regrsa resultado no hay productos por surtir
      $insertsProd['resultado']='Sin productos por surtir';
      $insertsProd['descripcion']='No hay productos habilitados para surtir';
    }
    
    //Solicitud generada
    if($resultado == 1){
      $insertsProd['resultado']='Solicitado';
      $insertsProd['descripcion']='Se ha solicitado la muestra de '. count($productosSolicitados) . ' producto(s)';
      $insertsProd['solicitado']= $productosSolicitados;
      $insertsProd['noSolicitado']= $productosNoSolicitados;
      $insertsProd['noHabilitado']= $productosNoHabilitados;
    }
    
    //Muestra en proceso
    if($resultado == 2){
      //Regrsa resultado no hay productos por surtir
      $insertsProd['resultado']='Muestra en proceso';
      $insertsProd['descripcion']='Ya existe una solicitud de muestra para los productos seleccionados. Espere a que se surta para poder solicitar otra muestra';
    
    }
  }catch (PDOException $e) {
    $insertsProd['resultado']='Error';
    $insertsProd['descripcion']= $e->getMessage();
  }


  //Limpia variables
  $link = null;
  //Regresa resultado
  return $rs->successMessage($request->getParsedBody(),$response, $insertsProd);

});

?>
