<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: surteMuestra
* Path: /surte/Muestra
* Método: POST
* Descripción: Servicio para solicitar muestra
*/
$app->post('/obtenerNotificacionesPendientes', function (Request $request, Response $response){
  //Init
  $db = new db();           //Instancia BD General
  $link = $db->conectDB();
  $rs = new manageResponse();
  //Recuperar parámetros de entrada
  $body = $request->getBody();
  $params = json_decode($body, true);
  if($params == null){
    $params = $request->getParsedBody();
  }
//Recuperar parámetros de entrada
  $id_vendedor = ( isset($params['id_vendedor']) ? $params['id_vendedor'] : null );
  //Validar elementos requeridos para crear surtimiento
  if (empty($id_vendedor) || $id_vendedor == null) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información del vendedor', 400);
  }
  $pending_notifications = array();
  try{
    $sql = "SELECT
              s.id AS supply_id,
              spr.id_surtimiento_por_rango AS supply_range_id,
              CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) AS supplier_name,
              SUM(IF(sd.cantidad_surtida > 0 AND sd.cantidad_surtida IS NOT NULL, 1, 0)) AS supplied_counter
            FROM ec_surtimiento_por_rangos spr
            LEFT JOIN ec_surtimiento_detalle sd
            ON spr.id_surtimiento_por_rango = sd.id_surtimiento_por_rango
            LEFT JOIN ec_surtimiento s
            ON spr.id_surtimiento = s.id
            LEFT JOIN sys_users u
            ON spr.id_usuario_asignado = u.id_usuario 
            WHERE s.id_vendedor = {$id_vendedor}
            AND spr.id_status_surtimiento_pedidos = 4
            AND spr.notificacion_vista = 0
            GROUP BY spr.id_surtimiento_por_rango";
    foreach($link->query($sql) AS $row){
      $pending_notifications[] = $row;
    }
    $resultado['result'] = 'exito';
    $resultado['description']= "Notificaciones obtenidas exitosamente.";
    $resultado['notifications'] = $pending_notifications;
  }catch (PDOException $e) {
    $resultado['resultado']='Error';
    $resultado['descripcion']= $e->getMessage();
  }
  $link = null;//Limpia variables
  return $rs->successMessage($request->getParsedBody(),$response, $resultado);//Regresa resultado
});

?>
