<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: surteMuestra
* Path: /surte/Muestra
* Método: POST
* Descripción: Servicio para solicitar muestra
*/
$app->post('/actualizarNotificacionSurtimiento', function (Request $request, Response $response){
  //Init
  $db = new db();           //Instancia BD General
  $link = $db->conectDB();
  $rs = new manageResponse();
  //Recuperar parámetros de entrada
  $body = $request->getBody();
  $params = json_decode($body, true);
  if($params == null){
    $params = $request->getParsedBody();
  }
//Recuperar parámetros de entrada
  $supply_range_id = ( isset($params['supply_range_id']) ? $params['supply_range_id'] : null );
  //Validar elementos requeridos para crear surtimiento
  if (empty($supply_range_id) || $supply_range_id == null) {
    return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información del vendedor', 400);
  }
  $resultado = array();
  try{
    $sql = "UPDATE ec_surtimiento_por_rangos spr 
                SET spr.notificacion_vista = 1
            WHERE id_surtimiento_por_rango = {$supply_range_id}";
    $link->query($sql);
    $resultado["status"] = "200";
    $resultado["sql"] = "{$sql}";
  }catch (PDOException $e) {
    $resultado['status'] = 'Error';
    $resultado['descripcion'] = $e->getMessage();
  }
  $link = null;//Limpia variables
  return $rs->successMessage($request->getParsedBody(),$response, $resultado);//Regresa resultado
});

?>
