<?php
/*
     * Version 1.1 donde se corrige error de comprobación que tomaba comprobaciones de registros otras sucursales
*/
    class warehouseProductProviderMovementsRowsVerification{
        private $link;
		private $LOGGER;
		function __construct( $connection, $Logger = false ){
			$this->link = $connection;
            $this->LOGGER = $Logger;
		}

        public function insertVerificationLog( $table, $unique_folio, $json_detail, $logger_id = false ){
            $log_steep_id = null;
            $json_detail = str_replace( "'", "\'", $json_detail );
            try{
                $sql = "INSERT INTO sys_sincronizacion_comprobaciones_log ( tabla, folio_unico_peticion, json_comprobacion, fecha_alta ) 
                        VALUES( '{$table}', '{$unique_folio}', '{$json_detail}', NOW() )";
                $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta log de comprobacion", $sql );
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar log de comprobacion", 'sys_sincronizacion_comprobaciones_log', $sql, $error );
                }
                die( "Error al insertar log de comprobacion : {$sql} : {$error}" );
            }
            return 'ok';
        }

        public function getPendingWarehouseProductProviderMovement( $origin_store_id, $destinity_store_id, $logger_id = false ){
            $log_steep_id = null;
            $resp = array();
            $pending_rows = array();
            try{
                $sql = "SELECT 
                            sp.id_peticion AS petition_id,
                            sp.folio_unico AS unique_folio,
                            sp.id_sucursal_origen AS origin_store,
                            sp.id_sucursal_destino AS destinity_store,
                            sp.tabla AS table_name,
                            sp.tipo AS petition_type,
                            sp.hora_comienzo AS datetime_start,
                            sp.hora_envio AS datetime_send,
                            sp.hora_llegada_destino AS datetime_destinity,
                            sp.hora_respuesta AS datetime_send_response,
                            sp.contenido_respuesta AS response_content,
                            sp.hora_llegada_respuesta AS datetime_response,
                            sp.hora_finalizacion AS datetime_end
                        FROM sys_sincronizacion_peticion sp
                        LEFT JOIN sys_sincronizacion_movimientos_proveedor_producto sma
                        ON sma.folio_unico_peticion = sp.folio_unico
                        WHERE sp.tabla = 'sys_sincronizacion_movimientos_proveedor_producto'
                        AND sp.id_sucursal_origen = {$origin_store_id}
                        AND sp.id_sucursal_destino = {$destinity_store_id}
                        AND sp.hora_envio IS NOT NULL
                        AND( sp.hora_llegada_destino IS NULL
                        OR sp.hora_llegada_respuesta IS NULL
                        OR sp.hora_finalizacion IS NULL 
                        OR sma.id_status_sincronizacion = 2 )
                        GROUP BY sp.id_peticion";
                $stm = $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta peticiones pendientes de alguna respuesta", $sql );
                }
                $resp['verification'] = ( $stm->rowCount() > 0 ? true : false );//num_rows
                if($stm->rowCount() > 0){
                    try{
                        $petition = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
                        $resp['petition'] = $petition;
                        //$resp['petition_id'] = $petition['petition_id'];
                        //$resp['unique_folio'] = $petition['unique_folio'];
                        $sql = "SELECT 
                                    json,
                                    tabla,
                                    registro_llave
                                FROM sys_sincronizacion_movimientos_proveedor_producto
                                WHERE folio_unico_peticion = '{$petition['unique_folio']}'
                                ANd id_status_sincronizacion = 2";
                        $stm_2 = $this->link->query( $sql );
                            if( $logger_id ){
                                $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta detalle de json", $sql );
                            }
                        while( $detail = $stm_2->fetch(PDO::FETCH_ASSOC) ){//_assoc
                            $pending_rows[] = $detail;
                        }
                        $resp['rows'] = $pending_rows;
                        $pending_rows_string = json_encode( $pending_rows );
                    //inserta el log
                        $log = $this->insertVerificationLog( 'sys_sincronizacion_movimientos_proveedor_producto', $petition['unique_folio'], $pending_rows_string, $logger_id );
                        if( $log != 'ok' ){
                            return false;
                        }
                    }catch(PDOException $error){
                        if( $logger_id ){
                            $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar detalle de json", 'sys_sincronizacion_peticion', $sql, $error );
                        }
                        die( "Error al consultar detalle de json : {$sql} : {$error}" );
                    }
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar las peticiones pendientes de alguna respuesta", 'sys_sincronizacion_peticion', $sql, $error );
                }
                die( "Error al consultar las peticiones pendientes de alguna respuesta : {$sql} : {$error}" );
            }
            return $resp;
        }
        
        public function validateIfExistsPetitionLog( $petition_log, $logger_id = false ){
            $log_steep_id = null;
           // var_dump( $petition_log );
            $resp = array();
        //verifica si existe el log de peticion
            try{
                $sql = "SELECT
                            id_peticion AS petition_id,
                            folio_unico AS unique_folio,
                            id_sucursal_origen AS origin_store,
                            id_sucursal_destino AS destinity_store,
                            tabla AS table_name,
                            tipo AS petition_type,
                            hora_comienzo AS datetime_start,
                            hora_envio AS datetime_send,
                            hora_llegada_destino AS datetime_destinity,
                            hora_respuesta AS datetime_send_response,
                            contenido_respuesta AS response_content,
                            hora_llegada_respuesta AS datetime_response,
                            hora_finalizacion AS datetime_end
                        FROM sys_sincronizacion_peticion
                        WHERE folio_unico = '{$petition_log['unique_folio']}'";
                $stm = $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta si existe la peticion en el destino", $sql );
                }
                if( $stm->rowCount() > 0 ){//existe//num_rows
                    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
                    $resp = $row;
                    $resp['datetime_destinity'] = ( $resp['datetime_destinity'] == null || $resp['datetime_destinity'] == null ? 'null' : $resp['datetime_destinity'] );
                    $resp['datetime_send_response'] = ( $resp['datetime_send_response'] == null || $resp['datetime_send_response'] == 'null' ? null : $resp['datetime_send_response'] );
                    $resp['response_content'] = ( $resp['response_content'] == null || $resp['response_content'] == 'null' ? null : $resp['response_content'] );
                    $resp['datetime_response'] = ( $resp['datetime_response'] == null || $resp['datetime_response'] == 'null' ? null : $resp['datetime_response'] );
                    $resp['datetime_end'] = ( $resp['datetime_end'] == null || $resp['datetime_end'] == 'null' ? null : $resp['datetime_end'] );
                }else{//no_existe
                    try{
                        $sql = "INSERT INTO sys_sincronizacion_peticion ( id_sucursal_origen, id_sucursal_destino, tabla, tipo, hora_comienzo, 
                                hora_envio, hora_llegada_destino, hora_respuesta, contenido_respuesta, hora_llegada_respuesta, hora_finalizacion, folio_unico )
                            VALUES ( {$petition_log['origin_store']}, {$petition_log['destinity_store']}, '{$petition_log['table_name']}', '{$petition_log['petition_type']}', '{$petition_log['datetime_start']}', 
                            '{$petition_log['datetime_send']}', NOW(), NOW(), '', NOW(), NOW(), '{$petition_log['unique_folio']}' )";
                        $stm = $this->link->query( $sql );
                        if( $logger_id ){
                            $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta peticion en el destino", $sql );
                        }
                    }catch(PDOException $error){
                        if( $logger_id ){
                            $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar peticion en el destino", 'sys_sincronizacion_peticion', $sql, $error );
                        }
                        die( "Error al insertar peticion en el destino : {$sql} : {$error}" );
                    }
                    $resp = $petition_log;
                //consulta la hor actual
                    try{
                        $sql = "SELECT NOW() AS current_date_time";
                        $stm_2 = $this->link->query( $sql );
                        $row = $stm_2->fetch(PDO::FETCH_ASSOC);//_assoc
                        $resp['datetime_destinity'] = $row['current_date_time'];
                        $resp['datetime_send_response'] = $row['current_date_time'];
                        $resp['response_content'] = $row['current_date_time'];
                        $resp['datetime_response'] = $row['current_date_time'];
                        $resp['datetime_end'] = $row['current_date_time'];
                    }catch(PDOException $error){
                        die( "Error al consultar la fecha y hora : {$sql} : {$error}" );
                    }
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar si existe la peticion en el destino", 'sys_sincronizacion_peticion', $sql, $error );
                }
                die( "Error al consultar si existe la peticion en el destino : {$sql} : {$error}" );
            }
            return $resp;
        }

        public function warehouseProductProviderMovementsValidation( $movements, $logger_id = false ){
            $log_steep_id = null;
            $resp = array();
            $resp['ok_rows'] = "";
            $resp['error_rows'] = "";
            foreach ($movements as $key => $movement_) {
                $p_p_movement = json_decode( $movement_['json'] );
                //var_dump($p_p_movement);
            //consulta si la cabecera existe
                try{
                    $sql = "SELECT id_movimiento_detalle_proveedor_producto AS movement_id FROM ec_movimiento_detalle_proveedor_producto WHERE folio_unico = '{$movement_['registro_llave']}'";
                    $stm = $this->link->query( $sql );// or die( "Error al consultar si ya existe la cabecera de movimiento de almacen en la comprobacion : {$sql} : {$this->link->error}" );
                    if( $logger_id ){
                        $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta si ya existe la cabecera de movimiento de almacen en la comprobacion", $sql );
                    }
                    if( $stm->rowCount() <= 0 ){//no existe//num_rows
                        //die("p_p : {$p_p_movement->id_movimiento_almacen_detalle} | ");
                        if( $p_p_movement->id_movimiento_almacen_detalle != -1 && $p_p_movement->id_movimiento_almacen_detalle != '' && $p_p_movement->id_movimiento_almacen_detalle != null 
                        && $p_p_movement->id_movimiento_almacen_detalle != NULL && $p_p_movement->id_movimiento_almacen_detalle != 'null' && $p_p_movement->id_movimiento_almacen_detalle != 'NULL'){
                            try{
                                $sql = $p_p_movement->id_movimiento_almacen_detalle;
                                $stm = $this->link->query( $sql );
                                $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
                                $p_p_movement->id_movimiento_almacen_detalle = $row['id_movimiento_almacen_detalle'];
                            }catch(PDOException $error){
                                die( "Error al consultar detalle de movimiento a nivel producto en comprobacion de movimientos proveedor producto : {$sql} : {$error}" );
                            }
                        }
                        if( $p_p_movement->id_pedido_validacion != -1 && $p_p_movement->id_pedido_validacion != '' && $p_p_movement->id_pedido_validacion != null ){
                            try{
                                $sql = $p_p_movement->id_pedido_validacion;
                                $stm = $this->link->query( $sql );
                                $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
                                $p_p_movement->id_pedido_validacion = $row['id_pedido_validacion'];
                            }catch(PDOException $error){
                                die( "Error al consultar id de validacion en comprobacion de movimientos proveedor producto : {$sql} : {$error}" );
                            }
                        }
                    //se inserta movimiento proveedor producto por procedure
                        try{
                            $sql = "CALL spMovimientoDetalleProveedorProducto_inserta( {$p_p_movement->id_movimiento_almacen_detalle}, {$p_p_movement->id_proveedor_producto}, {$p_p_movement->cantidad}, 
                                        {$p_p_movement->id_sucursal}, {$p_p_movement->id_tipo_movimiento}, {$p_p_movement->id_almacen}, {$p_p_movement->id_pedido_validacion}, 
                                        {$p_p_movement->id_pantalla}, '{$p_p_movement->folio_unico}' )";
                            $stm = $this->link->query( $sql );
                            if( $logger_id ){
                                $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta movimiento de almacen proveedor producto", $sql );
                            }
                        }catch(PDOException $error){
                            if( $logger_id ){
                                $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar movimiento de almacen proveedor producto", 'ec_movimiento_almacen', $sql, $error );
                            }
                            die( "Error al insertar movimiento de almacen proveedor producto : {$sql} : {$error}" );
                        }
                    }
                    $resp['ok_rows'] .= ( $resp['ok_rows'] == '' ? '' : '|' );
                    $resp['ok_rows'] .= ( $movement_['registro_llave'] );
                }catch(PDOException $error){
                    if( $logger_id ){
                        $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar si ya existe la cabecera de movimiento de almacen en la comprobacion", 'ec_movimiento_almacen', $sql, $error );
                    }
                    die( "Error al consultar si ya existe el movimiento proveedor producto en la comprobacion : {$sql} : {$error}" );
                }
            }
            //var_dump( $resp );
            //die( $resp['ok_rows'] );
            return $resp;
        }

        public function updateLogAndJsonsRows( $log_response, $rows_response, $logger_id = false ){
            $log_steep_id = null;
            $this->link->beginTransaction();//autocommit( false );
            //die( "here1" );
            $log_response->response_content = str_replace( "'", "\'", $log_response->response_content );
            try{
                $sql = "UPDATE sys_sincronizacion_peticion SET hora_llegada_destino = IF( hora_llegada_destino IS NULL OR hora_llegada_destino = '', '{$log_response->datetime_destinity}', hora_llegada_destino ),
                            hora_respuesta = IF( hora_respuesta IS NULL OR hora_respuesta = '', '{$log_response->datetime_send_response}', hora_respuesta ),
                            contenido_respuesta = IF( contenido_respuesta IS NULL OR contenido_respuesta = '', '{$log_response->response_content}', contenido_respuesta ),
                            hora_llegada_respuesta = IF( hora_llegada_respuesta IS NULL OR hora_llegada_respuesta = '', NOW(), hora_llegada_respuesta ),
                            hora_finalizacion = IF( hora_finalizacion IS NULL OR hora_finalizacion = '', NOW(), hora_finalizacion )
                        WHERE folio_unico = '{$log_response->unique_folio}'";//die( $sql );
                $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualiza la peticion (comprobación)", $sql );
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al actualizar la peticion (comprobación) ", 'sys_sincronizacion_peticion', $sql, $error );
                }
                die( "Error al actualizar la peticion (comprobación) : {$sql} : {$error}" );
            }
        //actualiza los registros correctos
            $ok_rows = $rows_response->ok_rows;
            $uniques_folios = '';
            $ok_rows = explode( '|', $ok_rows );//= str_replace( '|', ',', $ok_rows );
            foreach ($ok_rows as $key => $row) {
                $uniques_folios .= ( $uniques_folios == '' ? '' : ',' );
                $uniques_folios .= "'{$row}'";
            }
            try{
                $sql = "UPDATE sys_sincronizacion_movimientos_proveedor_producto SET id_status_sincronizacion = 3 WHERE registro_llave IN( $uniques_folios )";
                $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualizar detalles (jsons)", $sql );
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al actualizar detalles (jsons)", 'sys_sincronizacion_movimientos_proveedor_producto', $sql, $error );
                }
                die( "Error al actualizar detalles (jsons) local : {$sql} : {$error}" );
            }
            $this->link->commit();//autocommit( true );
            return 'ok';
        }
    }
?>