<?php
/*
     * Version 1.1 donde se corrige error de comprobación que tomaba comprobaciones de registros otras sucursales
     * Version Oscar 2024-11-18 Para corregir error en ciclos de comprobacion de registros generales
*/
    class generalRowsVerification{
        private $link;
		private $LOGGER;
		function __construct( $connection, $Logger = false ){
			$this->link = $connection;
            $this->LOGGER = $Logger;
		}

        public function insertVerificationLog( $table, $unique_folio, $json_detail, $logger_id = false ){
            $log_steep_id = null;
            $json_detail = str_replace( "'", "\'", $json_detail );
            try{
               $sql = "INSERT INTO sys_sincronizacion_comprobaciones_log ( tabla, folio_unico_peticion, json_comprobacion, fecha_alta ) 
                        VALUES( '{$table}', '{$unique_folio}', '{$json_detail}', NOW() )";
                $this->link->query( $sql );
                if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta log de comprobacion", $sql );
				}
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar log de comprobacion", 'sys_sincronizacion_comprobaciones_log', $sql, $error );
                }
			    die( "Error al insertar log de comprobacion : {$sql} : {$error}" );
			}
            return 'ok';
        }

        public function getPendingRows( $origin_store_id, $destinity_store_id, $table_name, $logger_id = false){
            $log_steep_id = null;
            $resp = array();
            $pending_rows = array();
            $petition = null;
            $stm = null;
            try{
                $sql = "SELECT 
                            sp.id_peticion AS petition_id,
                            sp.folio_unico AS unique_folio,
                            sp.id_sucursal_origen AS origin_store,
                            sp.id_sucursal_destino AS destinity_store,
                            sp.tabla AS table_name,
                            sp.tipo AS petition_type,
                            sp.hora_comienzo AS datetime_start,
                            sp.hora_envio AS datetime_send,
                            sp.hora_llegada_destino AS datetime_destinity,
                            sp.hora_respuesta AS datetime_send_response,
                            sp.contenido_respuesta AS response_content,
                            sp.hora_llegada_respuesta AS datetime_response,
                            sp.hora_finalizacion AS datetime_end
                        FROM sys_sincronizacion_peticion sp
                        LEFT JOIN {$table_name} sr
                        ON sr.folio_unico_peticion = sp.folio_unico
                        WHERE sp.tabla = '{$table_name}'
                        AND sp.id_sucursal_origen = {$origin_store_id}
                        AND sp.id_sucursal_destino = {$destinity_store_id}
                        AND sp.hora_envio IS NOT NULL
                        AND( sp.hora_llegada_destino IS NULL
                        OR sp.hora_llegada_respuesta IS NULL
                        OR sp.hora_finalizacion IS NULL 
                        OR sr.status_sincronizacion = 2 )
                        GROUP BY sp.id_peticion";
                $stm = $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta peticiones pendientes de alguna respuesta", $sql );
                }
                $resp['verification'] = ( $stm->rowCount() > 0 ? true : false );//num_rows
                try{
                    if($stm->rowCount() > 0){
                        $petition = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
                        $resp['petition'] = $petition;
                        $sql = "SELECT 
                                    datos_json,
                                    id_sincronizacion_registro synchronization_row_id,
                                    tipo AS tabla
                                FROM {$table_name}
                                WHERE folio_unico_peticion = '{$petition['unique_folio']}'
                                AND status_sincronizacion = 2";
                        $stm_2 = $this->link->query( $sql );
                        if( $logger_id ){
                            $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta detalle de json", $sql );
                        }
                        while( $detail = $stm_2->fetch(PDO::FETCH_ASSOC) ){//_assoc
                            $pending_rows[] = $detail;
                        }
                        $resp['rows'] = $pending_rows;
                        $pending_rows_string = json_encode( $pending_rows );
                    //inserta el log
                        $log = $this->insertVerificationLog( "{$table_name}", $petition['unique_folio'], $pending_rows_string, $logger_id );
                        if( $log != 'ok' ){
                            return false;
                        }
                    }
                }catch(PDOException $error){
                    if( $logger_id ){
                        $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar detalle de json", "{$table_name}", $sql, $error );
                    }
                    die( "Error al consultar detalle de json en {$table_name} : {$sql} {$error}" );
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar las peticiones pendientes de alguna respuesta", "{$table_name}", $sql, $error );
                }
                die( "Error al consultar las peticiones pendientes de alguna respuesta : {$sql} : {$error}" );
            }
            return $resp;
        }
        
        public function validateIfExistsPetitionLog( $petition_log, $logger_id = false ){
            $log_steep_id = null;// var_dump( $petition_log );
            $resp = array();
        //verifica si existe el log de peticion
            try{
                $sql = "SELECT
                            id_peticion AS petition_id,
                            folio_unico AS unique_folio,
                            id_sucursal_origen AS origin_store,
                            id_sucursal_destino AS destinity_store,
                            tabla AS table_name,
                            tipo AS petition_type,
                            hora_comienzo AS datetime_start,
                            hora_envio AS datetime_send,
                            hora_llegada_destino AS datetime_destinity,
                            hora_respuesta AS datetime_send_response,
                            contenido_respuesta AS response_content,
                            hora_llegada_respuesta AS datetime_response,
                            hora_finalizacion AS datetime_end
                        FROM sys_sincronizacion_peticion
                        WHERE folio_unico = '{$petition_log['unique_folio']}'";
                $stm = $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta si existe la peticion en el destino", $sql );
                }
                if( $stm->rowCount() > 0 ){//existe//num_rows
                    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
                    $resp = $row;
                    $resp['datetime_destinity'] = ( $resp['datetime_destinity'] == null || $resp['datetime_destinity'] == null ? 'null' : $resp['datetime_destinity'] );
                    $resp['datetime_send_response'] = ( $resp['datetime_send_response'] == null || $resp['datetime_send_response'] == 'null' ? null : $resp['datetime_send_response'] );
                    $resp['response_content'] = ( $resp['response_content'] == null || $resp['response_content'] == 'null' ? null : $resp['response_content'] );
                    $resp['datetime_response'] = ( $resp['datetime_response'] == null || $resp['datetime_response'] == 'null' ? null : $resp['datetime_response'] );
                    $resp['datetime_end'] = ( $resp['datetime_end'] == null || $resp['datetime_end'] == 'null' ? null : $resp['datetime_end'] );
                }else{//no_existe
                    try{
                        $sql = "INSERT INTO sys_sincronizacion_peticion ( id_sucursal_origen, id_sucursal_destino, tabla, tipo, hora_comienzo, 
                                    hora_envio, hora_llegada_destino, hora_respuesta, contenido_respuesta, hora_llegada_respuesta, hora_finalizacion, folio_unico )
                                VALUES ( {$petition_log['origin_store']}, {$petition_log['destinity_store']}, '{$petition_log['table_name']}', '{$petition_log['petition_type']}', '{$petition_log['datetime_start']}', 
                                '{$petition_log['datetime_send']}', NOW(), NOW(), '', NOW(), NOW(), '{$petition_log['unique_folio']}' )";
                        $stm = $this->link->query( $sql );
                            if( $logger_id ){
                                $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta peticion en el destino", $sql );
                            }
                        // or die( "Error al insertar el registro de sincronizacion en el destino : {$sql} : {$this->link->error}" );
                        $resp = $petition_log;
                    //consulta la hora actual
                        try{
                            $sql = "SELECT NOW() AS current_date_time";
                            $stm_2 = $this->link->query( $sql );
                            $row = $stm_2->fetch(PDO::FETCH_ASSOC);//_assoc
                            $resp['datetime_destinity'] = $row['current_date_time'];
                            $resp['datetime_send_response'] = $row['current_date_time'];
                            $resp['response_content'] = $row['current_date_time'];
                            $resp['datetime_response'] = $row['current_date_time'];
                            $resp['datetime_end'] = $row['current_date_time'];
                        }catch(PDOException $error){
                            die( "Error al consultar la fecha y hora : {$sql} : {$error}" );
                        }
                    }catch(PDOException $error){
                        if( $logger_id ){
                            $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar peticion en el destino", 'sys_sincronizacion_peticion', $sql, $error );
                        }
                        die( "Error al insertar peticion en el destino : {$sql} : {$error}" );
                    }
                }
            }catch(PDOException $error){
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar si existe la peticion en el destino", 'sys_sincronizacion_peticion', $sql, $error );
                }
                die( "Error al consultar si existe la peticion en el destino : {$sql} : {$error}" );
            }
            return $resp;
        }

        public function RowsValidation( $rows, $table_name, $logger_id = false ){
            $log_steep_id = null;
            $resp = array();
            $resp['ok_rows'] = "";
            $resp['error_rows'] = "";
            $queries = array();
			foreach ($rows as $key => $row_) {
				$sql = "";
				$condition = "";
                //$row_['datos_json'] = str_replace( "\n", " ", $row_['datos_json'] );//se eliminan saltos de linea
                $row_['datos_json'] = preg_replace('/\r|\n/', '', $row_['datos_json']);
                $row_['datos_json'] = preg_replace('/[\x00-\x1F\x7F]/u', '', $row_['datos_json']);
                $row = json_decode( $row_['datos_json'], true );//
                //var_dump( $row );die('here');
				if( isset( $row['primary_key'] ) && isset( $row['primary_key_value'] ) ){
					$condition .= "WHERE {$row['primary_key']} = '{$row['primary_key_value']}'";
				}
				if( isset( $row['secondary_key'] ) && isset( $row['secondary_key_value'] ) ){
					$condition .= " AND {$row['secondary_key']} = '{$row['secondary_key_value']}'";
				}
				$condition = str_replace( "'(", "(", $condition );
				$condition = str_replace( ")'", ")", $condition );
				switch ( $row['action_type'] ) {
					case 'insert' :
                    //verifica si existe el registro
                        try{
                            $verification_sql = "SELECT {$row['primary_key']} FROM {$row['table_name']} {$condition}";//die( $verification_sql );
                            $verification_stm   = $this->link->query( $verification_sql );
                            if( $logger_id ){
                                $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "(INSERT); Verifica si existe el registro en tabla {$row['table_name']} : ", $verification_sql );
                            }
                            if( $verification_stm->rowCount() <= 0) {//si el registro no existe//num_rows
                                $sql = "INSERT INTO {$row['table_name']} ( ";
                                $fields = "";
                                $values   = "";
                                foreach ($row as $key2 => $value) {
                                    if( $key2 != 'table_name' && $key2 != 'action_type' && $key2 != 'primary_key' 
                                        && $key2 != 'primary_key_value' && $key2 != 'secondary_key' 
                                        && $key2 != 'secondary_key_value' && $key2 != 'synchronization_row_id' ){
                                        $fields .= ( $fields == "" ? "" : ", " );
                                        $fields .= "{$key2}";
                                        $values .= ( $values == "" ? "" : ", " );
                                        $values .= "'{$value}'";
                                    }
                                }
                                $fields .= " )";
                                $sql .=  "{$fields} VALUES ( {$values} )";
                                array_push( $queries, array( "query"=>$sql, "row_id"=>$row_['synchronization_row_id']) );
                                if( $row['table_name'] != 'ec_pedidos' && $row['table_name'] != 'ec_pedidos_detalle' ){
                                    $sql = "UPDATE {$row['table_name']} SET sincronizar = 0 {$condition}";
                                    array_push( $queries, array( "query"=>$sql, "row_id"=>"n/a") );
                                }
                            }else{//si el registro ya existe en el destino
                                $resp["ok_rows"] .= ( $resp["ok_rows"] == '' ? '' : ',' ) . "'{$row_['synchronization_row_id']}'";
                            }
                        //Crear carpetas mediante la sincronizacion
                            if( $row['table_name'] == 'sys_carpetas' ){
                                mkdir( "../../{$row['`path`']}/{$row['nombre_carpeta']}" , 0777);
                                if( $logger_id ){
                                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "(INSERT); Creacion de carpeta por sincronizacion {$row['table_name']} : ", "mkdir( \"../../{$row['`path`']}/{$row['nombre_carpeta']}\" , 0777);" );
                                }
                                chmod( "../../{$row['`path`']}/{$row['nombre_carpeta']}" , 0777 );
                                if( $logger_id ){
                                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "(INSERT); Cambia permisos de carpeta por sincronizacion {$row['table_name']} : ", "chmod( \"../../{$row['`path`']}/{$row['nombre_carpeta']}\" , 0777 );" );
                                }
                            }
                        }catch(PDOException $error){
                            $ok = false;
                            if( $logger_id ){
                                $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error en INSERT al verificar si existe el registro en tabla {$row['table_name']}", "{$row['table_name']}", $verification_sql, $error );
                            }
                            die( "Error en INSERT al verificar si existe el registro en tabla {$row['table_name']} : {$verification_sql} : {$error}" );
                        }
					break;
					case 'update' :
						$sql = "UPDATE {$row['table_name']} SET ";
						$fields = "";
						foreach ($row as $key2 => $value) {
							if( $key2 != 'table_name' && $key2 != 'action_type' && $key2 != 'primary_key' 
								&& $key2 != 'primary_key_value' && $key2 != 'secondary_key' 
								&& $key2 != 'secondary_key_value' && $key2 != 'synchronization_row_id' ){
								$fields .= ( $fields == "" ? "" : ", " );
								$fields .= "{$key2} = '{$value}'";
							}
						}
						$sql .= "{$fields} {$condition}";
						if( $row['table_name'] == 'ec_movimiento_detalle' ){
						//procedure aqui
                            try{
                                $aux = "SELECT id_movimiento_almacen_detalle AS detail_id FROM ec_movimiento_detalle WHERE folio_unico = '{$row['primary_key_value']}'";
                                $aux_stm = $this->link->query( $aux );
                                $aux_row = $aux_stm->fetch(PDO::FETCH_ASSOC);//_assoc
                                $sql = "CALL spMovimientoAlmacenDetalle_actualiza( {$aux_row['detail_id']}, {$row['cantidad']}, {$row['id_proveedor_producto']}, NULL );";
                            }catch(PDOException $error){
                                die( "Error al consultar id de detalle mov almacen : {$aux} : {$error}" );
                            }
						}
					    array_push( $queries, array( "query"=>$sql, "row_id"=>$row_['synchronization_row_id'] ) );
					break;
					case 'delete' :
                    //verifica si existe el registro
                        try{
                            $verification_sql = "SELECT {$row['primary_key']} FROM {$row['table_name']} {$condition}";
                            $verification_stm = $this->link->query( $verification_sql );
                            if( $verification_stm->rowCount() > 0) {//si el registro existe//num_rows
                                $sql = "DELETE FROM {$row['table_name']} {$condition}";
                                if( $row['table_name'] == 'ec_movimiento_detalle' ){
                                //procedure aqui
                                    try{
                                        $aux = "SELECT id_movimiento_almacen_detalle AS detail_id FROM ec_movimiento_detalle WHERE folio_unico = '{$row['primary_key_value']}'";
                                        $aux_stm = $this->link->query( $aux );
                                        $aux_row = $aux_stm->fetch(PDO::FETCH_ASSOC);//_assoc
                                        $sql = "CALL spMovimientoAlmacenDetalle_elimina( {$aux_row['detail_id']}, NULL );";
                                    }catch(PDOException $error){
                                        die("Error al consultar id de detalle mov almacen : {$aux} : {$error}" );
                                    }
                                }
                                array_push( $queries, array( "query"=>$sql, "row_id"=>$row_['synchronization_row_id'] ) );
                            }else{//si el registro ya no existe en el destino
                                $resp["ok_rows"] .= ( $resp["ok_rows"] == '' ? '' : ',' ) . "'{$row_['synchronization_row_id']}'";
                            }
                        }catch(PDOException $error){
                            die("Error al consultar si el registro existe : {$verification_sql} : {$error}");
                        }
					break;

					case 'sql_instruction' : 
						$sql = $row['sql'];
						//$resp["ok_rows"] .= ( $resp["ok_rows"] == '' ? '' : ',' ) . "'{$row['synchronization_row_id']}'";
					    array_push( $queries, array( "query"=>$sql, "row_id"=>$row_['synchronization_row_id'] ) );//se manda ejecutar de nuevo al ser una consulta dinamica
					break;
					
					default:
						//var_dump($row);
						//die( "JSON incorrecto : {$row['action_type']}" );
					break;
				}    
			}
            //ejecuta instrucciones sql
                foreach ($queries as $key2 => $query_) {
                    $ok = true;
//$this->link->beginTransaction();//autocommit(false);
                    $query = str_replace( "'(", "(", $query_['query'] );
                    $query = str_replace( ")'", ")", $query );
                    try{
                        $stm = $this->link->query( $query );// 
                        if( $logger_id ){
                            $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Ejecuta consulta SQL : ", $query );
                        }
                    }catch(PDOException $error){
                        $ok = false;
                        if( $logger_id ){
                            $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al ejecutar consulta en comprobación", "$table_name", $query, $error );
                        }
                        die( "Error al ejecutar consulta en comprobación : {$query} : {$error}" );
                    }
                    if( $ok == true && $query_['row_id'] != 'n/a' ){
						$resp["ok_rows"] .= ( $resp["ok_rows"] == '' ? '' : ',' ) . "'{$query_['row_id']}'";
//$this->link->commit();//commit();
                    }else if( $ok == false  && $query_['row_id'] != 'n/a' ){
						$resp["error_rows"] .= ( $resp["error_rows"] == '' ? '' : ',' ) . "'{$query_['row_id']}'";
//$this->link->rollBack();//rollback();
                    }
                }
            return $resp;
        }

        public function updateLogAndJsonsRows( $log_response, $rows_response, $table_name, $logger_id = false ){
            $log_steep_id = null;
            $this->link->beginTransaction();//autocommit( false );
            $log_response = json_decode( json_encode($log_response), true);//correcion de error
            $log_response['response_content'] = ( (!isset($log_response['response_content']) || $log_response['response_content'] == null) ? '' : $log_response['response_content'] );
            $log_response['response_content'] = str_replace( "'", "\'", $log_response['response_content'] );
            try{
                $sql = "UPDATE sys_sincronizacion_peticion SET hora_llegada_destino = IF( hora_llegada_destino IS NULL OR hora_llegada_destino = '', '{$log_response['datetime_destinity']}', hora_llegada_destino ),
                            hora_respuesta = IF( hora_respuesta IS NULL OR hora_respuesta = '', '{$log_response['datetime_send_response']}', hora_respuesta ),
                            contenido_respuesta = IF( contenido_respuesta IS NULL OR contenido_respuesta = '', '{$log_response['response_content']}', contenido_respuesta ),
                            hora_llegada_respuesta = IF( hora_llegada_respuesta IS NULL OR hora_llegada_respuesta = '', NOW(), hora_llegada_respuesta ),
                            hora_finalizacion = IF( hora_finalizacion IS NULL OR hora_finalizacion = '', NOW(), hora_finalizacion )
                        WHERE folio_unico = '{$log_response['unique_folio']}'";//die( $sql );
                $stm = $this->link->query( $sql );
                if( $logger_id ){
                    $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualiza la peticion (comprobación)", $sql );
                }
            }catch(PDOException $error){
                $this->link->rollBack();
                if( $logger_id ){
                    $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al actualizar la peticion (comprobación) ", 'sys_sincronizacion_peticion', $sql, $error );
                }
                die( "Error al actualizar la peticion (comprobación) : {$sql} : {$error}" );
            }
        //actualiza los registros correctos
            $ok_rows = $rows_response->ok_rows;
            
            if( $ok_rows != '' ){
                try{
                    $sql = "UPDATE {$table_name} SET status_sincronizacion = 3 WHERE id_sincronizacion_registro IN( $ok_rows )";
                    $stm = $this->link->query( $sql );
                    if( $logger_id ){
                        $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualizar detalles (jsons)", $sql );
                    }
                }catch(PDOException $error){
                    $this->link->rollBack();
                    if( $logger_id ){
                        $this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al actualizar detalles (jsons)", "{$table_name}", $sql, $error );
                    }
                    die( "Error al actualizar detalles (jsons) local : {$sql} : {$error}" );
                }
            }
            $this->link->commit();//autocommit( true );
            return 'ok';
        }
    }

?>