<?php

	class productProviderMovementsSynchronization
	{
		private $link;
		private $LOGGER;
		function __construct( $connection, $Logger = false ){
			$this->link = $connection;
			$this->LOGGER = $Logger;
		}
		
//hacer jsons de movimientos de almacen
		public function setNewSynchronizationProductProviderMovements( $store_id, $system_store, $origin_store_prefix, $limit, $logger_id = false ){
			$log_steep_id = null;
			try{
				$sql = "CALL buscaMovimientosProveedorProductoPendientesDeSincronizar( {$store_id}, {$system_store}, '{$origin_store_prefix}', {$limit} )"; 
				$this->link->query( $sql );
				if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Genera registros de Movimientos de Almacen Ptoveedor Producto", $sql );
				}
			}catch(PDOException $error){
				if( $logger_id ){
					$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al generar registros de movimientos proveedor producto por sincronizar", 'sys_sincronizacion_peticion', $sql, $error );
				}
				die( "Error al generar registros de movimientos proveedor producto por sincronizar : {$sql} : {$error}" );
			}
			return 'ok';
		}
//hacer / obtener jsons de movimientos de almacen
		public function getSynchronizationProductProviderMovements( $system_store, $limit, $type, $petition_unique_folio, $logger_id = false ){
			$log_steep_id = null;
			$resp = array();
			try{
				$sql = "SELECT 
							id_sincronizacion_movimiento_proveedor_producto,
							REPLACE( REPLACE( REPLACE( json, '\r\n', ' ' ), '\n', '' ), '\r', '' ) AS data,
							tabla
						FROM sys_sincronizacion_movimientos_proveedor_producto
						WHERE tabla = 'ec_movimiento_detalle_proveedor_producto'
						AND id_status_sincronizacion IN( 1 )
						AND id_sucursal_destino = {$system_store}
						LIMIT {$limit}";
			//die( $sql );
				$stm = $this->link->query( $sql );// or die( "Error al consultar los datos de jsons : {$this->link->error}" );
				if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta JSONs de Movimientos de Almacen", $sql );
				}
				$movements_counter = 0;
				//forma arreglo
				while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
					if( $row['data'] != '' && $row['data'] != null && $row['data'] != 'null' 
						&& json_decode($row['data']) != null && json_decode($row['data']) != '' ){
						//reemplaza saltos de linea y caracteres especiales
						$row['data'] = str_replace( "\n", " ", $row['data'] );
						$row['data'] = str_replace( "\r\n", " ", $row['data'] );
						$row['data'] = str_replace( "\t", " ", $row['data'] );
						$row['data'] = preg_replace("/[\r\n|\n|\r|\r\n]/", PHP_EOL, $row['data'] );
						$row['data'] = str_replace('Ñ', 'N', $row['data'] );
						$row['data'] = trim( $row['data'] );
						
						array_push( $resp, json_decode($row['data']) );//decodifica el JSON
						$movements_counter ++;
					//actualiza al status 2 los registros que va a enviar
						try{
							$sql = "UPDATE sys_sincronizacion_movimientos_proveedor_producto SET id_status_sincronizacion = 2, folio_unico_peticion = '{$petition_unique_folio}' WHERE id_sincronizacion_movimiento_proveedor_producto = {$row['id_sincronizacion_movimiento_proveedor_producto']}";
							$this->link->query( $sql );
							if( $logger_id ){
								$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualiza registro de sincronizacion movimiento proveedor producto a status 2", $sql );
							}
						}catch(PDOException $error){
							if( $logger_id ){
								$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al poner registro de sincronizacion de movimiento proveedor producto en status 2", 'sys_sincronizacion_peticion', $sql, $error );
							}
							die( "Error al poner registro de sincronizacion de movimiento proveedor producto en status 2 : {$sql} : {$error}" );
						}
					}
				}
			}catch(PDOException $error){
				if( $logger_id ){
					$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar JSONs de Movimientos de Almacen", 'sys_sincronizacion_peticion', $sql, $error );
				}
				die( "Error al consultar JSONs de Movimientos de Almacen : {$sql} : {$error}" );
			}
			return $resp;
		}
//actualizacion de registros de sincronizacion
		public function updateProductProviderMovementsSynchronization( $rows, $petition_unique_folio, $status = 3, $logger_id = false ){
			$log_steep_id = null;
			if( $petition_unique_folio == '' || $petition_unique_folio == null ){
				die( "Error : el folio unico de peticion esta vacio." );
			}
			$sql = "";
			try{
				$sql = "UPDATE sys_sincronizacion_movimientos_proveedor_producto 
	              SET id_status_sincronizacion = '{$status}',
	              	folio_unico_peticion = '{$petition_unique_folio}' 
	            WHERE registro_llave IN( {$rows} )";
	   	 		$this->link->query( $sql );
				if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualiza status de registros de sincronizacion proveedor producto", $sql );
				}
			}catch(PDOException $error){
				if( $logger_id ){
					$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al actualizar status de registros de sincronizacion proveedor producto", 'sys_sincronizacion_peticion', $sql, $error );
				}
				die( "Error al actualizar status de registros de sincronizacion proveedor producto : {$sql} : {$error}" );
			}
		}
//inserción de movimientos
		public function insertProductProviderMovements( $product_providers_movements, $logger_id = false ){
			$log_steep_id = null;
  			$resp = array();
			$resp["ok_rows"] = '';
			$resp["error_rows"] = '';

			$resp["tmp_ok"] = "";
			$resp["tmp_no"] = "";
			$updates = array();
			foreach ( $product_providers_movements as $key => $p_p_movement ) {
				if( $p_p_movement['id_movimiento_almacen_detalle'] != -1 && $p_p_movement['id_movimiento_almacen_detalle'] != '' && $p_p_movement['id_movimiento_almacen_detalle'] != null ){
					try{
						$sql = $p_p_movement['id_movimiento_almacen_detalle'];
						$stm = $this->link->query( $sql );
						//if($stm->rowCount()){
							$row = $stm->fetch(PDO::FETCH_NUM);//_row
							$p_p_movement['id_movimiento_almacen_detalle'] = $row[0];
						//}
					}catch(PDOException $error){
						die( "Error al consultar detalle de movimiento a nivel producto en inserción de movimientos proveedor producto : {$sql} : {$error}" );
					}
				}
				if( $p_p_movement['id_pedido_validacion'] != -1 && $p_p_movement['id_pedido_validacion'] != '' && $p_p_movement['id_pedido_validacion'] != null ){
					try{
						$sql = $p_p_movement['id_pedido_validacion'];
						$stm = $this->link->query( $sql );
						//if($stm->rowCount()){
							$row = $stm->fetch(PDO::FETCH_NUM);//_row
							$p_p_movement['id_pedido_validacion'] = $row[0];
							if( $p_p_movement['id_pedido_validacion'] == '' || $p_p_movement['id_pedido_validacion'] == null ){
								$p_p_movement['id_pedido_validacion']= -1;
							}
						//}
					}catch(PDOException $error){
						die( "Error al consultar id de validacion en inserción de movimientos proveedor producto : {$sql} : {$error}" );
					}
				}
				$this->link->beginTransaction();//autocommit( false );
				$ok = true;
			//inserta cabecera
				try{
					$sql = "CALL spMovimientoDetalleProveedorProducto_inserta( {$p_p_movement['id_movimiento_almacen_detalle']}, {$p_p_movement['id_proveedor_producto']}, {$p_p_movement['cantidad']}, 
					{$p_p_movement['id_sucursal']}, {$p_p_movement['id_tipo_movimiento']}, {$p_p_movement['id_almacen']}, {$p_p_movement['id_pedido_validacion']}, 
					{$p_p_movement['id_pantalla']}, '{$p_p_movement['folio_unico']}' )";
					$this->link->query( $sql );
					if( $logger_id ){
						$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta movimiento detalle proveedor producto", $sql );
					}
					if( $ok == true ){
						$this->link->commit();//commit();
						$resp["ok_rows"] .= ( $resp["ok_rows"] == '' ? '' : ',' ) . "'{$p_p_movement['folio_unico']}'";
						$resp["tmp_ok"] .= ( $resp["tmp_ok"] == '' ? '' : ',' ) . "'{$p_p_movement['folio_unico']}'";
					}else{
						$this->link->rollBack();//rollback();
						$resp["error_rows"] .= ( $resp["error_rows"] == '' ? '' : ',' ) . "'{$p_p_movement['folio_unico']}'";
						$resp["tmp_no"] .= ( $resp["tmp_no"] == '' ? '' : ',' ) . "'{$p_p_movement['folio_unico']}'";
					}
				}catch(PDOException $error){
					$ok = false;
					if( $logger_id ){
						$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar movimiento detalle proveedor producto", 'sys_sincronizacion_peticion', $sql, $error );
					}
					//die( "Error al insertar cabecera de movimientos de almacen : {$this->link->error} {$sql}" );
				}
			}
			return $resp;
		}
	}
?>