<?php

	class movementsSynchronization
	{
		private $link;
		private $LOGGER;
		function __construct( $connection, $Logger = false ){
			$this->link = $connection;
			$this->LOGGER = $Logger;
		}
//hacer jsons de movimientos de almacen
		public function setNewSynchronizationMovements( $store_id, $system_store, $origin_store_prefix, $limit, $logger_id = false ){
			$log_steep_id = null;
			try{
				$sql = "CALL buscaMovimientosPendientes( {$store_id}, {$system_store}, '{$origin_store_prefix}', {$limit} )"; 
				$stm = $this->link->query( $sql );
				if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Genera registros de Movimientos de Almacen pendientes", $sql );
				}
			}catch(PDOException $error){
				if( $logger_id ){
					$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al generar registros de movimientos de almacen", 'sys_sincronizacion_peticion', $sql, $error );
				}
				die( "Error al generar registros de movimientos de almacen : {$sql} : {$error}" );
			}
			try{
				$sql = "CALL buscaDetallesMovimientosPendientes( {$store_id}, {$system_store}, '{$origin_store_prefix}', {$limit} )";			
				$stm = $this->link->query( $sql );
				if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Genera registros de detalles de Movimientos de Almacen pendientes", $sql );
				}
			}catch(PDOException $error){
				if( $logger_id ){
					$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al generar registros de detalles de movimientos de almacen", 'sys_sincronizacion_peticion', $sql, $error );
				}
				die( "Error al generar registros de detalles de movimientos de almacen : {$sql} : {$error}" );
			}
			return 'ok';
		}
//hacer / obtener jsons de movimientos de almacen
		public function getSynchronizationMovements( $system_store, $limit, $type, $petition_unique_folio, $logger_id = false ){
			$log_steep_id = null;
			$resp = array();
			try{
				$sql = "SELECT 
							id_sincronizacion_movimiento_almacen,
							REPLACE( json, '\r\n', ' ' ) AS data,
							tabla
						FROM sys_sincronizacion_movimientos_almacen
						WHERE tabla = 'ec_movimiento_almacen'
						AND id_status_sincronizacion IN( 1 )
						AND id_sucursal_destino = {$system_store}
						AND json != ''
						LIMIT {$limit}";
			//die( $sql );
				$stm = $this->link->query( $sql );
				if( $logger_id ){
					$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Consulta JSONs de Movimientos de Almacen", $sql );
				}
				$movements_counter = 0;
				//forma arreglo
				while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
					if( $row['data'] != '' && $row['data'] != null && $row['data'] != 'null' ){
						//reemplaza saltos de linea y caracteres especiales
						$row['data'] = str_replace( "\n", " ", $row['data'] );
						$row['data'] = str_replace( "\r\n", " ", $row['data'] );
						$row['data'] = preg_replace("/[\r\n|\n|\r|\r\n]+/", PHP_EOL, $row['data'] );
						$row['data'] = str_replace('Ñ', 'N', $row['data'] );
						$row['data'] = trim( $row['data'] );
						
						array_push( $resp, json_decode($row['data']) );//decodifica el JSON
						$movements_counter ++;
					//actualiza al status 2 los registros que va a enviar
						try{
							$sql = "UPDATE sys_sincronizacion_movimientos_almacen SET id_status_sincronizacion = 2, folio_unico_peticion = '{$petition_unique_folio}' WHERE id_sincronizacion_movimiento_almacen = {$row['id_sincronizacion_movimiento_almacen']}";
							$this->link->query( $sql );
							if( $logger_id ){
								$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualiza registro de sincronizacion a status 2", $sql );
							}
						}catch(PDOException $error){
							if( $logger_id ){
								$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al poner registro de sincronizacion de movimiento de almacen en status 2", 'sys_sincronizacion_peticion', $sql, $error );
							}
							die( "Error al poner registro de sincronizacion de movimiento de almacen en status 2 : {$sql} : {$error}" );
						}
					}
				}
			}catch(PDOException $error){
				if( $logger_id ){
					$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al consultar JSONs de Movimientos de Almacen", 'sys_sincronizacion_peticion', $sql, $error );
				}
				die( "Error al consultar JSONs de Movimientos de Almacen : {$sql} : {$error}" );
			}
			//var_dump( $resp );
			return $resp;
		}
//actualizacion de registros de sincronizacion
		public function updateMovementSynchronization( $rows, $petition_unique_folio, $status = null, $sum = false, $logger_id = false ){
			$log_steep_id = null;
			$sql = "";
			if( $rows != '' && $rows != null ){
				try{
					if( $status != null ){//actualiza status y folio unico de peticion
						$sql = "UPDATE sys_sincronizacion_movimientos_almacen 
						SET id_status_sincronizacion = '{$status}',
							folio_unico_peticion = '{$petition_unique_folio}' 
						WHERE registro_llave IN( {$rows} )";

					}
					$this->link->query( $sql );
					if( $logger_id ){
						$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Actualiza status de registros de sincronizacion", $sql );
					}
				}catch(PDOException $error){
					if( $logger_id ){
						$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al actualizar status de registros de sincronizacion", 'sys_sincronizacion_peticion', $sql, $error );
					}
					die( "Error al actualizar status de registros de sincronizacion : {$sql} : {$error}" );
				}
			}
		}
//inserción de movimientos
		public function insertMovements( $movements, $logger_id = false ){
			$transaction = false;
			$log_steep_id = null;
			$updates = array();
		//verifica si esta habilitada la transaccion en el módulo de movimientos de almacen
			try{
				$sql = "SELECT habilitar_transaccion AS transaction_configuration FROM sys_limites_sincronizacion WHERE tabla = 'ec_movimiento_almacen'";
				$stm = $this->link->query( $sql );
				$transaction_row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
				$transaction = ( $transaction_row['transaction_configuration'] == 1 ? true : false );
			}catch(PDOException $error){
				die( "Error al consultar si esta habilitada la transacción en ec_movimiento_almacen : {$sql} : {$error}" );
			}
			$file = fopen("movements_log.txt", "w");
  			$resp = array();
			$resp["ok_rows"] = '';
			$resp["error_rows"] = '';

			$resp["tmp_ok"] = "";
			$resp["tmp_no"] = "";
			foreach ($movements as $key => $movement) {
				$ok = true;
				$movement_id = null;
				if( $transaction ){
					$this->link->beginTransaction();//autocommit( false );
				}
				$movement_detail = $movement['movimiento_detail'];
				$is_valid = true;
				foreach ($movement_detail as $key2 => $detail) {
					if( $detail['id_pedido_detalle'] != -1 && $detail['id_pedido_detalle'] != '' 
						&& $detail['id_pedido_detalle'] != null ){
						try{
							$sql = "{$detail['id_pedido_detalle']}";
							$stm_aux = $this->link->query( $sql );
							if( $stm_aux->rowCount() <= 0 ){
								$is_valid = false;
								$ok = false;
							}else{
								$is_valid = true;
								$ok = true;
							}
						}catch(PDOException $error){
							$ok = false;
							//die( "Error al consultar si existe el detalle de venta : {$sql} : {$error}" );
						}
					}	
				}
				if( $is_valid == true && $ok == true ){
				//se inserta cabecera de movimiento de almacen por procedure
					try{
						$sql = "CALL spMovimientoAlmacen_inserta( {$movement['id_usuario']}, '{$movement['observaciones']} \nInsertado desde API por sincronización', {$movement['id_sucursal']},
							{$movement['id_almacen']}, {$movement['id_tipo_movimiento']}, -1, -1, '{$movement['id_maquila']}', {$movement['id_transferencia']}, {$movement['id_pantalla']}, 
							'{$movement['folio_unico']}' )";
					//reemplazamiento de comillas en consultas
						$sql = str_replace( "'(", "(", $sql );
						$sql = str_replace( "' (", "(", $sql );
						$sql = str_replace( ")'", ")", $sql );
						$sql = str_replace( ") '", ")", $sql );
						$stm_head = $this->link->query( $sql );//or die( "Error al insertar cabecera de movimiento de almacen : {$sql} {$this->link->error}" );
						if( $logger_id ){
							$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta cabecera de movimientos de almacen", $sql );
						}
					}catch(PDOException $error){
						$ok = false;
						if( $logger_id ){
							$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar cabecera de movimientos de almacen", 'sys_sincronizacion_peticion', $sql, $error );
						}
						//die( "Error al insertar cabecera de movimientos de almacen : {$this->link->error} {$sql}" );
					}
				//recupera el id insertado
					try{
						$sql = "SELECT MAX(id_movimiento_almacen) AS last_id FROM ec_movimiento_almacen";
						$stm_last = $this->link->query($sql); 
						$row_last = $stm_last->fetch(PDO::FETCH_ASSOC);//_assoc
						$movement_id = $row_last['last_id'];
					}catch(PDOException $error){
						$ok = false;
						//die( "Error al recuperar el id insertado : {$sql} : {$error}" );
					}
					$movement_detail = $movement['movimiento_detail'];
					if($ok == true ){
						foreach ($movement_detail as $key2 => $detail) {
							if( $ok == true ){
								try{
									$sql = "CALL spMovimientoAlmacenDetalle_inserta( {$movement_id}, {$detail['id_producto']}, {$detail['cantidad']}, {$detail['cantidad']}, {$detail['id_pedido_detalle']},
												-1, IF( {$detail['id_proveedor_producto']} IS NULL OR '{$detail['id_proveedor_producto']}' = '', NULL, '{$detail['id_proveedor_producto']}' ), 
												{$movement['id_pantalla']}, '{$detail['folio_unico']}' )";
									$stm = $this->link->query( $sql );
									if( $logger_id ){
										$log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Inserta detalle de movimientos de almacen", $sql );
									}
								}catch(PDOException $error){
									$ok = false;
									if( $logger_id ){
										$this->LOGGER->insertErrorSteepRow( $log_steep_id, "Error al insertar detalle de movimientos de almacen", 'sys_sincronizacion_peticion', $sql, $error );
									}//die( "Error al insertar detalle de movimientos de almacen : {$this->link->error} {$sql}" );
								}
							}
						}
					}
					if( $ok == true ){
						if( $transaction ){
							$this->link->commit();//commit();
						}
						$resp["ok_rows"] .= ( $resp["ok_rows"] == '' ? '' : ',' ) . "'{$movement['folio_unico']}'";
						$resp["tmp_ok"] .= ( $resp["tmp_ok"] == '' ? '' : ',' ) . "'{$movement['folio_unico']}'";
					}else{
						if( $transaction ){
							$this->link->rollBack();//rollback();
						}
						$resp["error_rows"] .= ( $resp["error_rows"] == '' ? '' : ',' ) . "'{$movement['folio_unico']}'";
						$resp["tmp_no"] .= ( $resp["tmp_no"] == '' ? '' : ',' ) . "'{$movement['folio_unico']}'";
					}
				}
			}
			//fclose($file);
			return $resp;
		}
	}
?>