<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: actualiza_comprobacion_movimientos_almacen_proveedor_producto
* Path: /actualiza_comprobacion_movimientos_almacen_proveedor_producto
* Método: POST
* Descripción: Comprobacion de movimientos almacen a nivel proveedor producto
*/
$app->post('/actualiza_comprobacion_movimientos_proveedor_producto', function (Request $request, Response $response){  
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $resp = array();
    if( ! include( 'utils/verification/warehouseProductProviderMovementsRowsVerification.php' ) ){
        die( "Error al incluir clase warehouseProductProviderMovementsRowsVerification.php" );
    }
    $warehouseProductProviderMovementsRowsVerification = new warehouseProductProviderMovementsRowsVerification( $link );//instancia clase de comprobacion
    $body = $request->getBody();
    $params = json_decode($body, true);
    $petition_log = ( isset($params['log_response']) ? json_decode( json_encode( $params['log_response'] ) ) : '' );//$local_log = $request->getParam( "local_response_log" );
    $rows_response = ( isset($params['rows_response']) ? json_decode( json_encode( $params['rows_response'] ) ) : array() );//$local_log = $request->getParam( "local_response_log" );
    //$verification = $request->getParam( 'verification' );
    //$origin_store = $request->getParam( 'origin_store' );
    if( $petition_log != null && $petition_log != '' ){
        $update_log = $warehouseProductProviderMovementsRowsVerification->updateLogAndJsonsRows( $petition_log, $rows_response );
        if( $update_log != 'ok' ){
          die( "Hubo un error : {$update_log}" );
        }
    }
    $resp['status'] = 200;
    $resp['message'] = "Comprobacion de movimientos almacen (proveedor producto) actualizada exitosamente en linea.";
    return json_encode( $resp );
});

?>
