<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: actualiza_comprobacion_movimientos_almacen
* Path: /actualiza_comprobacion_movimientos_almacen
* Método: POST
* Descripción: Insercion de movimeintos de almacen a nivel producto
*/
$app->post('/actualiza_comprobacion_movimientos_almacen', function (Request $request, Response $response){  
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $resp = array();
    //$resp['rows_response'] = array();
    //$resp['rows_download'] = array();

    if( ! include( 'utils/verification/warehouseMovementsRowsVerification.php' ) ){
        die( "Error al incluir clase warehouseMovementsRowsVerification.php" );
    }
    $warehouseMovementsRowsVerification = new warehouseMovementsRowsVerification( $link );//instancia clase de comprobacion
    $body = $request->getBody();
    $params = json_decode($body, true);
    $petition_log = ( isset($params['log_response']) ? json_decode( json_encode( $params['log_response'] ) ) : '' );//$local_log = $request->getParam( "local_response_log" );
    $rows_response = ( isset($params['rows_response']) ? json_decode( json_encode( $params['rows_response'] ) ) : array() );//$local_log = $request->getParam( "local_response_log" );

    if( $petition_log != null && $petition_log != '' ){
        $update_log = $warehouseMovementsRowsVerification->updateLogAndJsonsRows( $petition_log, $rows_response );
        if( $update_log != 'ok' ){
          die( "Hubo un error : {$update_log}" );
        }
    }
    $resp['status'] = 200;
    $resp['message'] = "Comprobacion de movimientos almacen (producto) actualizada exitosamente en linea.";
    return json_encode( $resp );
});

?>
