<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: procesa_registros_pendientes
* Path: /procesa_registros_pendientes
* Método: POST
* Descripción: Procesa registros de petición que no obtuvieron respuesta
*/
$app->post('/procesa_registros_pendientes', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $data = array();
    $data['pending'] = array();
    $id_sucursal = null;
//recibe variables de peticion
    $body = $request->getBody();
    $params = json_decode($body, true);
    $pendientes = ( isset($params['pending']) ? $params['pending'] : array() );//$request->getParam( "registros" );
    foreach( $pendientes as $key=> $value){
    //consulta si existe la peticion en el servidor en linea
        echo $value['folio_unico'];
    }
//consulta sucursal de acceso
    try{
        $sql = "SELECT id_sucursal FROM sys_sucursales WHERE acceso = 1";
        $stm = $link->query( $sql );
        $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
        $id_sucursal = $row['id_sucursal'];
    }catch(PDOException $error){
        $resp = array( "status"=>400, "message"=>"Error al consultar sucursal de acceso : {$sql}", "error_detail"=>$error->getMessage() );
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
//consulta los registros de sincronizacion que no tienen respuesta
    try{
        $sql = "SELECT
                    folio_unico
                FROM sys_sincronizacion_peticion
                WHERE contenido_respuesta IS NULL
                AND id_sucursal_origen = {$id_sucursal}";
        $stm = $link->query( $sql );
        while( $row = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc
            array_push( $data['pending'], $row );
        }
    }catch(PDOException $error){
        $resp = array( "status"=>400, "message"=>"Error al consultar si hay peticiones pendientes : {$sql}", "error_detail"=>$error->getMessage() );
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }

    $payload = json_encode($data, JSON_PRETTY_PRINT);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
//envia peticion al servidor en linea para comprobar 
    //return json_encode($data);
});

?>