<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
    * Endpoint: verifica_registros_por_modulo_linea
    * Path: /verifica_registros_por_modulo_linea
    * Método: POST
    * Descripción: verifica registros por modulo linea
*/
$app->post('/verifica_registros_por_modulo_linea', function (Request $request, Response $response){
  $db = new db("../../");//Instancia BD General
  $link = $db->conectDB();
  
  $body = $request->getBody();
  $params = json_decode($body, true);
  $origin_store_id = ( isset($params['store_id']) ? $params['store_id'] : '' );
  $resp = array();
//consulta registros pendientes por modulo
  $resp = array();
    try{
        $sql = "(SELECT 'sys_sincronizacion_registros' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_registros WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_registros_transferencias' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_registros_transferencias WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_ventas' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_ventas WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_registros_ventas' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_registros_ventas WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_devoluciones' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_devoluciones WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_movimientos_almacen' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_movimientos_almacen WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_registros_movimientos_almacen' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_registros_movimientos_almacen WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_validaciones_ventas' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_validaciones_ventas WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_movimientos_proveedor_producto' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_movimientos_proveedor_producto WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})
                UNION
                (SELECT 'sys_sincronizacion_registros_movimientos_proveedor_producto' AS module_name, COUNT(*) AS pending_rows_server FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = {$origin_store_id})";
        $stm = $link->query( $sql );
        while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {
          $resp[$row['module_name']] = $row;
        }
    }catch(PDOException $error){
        die( "Error al consultar los limites de sincronizacion : {$sql} : {$error}" );
    }
//procesa resultado
  $payload = json_encode($resp, JSON_PRETTY_PRINT);
  $response->getBody()->write($payload);
  return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});
?>