<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: obtener_registros_restantes_linea
* Path: /obtener_registros_restantes_linea
* Método: POST
* Descripción: Consulta parametros de sincronizacion y registros restantes en servidor en linea
*/
$app->post('/obtener_registros_restantes_linea', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $modules = array();
    $body = $request->getBody();
    $params = json_decode($body, true);
    $store_id = ( isset($params['store_id']) ? $params['store_id'] : '' );
//consulta los registros pendientes
    try{
        /*$sql = "( SELECT 'sys_sincronizacion_registros' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_ventas WHERE id_sucursal_destino = {$store_id} AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_ventas' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_ventas WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_devoluciones' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_devoluciones WHERE id_sucursal_destino = {$store_id} AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_movimientos_almacen WHERE id_sucursal_destino = {$store_id} AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_movimientos_almacen WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_validaciones_ventas' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_validaciones_ventas WHERE id_sucursal_destino = {$store_id} AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_movimientos_proveedor_producto WHERE id_sucursal_destino = {$store_id} AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_transferencias' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_transferencias WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)";*/
        $sql = "( SELECT 'sys_sincronizacion_registros' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_pedidos WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_registros_ventas' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_ventas WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_devoluciones' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_devolucion WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_movimiento_almacen WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_movimientos_almacen WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_validaciones_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_pedidos_validacion_usuarios WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_movimiento_detalle_proveedor_producto WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_transferencias' AS module_name, COUNT( * ) AS pending_rows_server FROM sys_sincronizacion_registros_transferencias WHERE id_sucursal_destino = {$store_id} AND status_sincronizacion = 1)";     
        $stm = $link->query($sql);
        while($row = $stm->fetch(PDO::FETCH_ASSOC)){
            $modules[$row['module_name']] = $row;
        }
        $payload = json_encode($modules, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);

    }catch(PDOException $error){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "Error al consultar los registros pendientes en linea."; 
        $resp['query'] = "{$sql}";
        $resp['error_detail'] = "{$error->getMessage()}";
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    }
    $payload = json_encode($modules, JSON_PRETTY_PRINT);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>