<?php
    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Slim\Factory\AppFactory;

    require __DIR__ . '../../../vendor/autoload.php';
/*
    * Instancia utilities
*/
    if( ! require '../../rest/src/config/db.php' ){// DB Connect CL
        die("Error al incluir archivo de conexion PDO.");
    }
    if( ! include( 'utils/SynchronizationManagmentLog.php' ) ){
        die( "No se incluyó : SynchronizationManagmentLog.php" );
    }
    if( !include( 'utils/Logger.php' ) ){
        die( "No se pudo incluir la clase Logger.php" );
    }

    require '../utils/manageResponse.php';
    require '../utils/validaToken.php';

    $archivo_path = "../../conexion_inicial.txt";
    $carpeta_path = "";
    if(file_exists($archivo_path)){
      $file = fopen($archivo_path,"r");
      $line=fgets($file);
      fclose($file);
      $config=explode("<>",$line);
      $tmp=explode("~",$config[2]);
      $ruta_or=$tmp[0];
      $ruta_des=$tmp[1];
      $tmp_=explode("~",$config[0]);
      $carpeta_path = base64_decode( $tmp_[1] );
    }else{
      die("No hay archivo de configuración.");
    }
    $app = AppFactory::create();
    $app->setBasePath("/{$carpeta_path}/rest_v2/sincronizacion");

    $app->post('/example', function (Request $request, Response $response, $args) {
        $response->getBody()->write("Hello world!");
        return $response;
    });
  
//Servicios de Cliente
	require 'client/verificacion_registros_pendientes.php';//comprobacion de los registros pendientes
  require 'client/registros_sincronizacion.php';
	require 'client/ventas.php';
	require 'client/devoluciones.php';
	require 'client/movimientos_almacen.php';
	require 'client/validaciones_ventas.php';
	require 'client/movimientos_proveedor_producto.php';
  require 'client/registros_sincronizacion_ventas.php';
	require 'client/registros_sincronizacion_mov_almacen.php';
	require 'client/registros_sincronizacion_mov_p_p.php';
	require 'client/registros_sincronizacion_transferencias.php';
//
  require 'client/verificacion_registros_por_modulo_sincronizacion.php';
  require 'client/obtener_registros_restantes_local.php';
  require 'client/obtener_configuracion_sincronizacion.php';

//Servicios de Servidor
  require 'server/verificacion_registros.php';//comprobacion de los registros pendientes
  require 'server/inserta_registros_sincronizacion.php';
  require 'server/actualiza_inventarios_productos.php';
  require 'server/inserta_ventas.php';
  require 'server/inserta_devoluciones.php';
  require 'server/inserta_movimientos_almacen.php';
  require 'server/comprobacion_movimientos_almacen.php';
  require 'server/inserta_validaciones_ventas.php';
  require 'server/inserta_movimientos_proveedor_producto.php';
  require 'server/actualiza_inventarios_proveedor_producto.php';
  require 'server/actualiza_peticion.php';
/*implementacion Osacr 2023 para insertar modificaciones en ventas y movimientos de almacen (servidor)*/
	require 'server/inserta_registros_sincronizacion_ventas.php';
	require 'server/inserta_registros_sincronizacion_mov_almacen.php';
	require 'server/inserta_registros_sincronizacion_mov_p_p.php';
	require 'server/inserta_registros_sincronizacion_transferencias.php';
//
	require 'server/obtener_movimientos_por_sumar_en_local.php';
	require 'server/ejecuta_consulta_en_servidor.php';
//comprobaciones 2024
	require 'server/wharehouseMovementVerification.php';
	require 'server/warehouseMovementVerificationServer.php';
	require 'server/wharehouseProductProviderMovementVerification.php';
	require 'server/warehouseProductProviderMovementVerificationServer.php';
	require 'server/salesVerificationServer.php';
	require 'server/ReturnsVerificationServer.php';
	require 'server/RowsVerificationServer.php';
//
  require 'server/verifica_registros_por_modulo_server.php';
  require 'server/obtener_registros_restantes_linea.php';
    
$app->run();
