<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
  * Endpoint: verifica_registros_por_modulo_local
  * Path: /verifica_registros_por_modulo_local
  * Método: POST
  * Descripción: verifica registros por modulo local
*/
$app->get('/verifica_registros_por_modulo_local', function (Request $request, Response $response){
  $db = new db("../../");//Instancia BD General
  $link = $db->conectDB();
  $modules = array();
  $store_id = null;
  $api_path = null;
//consulta registros pendientes por modulo
    try{
        $sql = "(SELECT 'sys_sincronizacion_registros' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_registros WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_registros_transferencias' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_registros_transferencias WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_ventas' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_ventas WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_registros_ventas' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_registros_ventas WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_devoluciones' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_devoluciones WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_movimientos_almacen' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_movimientos_almacen WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_registros_movimientos_almacen' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_registros_movimientos_almacen WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_validaciones_ventas' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_validaciones_ventas WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_movimientos_proveedor_producto' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_movimientos_proveedor_producto WHERE id_status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)
                UNION
                (SELECT 'sys_sincronizacion_registros_movimientos_proveedor_producto' AS module_name, COUNT(*) AS pending_rows_local FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE status_sincronizacion IN(1,2) AND id_sucursal_destino = -1)";
        $stm = $link->query( $sql );
        while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {
          $modules[$row['module_name']] = $row;
        }
    }catch(PDOException $error){
        die( "Error al consultar los limites de sincronizacion : {$sql} : {$error}" );
    }
//consulta en linea
    
//consulta la sucursal del sistema
  try{
    $sql = "SELECT id_sucursal AS store_id FROM sys_sucursales WHERE acceso = 1";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
    $store_id = $row['store_id'];
  }catch(PDOException $error){
    die( "Error al consultar la sucursal de acceso : {$sql} : {$error}" );
  }
//consulta la url de la API
  try{
    $sql = "SELECT 
              `value` AS api_path,
              (SELECT id_sucursal FROM sys_sucursales WHERE acceso = 1) AS store_id
            FROM `api_config` 
            WHERE `name` = 'path'";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
    $api_path = $row['api_path'];
    $store_id = $row['store_id'];
  }catch(PDOException $error){
    die( "Error al consultar el path del API : {$sql} : {$error}" );
  }
//consulta registros linea
  $data = array("store_id"=>$store_id);
  $post_data = json_encode($data);
  $crl = curl_init( "{$api_path}/rest_v2/sincronizacion/verifica_registros_por_modulo_linea" );
  curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($crl, CURLINFO_HEADER_OUT, true);
  curl_setopt($crl, CURLOPT_POST, true);
  curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
  //curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
  curl_setopt($crl, CURLOPT_TIMEOUT, 60000);
  curl_setopt($crl, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'token: ')
  );
  $curl_resp = curl_exec($crl);//envia peticion
  curl_close($crl);
  $json_response = json_decode($curl_resp, true);
  foreach ($modules as $key => $module) {
    $modules[$key]['pending_rows_server'] = $json_response[$key]['pending_rows_server'];
  }
  //var_dump($curl_resp);
//procesa resultado
  $payload = json_encode($modules, JSON_PRETTY_PRINT);
  $response->getBody()->write($payload);
  return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});
?>