<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: obtener_registros_restantes_local
* Path: /obtener_registros_restantes_local
* Método: POST
* Descripción: Consulta parametros de sincronizacion y registros restantes
*/
$app->get('/obtener_registros_restantes_local', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $body = $request->getBody();
    $params = json_decode($body, true);
    $origin_store_id = ( isset($params['id_sucursal']) ? $params['id_sucursal'] : '' );//
    /*if($origin_store_id == '' || $origin_store_id == null){
        $resp = array();
        $resp['status'] = "400";
        $resp['message'] = "El atributo 'id_sucursal' es requerido.";
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    }*/

    $modules = array();
    $store_id = null;
    $api_path = null;

//consulta la url de la API
    try{
        $sql = "SELECT 
                `value` AS api_path,
                (SELECT id_sucursal AS store_id FROM sys_sucursales WHERE acceso = 1) AS store_id
            FROM `api_config` 
            WHERE `name` = 'path'";
        $stm = $link->query( $sql );
        $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
        $api_path = $row['api_path'];
        $store_id = $row['store_id'];
    }catch(PDOException $error){
        die( "Error al consultar el path del API : {$sql} : {$error}" );
    }
    
//consulta los registros pendientes
    try{
        /*$sql = "( SELECT 'sys_sincronizacion_registros' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_ventas WHERE id_sucursal_destino = -1 AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_ventas WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_devoluciones' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_devoluciones WHERE id_sucursal_destino = -1 AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_movimientos_almacen WHERE id_sucursal_destino = -1 AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_movimientos_almacen WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_validaciones_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_validaciones_ventas WHERE id_sucursal_destino = -1 AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_movimientos_proveedor_producto WHERE id_sucursal_destino = -1 AND id_status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_transferencias' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_transferencias WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)";*/
        $sql = "( SELECT 'sys_sincronizacion_registros' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_pedidos WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_registros_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_ventas WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_devoluciones' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_devolucion WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_movimiento_almacen WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_almacen' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_movimientos_almacen WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_validaciones_ventas' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_pedidos_validacion_usuarios WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_local FROM ec_movimiento_detalle_proveedor_producto WHERE id_sucursal = {$store_id} AND (folio_unico IS NULL OR folio_unico = ''))
            UNION
            ( SELECT 'sys_sincronizacion_registros_movimientos_proveedor_producto' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)
            UNION
            ( SELECT 'sys_sincronizacion_registros_transferencias' AS module_name, COUNT( * ) AS pending_rows_local FROM sys_sincronizacion_registros_transferencias WHERE id_sucursal_destino = -1 AND status_sincronizacion = 1)";
        
        $stm = $link->query($sql);
        while($row = $stm->fetch(PDO::FETCH_ASSOC)){
            $modules[$row['module_name']] = $row;
        }
    }catch(PDOException $error){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "Error al consultar los registros pendientes en local."; 
        $resp['query'] = "{$sql}";
        $resp['error_detail'] = "{$error->getMessage()}";
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    }

    $data = array("store_id"=>$store_id);
    $post_data = json_encode($data);
//consulta registros linea
    $crl = curl_init( "{$api_path}/rest_v2/sincronizacion/obtener_registros_restantes_linea" );
    curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($crl, CURLINFO_HEADER_OUT, true);
    curl_setopt($crl, CURLOPT_POST, true);
    curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
    //curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
    curl_setopt($crl, CURLOPT_TIMEOUT, 60000);
    curl_setopt($crl, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'token: ')
    );
    $curl_resp = curl_exec($crl);//envia peticion
    //die("resp : " . $curl_resp);
    curl_close($crl);
    $json_response = json_decode($curl_resp, true);
    foreach ($modules as $key => $module) {
      $modules[$key]['pending_rows_server'] = $json_response[$key]['pending_rows_server'];
    }
    //$modules['limits'] = array();
/*consulta limite de registros por modulo
    try{
        $sql = "( SELECT 'sys_sincronizacion_registros' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'sys_sincronizacion_registros' )
            UNION
            ( SELECT 'ec_pedidos' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'ec_pedidos' )
            UNION
            ( SELECT 'ec_devolucion' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'ec_devolucion' )
            UNION
            ( SELECT 'ec_movimiento_almacen' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'ec_movimiento_almacen' )
            UNION
            ( SELECT 'ec_pedidos_validacion_usuarios' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'ec_pedidos_validacion_usuarios' )
            UNION
            ( SELECT 'ec_movimiento_detalle_proveedor_producto' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'ec_movimiento_detalle_proveedor_producto' )
            UNION
            ( SELECT 'ec_transferencias' AS module_name, limite FROM sys_limites_sincronizacion WHERE tabla = 'ec_transferencias' )";
        $stm = $link->query( $sql );
        while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
            $modules['limits'][$row['module_name']] = $row;
        }
    }catch(PDOException $error){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "Error al consultar los limites de sincronizacion."; 
        $resp['query'] = "{$sql}";
        $resp['error_detail'] = "{$error->getMessage()}";
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
        
    }*/
    $payload = json_encode($modules, JSON_PRETTY_PRINT);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>