<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: obtener_configuracion_sincronizacion
* Path: /obtener_configuracion_sincronizacion
* Método: POST
* Descripción: Consulta parametros de sincronizacion y registros restantes
*/
$app->get('/obtener_configuracion_sincronizacion', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $config = array();
//consulta el path local del sistema
    $local_path = "";
    $archivo_path = "../../conexion_inicial.txt";
    if(file_exists($archivo_path)){
    $file = fopen($archivo_path,"r");
    $line=fgets($file);
    fclose($file);
        $config_=explode("<>",$line);
        $tmp=explode("~",$config_[0]);
        $local_path = base64_decode( $tmp[1] );
        $config['local_path'] = $local_path;
    }else{
        die("No hay archivo de configuración.");
    }
//consulta la url de la API / datos de la sucursal
    try{
        $sql = "SELECT 
                id_sucursal AS store_id,
                nombre AS store_name,
                (SELECT `value` FROM `api_config` WHERE `name` = 'path') AS api_path
            FROM sys_sucursales 
            WHERE acceso = 1
            LIMIT 1";
        $stm = $link->query( $sql );
        $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
        $config['api_path'] = $row['api_path'];
        $config['store_id'] = $row['store_id'];
        $config['store_name'] = $row['store_name'];
    }catch(PDOException $error){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "Error al consultar datos de la sucursal."; 
        $resp['query'] = "{$sql}";
        $resp['error_detail'] = "{$error->getMessage()}";
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    }
//consulta la configuracion de la sincronizacion
    try{
        $sql = "SELECT
                id_configuracion_sincronizacion_sucursal, 
                id_sucursal, 
                puerto_sincronizacion, 
                permitir_sincronizacion_en_sucursal, 
                minutos_retardo_inicial_sincronizacion, 
                segundos_intervalo_sincronizacion, 
                habilitar_depuracion_sincronizacion, 
                minutos_antiguedad_limpieza_sincronizacion, 
                minutos_antiguedad_limpieza_log_sincronizacion, 
                hora_referencia_depuracion, 
                minutos_intervalo_depuracion
            FROM sys_configuracion_sincronizacion_sucursal
            WHERE id_sucursal = {$config['store_id']}";
        $stm = $link->query($sql);
        $row = $stm->fetch(PDO::FETCH_ASSOC);
        foreach ($row as $key => $value) {
            $config[$key] = $value;
        }
    }catch(PDOException $error){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "Error al consultar datos de sincronizacion de la sucursal."; 
        $resp['query'] = "{$sql}";
        $resp['error_detail'] = "{$error->getMessage()}";
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    }

    $payload = json_encode($config, JSON_PRETTY_PRINT);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>