<?php
/*actualizado desde rama api_busqueda_archivos 2024-01-18*/
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: enviar archivos
* Path: /get_print_files
* Método: POST
* Descripción: Consulta archivos pendientes de descargar
*/
$app->post('/get_print_files', function (Request $request, Response $response){
	//include( '../../conexionMysqli.php' );
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
	$files = array();
//recibe id de la sucursal
	//$store_id = $request->getParam( 'destinity_store_id' );
	$body = $request->getBody();
	$params = json_decode( $body, true);
	$store_id = ( isset($params['destinity_store_id']) ? $params['destinity_store_id'] : '' );
	if($store_id == '' || $store_id == null){
		$data = $request->getParsedBody();
		// Acceder a la variable 'id_sucursal' desde el array de parámetros
		$store_id = ($data['destinity_store_id'] ? $data['destinity_store_id'] : null);
		if( trim($store_id) == null || trim($store_id) == '' ){//validacion de la sucursal
			$payload = json_encode( array( "status"=>400, "message"=> "El atributo destinity_store_id es obligatorio.") );
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
		}

		/*$payload = json_encode( array( "status"=>400, "message"=> "El atributo destinity_store_id es obligatorio.") );
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);*/
	}
//obtiene los archivos pendientes de descargar
	try{
		$sql = "SELECT
					id_archivo AS file_id,
					tipo_archivo AS file_type,
					nombre_archivo AS file_name,
					ruta_origen AS file_origin,
					ruta_destino AS file_destinity,
					id_sucursal AS file_store 
				FROM sys_archivos_descarga
				WHERE descargado = 0
				AND id_sucursal = {$store_id}
				ORDER BY id_archivo DESC
				LIMIT 10";
		$stm = $link->query( $sql );
		if( $stm->rowCount() <= 0 ){//num_rows
			$payload = json_encode( array( "status"=>200, "message"=> "No hay archivos por descargar", "files"=>array()) );
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
		}
		while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
			$files[] = $row;
		}
	}catch(PDOException $error){
		$payload = json_encode(array("status"=>400,"message"=>"Error al consultar los archivos por descargar.",
		"query"=>$sql, "error_detail"=>$error->getMessage()));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		//die( "Error al consultar los archivos por descargar : {$sql} {$link->error}" );
	}
//codifica el arreglo de jsons
	$payload = json_encode( array( "files"=>$files ) );
	$response->getBody()->write($payload);
	return $response->withHeader('Content-Type', 'application/json')->withStatus(200);//return $post_data;
});

?>
