<?php
/*actualizado desde rama api_busqueda_archivos 2024-01-18*/
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: obtener_archivo_por_id
* Path: /obtener_archivo_por_id
* Método: POST
* Descripción: Consulta archivo para de descargar
*/
$app->post('/obtener_archivo_por_id', function (Request $request, Response $response){
	//include( '../../conexionMysqli.php' );
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
	$files = array();
//recibe id del archivo
	$body = $request->getBody();
	$params = json_decode( $body, true);
	$file_id = ( isset($params['destinity_store_id']) ? $params['file_id'] : '' );
	if($file_id == '' || $file_id == null){
		$data = $request->getParsedBody();
		// Acceder a la variable 'id_sucursal' desde el array de parámetros
		$file_id = ($data['file_id'] ? $data['file_id'] : null);
		if( trim($file_id) == null || trim($file_id) == '' ){//validacion de la sucursal
			$payload = json_encode( array( "status"=>400, "message"=> "El atributo file_id es obligatorio.") );
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
		}
	}
//obtiene los archivos pendientes de descargar
	try{
		$sql = "SELECT
					id_archivo AS file_id,
					tipo_archivo AS file_type,
					nombre_archivo AS file_name,
					ruta_origen AS file_origin,
					ruta_destino AS file_destinity,
					id_sucursal AS file_store 
				FROM sys_archivos_descarga
				WHERE descargado = 0
                AND id_archivo = {$file_id}";
		$stm = $link->query( $sql );
		if( $stm->rowCount() <= 0 ){//num_rows
			$payload = json_encode( array( "status"=>200, "message"=> "No se encontro registro del archivo.", "files"=>array()) );
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
		}
		while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
			$files[] = $row;
		}
	}catch(PDOException $error){
		$payload = json_encode(array("status"=>400,"message"=>"Error al consultar el archivos por descargar.",
		"query"=>$sql, "error_detail"=>$error->getMessage()));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
//codifica el arreglo de jsons
	$payload = json_encode( array( "files"=>$files ) );
	$response->getBody()->write($payload);
	return $response->withHeader('Content-Type', 'application/json')->withStatus(200);//return $post_data;
});

?>
