<?php
/*actualizado desde rama api_busqueda_archivos 2024-01-18*/
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: enviar actualizar_status_archivos
* Path: /actualizar_status_archivos
* Método: POST
* Descripción: Actualiza status de archivos
*/
$app->post('/obtener_configuracion_impresion', function (Request $request, Response $response){
	$resp = array();
	$resp['modulos'] = array();
	$resp['impresoras_especificas'] = array();
	$resp['message'] = "ok";
	$resp['status_code'] = 200;
	//include( '../../conexionMysqli.php' );
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();

	//$sucursal = $request->getParam( 'id_sucursal' );
	$body = $request->getBody();
	$params = json_decode( $body, true);
	$sucursal = ( isset($params['id_sucursal']) ? $params['id_sucursal'] : '' );
	
	if( trim($sucursal) == null || trim($sucursal) == '' ){//validacion de la sucursal
		$data = $request->getParsedBody();
		// Acceder a la variable 'id_sucursal' desde el array de parámetros
		$sucursal = $data['id_sucursal'] ?? null;
		if( trim($sucursal) == null || trim($sucursal) == '' ){//validacion de la sucursal
			$payload = json_encode( array( "status"=>400, "message"=> "El atributo id_sucursal es obligatorio.") );
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
		}
	}
//consulta los modulos y sus rutas
	try{
		$sql = "SELECT
					mi.nombre_modulo AS nombre_modulo,
					REPLACE( s.nombre, ' ', '_' ) AS usuario,
					CONCAT( c.path, '/', c.nombre_carpeta ) AS ruta,
					i.nombre_impresora AS impresora,
					ci.comando_impresion,
					mis.extension_archivo,
					'0' AS habilitado,
					mis.endpoint_api_destino,
					CONCAT('',mis.id_modulo_impresion_sucursal) AS id,
					'sucursal' AS tipo,
					CONCAT('',mis.convertir_pdf_a_imagen) AS convertir_pdf_a_imagen
				FROM sys_modulos_impresion_sucursales mis
				LEFT JOIN sys_modulos_impresion mi
				ON mis.id_modulo_impresion = mi.id_modulo_impresion
				LEFT JOIN sys_sucursales s
				ON s.id_sucursal = mis.id_sucursal
				LEFT JOIN sys_carpetas c
				ON c.id_carpeta = mis.id_carpeta
				LEFT JOIN sys_impresoras_sucursales i
				ON i.id_impresora_sucursal = mis.id_impresora_sucursal
				LEFT JOIN sys_comandos_impresion ci
				ON ci.id_comando_impresion = mis.id_comando_impresion
				WHERE mis.id_sucursal = {$sucursal}";
		$stm = $link->query( $sql );
		while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
			array_push( $resp['modulos'], $row );
		}
	}catch(PDOException $error){
		$payload = json_encode(array("status"=>400,"message"=>"Error al consultar modulos y sus carpetas.",
		"query"=>$sql, "error_detail"=>$error->getMessage()));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(200);//die( " : {$sql} : {$error}." );
	}
//consulta modulos por usuarios
	try{
		$sql = "SELECT
					mi.nombre_modulo AS nombre_modulo,
					CONCAT( u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno ) AS usuario,
					CONCAT( c.path, '/', c.nombre_carpeta ) AS ruta,
					i.nombre_impresora AS impresora,
					ci.comando_impresion,
					miu.extension_archivo,
					'0' AS habilitado,
					miu.endpoint_api_destino,
					CONCAT('',miu.id_modulo_impresion_usuario) AS id,
					'usuario' AS tipo,
					CONCAT( '', miu.convertir_pdf_a_imagen) AS convertir_pdf_a_imagen
				FROM sys_modulos_impresion_usuarios miu
				LEFT JOIN sys_modulos_impresion mi
				ON miu.id_modulo_impresion = mi.id_modulo_impresion
				LEFT JOIN sys_users u
				ON u.id_usuario = miu.id_usuario
				LEFT JOIN sys_carpetas c
				ON c.id_carpeta = miu.id_carpeta
				LEFT JOIN sys_impresoras_sucursales i
				ON i.id_impresora_sucursal = miu.id_impresora_sucursal
				LEFT JOIN sys_comandos_impresion ci
				ON ci.id_comando_impresion = miu.id_comando_impresion
				WHERE u.id_sucursal = {$sucursal}";
		$stm = $link->query( $sql );
		while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
			array_push( $resp['modulos'], $row );
		}
	}catch(PDOException $error){
		$payload = json_encode(array("status"=>400,"message"=>"Error al consultar modulos de impresion por usuarios y sus carpetas.",
		"query"=>$sql, "error_detail"=>$error->getMessage()));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(200);//die( " : {$sql} : {$error}" );
	}
	$payload = json_encode( $resp );
	$response->getBody()->write($payload);
	return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});
?>