<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: send_file
* Path: /send_file
* Método: POST
* Descripción: Envia los archivos al servidor destino
*/
$app->post('/send_file', function (Request $request, Response $response){
	//include( '../../conexionMysqli.php' );
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
	$files = array();
	//die( 'one' );
	//$file_id = $request->getParam( 'file_id' );
//recibe id de la sucursal//$store_id = $request->getParam( 'destinity_store_id' );
	$body = $request->getBody();
	$params = json_decode( $body, true);
	$store_id = ( isset($params['destinity_store_id']) ? $params['destinity_store_id'] : null );
	if($store_id == null){
		$payload = json_encode(array("status"=>400,"message"=>"El atributo 'destinity_store_id' no puede ser vacio."));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
//obtiene los archivos pendientes de descargar
	try{
		$sql = "SELECT
					id_archivo AS file_id,
					tipo_archivo AS file_type,
					nombre_archivo AS file_name,
					ruta_origen AS file_origin,
					ruta_destino AS file_destinity,
					id_sucursal AS file_store 
				FROM sys_archivos_descarga
				WHERE descargado = 0
				AND id_sucursal = {$store_id}
				ORDER BY id_archivo DESC
				LIMIT 10";
		$stm = $link->query( $sql );
		while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//_assoc
			$files[] = $row;
		}
	}catch(PDOException $error){
		die( "Error al consultar los archivos por descargar : {$sql} : {$error}" );
	}
//codifica el arreglo de jsons
	$post_data = json_encode( array( "files"=>$files ) );
//obtiene los datos principales de la sucursal y el / los archivos
	$row = array();
	try{
		$sql = "SELECT 
					endpoint_impresion_remota AS store_print_dns
				FROM ec_configuracion_sucursal
				WHERE id_sucursal = {$store_id}";
		$stm = $link->query( $sql );
	//consume api en el servidor destino
		$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
	}catch(PDOException $error){
		die( "Error al consultar el dominio de la sucursal destino : {$sql} : {$error}" );
	}
	if($row['store_print_dns'] == '' || $row['store_print_dns'] == null){
		$payload = json_encode(array("status"=>400,"message"=>"La sucursal no tiene un endpoint desino configurado"));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
	$url = "{$row['store_print_dns']}/rest_v2/print/recibir_archivo";//url
	//die("URL :  {$url} {$post_data}");
	$resp = "";
	$token = "";
	$crl = curl_init( $url );
	curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($crl, CURLINFO_HEADER_OUT, true);
	curl_setopt($crl, CURLOPT_POST, true);
	curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
	//curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
	curl_setopt($crl, CURLOPT_TIMEOUT, 60000);
	curl_setopt($crl, CURLOPT_HTTPHEADER, array(
	  'Content-Type: application/json',
	  'token: ' . $token)
	);
	$resp = curl_exec($crl);//envia peticion
	curl_close($crl);
//decodifica el json de respuesta
	$result = json_decode(json_encode($resp));//, true
	//$result = json_decode( $result );
	
	if( isset($result->ok_rows) && $result->ok_rows != '' ){
	//ejecuta actualizacion a descargados
		try{
			$sql = "UPDATE sys_archivos_descarga SET descargado = '1' WHERE id_archivo IN( {$result->ok_rows} )";
			$link->query( $sql );
		}catch(PDOException $error){
			$payload = json_encode(array("status"=>400,"message"=>"Error al actualizar los registros de archivos descargados.",
				"query"=>$sql, "error_detail"=>$error->getMessage()));
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
			//die( " : {$sql} : {$error}" );
		}
		//die( $sql );
	}else{
		$payload = json_encode(array("status"=>400,"message"=>"Algo salio mal al enviar peticion al servidor destino",
			"url"=>"{$url}"));
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
	}
	return 'ok';
	//return $result;
	//return $resp;
});

?>
