<?php
	use \Psr\Http\Message\ResponseInterface as Response;
	use \Psr\Http\Message\ServerRequestInterface as Request;
	/*
	* Endpoint: subir_peticion_netPay
	* Path: /subir_peticion_netPay
	* Método: POST
	* Descripción: Subir peticion de NetPay
	*/
	$app->post('/insertar_peticion_transaccion', function (Request $request, Response $response){
		$db = new db('../../');
		$link = $db->conectDB();
		$rs = new manageResponse();
		$vt = new tokenValidation();
		//$Encrypt = new Encrypt();
		$token =  (empty($request->getHeader('Token'))) ? '' : implode(" ",$request->getHeader('Token'));
		//$token = $Encrypt->decryptText($token, 'CDLL2024');//desencripta token
		if (empty($token) || strlen($token)<36 ) {
		//Define estructura de salida: Token requerido
			return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Requerido', 'Se requiere el uso de un token', 400);
		}else{
		  //Consulta vigencia
			try{
				$resultadoToken = $vt->verificaExistenciaToken($token);
			if ($resultadoToken->rowCount()==0) {
				return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Invalido', 'El token proporcionado no es válido', 400);
			}
			}catch (PDOException $e) {
				return $rs->errorMessage($request->getParsedBody(),$response, 'CL_Error', $e->getMessage(), 500);
			}
		}

		/*if( !include( '../../conexionMysqli.php' ) ){
			die( "No se pudo incluir el archivo de conexion!" );
		}*/
		$body = $request->getBody();
		$params = json_decode($body, true);
		$id_cajero = ( isset($params['id_usuario']) ? $params['id_usuario'] : array() );//$request->getParam( 'id_usuario' );
		if( $id_cajero == '' || $id_cajero == null ){
			$resp = array( "status"=>400, "message"=>"El atributo 'id_usuario' es requerido" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
		$id_sucursal = ( isset($params['id_sucursal']) ? $params['id_sucursal'] : array() );//$id_sucursal = $request->getParam( 'id_sucursal' );
		if( $id_sucursal == '' || $id_sucursal == null ){
			$resp = array( "status"=>400, "message"=>"El atributo 'id_sucursal' es requerido" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
		$terminalId = ( isset($params['terminal_id']) ? $params['terminal_id'] : array() );//$terminalId = $request->getParam( 'terminal_id' );
		if( $terminalId == '' || $terminalId == null ){
			$resp = array( "status"=>400, "message"=>"El atributo 'id_terminal' de la terminal es requerido" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
		$store_id_netpay = ( isset($params['store_id_netpay']) ? $params['store_id_netpay'] : array() );//$store_id_netpay = $request->getParam( 'store_id_netpay' );
		if( $store_id_netpay == '' || $store_id_netpay == null ){
			$resp = array( "status"=>400, "message"=>"El atributo 'store_id_netpay' es requerido" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
		$sale_folio = ( isset($params['sale_folio']) ? $params['sale_folio'] : array() );//$sale_folio = $request->getParam( 'sale_folio' );
		if( $sale_folio == '' || $sale_folio == null ){
			$resp = array( "status"=>400, "message"=>"El atributo 'sale_folio' es requerido" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}

	//consulta folio unico de la sucursal
		$prefix = null;
		$path_api = null;
		$id_registro = null;
		try{
			$sql = "SELECT 
					prefijo,
					(SELECT value FROM api_config WHERE `name` = 'path' ) AS api_path
				FROM sys_sucursales 
				WHERE acceso = 1";
			$stm = $link->query( $sql );
			$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
			$prefix = $row['prefijo'];
			$path_api = $row['api_path'];
		}catch(PDOException $error){
			$resp = array( "status"=>400, "message"=>"Error al consultar prefijo de sucural para generar el folio unico : {$sql}", "error_detail"=>"{$error}" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
	
		$link->beginTransaction();//$link->autocommit(false);
	//inserta la peticion de la transaccion
		try{
			$sql = "INSERT INTO vf_transacciones_netpay ( id_cajero, id_sucursal, terminalId, store_id_netpay, folio_venta ) 
					VALUES ( {$id_cajero}, {$id_sucursal}, '{$terminalId}', '{$store_id_netpay}', '{$sale_folio}' )";
			$stm = $link->query( $sql );
		}catch( PDOException $error ){
			$resp = array( "status"=>400, "message"=>"Error al insertar transaccion netPay : {$error}", "error_detail"=>"{$error}" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
	//recupera id insertado
		try{
			$sql = "SELECT LAST_INSERT_ID() AS id";
			$stm = $link->query( $sql );
			$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
			$id_registro = $row['id'];
		}catch(PDOException $error){
			$resp = array( "status"=>400, "message"=>"Error al consultar el ultimo id insertado : {$sql}", "error_detail"=>"{$error}" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
	//actualiza el folio unico
		try{
			$sql = "UPDATE vf_transacciones_netpay SET folio_unico = CONCAT( '{$prefix}_TNP_', {$id_registro} ) WHERE id_transaccion_netpay = {$id_registro}";
			$stm = $link->query( $sql );
		}catch(PDOException $error){
			$resp = array( "status"=>400, "message"=>"Error al actualizar el folio unico de la transaccion : {$sql}", "error_detail"=>"{$error}" );
			$payload = json_encode($resp, JSON_PRETTY_PRINT);
			$response->getBody()->write($payload);
			return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
		}
		$link->commit();//$link->autocommit(true);
		
		$resp = array( "status"=>200, "folio_unico_transaccion"=>"{$prefix}_TNP_{$id_registro}" );
		$payload = json_encode($resp, JSON_PRETTY_PRINT);
		$response->getBody()->write($payload);
		return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
		//return json_encode( array( "status"=>200, "folio_unico_transaccion"=>"{$prefix}_TNP_{$id_registro}" ) );
	});
?>
