<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: actualizar_datos_transacciones
* Path: /actualizar_datos_transacciones
* Método: POST
* Descripción: Actualizar datos de transacciones de NetPay
*/

$app->post('/actualizar_datos_transacciones', function (Request $request, Response $response){
    $db = new db('../../');
    $link = $db->conectDB();
    $rs = new manageResponse();
    $vt = new tokenValidation();
    //$Encrypt = new $Encrypt();

    $body = $request->getBody();
    //var_dump( $body );
    $file = fopen("archivo_local.txt", "w");
    fwrite($file,"{$body}");
    fclose($file);
    $token =  (empty($request->getHeader('Token'))) ? '' : implode(" ",$request->getHeader('Token'));
    //$token = $Encrypt->decryptText($token, 'CDLL2024');//desencripta token
    if (empty($token) || strlen($token)<36 ) {
    //Define estructura de salida: Token requerido
        return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Requerido', 'Se requiere el uso de un token', 400);
    }else{
      //Consulta vigencia
        try{
            $resultadoToken = $vt->verificaExistenciaToken($token);
        if ($resultadoToken->rowCount()==0) {
            return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Invalido', 'El token proporcionado no es válido', 400);
        }
        }catch (PDOException $e) {
            return $rs->errorMessage($request->getParsedBody(),$response, 'CL_Error', $e->getMessage(), 500);
        }
    }
    /*if( !include( '../../conexionMysqli.php' ) ){
        die( "No se pudo incluir el archivo de conexion!" );
    }*/
    if( !include( '../../code/especiales/tesoreria/cobrosSmartAccounts/ajax/db.php' ) ){
        die( "No se pudo incluir libreria de Pagos!" );
    }
    if( ! include( '../../code/especiales/tesoreria/cobrosSmartAccounts/ajax/Logger.php' ) ){/*Logger*/
      die( "Error al incluir libreria de Logs!" );
    }
	$Logger = null;
    $log_id = null;
    $steep_log_id = 0;
    try{
        $sql = "SELECT log_habilitado AS log_enabled FROM sys_configuraciones_logs WHERE id_configuracion_log = '2'";
        $stm = $link->query( $sql );
        $log = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
        if( $log['log_enabled'] == 1 ){
            $Logger = new Logger( $link );//instancia clase de log
        }
    }catch(PDOException $error){
        die( "Error al consultar si el log de cobros esta habilitado : {$sql} : {$error}" );
    }

    $params = json_decode($body, true);
    //var_dump( $Logger ); //die( 'here' );
//recibe los parametros de netPay
    $affiliation = ( isset($params['affiliation']) ? $params['affiliation'] : null );//$request->getParam( "affiliation" );//1
    $applicationLabel = ( isset($params['applicationLabel']) ? $params['applicationLabel'] : null );//$request->getParam( "applicationLabel" );//2
    $arqc = ( isset($params['arqc']) ? $params['arqc'] : null );//$request->getParam( "arqc" );//3
    $aid = ( isset($params['aid']) ? $params['aid'] : null );//$request->getParam( "aid" );//4
    $amount = ( isset($params['amount']) ? $params['amount'] : null );//$request->getParam( "amount" );//5
    $authCode = ( isset($params['authCode']) ? $params['authCode'] : null );//$request->getParam( "authCode" );//6
    $bin = ( isset($params['bin']) ? $params['bin'] : null );//$request->getParam( "bin" );//7
    $bankName = ( isset($params['bankName']) ? $params['bankName'] : null );//$request->getParam( "bankName" );//8
    $cardExpDate = ( isset($params['cardExpDate']) ? $params['cardExpDate'] : null );//$request->getParam( "cardExpDate" );//9
    $cardType = ( isset($params['cardType']) ? $params['cardType'] : null );//$request->getParam( "cardType" );//10
    $cardTypeName = ( isset($params['cardTypeName']) ? $params['cardTypeName'] : null );//$request->getParam( "cardTypeName" );//11
    $cityName = ( isset($params['cityName']) ? $params['cityName'] : null );//$request->getParam( "cityName" );//12
    $responseCode = ( isset($params['responseCode']) ? $params['responseCode'] : null );//$request->getParam( "responseCode" );//13
    $folioNumber = ( isset($params['folioNumber']) ? $params['folioNumber'] : null );//$request->getParam( "folioNumber" );//14
    $hasPin = ( isset($params['hasPin']) ? $params['hasPin'] : null );//$request->getParam( "hasPin" );//15
    $hexSign = ( isset($params['hexSign']) ? $params['hexSign'] : null );//$request->getParam( "hexSign" );//16
    $isQps = ( isset($params['isQps']) ? $params['isQps'] : null );//$request->getParam( "isQps" );//17
    
    $message_ = ( isset($params['message']) ? $params['message'] : '' );//$request->getParam( "message" );//utf8_encode($request->getParam( "message" ));//18
    $message_ = str_replace( 'á', 'a', $message_ );
    $message_ = str_replace( 'é', 'e', $message_ );
    $message_ = str_replace( 'í', 'i', $message_ );
    $message_ = str_replace( 'ó', 'o', $message_ );
    $message_ = str_replace( 'ú', 'u', $message_ );
    
    $isRePrint = ( isset($params['isRePrint']) ? $params['isRePrint'] : null );//$request->getParam( "isRePrint" );//19
    $moduleCharge = ( isset($params['moduleCharge']) ? $params['moduleCharge'] : null );//$request->getParam( "moduleCharge" );//20
    $moduleLote = ( isset($params['moduleLote']) ? $params['moduleLote'] : null );//$request->getParam( "moduleLote" );//21
    $customerName = ( isset($params['customerName']) ? $params['customerName'] : null );//$request->getParam( "customerName" );//22
    $terminalId = ( isset($params['terminalId']) ? $params['terminalId'] : null );//$request->getParam( "terminalId" );//23
    $orderId = ( isset($params['orderId']) ? $params['orderId'] : null );//$request->getParam( "orderId" );//24
    $preAuth = ( isset($params['preAuth']) ? $params['preAuth'] : null );//$request->getParam( "preAuth" );//25
    $preStatus = ( isset($params['preStatus']) ? $params['preStatus'] : null );//$request->getParam( "preStatus" );//26
    $promotion = ( isset($params['promotion']) ? $params['promotion'] : null );//$request->getParam( "promotion" );//27
    $rePrintDate = ( isset($params['rePrintDate']) ? $params['rePrintDate'] : null );//$request->getParam( "rePrintDate" );//28
    $rePrintMark = ( isset($params['rePrintMark']) ? $params['rePrintMark'] : null );//$request->getParam( "rePrintMark" );//29
    $reprintModule = ( isset($params['reprintModule']) ? $params['reprintModule'] : null );//$request->getParam( "reprintModule" );//30
    $cardNumber = ( isset($params['cardNumber']) ? $params['cardNumber'] : null );//$request->getParam( "cardNumber" );//31
    $storeName = ( isset($params['storeName']) ? $params['storeName'] : null );//$request->getParam( "storeName" );//32
    $streetName = ( isset($params['streetName']) ? $params['streetName'] : null );//$request->getParam( "streetName" );//33
    $ticketDate = ( isset($params['ticketDate']) ? $params['ticketDate'] : null );//$request->getParam( "ticketDate" );//34
    $tipAmount = ( isset($params['tipAmount']) ? $params['tipAmount'] : null );//$request->getParam( "tipAmount" );//35
    $tipLessAmount = ( isset($params['tipLessAmount']) ? $params['tipLessAmount'] : null );//$request->getParam( "tipLessAmount" );//36
    $transDate = ( isset($params['transDate']) ? $params['transDate'] : null );//$request->getParam( "transDate" );//37
    $transType = ( isset($params['transType']) ? $params['transType'] : null );//$request->getParam( "transType" );//38
    $transactionCertificate = ( isset($params['transactionCertificate']) ? $params['transactionCertificate'] : null );//$request->getParam( "transactionCertificate" );//39
    $transactionId = ( isset($params['transactionId']) ? $params['transactionId'] : null );//$request->getParam( "transactionId" );//40
    $traceability = ( isset($params['traceability']) ? $params['traceability'] : null );//$request->getParam( "traceability" );//41
    
    $transaction_unique_folio = $folioNumber;
    if( $traceability['folio_unico_transaccion'] != null && $traceability['folio_unico_transaccion'] != '' ){
      $transaction_unique_folio = $traceability['folio_unico_transaccion'];
    }

    /*Logger*/
    if( $Logger != null ){
        $log = $Logger->insertLoggerRow( $traceability['folio_unico_transaccion'], $traceability['id_cajero'], 'vf_transacciones_netpay', -1, $traceability['id_sucursal'] );
        $log_id = $log['id_log'];
        if( $log_id != null ){
            $steep_log_id = $Logger->insertLoggerSteepRow( $log_id, "Respuesta ( JSON ) que llega al servicio /actualizar_datos_transacciones : ", $body );
        }
    }
    //traceability
   // $traceability['']
  
  //$file = fopen("archivo.txt", "w");
    $link->beginTransaction();//$link->autocommit( false );
  //actualiza la respuesta de la transaccion
    try{
        $sql = "UPDATE vf_transacciones_netpay SET 
              /*2*/affiliation = '{$affiliation}',
              /*3*/applicationLabel = '{$applicationLabel}',
              /*4*/arqc = '{$arqc}',
              /*5*/aid = '{$aid}',
              /*6*/amount = '{$amount}',
              /*7*/authCode = '{$authCode}',
              /*8*/bin = '{$bin}',
              /*9*/bankName = '{$bankName}',
              /*10*/cardExpDate = '{$cardExpDate}',
              /*11*/cardType = '{$cardType}',
              /*12*/cardTypeName = '{$cardTypeName}',
              /*13*/cityName = '{$cityName}',
              /*14*/responseCode = '{$responseCode}',
              /*15*/folioNumber = '{$folioNumber}',
              /*16*/hasPin = '{$hasPin}',
              /*17*/hexSign = '{$hexSign}',
              /*18*/isQps = '{$isQps}',
              /*19*/message = '{$message_}',
              /*20*/isRePrint = '{$isRePrint}',
              /*21*/moduleCharge = '{$moduleCharge}',
              /*22*/moduleLote = '{$moduleLote}',
              /*23*/customerName = '{$customerName}',
              /*24*/terminalId = '{$terminalId}',
              /*25*/orderId = '{$orderId}',
              /*26*/preAuth = '{$preAuth}',
              /*27*/preStatus = '{$preStatus}',
              /*28*/promotion = '{$promotion}',
              /*29*/rePrintDate = '{$rePrintDate}',
              /*30*/rePrintMark = '{$rePrintMark}',
              /*31*/reprintModule = '{$reprintModule}',
              /*32*/cardNumber = '{$cardNumber}',
              /*33*/storeName = '{$storeName}',
              /*34*/streetName = '{$streetName}',
              /*35*/ticketDate = '{$ticketDate}',
              /*36*/tipAmount = '{$tipAmount}',
              /*37*/tipLessAmount = '{$tipLessAmount}',
              /*38*/transDate = '{$transDate}',
              /*39*/transType = '{$transType}',
              /*40*/transactionCertificate = '{$transactionCertificate}',
              /*41*/transactionId = '{$transactionId}',
              /*42*/id_sucursal = '{$traceability['id_sucursal']}', 
              /*43*/id_cajero = '{$traceability['id_cajero']}', 
              /*44*/folio_venta = '{$traceability['folio_venta']}',
              /*44*/id_sesion_cajero = '{$traceability['id_sesion_cajero']}',
              /*45*/store_id_netpay = '{$traceability['store_id_netpay']}',
              /*46*/notificacion_vista = '1'
            WHERE folio_unico = '{$transaction_unique_folio}'";//$folioNumber
        $stm = $link->query( $sql );//die( $sql );
        if( $log_id != null ){/*Logger*/
        $steep_log_id = $Logger->insertLoggerSteepRow( $log_id, "Actualiza el registro de transaccion en servidor local", $sql );
        }
    }catch(PDOException $error){
        $link->rollBack();
        if( $log_id != null ){
            $steep_log_error = $Logger->insertErrorSteepRow( $steep_log_id, 'vf_transacciones_netpay', $traceability['folio_unico_transaccion'], $sql, $error );
        }
        $resp = array( "status"=>400, "message"=>"Error al actualizar datos de la transaccion en servidor local : {$error}" );
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        //return json_encode( array( "status"=>400, "message"=>"Error al actualizar datos de la transaccion en servidor local : {$error}" ) );
    }
//inserta pago
    require_once( './utils/inserta_pago_con_tarjeta.php' );
    //die('here6');
    $link->commit();//$link->autocommit( true );
    $resp = array( "status"=>200, "message"=>"Registro actualizado exitosamente." );
    $payload = json_encode($resp, JSON_PRETTY_PRINT);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    //return json_encode( array( "status"=>200, "message"=>"Registro actualizado exitosamente." ) );
});
?>
