<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: getScripts
* Path: /getScripts
* Método: POST
* Descripción: Recupera y envia scripts
*/
//die( 'here' );
$app->post('/getScripts', function (Request $request, Response $response){
  $resp = array();
  if ( ! include( '../../config.inc.php' ) ){//conexionMysqli
    die( 'no se incluyó conexion' );
  }

  $link = mysqli_connect($dbHost, $dbUser, $dbPassword, $dbName);
  $link->set_charset("utf8");

  if ( ! include( '../../code/especiales/development/versionador_sql/ajax/scriptVersioner.php' ) ){
    die( 'No se incluyó libereria de versionamiento' );
  }/*
  if( ! include( 'utils/SynchronizationManagmentLog.php' ) ){
    die( "No se incluyó : SynchronizationManagmentLog.php" );
  }*/

  $body = $request->getBody();
  $params = json_decode($body, true);
  $branch = ( isset($params['versioner_config']) ? $params['versioner_config'] : array() );//$local_log = $request->getParam( "local_response_log" );
  //$branch = $request->getParam( "versioner_config" );
  //return 'here : '. $versioner['mysql_database'];
  $sV = new scriptVersioner( $link );
  $resp["pending_scripts"] = $sV->getBranchPendingScripts( $branch['branch_name'], $branch['last_script_id'] );
  if( $resp["pending_scripts"] == null ){
    $resp["pending_scripts"] = "No hay actualizaciones por descargar.";
  }
//regresa respuesta
  $payload = json_encode( $resp );
  $response->getBody()->write($payload);
  return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>
