<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: recuperar_respuestas
* Path: /recuperar_respuestas
* Método: POST
* Descripción: Obtener datos de respuestas de GetNet que no fueron entregadas al usuario
*/

$app->post('/recuperar_respuestas_transacciones', function (Request $request, Response $response){
    $db = new db('../../');
    $link = $db->conectDB();
    $rs = new manageResponse();
    $vt = new tokenValidation();
    //$Encrypt = new Encrypt();
    
    $token =  (empty($request->getHeader('Token'))) ? '' : implode(" ",$request->getHeader('Token'));
    //$token = $Encrypt->decryptText($token, 'CDLL2024');//desencripta token
    if (empty($token) || strlen($token)<36 ) {
    //Define estructura de salida: Token requerido
        return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Requerido', 'Se requiere el uso de un token', 400);
    }else{
      //Consulta vigencia
        try{
            $resultadoToken = $vt->verificaExistenciaToken($token);
        if ($resultadoToken->rowCount()==0) {
            return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Invalido', 'El token proporcionado no es válido', 400);
        }
        }catch (PDOException $e) {
            return $rs->errorMessage($request->getParsedBody(),$response, 'CL_Error', $e->getMessage(), 500);
        }
    }
/*
    if( !include( '../../conexionMysqli.php' ) ){
        die( "No se pudo incluir el archivo de conexion!" );
    }*/
    $body = $request->getBody();
    $params = json_decode($body, true);
    $user_id = ( isset($params['id_usuario']) ? $params['id_usuario'] : '' );//$request->getParam( "id_usuario" );
//consulta las transacciones que no han sido marcadas como vistas
    $transacciones = array();
    try{
        $sql = "SELECT * FROM gt_transacciones_getnet WHERE gt_id_cajero = '{$user_id}' AND gt_TrxResult != '' AND gt_notificacion_vista = 0";
        $stm = $link->query( $sql );
        while( $row = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc
            $transacciones[] = $row;
        }
    }catch(PDOException $error){
        $resp = array( "status"=>400, "message"=>"Error al consultar respuesta de la transaccion : {$sql}", "error_detail"=>"{$error}");
        $payload = json_encode($resp, JSON_PRETTY_PRINT);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
    $resp = array( "status"=>200, "transacciones"=>$transacciones);
    $payload = json_encode($resp, JSON_PRETTY_PRINT);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});
?>
