<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
    * Endpoint: inserta_registro_peticion
    * Path: /inserta_registro_peticion
    * Método: POST
    * Descripción: Envia registro de peticion getNet de local a linea.
    * Versión : 1
*/
$app->post('/inserta_registro_peticion', function (Request $request, Response $response){
    $db = new db('../../');
    $link = $db->conectDB();
    $body = $request->getBody();
    $req = json_decode($body, true);
    $store_id = (isset($req['store_id']) ? $req['store_id'] : null );
    if($store_id == null){
        $payload = json_encode(array("status"=>"400", "message"=>"El atributo 'store_id' es requerido."));
        $response->getBody()->write($payload);
        return $response->withStatus(400);
    }
    $system_type = (isset($req['system_type']) ? $req['system_type'] : null );
    if($system_type == null){
        $payload = json_encode(array("status"=>"400", "message"=>"El atributo 'system_type' es requerido."));
        $response->getBody()->write($payload);
        return $response->withStatus(400);
    }
    $user_id = (isset($req['user_id']) ? $req['user_id'] : null );
    if($user_id == null){
        $payload = json_encode(array("status"=>"400", "message"=>"El atributo 'user_id' es requerido."));
        $response->getBody()->write($payload);
        return $response->withStatus(400);
    }
    $terminal_serial_number = (isset($req['terminal_serial_number']) ? $req['terminal_serial_number'] : null );
    if($terminal_serial_number == null){
        $payload = json_encode(array("status"=>"400", "message"=>"El atributo 'terminal_serial_number' es requerido."));
        $response->getBody()->write($payload);
        return $response->withStatus(400);
    }
    $sale_folio = (isset($req['sale_folio']) ? $req['sale_folio'] : null );
    if($sale_folio == null){
        $payload = json_encode(array("status"=>"400", "message"=>"El atributo 'sale_folio' es requerido."));
        $response->getBody()->write($payload);
        return $response->withStatus(400);
    }
    $id = null;
    try{
    //inserta el registro de transaccion
        $sql = "INSERT INTO gt_transacciones_getnet(gt_folio_venta, gt_id_sucursal, gt_id_tipo_sistema, gt_id_cajero) 
        VALUES ('{$sale_folio}', {$store_id}, {$system_type}, {$user_id})";
        $link->query($sql);
    //recupera id de registro de transaccion
        $id = $link->lastInsertId();
    //actualiza el folio unico de transaccion
        $sql = "UPDATE gt_transacciones_getnet SET gt_folio_unico = CONCAT('25LNA_GT_', {$id}) WHERE gt_id_tansaccion_id = {$id}";
        $link->query($sql);
    }catch(PDOException $error){
        $payload = json_encode(array("status"=>"302", "message"=>"Error al insertar registro de transacción.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}"));
        $response->getBody()->write($payload);
        return $response->withStatus(400);
    }
    $payload = json_encode(array("status"=>"200", "unique_folio"=>"25LNA_GT_{$id}"));
    $response->getBody()->write($payload);
    return $response->withStatus(200);
});

?>
