<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: productos
* Path: /productos/sincroniza_producto
* Método: POST
* Descripción: Servicio para registrar nuev producto en BDs facturación
*/
$app->post('/productos/sincroniza_producto', function (Request $request, Response $response){
  //Init
    $rs = new manageResponse();
    $vt = new tokenValidation();
    //Instancia BD General
    $db = new db();
    $link = $db->conectDB();
    //consulta los parametros de bases de datos de facturacion
    $fact_params = array();
    try{
        $sql = "SELECT host_bd, usuario_bd, pass_bd, nombre_bd FROM ec_bases_facturacion LIMIT 1";
        $stm = $link->query($sql);
        if($stm->rowCount() <= 0){
            return $rs->errorMessage($request->getParsedBody(),$response, 'Configuracion_Faltante', 'Se requiere configurar las bases de facturación.', 400);
        }
        $fact_params = $stm->fetch(PDO::FETCH_ASSOC);
    }catch(PDOException $error){
        die("Error al consultar los parametros de conexion a la base de datos.");
    }
    
    $dbFact = new dbFact($fact_params['host_bd'], $fact_params['usuario_bd'], $fact_params['pass_bd'], $fact_params['nombre_bd']);   //Instancia a BD Fact
    $linkFact = $dbFact->conectDB();
//error_log("paramsFact : " . json_encode($fact_params));

//Valida token
    $token =  (empty($request->getHeader('Token'))) ? '' : implode(" ",$request->getHeader('Token'));
    if (empty($token) || strlen($token)<36 ) {
//Define estructura de salida: Token requerido
        return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Requerido', 'Se requiere el uso de un token con el formato correcto', 400);
    }else{
    //Consulta vigencia de token
        try{
            $resultadoToken = $vt->validaToken($token);
            if ($resultadoToken->rowCount()==0) {
                return $rs->errorMessage($request->getParsedBody(),$response, 'Token_Invalido', 'El token proporcionado no es válido', 400);
            }
        }catch (PDOException $e) {
            return $rs->errorMessage($request->getParsedBody(),$response, 'CL_Error', $e->getMessage(), 500);
        }
    }

  //Recuperar parámetros de entrada
    $body = $request->getBody();
    $params = json_decode( $body, true);
    $id_producto = ( isset($params['id_producto']) ? $params['id_producto'] : null );
//Validar elementos requerido para crear venta
    if (empty($id_producto)){
        return $rs->errorMessage($request->getParsedBody(),$response, 'Datos_Faltantes', 'Hace falta información para crear producto(s)', 400);
    }
  //Consulta BD para insertar
    $bd_facturacion = [];
    try{
    //Recupera bases de datos
        $sql = "SELECT id, nombre_bd FROM ec_bases_facturacion WHERE active=1";
        $stm = $link->query($sql);
        while($row = $stm->fetch(PDO::FETCH_ASSOC)){
            $bd_facturacion[] = $row;
        }
    }catch(PDOException $error){
        die(json_encode(array("status"=>302, "message"=>"Error al consultar bases de datos de facturacion.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
    }
    if (count($bd_facturacion)<=0) {
        return $rs->errorMessage($request->getParsedBody(),$response, 'Error_Insert', 'No existen bases de datos definidas para sistema de facturación: ec_bases_facturacion', 500);
    }
      //Recupera productos
    $producto = [];
    try{
        $sql="SELECT
                producto.id_productos,
                producto.clave,
                concat( COALESCE(codigo_sat.descripcion_cl,''), ' Modelo ' , COALESCE(producto.orden_lista,'')) AS nombre,
                0 AS precio_venta,
                0 AS precio_compra,
                producto.marca,
                producto.min_existencia,
                producto.imagen,
                producto.observaciones,
                producto.inventariado,
                producto.genera_iva,
                producto.genera_ieps,
                producto.porc_iva,
                producto.porc_ieps,
                producto.desc_gral,
                producto.nombre AS nombre_etiqueta,
                codigo_sat.codigo_sat orden_lista, -- producto.orden_lista,
                producto.ubicacion_almacen,
                producto.codigo_barras_1,
                producto.codigo_barras_2,
                producto.codigo_barras_3,
                producto.codigo_barras_4,
                producto.maximo_existencia,
                1 AS habilitado, -- producto.habilitado,
                producto.omitir_alertas,
                producto.existencia_media,
                1 AS id_tipo_facturacion,
                IF(tienda_linea.producto_solo_facturacion, tienda_linea.producto_solo_facturacion, 0) producto_solo_facturacion
            FROM ec_productos producto
            LEFT JOIN ec_admin_codigos_sat codigo_sat 
            ON codigo_sat.id_categoria = producto.id_categoria 
            AND codigo_sat.id_subcategoria = producto.id_subcategoria
            LEFT JOIN ec_producto_tienda_linea tienda_linea 
            ON tienda_linea.id_producto = producto.id_productos
            WHERE producto.id_productos IN ({$id_producto})";
        $stm = $link->query($sql);
        if($stm->rowCount() <= 0){
            die(json_encode(array("status"=>"302", "message"=>"El producto no fue encontrado en la base de datos del Sistema General.")));
        }
        $producto = $stm->fetch(PDO::FETCH_ASSOC);
    }catch(PDOException $e) {
        return $rs->errorMessage($request->getParsedBody(),$response, 'Error_Insert', $e->getMessage(), 500);
    }
  //Ejecuta inserts a BD cdelasluces
    foreach ($bd_facturacion as $key => $facturacion) {
        $product_id = null;
        try{
            $sql = "SELECT id_productos FROM {$facturacion['nombre_bd']}.ec_productos WHERE id_productos = {$producto['id_productos']}";
            $stm = $linkFact->query($sql);
            if($stm->rowCount() > 0){
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                $product_id = $row['id_productos'];
            }
        }catch(PDOException $error){
//error_log("Error : " . json_encode(array("status"=>"302", "message"=>"Error al validar si el producto existe en la bd {$facturacion['nombre_bd']}", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            die(json_encode(array("status"=>"302", "message"=>"Error al validar si el producto existe en la bd {$facturacion['nombre_bd']}", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        if($product_id == null ){//insert
            $sql="INSERT INTO {$facturacion['nombre_bd']}.ec_productos (id_productos,clave,nombre,precio_venta,precio_compra,marca,min_existencia,imagen,observaciones,inventariado,genera_iva,genera_ieps,porc_iva,porc_ieps,desc_gral,nombre_etiqueta,orden_lista,ubicacion_almacen,codigo_barras_1,codigo_barras_2,codigo_barras_3,codigo_barras_4,maximo_existencia,habilitado,omitir_alertas,existencia_media,id_tipo_facturacion,producto_solo_facturacion)
                  VALUES (
                    '{$producto['id_productos']}',
                    '{$producto['clave']}',
                    '{$producto['nombre']}',
                    '{$producto['precio_venta']}',
                    '{$producto['precio_compra']}',
                    '{$producto['marca']}',
                    '{$producto['min_existencia']}',
                    '{$producto['imagen']}',
                    '{$producto['observaciones']}',
                    '{$producto['inventariado']}',
                    '{$producto['genera_iva']}',
                    '{$producto['genera_ieps']}',
                    '{$producto['porc_iva']}',
                    '{$producto['porc_ieps']}',
                    '{$producto['desc_gral']}',
                    '{$producto['nombre_etiqueta']}',
                    '{$producto['orden_lista']}',
                    '{$producto['ubicacion_almacen']}',
                    '{$producto['codigo_barras_1']}',
                    '{$producto['codigo_barras_2']}',
                    '{$producto['codigo_barras_3']}',
                    '{$producto['codigo_barras_4']}',
                    '{$producto['maximo_existencia']}',
                    '{$producto['habilitado']}',
                    '{$producto['omitir_alertas']}',
                    '{$producto['existencia_media']}',
                    3,
                    '{$producto['producto_solo_facturacion']}');";
        }else{//update
            $sql="UPDATE {$facturacion['nombre_bd']}.ec_productos
                    SET
                    clave = '{$producto['clave']}',
                    nombre = '{$producto['nombre']}',
                    marca = '{$producto['marca']}',
                    min_existencia = '{$producto['min_existencia']}',
                    imagen = '{$producto['imagen']}',
                    observaciones = '{$producto['observaciones']}',
                    inventariado = '{$producto['inventariado']}',
                    genera_iva = '{$producto['genera_iva']}',
                    genera_ieps = '{$producto['genera_ieps']}',
                    porc_iva = '{$producto['porc_iva']}',
                    porc_ieps = '{$producto['porc_ieps']}',
                    desc_gral = '{$producto['desc_gral']}',
                    nombre_etiqueta = '{$producto['nombre_etiqueta']}',
                    orden_lista = '{$producto['orden_lista']}',
                    ubicacion_almacen = '{$producto['ubicacion_almacen']}',
                    codigo_barras_1 = '{$producto['codigo_barras_1']}',
                    codigo_barras_2 = '{$producto['codigo_barras_2']}',
                    codigo_barras_3 = '{$producto['codigo_barras_3']}',
                    codigo_barras_4 = '{$producto['codigo_barras_4']}',
                    maximo_existencia = '{$producto['maximo_existencia']}',
                    omitir_alertas = '{$producto['omitir_alertas']}',
                    existencia_media = '{$producto['existencia_media']}',
                    producto_solo_facturacion = '{$producto['producto_solo_facturacion']}',
                    id_tipo_facturacion = 3
                WHERE id_productos = '{$product_id}'";
        }
        try{
//error_log($sql);
            $linkFact->query($sql);
        }catch(PDOException $error){
//error_log("Error : " . json_encode(array("status"=>"302", "message"=>"Error al insertar / actualizar producto", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            die(json_encode(array("status"=>"302", "message"=>"Error al insertar / actualizar producto", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
    }
    $inserts = array();
    //Regresa resultado
    return $rs->successMessage($request->getParsedBody(),$response, $inserts);
});

?>
