<?php
    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Slim\Factory\AppFactory;

    require __DIR__ . '../../../vendor/autoload.php';
    if( ! require '../../rest/src/config/db.php' ){// DB Connect CL
        die("Error al incluir archivo de conexion PDO.");
    }
    if( ! require '../../rest/src/config/dbFact.php' ){// DB Connect CL
        die("Error al incluir archivo de conexion PDO de facturacion.");
    }
    /*
        * Instancia utilities*/

    require '../utils/manageResponse.php';
    require '../utils/validaToken.php';

    $archivo_path = "../../conexion_inicial.txt";
    $carpeta_path = "";
    if(file_exists($archivo_path)){
    $file = fopen($archivo_path,"r");
    $line=fgets($file);
    fclose($file);
    $config=explode("<>",$line);
    $tmp=explode("~",$config[2]);
    $ruta_or=$tmp[0];
    $ruta_des=$tmp[1];
    $tmp_=explode("~",$config[0]);
    $carpeta_path = base64_decode( $tmp_[1] );
    }else{
    die("No hay archivo de configuración.");
    }
    $app = AppFactory::create();
    $app->setBasePath("/{$carpeta_path}/rest_v2/facturacion");

//client
    require 'client/envia_cliente.php';
    require 'client/envia_cliente_facturacion.php';
    require 'client/descarga_clientes.php';
    require 'client/devolucion.php';
    require 'client/barrido_ventas_sin_subir.php';
    //require 'client/barrido_ventas_pendientes_de_subir_a_facturacion.php';

//server
    require 'server/inserta_cliente.php';
    require 'server/insertaClienteGeneralLineaDirecto.php';
    require 'server/facturaReceptor.php';
    require 'server/token.php';
    require 'server/productos.php';
    require 'server/sincroniza_producto.php';

$app->run();

