<?php
//ok 2023/11/25
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: envia_cliente
* Path: /envia_cliente
* Método: GET
* Descripción: envia cliente facturacion
*/

$app->post('/devolucion', function (Request $request, Response $response){
//variables
	$req = [];
	$req["rows"] = array();
	$result = "";
//librerias
	$db = new db("../../");//Instancia BD General
	$link = $db->conectDB();
  	if ( ! include( '../sincronizacion/utils/rowsSynchronization.php' ) ){
    	die( 'No se incluyó libreria de registros de sincronizacion' );
  	}
  	if ( ! include( '../sincronizacion/utils/SynchronizationManagmentLog.php' ) ){
    	die( 'No se incluyó libreria SynchronizationManagmentLog' );
  	}
    $SynchronizationManagmentLog = new SynchronizationManagmentLog($link);
//recibe parametros de venta
    $body = $request->getBody();
    $params = json_decode( $body, true);
    $sale_id = ( isset($params['id_pedido']) ? $params['id_pedido'] : null );//$request->getParam( "store_id" );
    if($sale_id == null || $sale_id == ''){
        $payload = json_encode(array("status"=>400,"message"=>"El atributo id_pedido es requerido y no puede ser vacio."));
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
//consulta cabecera de la venta actualizada
    $sale = array();
    try{
        $sql = "SELECT 
                    folio_nv,
                    subtotal,
                    total,
                    descuento
                FROM ec_pedidos
                WHERE id_pedido = {$sale_id}";
        $stm = $link->query($sql);
        $sale = $stm->fetch(PDO::FETCH_ASSOC);
    }catch(PDOException $error){
        die("Error al consultar cabecera actualizada de la nota de venta : {$sql} : {$error}");
    }
    $sale['detail'] = array();
//consulta detalle de la venta actualizada
    try{
        $sql = "SELECT 
                    id_producto,
                    cantidad,
                    precio,
                    monto,
                    precio_facturacion,
                    monto_facturacion,
                    folio_facturacion
                FROM ec_pedidos_detalle
                WHERE id_pedido = {$sale_id}";
        $stm = $link->query($sql);
        while($detail = $stm->fetch(PDO::FETCH_ASSOC)){
            $sale['detail'][] = $detail;
        }
    }catch(PDOException $error){
        die("Error al consultar detalle actualizado de la nota de venta : {$sql} : {$error}");
    }
    $post_data = json_encode($sale);
    
   /* $response->getBody()->write($post_data);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);*/
//consulta la url del api de sistema de facturacion en la base de datos
	$row = null;
	try{
		$sql = "SELECT `value` FROM `api_config` WHERE name = 'path_facturacion'";
		$stm = $link->query( $sql );
		$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
	}catch(PDOException $error){
		die( "Error al consultar el PATH de facturación : {$sql} : {$error->getMessage()}" );
	}
	$fact_path = trim ( $row['value'] );
	//$post_data = json_encode($req, JSON_UNESCAPED_UNICODE);//forma peticion//
//return $post_data;
	$result_1 = $SynchronizationManagmentLog->sendPetition( "{$fact_path}/rest/devolucion", $post_data );
    //die("{$fact_path}/rest/devolucion : {$result_1}");
    $result = json_decode( $result_1, true );//decodifica respuesta
    if(isset($result['status']) && ($result['status'] == 200 || $result['status'] == '200')){
        $payload = json_encode(array("status"=>200, "message"=>"Venta actualizada exitosamente en administracion de facturación y la Razon Social."));
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
    }else if(isset($result['status']) && ($result['status'] == 400 || $result['status'] == '400')){
        $payload = json_encode(array("status"=>400, "message"=>$result['message']));
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
	//return $result_1;
	//var_dump($result_1);
   	if( $result == null || $result == "" ){
   		echo "error {$fact_path}/rest/devolucion : ";
        echo "{$post_data}";
   		var_dump($result_1);
   		die('<br><div class="text-center"><button class="btn btn-danger" onclick="close_emergent();">Cerrar</button></div>');
   	}
    /*$payload = 
    $response->getBody()->write("ok");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);*/
});

?>
