<?php
//ok 2023/11/25
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

/*
* Endpoint: barrido_ventas_sin_subir
* Path: /barrido_ventas_sin_subir
* Método: POST
* Descripción: Servicio para barrer ventas pendientes de subir a facturación
*/
$app->post('/barrido_ventas_sin_subir', function (Request $request, Response $response){
	$db = new db("../../");//Instancia BD General
	$link = $db->conectDB();
    $store_id = null;
    $current_year = null;
    $api_url = null;
    $date_since = null;
    $date_to = null;
    $store_id = null;
//recibe parametros    
    $body = $request->getBody();
    $params = json_decode( $body, true);
    $date_since = ( isset($params['fecha_desde']) ? $params['fecha_desde'] : null );//$request->getParam( "store_id" );
    if($date_since == null){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "El parametro fecha_desde es obligatorio.";
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
    $date_to = ( isset($params['fecha_hasta']) ? $params['fecha_hasta'] : null );//$request->getParam( "store_id" );
    if($date_to == null){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "El parametro fecha_hasta es obligatorio.";
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
    $store_id = ( isset($params['id_sucursal']) ? $params['id_sucursal'] : null );//$request->getParam( "store_id" );
    if($date_to == null){
        $resp = array();
        $resp['status'] = "302";
        $resp['message'] = "El parametro id_sucursal es obligatorio.";
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }

    $sincronizaVentaFacturacion = new sincronizaVentaFacturacion($link);
//obtener configuracion
    $config = $sincronizaVentaFacturacion->getStoreAndConfig(); 
    if(isset($config['status']) && $config['status'] == "302"){
        $payload = json_encode($config);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }else{
        //$store_id = $config['store_id'];
        $current_year = $config['current_year'];
        $api_url = $config['api_url'] . "/rest/inserta_venta_facturacion";
    }
//obtener ventas
    $sales = $sincronizaVentaFacturacion->getPendingSales($store_id, $date_since, $date_to);

    if(isset($sales['status']) && $sales['status'] == "302"){
        $payload = json_encode($sales);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
//itera las ventas
    if(count($sales) > 0){
        foreach ($sales as $key => $sale) {
            $sale_header = $sincronizaVentaFacturacion->getSaleHeader($sale['id_pedido'], $store_id);//consulta cabecera de la venta
            $sale_detail = $sincronizaVentaFacturacion->getSaleDetail($sale['id_pedido']);//consulta detalle de la venta
            $sale_payments = $sincronizaVentaFacturacion->getPayments($sale['id_pedido']);//consulta cobros de la venta
            $sale_payments_detail = $sincronizaVentaFacturacion->getPaymentsDetail($sale['id_pedido']);//consulta detalle de cobros de la venta
            $post_data = json_encode( array( "venta"=>$sale_header, "venta_detalle"=>$sale_detail, "cobros"=>$sale_payments, "pagos"=>$sale_payments_detail  ) );//forma el json de la petición
            $send = $sincronizaVentaFacturacion->sendPetition($api_url, $post_data);
            $json_decode = json_decode($send, true);
            $status_update = 2;
            if($json_decode['status'] == ''){
                $status_update = 3;
            }else if($json_decode['status'] == ''){
                
            }
            $update = $sincronizaVentaFacturacion->updateSaleStatus($sale['id_pedido'], $status_update);
            if($update != 'ok'){
                $payload = json_encode($update);
                $response->getBody()->write($payload);
                return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
            }
        }
    }
    $payload = json_encode(array("status"=>"200", "message"=>"Barrido exitoso."));
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    
});

final class sincronizaVentaFacturacion{
    private $link;
    public function __construct($connection) {
        $this->link = $connection;
    }

    public function getStoreAndConfig(){
//consulta el año actual y sucursal de acceso
        $resp = array();
        try{
            $sql = "SELECT
                        id_sucursal AS store_id,
                        (SELECT DATE_FORMAT(NOW(), '%Y')) AS current_year,
                        (SELECT `value` FROM api_config WHERE `key` = 'facturacion') AS api_url
                    FROM sys_sucursales
                    WHERE acceso = 1";//die("{$sql}");
            $stm = $this->link->query($sql);
            $resp = $stm->fetch(PDO::FETCH_ASSOC);
            return $resp;
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al consultar sucursal del sistema y año actual.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }

    public function getPendingSales($store_id, $date_since, $date_to){
        $sales = array();
        try{
            $sql = "SELECT
                        id_pedido,
                        folio_nv
                    FROM ec_pedidos
                    WHERE id_sucursal = {$store_id}
                    AND ( fecha_alta BETWEEN '{$date_since} 00:00:01' AND '{$date_to} 23:59:59' )
                    AND id_status_facturacion IN(1,2)";
            $stm = $this->link->query($sql);
            while($row = $stm->fetch(PDO::FETCH_ASSOC)){
                $sales[] = $row;
            }
            return $sales;
        }catch(PDOException $error){
            $resp = array();
            $resp['status'] = "302";
            $resp['message'] = "Error al consultar las ventas pendientes de comprobar en facturación.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }

    public function getSaleHeader($sale_id, $store_id){
        $sale = array();
        try{
            $sql = "SELECT 
                    id_pedido, 
                    folio_pedido, 
                    folio_nv, 
                    folio_factura, 
                    folio_cotizacion, 
                    id_cliente, 
                    id_estatus, 
                    id_moneda, 
                    fecha_alta, 
                    fecha_factura, 
                    id_razon_social, 
                    subtotal, 
                    iva, 
                    ieps, 
                    total, 
                    dias_proximo, 
                    pagado, 
                    surtido, 
                    enviado, 
                    id_sucursal, 
                    id_usuario, 
                    fue_cot, 
                    facturado, 
                    id_tipo_envio, 
                    descuento, 
                    id_razon_factura, 
                    folio_abono, 
                    correo, 
                    facebook, 
                    modificado, 
                    ultima_sincronizacion, 
                    ultima_modificacion, 
                    tipo_pedido, 
                    id_status_agrupacion, 
                    id_cajero, 
                    id_devoluciones, 
                    venta_validada, 
                    folio_unico, 
                    id_sesion_caja, 
                    tipo_sistema, 
                    monto_pago_inicial, 
                    cobro_finalizado,
                    id_status_facturacion 
                FROM ec_pedidos 
                WHERE id_pedido = {$sale_id}";// die($sql);
            $stm = $this->link->query( $sql );
            $sale_header = $stm->fetch(PDO::FETCH_ASSOC);
        //obtiene RS destino
            $sale_header['id_razon_social'] = $this->getSaleSocialReason( $sale_header['id_pedido'], $store_id );
            if(isset($sale_header['id_razon_social']['status']) && $sale_header['id_razon_social']['status'] == "302"){
                
            }
            return $sale_header;
        }catch(PDOException $error){
            $resp = array();
            $resp['status'] = "302";
            $resp['message'] = "Error al consultar las ventas pendientes de comprobar en facturación.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }

    public function getSaleSocialReason( $sale_id, $store_id ){
/*if($this->Logger){
	$this->write_log("Entra en getSaleSocialReason( {$sale_id}, {$store_id} );");
}*/
			$row = array();
		//consulta si los pagos fueron en efectivo
			try{
				//$sql = "SELECT DISTINCT( id_tipo_pago ) AS payment_type FROM ec_cajero_cobros WHERE id_pedido = {$sale_id}";
				$sql = "SELECT DISTINCT( IF(id_tipo_pago = 2, 1, id_tipo_pago) ) AS payment_type FROM ec_cajero_cobros WHERE id_pedido = {$sale_id}";//die($sql);
/*if($this->Logger){
	$this->write_log("Consulta tipos de pago de la nota de venta : {$sql}");
}*/
				$stm = $this->link->query( $sql );
				if( $stm->rowCount() == 1 ){//una sola forma de pago//num_rows
/*if($this->Logger){
	$this->write_log("Entra en una sola forma de pago.");
}*/
					$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
					if( $row['payment_type'] == 1 || $row['payment_type'] == 2 ){//si solo fue pagada en efectivo
/*if($this->Logger){
    $this->write_log("Entra en un solo tipo de pago (Efectivo).");
}*/
					//die("here");
					//consulta el id de la razon social configurada en la sucursal
						try{
							$sql = "SELECT id_razon_social FROM sys_sucursales WHERE id_sucursal = {$store_id}";
							$stm = $this->link->query( $sql );
							$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
/*if($this->Logger){
	$this->write_log("consulta el id de la razon social configurada en la sucursal : {$sql}");
	$this->write_log("Resultado = {$row['id_razon_social']}");
}*/
							return $row['id_razon_social'];
						}catch(PDOException $error){
							die( "Error al consultar la razon social configurada en la sucursal : {$sql} : {$error}" );
						}
					}
				}
			}catch(PDOException $error){
				die( "Error al consultar los tipo de pagos : {$sql} : {$error}" );
			}
			//die("pasa");
		//consulta el pago mas alto y su razon social
			try{
				$sql = "SELECT 
							cc.id_afiliacion,
							cc.id_terminal,
							cc.id_banco
						FROM ec_cajero_cobros cc
						WHERE cc.id_pedido = {$sale_id}
						AND ( cc.id_afiliacion > 0 OR cc.id_terminal > 0 OR cc.id_banco > 0 )
						ORDER BY cc.monto DESC
						LIMIT 1";
				$stm = $this->link->query( $sql );
				$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
/*if($this->Logger){
	$this->write_log("Consulta el pago mas alto y su razon social : {$sql}");
	$this->write_log("Resultado : \nid_afiliacion = {$row['id_afiliacion']}\nid_terminal = {$row['id_terminal']}\nid_banco = {$row['id_banco']}");
}*/
			}catch(PDOException $error){
				die( "Error al consultar pagos con tarjeta : {$sql} : {$error}" );
			}
			$sql = "";
			if( isset($row['id_afiliacion']) && $row['id_afiliacion'] > 0 && $row['id_afiliacion'] != '' ){//terminal inbursa
				try{
					$sql = "SELECT 
								cc.id_razon_social
							FROM ec_afiliaciones a
							LEFT JOIN ec_caja_o_cuenta cc
							ON a.id_banco = cc.id_caja_cuenta
							WHERE a.id_afiliacion = {$row['id_afiliacion']}";
					$stm = $this->link->query( $sql );
					$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
/*if($this->Logger){
	$this->write_log("Consulta razon social de terminal inbursa : {$sql}");
	$this->write_log("Resultado : {$row['id_razon_social']}");
}*/
					return $row['id_razon_social'];
				}catch(PDOException $error){
					die( "Error al consultar la razon social de la afiliación : {$sql} : {$error}" );
				}
			}else if( isset($row['id_terminal']) && $row['id_terminal'] > 0 && $row['id_terminal'] != '' ){//terminal netPay
				try{
					$sql = "SELECT 
								cc.id_razon_social
							FROM ec_terminales_integracion_smartaccounts t
							LEFT JOIN ec_caja_o_cuenta cc
							ON t.id_caja_cuenta = cc.id_caja_cuenta
							WHERE t.id_terminal_integracion = {$row['id_terminal']}";
					$stm = $this->link->query( $sql );
					$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
/*if($this->Logger){
	$this->write_log("Consulta razon social de terminal netPay : {$sql}");
	$this->write_log("Resultado : {$row['id_razon_social']}");
}*/
					return $row['id_razon_social'];
				}catch(PDOException $error){
					die( "Error al consultar la razon social de la afiliación : {$sql} : {$error}" );
				}
			}else if( isset($row['id_banco']) && $row['id_banco'] > 0 && $row['id_banco'] != '' ){//transferencia
				try{
					$sql = "SELECT 
								cc.id_razon_social
							FROM ec_caja_o_cuenta cc
							WHERE cc.id_caja_cuenta = {$row['id_banco']}";
					$stm = $this->link->query( $sql );
					$row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
/*if($this->Logger){
	$this->write_log("Consulta razon social de Transferencia : {$sql}");
	$this->write_log("Resultado : {$row['id_razon_social']}");
}*/
					return $row['id_razon_social'];
				}catch(PDOException $error){
					die( "Error al consultar la razon social de caja o cuenta (Transferencia): {$sql} : {$error}" );
				}
			}
		}

    public function getSaleDetail($sale_id){
        $sale_detail = array();
        try{
            $sql = "SELECT 
                        id_pedido_detalle, 
                        id_pedido, 
                        id_producto, 
                        cantidad, 
                        precio,
                        monto,
                        precio_facturacion, 
                        monto_facturacion, 
                        iva, 
                        ieps, 
                        cantidad_surtida, 
                        descuento, 
                        modificado, 
                        es_externo, 
                        id_precio, 
                        folio_unico,
                        folio_facturacion 
                    FROM ec_pedidos_detalle 
                    WHERE id_pedido = {$sale_id}";
            $stm = $this->link->query( $sql );
            while( $detail_row = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc
                $sale_detail[] = $detail_row;
            }
            return $sale_detail;
        }catch(PDOException $error){
            $resp = array();
            $resp['status'] = "302";
            $resp['message'] = "Error al consultar el detalle de la nota de venta.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }

    public function getPayments($sale_id){
        $sale_payments = array();
        try{
            $sql = "SELECT 
                        id_cajero_cobro, 
                        id_sucursal, 
                        id_pedido, 
                        id_devolucion, 
                        id_cajero, 
                        id_sesion_caja, 
                        id_afiliacion, 
                        id_terminal, 
                        id_banco, 
                        id_tipo_pago, 
                        monto, 
                        fecha, 
                        hora, 
                        observaciones, 
                        cobro_cancelado,
                        folio_unico, 
                        sincronizar,
                        id_tipo_pago,
                        id_forma_pago 
                    FROM ec_cajero_cobros 
                    WHERE id_pedido = {$sale_id}";
            $stm = $this->link->query( $sql );
            while( $payments = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc()
                $sale_payments[] = $payments;
            }
            return $sale_payments;
        }catch(PDOException $error){
            $resp = array();
            $resp['status'] = "302";
            $resp['message'] = "Error al consultar cobros de la nota de venta.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }
    public function getPaymentsDetail($sale_id){
        $sale_payments_detail = array();  
        try{
            $sql = "SELECT 
                        id_pedido_pago, 
                        id_pedido, 
                        id_cajero_cobro, 
                        id_tipo_pago, 
                        fecha, 
                        hora, 
                        monto, 
                        referencia, 
                        id_moneda, 
                        tipo_cambio, 
                        id_nota_credito, 
                        id_cxc, 
                        exportado, 
                        es_externo, 
                        id_cajero, 
                        folio_unico, 
                        sincronizar, 
                        id_sesion_caja, 
                        pago_cancelado 
                    FROM ec_pedido_pagos
                    WHERE id_pedido = {$sale_id}";
            $stm = $this->link->query( $sql );
            while( $payments_detail = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc
                $sale_payments_detail[] = $payments_detail;
            }
            return $sale_payments_detail;
        }catch(PDOException $error){
            $resp = array();
            $resp['status'] = "302";
            $resp['message'] = "Error al consultar pagos de la nota de venta.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }

    public function sendPetition($api_url, $post_data){
        $ch = curl_init($api_url);
//die("URL : {$api_url}\nPOST_DATA : {$post_data}");
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		$response = curl_exec($ch);
        return $response;
    }

    public function updateSaleStatus($sale_id, $status){
        try{
            $sql = "UPDATE ec_pedidos SET id_status_facturacion = {$status} WHERE id_pedido = {$sale_id}";
            $this->link->query($sql);
            return 'ok';
        }catch(PDOException $error){
            $resp = array();
            $resp['status'] = "302";
            $resp['message'] = "Error al actualizar status de facturacion de la nota de venta.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            return $resp;
        }
    }
}

    
?>