<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: actualiza_validacion_ventas_por_lote
* Path: /actualiza_validacion_ventas_por_lote
* Método: POST
* Descripción: Actualiza validacion de ventas por lote
*/
$app->post('/actualiza_validacion_ventas_por_lote', function (Request $request, Response $response){
    //include('../../conect.php');
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
  
    $body = $request->getBody();
    $params = json_decode($body, true);
    $store_id = ( isset($params['store_id']) ? $params['store_id'] : '' );//$request->getParam( "store_id" );
    if($store_id == '' || $store_id == null){
    $response->getBody()->write("El atributo store_id es requerido.");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
    $resp = array();
    $resp['updated'] = array();
    $resp['pending'] = array();
    $current_year = array();
	try{
		$sql = "SELECT DATE_FORMAT( NOW(), '%Y' ) AS year";
		$stm = $link->query( $sql );
		$current_year = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
	}catch(PDOException $error){
		die( "Error al consultar el año actual : {$sql} : {$error}" );
	}

    $sql = "SELECT 
                folio_nv AS folio, 
                total AS amount,
                DATE_FORMAT( fecha_alta, '%d/%m/%Y' )AS date,
                id_pedido
            FROM ec_pedidos 
            WHERE venta_validada = 0 
            AND fecha_alta LIKE '%{$current_year['year']}%'
            AND id_sucursal = {$store_id}";//
    $stm = $link->query( $sql );
    $sales_number = $stm->rowCount();//num_rows
    if($sales_number > 0){
        include('../../touch_desarrollo/validation/ajax/db.php');
		$validationTicket = new validationTicket( $link );
        while( $row = $stm->fetch(PDO::FETCH_ASSOC) ){
            $verification = validateIfIsComplete($row['id_pedido'], $link);
            if($verification == 'ok'){
                $validationTicket->finishValidation( $row['id_pedido'], 0, $store_id, 1 );
                $resp['updated'][] = $row['id_pedido'];
            }else{
                $resp['pending'][] = array("sale_id"=>$row['id_pedido'], "sale_folio"=>"{$row['folio']}", "response"=>"{$verification}");
            }
        }
    }
    //die( "Store : {$origin_store_id}" );
    //$resp = array("message"=>"Service is ON.", "data"=>$stm->fetchAll());
    $payload = json_encode($resp);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

    function validateIfIsComplete($sale_id, $link){
        try{
            $sql = "SELECT
                    ax2.row_id
                FROM(
                    SELECT
                        ax.row_id,
                        ax.name,
                        ax.original_quantity AS original_quantity,
                        ax.quantity_to_cancel,
                        ax.quantity,
                    	(ax.original_quantity - ax.quantity_to_cancel - ax.quantity) AS restante
                    FROM(
                        SELECT
                            pd.id_pedido_detalle AS row_id,
                            p.nombre AS name,
                            pd.cantidad AS original_quantity, 
                            IF( p.es_maquilado = 0, 
                                SUM( IF( pvu.id_pedido_validacion IS NULL OR pvu.id_proveedor_producto IS NULL, 0, ( pvu.piezas_validadas - pvu.piezas_devueltas ) ) ),
                                (SELECT
                                    ROUND( SUM( IF( pvu.id_pedido_validacion IS NULL OR pvu.id_proveedor_producto IS NULL, 0, ( pvu.piezas_validadas - pvu.piezas_devueltas ) ) ) / cantidad )
                                    FROM ec_productos_detalle
                                    WHERE id_producto = p.id_productos
                                )
                            ) AS quantity,
                            IF( p.es_maquilado = 0, 
                                SUM( IF( pvu.id_pedido_validacion IS NULL OR pvu.id_proveedor_producto IS NOT NULL, 0, ( pvu.piezas_validadas - pvu.piezas_devueltas ) ) ),
                                (SELECT
                                    ROUND( SUM( IF( pvu.id_pedido_validacion IS NULL OR pvu.id_proveedor_producto IS NOT NULL, 0, ( pvu.piezas_validadas - pvu.piezas_devueltas ) ) ) / cantidad )
                                    FROM ec_productos_detalle
                                    WHERE id_producto = p.id_productos
                                )
                            ) AS quantity_to_cancel
                        FROM ec_pedidos_detalle pd
                        LEFT JOIN ec_productos p
                        ON p.id_productos = pd.id_producto
                        LEFT JOIN ec_pedidos_validacion_usuarios pvu
                        ON pvu.id_pedido_detalle = pd.id_pedido_detalle
                        WHERE pd.id_pedido = {$sale_id}
                        GROUP BY pd.id_pedido_detalle
                    )ax
                    GROUP BY ax.row_id
                )ax2
                WHERE restante > 0";
            $stm = $link->query($sql);
            if($stm->rowCount() > 0){
                return 'no';//json_encode($response);
            }
        }catch(PDOException $error){
            return json_encode(array("status"=>"302", "message"=>"Error al consultar si hay algo pendiente de validar.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}"));
        }
        return 'ok';
    }

?>