<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: depurar_logs 
* Path: /depurar_logs
* Método: POST
* Descripción: Depura registros de logs ( tablas de Logs )
  * Version 1 Para depurar registros de sincronizacion de sucursales que no tiene una sucursal local
*/
$app->post('/depurar_sincronizacion_sucursales_sin_servidor_local', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();
    $resp = array();
    $stores = array();
    /*$body = $request->getBody();
    $params = json_decode($body, true);
    $is_complete = ( isset($params['is_complete']) ? $params['is_complete'] : false );*/
//consulta las sucursales que no tiene servidor local
    try{
        $sql = "SELECT id_sucursal AS store_id, nombre AS store_name, prefijo AS store_prefix FROM sys_sucursales WHERE tiene_servidor_local = 0 AND id_sucursal > 0";
        $stm = $link->query($sql);
        while($row = $stm->fetch(PDO::FETCH_ASSOC)){
            $stores[] = $row;
        }
    }catch(PDOException $error){
        $resp['status'] = "302";
        $resp['message'] = "Error al consultar las sucursales que no tienen servidor local.";
        $resp['query'] = "{$sql}";
        $resp['error_detail'] = "{$error->getMessage()}";
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
    /*$payload = json_encode($stores);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);*/
    
//itera arreglo de sucursales sin sedrvidor local
    foreach ($stores as $key => $store) {
    //Actualizar folios unicos de movimientos proveedor producto de la sucursal en local
        try{
            $sql = "UPDATE ec_movimiento_detalle_proveedor_producto 
                        SET folio_unico = IF( folio_unico IS NOT NULL, folio_unico, CONCAT( '{$store['store_prefix']}_MDPP_', id_movimiento_detalle_proveedor_producto ) )
                    WHERE id_sucursal = {$store['store_id']} 
                    AND folio_unico IS NULL";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al actualizar folios unicos de movimientos proveedor producto.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Actualizar folio unicos de validaciones de ventas
        try{
            $sql = "UPDATE ec_pedidos_validacion_usuarios 
                        SET folio_unico = IF( folio_unico IS NOT NULL, folio_unico, CONCAT( '{$store['store_prefix']}_VALID_', id_pedido_validacion ) )
                    WHERE id_sucursal = {$store['store_id']} 
                    AND folio_unico IS NULL";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al actualizar folio unicos de validaciones de ventas.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Actualizar folios unicos de movimientos de almacen
        try{
            $sql = "UPDATE ec_movimiento_almacen ma
                        LEFT JOIN ec_movimiento_detalle md
                        ON md.id_movimiento = ma.id_movimiento_almacen
                        SET ma.folio_unico = IF( ma.folio_unico IS NOT NULL, ma.folio_unico, CONCAT( '{$store['store_prefix']}_MA_', id_movimiento_almacen ) ),
                        md.folio_unico = IF( md.folio_unico IS NOT NULL, ma.folio_unico, CONCAT( '{$store['store_prefix']}_MD_', id_movimiento_almacen_detalle ) )
                    WHERE ma.id_sucursal = {$store['store_id']} 
                    AND ( ma.folio_unico IS NULL OR md.folio_unico IS NULL )";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al actualizar folios unicos de movimientos de almacen.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Actualizar folios unicos de devoluciones
        try{
            $sql = "UPDATE ec_devolucion d
                        LEFT JOIN ec_devolucion_detalle dd
                        ON dd.id_devolucion = d.id_devolucion
                        LEFT JOIN ec_devolucion_pagos dp
                        ON dp.id_devolucion = d.id_devolucion
                        SET d.folio_unico = IF( d.folio_unico IS NOT NULL, d.folio_unico, CONCAT( '{$store['store_prefix']}_DEV_', d.id_devolucion ) ), 
                        dd.folio_unico = IF( dd.folio_unico IS NOT NULL, dd.folio_unico, CONCAT( '{$store['store_prefix']}_DEVDET_', dd.id_devolucion_detalle ) ), 
                        dp.folio_unico = IF( dp.folio_unico IS NOT NULL, dp.folio_unico, CONCAT( '{$store['store_prefix']}_DEVPAG_', dp.id_devolucion_pago ) )
                    WHERE id_sucursal = {$store['store_id']} 
                    AND ( d.folio_unico IS NULL OR dd.folio_unico IS NULL OR dp.folio_unico IS NULL )";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al actualizar folios unicos de devoluciones.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Actualizar folios unicos de ventas
        try{
            $sql = "UPDATE ec_pedidos p
                        LEFT JOIN ec_pedidos_detalle pd
                        ON pd.id_pedido = p.id_pedido
                        LEFT JOIN ec_pedido_pagos pp
                        ON pp.id_pedido = p.id_pedido
                        SET p.folio_unico = IF( p.folio_unico IS NOT NULL, p.folio_unico, CONCAT( '{$store['store_prefix']}_VTA_', p.id_pedido ) ),
                        pd.folio_unico = IF( pd.folio_unico IS NOT NULL, pd.folio_unico, CONCAT( '{$store['store_prefix']}_VTADET_', pd.id_pedido_detalle ) ),
                        pp.folio_unico = IF( pp.folio_unico IS NOT NULL, pp.folio_unico, CONCAT( '{$store['store_prefix']}_VTAPAG_', pp.id_pedido_pago ) )
                    WHERE p.id_sucursal = {$store['store_id']} 
                    AND ( p.folio_unico IS NULL OR pd.folio_unico IS NULL OR pp.folio_unico IS NULL )";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al actualizar folios unicos de ventas.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar los registros de sincronizacion
        try{
            $sql = "DELETE FROM sys_sincronizacion_registros WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar registros de sincronizacion.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }        
    //Eliminar sincronizacion de ventas de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_ventas WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar sincronizacion de ventas de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar registros de sincronizacion de validaciones de ventas de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_validaciones_ventas WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar registros de sincronizacion de validaciones de ventas de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar registros de sincronizacion de ventas de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_registros_ventas WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
//error_log("QUERY : {$sql}");
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar registros de sincronizacion de ventas de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar registros de sincronizacion de transferencias de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_registros_transferencias WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar registros de sincronizacion de transferencias de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar registros de sincronizacion de movimientos proveedor producto de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_registros_movimientos_proveedor_producto WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar registros de sincronizacion de movimientos proveedor producto de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar registros de sincronizacion de movimientos almacen de la sucursal en linea
        try{
            $sql = "DELETE FROM sys_sincronizacion_registros_movimientos_almacen WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar registros de sincronizacion de movimientos almacen de la sucursal en linea.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar sincronizacion de movimientos de almacen de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_movimientos_almacen WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar sincronizacion de movimientos de almacen de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    //Eliminar sincronizacion de devoluciones de la sucursal
        try{
            $sql = "DELETE FROM sys_sincronizacion_devoluciones WHERE id_sucursal_destino = {$store['store_id']}";
            $link->query($sql);
//error_log("QUERY : {$sql}");
        }catch(PDOException $error){
            $resp['status'] = "302";
            $resp['message'] = "Error al eliminar sincronizacion de devoluciones de la sucursal.";
            $resp['query'] = "{$sql}";
            $resp['error_detail'] = "{$error->getMessage()}";
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    }

    $link = null;//cierra conexion Mysql
    $resp['status'] = "200";
    $resp['message'] = "Depuracion de sincronizacion de sucursales sin servidor local exitosa.";
    $payload = json_encode($resp);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>

