<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: depurar_logs 
* Path: /depurar_logs
* Método: POST
* Descripción: Depura registros de logs ( tablas de Logs )
  * Version 1.1 Para depurar logs ( 2024-08-03 )
  * Version Oscar 2024-11-08 para deshabilitar el consumo de depuracion de registros logs sincronizacion al servidor en linea 
*/
$app->post('/depurar_logs', function (Request $request, Response $response){
  $db = new db("../../");//Instancia BD General
  $link = $db->conectDB();
  
  $body = $request->getBody();
  $params = json_decode($body, true);
  $is_complete = ( isset($params['is_complete']) ? $params['is_complete'] : false );//$request->getParam( "store_id" );
  if($is_complete != false || $is_complete != null){
    $is_complete = true;
  }
  $row = null;
  $system_store = null;
  $api_path = null;
  $limit_date = null;

//consulta el tipo de sistema y path de linea
  try{
    $sql = "SELECT 
            id_sucursal,
            ( SELECT value FROM api_config WHERE name = 'path' ) AS api_path
            FROM sys_sucursales WHERE acceso = 1";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
    $system_store = $row['id_sucursal'];
    $api_path = $row['api_path'];
  }catch(PDOException $error){
    $response->getBody()->write("Error al consultar configuraciones del sistema : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
//consulta el intervalo de depuracion
  try{
    $sql = "SELECT 
            cs.dias_retardo_limpieza_sincronizacion
        FROM sys_sucursales s 
        LEFT JOIN ec_configuracion_sucursal cs
        ON s.id_sucursal = cs.id_sucursal
        WHERE s.acceso = 1";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
  }catch(PDOException $error){
    $response->getBody()->write("rror al consultar sucursal de logueo : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
//consulta fecha para registros de log
  try{
    $sql = "SELECT DATE_FORMAT( date_add(NOW(), INTERVAL -{$row['dias_retardo_limpieza_sincronizacion']} DAY), '%Y-%m-%d' ) AS limit_date";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
    $limit_date = $row['limit_date'];
  }catch(PDOException $error){
    $response->getBody()->write("Error al consultar rango de fecha para depurar registros : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
//consulta el intervalo de depuracion
  try{
    $sql = "SELECT minutos_antiguedad_depuracion_log FROM sys_configuracion_sistema";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
    $minutos_antiguedad = $row['minutos_antiguedad_depuracion_log'];
    if( $is_complete ){
        $minutos_antiguedad = 0;
    }
  }catch(PDOException $error){
    $response->getBody()->write("Error al consultar la antigüedad para eliminar registros de sincronizacion : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }

  try{
    $sql = "SELECT NOW() AS fecha_hora_actual, DATE_SUB(NOW(), INTERVAL {$minutos_antiguedad} MINUTE) AS fecha_hora_modificada";
    $stm = $link->query( $sql );
    $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc
    $fecha_antiguedad = $row['fecha_hora_modificada'];
  }catch(PDOException $error){
    $response->getBody()->write("Error al consultar fecha y hora para eliminar registros de sincronizacion : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }

//$link->autocommit( false );//inicio de trasaccion
/*Eliminacion de registros de tablas de log de sincronizacion*/
  try{
    $sql = "DELETE FROM LOG_sincronizaciones WHERE fecha_alta <= '{$fecha_antiguedad}'";
    $link->query( $sql );
  }catch(PDOException $error){
    $response->getBody()->write("Error al eliminar en LOG_sincronizaciones : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
  try{
    $sql = "DELETE FROM LOG_sincronizacion_pasos WHERE fecha_alta <= '{$fecha_antiguedad}'";
    $link->query( $sql );
  }catch(PDOException $error){
    $response->getBody()->write("Error al eliminar en LOG_sincronizacion_pasos : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
  try{
    $sql = "DELETE FROM LOG_sincronizacion_pasos_errores WHERE fecha_alta <= '{$fecha_antiguedad}'";
    $link->query( $sql );
  }catch(PDOException $error){
    $response->getBody()->write("Error al eliminar en LOG_sincronizacion_pasos_errores : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
/**/
/*Eliminacion de registros de tablas de log de cobros*/
try{
    $sql = "DELETE FROM LOG_cobros WHERE fecha_alta <= '{$fecha_antiguedad}'";
    $link->query( $sql );
  }catch(PDOException $error){
    $response->getBody()->write("Error al eliminar en LOG_cobros : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
  try{
    $sql = "DELETE FROM LOG_cobros_pasos WHERE fecha_alta <= '{$fecha_antiguedad}'";
    $link->query( $sql );
  }catch(PDOException $error){
    $response->getBody()->write("Error al eliminar en LOG_cobros_pasos : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
  try{
    $sql = "DELETE FROM LOG_cobros_pasos_errores WHERE fecha_alta <= '{$fecha_antiguedad}'";
    $link->query( $sql );
  }catch(PDOException $error){
    $response->getBody()->write("Error al eliminar en LOG_cobros_pasos_errores : {$sql} : {$error->getMessage()}");
    return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
  }
/**/
//$link->autocommit( true );//autoriza transaccion

//cierra conexion Mysql
  $link = null;
  $response->getBody()->write("Depuracion exitosa.");
  return $response->withHeader('Content-Type', 'application/json')->withStatus(200);

/*Deshabilitado por Oscar 2024-11-08 para deshabilit ar el consumo de depuracion de registros logs sincronizacion al servidor en linea  
  if( $system_store != -1 ){//envia peticion a linea
    $resp = "";
    $post_data = json_encode( array( "is_complete"=>$is_complete ) );
    $url = "{$api_path}/rest/crones/depurar_logs";
    $crl = curl_init( $url );
    curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($crl, CURLINFO_HEADER_OUT, true);
    curl_setopt($crl, CURLOPT_POST, true);
    curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
    curl_setopt($crl, CURLOPT_TIMEOUT, 60000);
    curl_setopt($crl, CURLOPT_HTTPHEADER, array(
      'Content-Type: application/json',
      'token: ' . $token)
    );
    $resp = curl_exec($crl);//envia peticion
    curl_close($crl);
    if( $logger_id ){
      $log_steep_id = $this->LOGGER->insertLoggerSteepRow( $logger_id, "Envia peticion a {$url}", $post_data );
    }
    //var_dump( $resp );
    //return $resp;
  }*/
//regresa respuesta
  //die('ok');
  //return json_encode( array( "response" => "Ventas ok!" ) );
});

?>

