<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: ejecuta_select
* Path: /ejecuta_select
* Método: POST
* Descripción: Ejecuta instruccion SELECT en Mysql
*/
$app->post('/ejecuta_select', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();

    $body = $request->getBody();
    $params = json_decode($body, true);
    $sql = ( isset($params['QUERY']) ? $params['QUERY'] : '' );//$request->getParam( "store_id" );
    if($sql == ''){
        $resp = array("status"=>400, "message"=>"El parametro QUERY no pude ser vacio.");
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }else{
        $validation_array = explode(" ", $sql);
        if(strtoupper($validation_array[0]) != "SELECT"){
            $resp = array("status"=>400, "message"=>"La consulta tiene que ser de tipo 'SELECT'");
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    }
    
    $resp = array();
    $stm = null;
    try{
        $stm = $link->query( $sql );// or die( "Error : {$sql}" );
    }catch(PDOException $error){
      $resp = array("status"=>400, "message"=>"Error al ejecutar consulta SELECT", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}");
      $payload = json_encode($resp);
      $response->getBody()->write($payload);
      return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
    while ( $row = $stm->fetch(PDO::FETCH_ASSOC) ){//_assoc
      array_push( $resp, $row );
    }
    //registros de sincronizacion 
    $response->getBody()->write(json_encode($resp));
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>