<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: ejecuta_insert
* Path: /ejecuta_insert
* Método: POST
* Descripción: Ejecuta instruccion INSERT en Mysql
*/
$app->post('/ejecuta_insert', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();

    $body = $request->getBody();
    $params = json_decode($body, true);
    $sql = ( isset($params['QUERY']) ? $params['QUERY'] : '' );//$request->getParam( "store_id" );
    if($sql == ''){
        $resp = array("status"=>400, "message"=>"El parametro QUERY no pude ser vacio.");
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }else{
        $validation_array = explode(" ", $sql);
        if(strtoupper($validation_array[0]) != "INSERT"){
            $resp = array("status"=>400, "message"=>"La consulta tiene que ser de tipo 'INSERT'");
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    }

    try{
        $link->query( $sql );// or die( "Error : {$sql}" );
    }catch(PDOException $error){
        $resp = array("status"=>400, "message"=>"Error al ejecutar consulta INSERT", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}");
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
//registros de sincronizacion
    $resp = array("status"=>200, "message"=>"Insercion ejecutada exitosamente.");
    $payload = json_encode($resp);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>