<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;
/*
* Endpoint: ejecuta_delete
* Path: /ejecuta_delete
* Método: POST
* Descripción: Ejecuta instruccion DELETE en Mysql
*/
$app->post('/ejecuta_delete', function (Request $request, Response $response){
    $db = new db("../../");//Instancia BD General
    $link = $db->conectDB();

    $body = $request->getBody();
    $params = json_decode($body, true);
    $sql = ( isset($params['QUERY']) ? $params['QUERY'] : '' );//$request->getParam( "store_id" );
    if($sql == ''){
        $resp = array("status"=>400, "message"=>"El parametro QUERY no pude ser vacio.");
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }else{
        $validation_array = explode(" ", $sql);
        if(strtoupper($validation_array[0]) != "DELETE"){
            $resp = array("status"=>400, "message"=>"La consulta tiene que ser de tipo 'DELETE'");
            $payload = json_encode($resp);
            $response->getBody()->write($payload);
            return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
        }
    }

    try{
        $link->query( $sql );// or die( "Error : {$sql}" );
    }catch(PDOException $error){
        $resp = array("status"=>400, "message"=>"Error al ejecutar consulta DELETE", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}");
        $payload = json_encode($resp);
        $response->getBody()->write($payload);
        return $response->withHeader('Content-Type', 'application/json')->withStatus(400);
    }
//registros de sincronizacion
    $resp = array("status"=>200, "message"=>"Eliminacion ejecutada exitosamente.");
    $payload = json_encode($resp);
    $response->getBody()->write($payload);
    return $response->withHeader('Content-Type', 'application/json')->withStatus(200);
});

?>