DROP TRIGGER IF EXISTS insertaRangoUbicacionSucursal|
DELIMITER $$
CREATE TRIGGER insertaRangoUbicacionSucursal
AFTER INSERT ON ec_rangos_ubicaciones_sucursales
FOR EACH ROW
BEGIN
	DECLARE store_id INTEGER;
/*Consulta tipo de sistema*/
	SELECT id_sucursal INTO store_id FROM sys_sucursales WHERE acceso=1;
/*inserta registro de sincronizacion si es el caso*/
	IF( store_id = -1 AND new.sincronizar != 0 )
	THEN
		INSERT INTO sys_sincronizacion_registros ( id_sincronizacion_registro, sucursal_de_cambio,
		id_sucursal_destino, datos_json, fecha, tipo, status_sincronizacion )
		SELECT 
			NULL,
			store_id,
			id_sucursal,
			CONCAT('{',
				'"table_name" : "ec_rangos_ubicaciones_sucursales",',
				'"action_type" : "insert",',
				'"primary_key" : "id_rango_ubicacion_sucursal",',
				'"primary_key_value" : "', new.id_rango_ubicacion_sucursal, '",',
				'"id_sucursal" : "', new.id_sucursal, '",',
				'"nombre" : "', new.nombre, '",',
				'"nivel_piso_sucursal" : "', new.nivel_piso_sucursal, '",',
				'"desde" : "', new.desde, '",',
				'"hasta" : "', new.hasta, '",',
				'"sincronizar" : "0"',
				'}'
			),
			NOW(),
			'insertaRangoUbicacionSucursal',
			1
		FROM sys_sucursales 
		WHERE id_sucursal > 0;
	END IF;
END $$