DROP TRIGGER IF EXISTS actualizaSucProd|
DELIMITER $$
CREATE TRIGGER actualizaSucProd
BEFORE UPDATE ON sys_sucursales_producto
FOR EACH ROW
BEGIN
    DECLARE store_id INTEGER;
    DECLARE location_counter INTEGER;
    DECLARE next_id INTEGER;
    DECLARE warehouse_id INTEGER;
    DECLARE line_prefix VARCHAR(20);

    IF(new.id_sucursal!=old.id_sucursal OR new.id_producto!=old.id_producto
        OR new.minimo_surtir!=old.minimo_surtir OR new.estado_suc!=old.estado_suc
        OR new.ubicacion_almacen_sucursal!=old.ubicacion_almacen_sucursal 
        OR new.es_externo != old.es_externo OR new.surtir != old.surtir )
    THEN
        SELECT id_sucursal INTO store_id FROM sys_sucursales WHERE acceso=1;
	    IF( new.sincronizar != 0 )
        THEN
            INSERT INTO sys_sincronizacion_registros ( id_sincronizacion_registro, sucursal_de_cambio,
            id_sucursal_destino, datos_json, fecha, tipo, status_sincronizacion )
            SELECT 
                NULL,
                store_id,
                id_sucursal,
                CONCAT('{',
                    '"table_name" : "sys_sucursales_producto",',
                    '"action_type" : "update",',
                    '"primary_key" : "id_sucursal",',
                    '"primary_key_value" : "', new.id_sucursal, '",',
                    '"secondary_key" : "id_producto",',
                    '"secondary_key_value" : "', new.id_producto, '",',
                    '"id_sucursal" : "', new.id_sucursal, '",',
                    '"id_producto" : "', new.id_producto, '",',
                    '"minimo_surtir" : "', new.minimo_surtir, '",',
                    '"estado_suc" : "', new.estado_suc, '",',
                    '"ubicacion_almacen_sucursal" : "', IF( new.ubicacion_almacen_sucursal IS NULL, '', new.ubicacion_almacen_sucursal ), '",',
                    '"ultima_modificacion" : "', new.ultima_modificacion, '",',
                    '"es_externo" : "', new.es_externo, '",',
                    '"stock_bajo" : "', new.stock_bajo, '",',
                    '"ajuste_realizado" : "', new.ajuste_realizado, '",',
                    '"racion_1" : "', new.racion_1, '",',
                    '"racion_2" : "', new.racion_2, '",',
                    '"racion_3" : "', new.racion_3, '",',
                    '"surtir" : "', new.surtir, '",',
                    '"sincronizar" : "0"',
                    '}'
                ),
                NOW(),
                'actualizaSucProd.sql',
                1
            FROM sys_sucursales 
            WHERE id_sucursal = IF( store_id = -1, new.id_sucursal, -1 );
        /*Implementacion Oscar 2025-08-28 para insertar la ubicacion si se habilita el check de surtir y no existe la ubicacion*/
            IF(new.surtir = 1 OR new.surtir = '1')
            THEN
                SELECT COUNT(*) INTO location_counter FROM ec_sucursal_producto_ubicacion_almacen WHERE id_sucursal = new.id_sucursal AND id_producto = new.id_producto;
                IF(location_counter <= 0)
                THEN
                    SELECT
                        (MAX(id_ubicacion_sucursal)+1),
                        (SELECT id_almacen FROM ec_almacen WHERE id_sucursal = new.id_sucursal AND es_almacen = 1),
                        (SELECT prefijo FROM sys_sucursales WHERE id_sucursal =-1)
                    INTO
                        location_counter,
                        warehouse_id,
                        line_prefix
                    FROM ec_sucursal_producto_ubicacion_almacen
                    WHERE 1;
                /*inserta registro de ubicacion en almacen*/
                    INSERT INTO `ec_sucursal_producto_ubicacion_almacen`(`id_sucursal`, `id_almacen`, `id_producto`, `inventario_acumulado`, `numero_ubicacion_desde`, `numero_ubicacion_hasta`, 
                    `pasillo_desde`, `pasillo_hasta`, `altura_desde`, `altura_hasta`, `habilitado`, `es_principal`, `fecha_alta`, `folio_unico`, `sincronizar`) 
                    VALUES (new.id_sucursal,warehouse_id, new.id_producto,'0','0','0','0','0','a','a','1','1', NOW(), CONCAT(line_prefix, '_UBIC_', location_counter), '1');
                /*inserta el registro de sincronizacion*/
                    INSERT INTO sys_sincronizacion_registros ( id_sincronizacion_registro, sucursal_de_cambio,
                    id_sucursal_destino, datos_json, fecha, tipo, status_sincronizacion )
                    SELECT 
                        NULL,
                        store_id,
                        id_sucursal,
                        CONCAT('{',
                            '"table_name" : "ec_sucursal_producto_ubicacion_almacen",',
                            '"action_type" : "insert",',
                            '"primary_key" : "id_sucursal",',
                            '"primary_key_value" : "', location_counter, '",',
                            '"id_sucursal" : "', new.id_sucursal, '",',
                            '"id_almacen" : "', warehouse_id, '",',
                            '"id_producto" : "', new.id_producto, '",',
                            '"inventario_acumulado" : "0",',
                            '"numero_ubicacion_desde" : "0",',
                            '"numero_ubicacion_hasta" : "0",',
                            '"pasillo_desde" : "0",',
                            '"pasillo_hasta" : "0",',
                            '"altura_desde" : "a",',
                            '"altura_hasta" : "a",',
                            '"habilitado" : "1",',
                            '"es_principal" : "1",',
                            '"folio_unico" : "', CONCAT(line_prefix, '_UBIC_', location_counter), '",',
                            '"sincronizar" : "0"',
                            '}'
                        ),
                        NOW(),
                        'actualizaSucProd.sql',
                        1
                    FROM sys_sucursales 
                    WHERE id_sucursal = IF( store_id = -1, new.id_sucursal, -1 );
                END IF;
            END IF;
        /*finde cambio Oscar 2025-08-28*/
        END IF;
    END IF;
    SET new.sincronizar=1;
END $$