DROP TRIGGER IF EXISTS actualizaSesionCajaTerminales|
DELIMITER $$
CREATE TRIGGER actualizaSesionCajaTerminales
BEFORE UPDATE ON ec_sesion_caja_terminales
FOR EACH ROW
BEGIN
    DECLARE store_id INTEGER;
    DECLARE store_id_session INTEGER;
    SELECT id_sucursal INTO store_id FROM sys_sucursales WHERE acceso = 1;
    SELECT id_sucursal INTO store_id_session FROM ec_sesion_caja WHERE id_sesion_caja = new.id_sesion_caja;
/*Creacion de registro de sincronizacion*/
    IF( new.sincronizar = 1 )
	THEN
		INSERT INTO sys_sincronizacion_registros ( id_sincronizacion_registro, sucursal_de_cambio,
		id_sucursal_destino, datos_json, fecha, tipo, status_sincronizacion )
		SELECT 
			NULL,
			store_id,
			id_sucursal,
			CONCAT('{',
				'"table_name" : "ec_sesion_caja_terminales",',
				'"action_type" : "update",',
				'"primary_key" : "folio_unico",',
				'"primary_key_value" : "', new.folio_unico, '",',
				'"id_sesion_caja" : "(SELECT id_sesion_caja FROM ec_sesion_caja WHERE folio_unico = \'', (SELECT folio_unico FROM ec_sesion_caja WHERE id_sesion_caja = new.id_sesion_caja LIMIT 1), '\')",',
				'"id_cajero" : "', new.id_cajero, '",',
				'"id_terminal" : "', new.id_terminal, '",',
				'"monto_corte_caja" : "', new.monto_corte_caja, '",',
				'"monto_validacion" : "', new.monto_validacion, '",',
				'"habilitado" : "', new.habilitado, '",',
				'"insertada_por_error_en_cobro" : "', new.insertada_por_error_en_cobro, '",',
				'"utilizada_en_error" : "', new.utilizada_en_error, '",',
				'"folio_unico" : "', IF( new.folio_unico IS NULL, '', new.folio_unico ), '",',
				'"sincronizar" : "0"',
				'}'
			),
			NOW(),
			0,
			1
		FROM sys_sucursales 
		WHERE id_sucursal = IF( store_id = -1, store_id_session, -1 );
	END IF;
/*fin de creacion de registro de sincronizacion*/
    IF( new.monto_validacion != old.monto_validacion )
    THEN
        UPDATE ec_movimiento_banco 
            SET monto=new.monto_validacion
        WHERE id_ingreso_corte_caja != -1 
        AND id_ingreso_corte_caja = new.id_sesion_caja_terminales
        AND id_afiliacion = -1
        AND id_terminal = new.id_terminal;
    END IF;
    SET new.sincronizar = 1;
END $$