DROP TRIGGER IF EXISTS eliminaClientes|
DELIMITER $$
CREATE TRIGGER eliminaClientes
AFTER DELETE ON ec_clientes
FOR EACH ROW
BEGIN
  DECLARE store_id INT(11);
  SELECT id_sucursal INTO store_id FROM sys_sucursales WHERE acceso = 1;

  INSERT INTO sys_sincronizacion_registros ( id_sincronizacion_registro, sucursal_de_cambio, id_sucursal_destino, 
    datos_json, fecha, tipo, status_sincronizacion )
  SELECT 
    NULL,
    store_id,
    id_sucursal,
    CONCAT('{', 
      '"table_name" : "ec_clientes",',
      '"action_type" : "delete",',
      '"primary_key" : "folio_unico",',
      '"primary_key_value" : "', old.folio_unico, '"',
      '}'
     ),
    NOW(),
    1,
    2
  FROM sys_sucursales 
  WHERE id_sucursal = IF( store_id = -1, old.id_sucursal, -1 );
END $$
