DROP PROCEDURE IF EXISTS generaRegistroSincronizacionVenta| 
DELIMITER $$
CREATE PROCEDURE generaRegistroSincronizacionVenta( IN sale_header_id BIGINT, IN teller_session_id INT, IN origin_store_id INTEGER(11) )/*IN folio_unico_movimiento_almacen VARCHAR( 30 )*/
BEGIN
	DECLARE done INT DEFAULT FALSE;
	DECLARE client_unique_folio VARCHAR( 30 );
    DECLARE teller_session_unique_folio VARCHAR( 30 );
    DECLARE id_pedido_relacion INT( 11 ) DEFAULT NULL;

	SELECT 
		c.folio_unico 
		INTO 
		client_unique_folio 
	FROM ec_pedidos p
	LEFT JOIN ec_clientes c
	ON p.id_cliente = c.id_cliente
	WHERE p.id_pedido = sale_header_id
	LIMIT 1;

	IF( teller_session_id IS NOT NULL AND teller_session_id > 0 )
	THEN
		SELECT 
	        folio_unico INTO teller_session_unique_folio 
        FROM ec_sesion_caja 
        WHERE id_sesion_caja = teller_session_id
		LIMIT 1;
	END IF;
	/*SET GLOBAL group_concat_max_len = 900000;*/
	INSERT INTO sys_sincronizacion_ventas ( id_sincronizacion_venta, json, tabla, registro_llave, id_sucursal_destino, id_status_sincronizacion )
	SELECT
		NULL,
		CONCAT(
			'{',
				'"folio_nv" : "', IF( ped.folio_nv IS NULL, '', ped.folio_nv ), '",\n',
				'"id_cliente" : "',
				IF( ped.id_cliente = 1 OR ped.id_cliente = -1, 
					ped.id_cliente, 
					CONCAT( '( SELECT id_cliente FROM ec_clientes WHERE folio_unico = \'', client_unique_folio ,'\' )' )  
				),
				'",\n',
				'"fecha_alta" : "', ped.fecha_alta, '",\n',
				'"subtotal" : "', ped.subtotal, '",\n',
				'"total" : "', ped.total, '",\n',
				'"pagado" : "', ped.pagado, '",\n',
				'"id_sucursal" : "', ped.id_sucursal, '",\n',
				'"id_usuario" : "', ped.id_usuario, '",\n',
				'"descuento" : "', ped.descuento, '",\n',
				'"folio_abono" : "', IF( ped.folio_abono IS NULL, '', ped.folio_abono ), '",\n',
				'"correo" : "', REPLACE( REPLACE( ped.correo, 'no aplica', '-' ), 'No aplica', '' ), '",\n',
				'"facebook" : "', REPLACE( REPLACE( ped.facebook, 'no aplica', '-' ), 'No aplica', '' ), '",\n',
				'"ultima_sincronizacion" : "', IF( ped.ultima_sincronizacion IS NULL, '', DATE_FORMAT( ped.ultima_sincronizacion, "%Y-%m-%d" ) ), '",\n',
				'"ultima_modificacion" : "', DATE_FORMAT( ped.ultima_modificacion, "%Y-%m-%d" ), '",\n',
				'"tipo_pedido" : "', ped.tipo_pedido, '",\n',
				'"id_status_agrupacion" : "', ped.id_status_agrupacion, '",\n',
				'"id_cajero" : "', ped.id_cajero, '",\n',
				'"id_devoluciones" : "', ped.id_devoluciones, '",\n',
				'"venta_validada" : "', ped.venta_validada, '",\n',
				'"tipo_sistema" : "', ped.tipo_sistema, '",\n',
				'"folio_unico" : "', ped.folio_unico, '",\n',
				'"cobro_finalizado" : "', ped.cobro_finalizado, '",\n',
				'"id_status_facturacion" : "', ped.id_status_facturacion, '"',
                IF( ped.id_sesion_caja != 0, 
                    CONCAT( ',\n"id_sesion_caja" : "( SELECT id_sesion_caja FROM ec_sesion_caja WHERE folio_unico = \'', teller_session_unique_folio, '\' LIMIT 1 )"\n' ),
                    ',"id_sesion_caja" : "0"'
                ),
				( SELECT 
					IF( ped_det.id_pedido_detalle IS NOT NULL,
						CONCAT( ', "sale_detail" : [\n',
							GROUP_CONCAT(
							DISTINCT( CONCAT( 
									'{',
										'"id_producto" : "', ped_det.id_producto, '",\n',
										'"cantidad" : "', ped_det.cantidad, '",\n',
										'"precio" : "', ped_det.precio, '",\n',
										'"monto" : "', ped_det.monto, '",\n',
										'"cantidad_surtida" : "', ped_det.cantidad_surtida, '",\n',
										'"descuento" : "', ped_det.descuento, '",\n',
										'"es_externo" : "', ped_det.es_externo, '",\n',
										'"id_precio" : "', ped_det.id_precio, '",\n',
										'"folio_unico" : "', ped_det.folio_unico, '"\n',
									'}\n'
								) )
								SEPARATOR ','
							),
							']\n'
						),
						''
					)
				FROM ec_pedidos_detalle ped_det
				WHERE ped_det.id_pedido = ped.id_pedido
			),
			(SELECT
				CONCAT(
				',"return_reference" : [{',
					'"id_pedido" : " ( SELECT id_pedido FROM ec_pedidos WHERE folio_unico = \'', (SELECT folio_unico FROM ec_pedidos WHERE id_pedido = sale_header_id LIMIT 1),'\' )",',
					'"total_venta" : "', prd.total_venta,'",',
					'"monto_venta_mas_ultima_devolucion" : "', prd.monto_venta_mas_ultima_devolucion, '",',
					'"saldo_a_favor" : "', prd.saldo_a_favor, '",',
					'"folio_unico" : "', prd.folio_unico, '",',
					'"sincronizar" : "0"',
				'}]'
				)
			FROM ec_pedidos_referencia_devolucion prd
			WHERE prd.id_pedido = sale_header_id
			LIMIT 1
			),
			'}'
		),
		'ec_pedidos',
		ped.folio_unico,
		IF( origin_store_id = -1, ped.id_sucursal, -1 ),
		1
	FROM ec_pedidos ped
	WHERE ped.id_pedido = sale_header_id
	GROUP BY ped.id_pedido;
/*manda actualizar el temporal de exhibicion si es el caso*/
	UPDATE ec_temporal_exhibicion SET sincronizar = 1 WHERE id_pedido = sale_header_id;
/*Implementacion Oscar 2025-05-14 para sincronizar tabla ec_pedidos_relacion_devolucion*/
	SELECT id_pedido_relacion_devolucion INTO id_pedido_relacion FROM ec_pedidos_relacion_devolucion WHERE id_pedido_relacionado = sale_header_id AND (folio_unico IS NULL OR folio_unico = '');
	IF( id_pedido_relacion IS NOT NULL)
	THEN
	/*Actualiza el folio unico de la relacion de devolucion*/
		UPDATE ec_pedidos_relacion_devolucion SET folio_unico = CONCAT( (SELECT prefijo FROM sys_sucursales WHERE acceso = 1), "_PRD_", id_pedido_relacion) WHERE id_pedido_relacion_devolucion = id_pedido_relacion;
	/*Crea registros de sincronizacion*/
		INSERT INTO `sys_sincronizacion_registros_ventas`( `sucursal_de_cambio`, `id_sucursal_destino`, `datos_json`, `fecha`, `tipo`, `status_sincronizacion`)
		SELECT
			(SELECT id_sucursal FROM sys_sucursales WHERE acceso = 1 ),
			(SELECT IF(id_sucursal > 0, -1, p1.id_sucursal ) FROM sys_sucursales WHERE acceso = 1 ),
			CONCAT('{\n"action_type" : "insert",\n',
				'"table_name" : "ec_pedidos_relacion_devolucion",\n',
				'"primary_key" : "folio_unico",\n',
				CONCAT( '"primary_key_value" : "', IF(prd.folio_unico IS NULL, '', prd.folio_unico) , '",\n'),
				IF( p1.folio_unico IS NULL,
					'',
					CONCAT('"id_pedido_original" : "(SELECT id_pedido FROM ec_pedidos WHERE folio_unico =\'',p1.folio_unico,'\')",\n')
				),
				IF( prd.monto_pedido_original IS NULL,
					'',
					CONCAT('"monto_pedido_original" : "',prd.monto_pedido_original,'",\n')
				),
				IF( (SELECT folio_unico FROM ec_sesion_caja WHERE id_sesion_caja = prd.id_sesion_caja_pedido_orginal) IS NULL,
					'',
					CONCAT('"id_sesion_caja_pedido_orginal" : "(SELECT id_sesion_caja FROM ec_sesion_caja WHERE folio_unico =\'',(SELECT folio_unico FROM ec_sesion_caja WHERE id_sesion_caja = prd.id_sesion_caja_pedido_orginal),'\')",\n')
				),
				IF( (SELECT folio_unico FROM ec_devolucion WHERE id_devolucion = prd.id_devolucion_interna) IS NULL,
					'',
					CONCAT('"id_devolucion_interna" : "(SELECT id_devolucion FROM ec_devolucion WHERE folio_unico =\'',(SELECT folio_unico FROM ec_devolucion WHERE id_devolucion = prd.id_devolucion_interna),'\')",\n')
				),
				IF( prd.monto_devolucion_interna IS NULL,
					'',
					CONCAT('"monto_devolucion_interna" : "',prd.monto_devolucion_interna,'",\n')
				),
				IF( (SELECT folio_unico FROM ec_devolucion WHERE id_devolucion = prd.id_devolucion_externa) IS NULL,
					'',
					CONCAT('"id_devolucion_externa" : "(SELECT id_devolucion FROM ec_devolucion WHERE folio_unico =\'',(SELECT folio_unico FROM ec_devolucion WHERE id_devolucion = prd.id_devolucion_externa),'\')",\n')
				),
				IF( prd.monto_devolucion_externa IS NULL,
					'',
					CONCAT('"monto_devolucion_externa" : "',prd.monto_devolucion_externa,'",\n')
				),
				IF( p2.folio_unico IS NULL,
					'',
					CONCAT('"id_pedido_relacionado" : "(SELECT id_pedido FROM ec_pedidos WHERE folio_unico =\'',p2.folio_unico,'\')",\n')
				),
				IF( prd.saldo_a_favor IS NULL,
					'',
					CONCAT('"saldo_a_favor" : "',prd.saldo_a_favor,'",\n')
				),
				IF( prd.monto_devolucion_tomado_a_favor IS NULL,
					'',
					CONCAT('"monto_devolucion_tomado_a_favor" : "',prd.monto_devolucion_tomado_a_favor,'",\n')
				),
				IF( prd.monto_interno_por_devolver IS NULL,
					'',
					CONCAT('"monto_interno_por_devolver" : "',prd.monto_interno_por_devolver,'",\n')
				),
				IF( prd.monto_externo_por_devolver IS NULL,
					'',
					CONCAT('"monto_externo_por_devolver" : "',prd.monto_externo_por_devolver,'",\n')
				),
				IF( p2.total IS NULL,
					'',
					CONCAT('"monto_pedido_relacionado" : "',p2.total,'",\n')
				),
				IF( (SELECT folio_unico FROM ec_sesion_caja WHERE id_sesion_caja = prd.id_sesion_caja_pedido_relacionado) IS NULL,
					'',
					CONCAT('"id_sesion_caja_pedido_relacionado" : "(SELECT id_sesion_caja FROM ec_sesion_caja WHERE folio_unico =\'',(SELECT folio_unico FROM ec_sesion_caja WHERE id_sesion_caja = prd.id_sesion_caja_pedido_relacionado),'\')",\n')
				),
				IF( prd.folio_unico IS NULL,
					'',
					CONCAT('"folio_unico" : "',prd.folio_unico,'",\n')
				),
				'"sincronizar" : "1"\n',
			'}'),
			NOW(),
			'generaRegistroSincronizacionVenta',
			1
		FROM ec_pedidos_relacion_devolucion prd
		LEFT JOIN ec_pedidos p1
		ON prd.id_pedido_original = p1.id_pedido
		LEFT JOIN ec_pedidos p2
		ON prd.id_pedido_relacionado = p2.id_pedido
		WHERE prd.id_pedido_relacion_devolucion = id_pedido_relacion;
	END IF;
/*fin de cambio Oscar 2025-05-14*/
/**/
END $$