/************************************************************************
*                                                                       *
*                        <Scripts en Produccion>                        *
*                                                                       *
*************************************************************************/
    INSERT INTO `sys_herramientas` (`id_herramienta`, `titulo`, `consulta`, `descripcion`, `campo_filtro_sucursal`, `campo_filtro_fecha1`, `campo_filtro_fecha2`, `campo_filtro_familia`, `campo_filtro_tipo`, `campo_filtro_subtipo`, `campo_filtro_color`, `campo_filtro_almacen`, `campo_filtro_es_externo`, `tipo_herramienta`) VALUES
    (8, 'Comparación entre inventario calculado e inventario acumulado', 'SELECT\n	ax.id_producto,\n        ax.nombre,\n        ax.nombre_etiqueta,\n        ax.precio_venta,\n        ax.inventario_producto AS invCalculado,\n        sp.inventario AS invAcumulado\nFROM(\n    SELECT\n    	p.id_productos AS id_producto,\n        p.nombre,\n        p.nombre_etiqueta,\n    	(SUM(IF(mi.id_movimiento_inventario IS NULL, 0, (tm.afecta*dm.cantidad)))) AS inventario_producto,\n    	p.precio_venta\n    FROM ec_productos p\n    LEFT JOIN ec_detalle_movimiento dm\n    ON p.id_productos = dm.id_producto\n    LEFT JOIN ec_movimiento_inventario mi\n    ON mi.id_movimiento_inventario = dm.id_movimiento_inventario\n    LEFT JOIN ec_tipos_movimiento tm\n    ON tm.id_movimiento = mi.id_tipo_movimiento\n    GROUP BY p.id_productos\n)ax\nLEFT JOIN ec_sucursal_producto sp\nON sp.id_producto = ax.id_producto\nWHERE sp.id_sucursal = 1', 'Comparación entre inventario calculado e inventario acumulado', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Consulta');
    /*Se inserta el menu de sets*/
INSERT INTO `sys_menus` (`id_menu`, `nombre`, `es_listado`, `tabla_relacionada`, `liga`, `menu_padre`, `en_permisos`, `icono`, `orden`, `no_tabla`) VALUES ('137', '1.6 Sets de Productos', '1', 'ec_sets', NULL, '4', '1', NULL, '6', '0');
/*Se inserta el listado de sets*/
DELETE FROM sys_listados WHERE id_listado = 86;
INSERT INTO `sys_listados` (`id_listado`, `titulo`, `tabla`, `no_tabla`, `consulta`, `anchos`, `alineacion`, `campos`, `ver`, `modificar`, `eliminar`, `condicion`, `nuevo`, `buscador`, `consulta_buscador`, `condiciones_buscador`) VALUES
(86, '1.6 Administración de sets de productos', 'ec_sets', 0, 'SELECT\ns.id_set AS ID,\nCONCAT(\'Set de \', sd.cantidad, \' piezas de \', p.nombre_etiqueta) AS NOMBRE,\ns.tipo_set AS TIPO,\nIF( s.habilitado = 1, \'HABILITADO\', \'DESHABILITADO\' ) AS STATUS,\nfecha_alta AS CREACION\nFROM ec_sets s\nLEFT JOIN ec_sets_detalles sd\nON s.id_set = sd.id_set\nLEFT JOIN ec_productos p\nON p.id_productos = sd.id_producto', '0|300|100|100|100', 'center|left|center|center|center', 's.id_set|CONCAT(\'Set de \', sd.cantidad, \'piezas de \', p.nombre_etiqueta)|s.tipo_set|IF( s.habilitado = 1, \'HABILITADO\', \'DESHABILITADO\' )|fecha_alta', 1, 1, 1, 'AND s.id_set > 0', 1, b'1', 'CONCAT(\'Set de \', sd.cantidad, \'piezas de \', p.nombre_etiqueta)', '');
UPDATE `sys_listados` SET `modificar` = '0', `eliminar` = '0', `nuevo` = '0' WHERE `sys_listados`.`id_listado` = 86;
/*Se insertan catalogos de sets*/
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES
(738, 'ec_sets', 0, 'NO', 'fecha_alta', 'Fecha alta : ', 6, 'CHAR', 0, 1, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(737, 'ec_sets', 0, 'NO', 'habilitado', 'Habilitado : ', 5, 'BINARY', 0, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(736, 'ec_sets', 0, 'NO', 'tipo_set', 'Tipo de Set : ', 4, 'COMBO', 0, 1, 0, 0, '', 'barra_tres', NULL, 'SELECT\nax.id_tipo_set,\nax.nombre_set\nFROM(\n(SELECT 2 AS id_tipo_set, \'Set de un producto\' AS nombre_set )\nUNION\n(SELECT 3 AS id_tipo_set, \'Set de 2 o mas \n de un producto\' AS nombre_set )\n)ax\nWHERE 1', 'AND ax.id_tipo_set = ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(735, 'ec_sets', 0, 'NO', 'monto', 'Monto : ', 3, 'FLOAT', 0, 1, 1, 0, NULL, 'barra_tres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(734, 'ec_sets', 0, 'NO', 'nombre', 'Nombre Set : ', 2, 'CHAR', 0, 1, 1, 1, NULL, 'barra_tres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(733, 'ec_sets', 0, 'NO', 'id_set', 'ID : ', 1, 'INT', 1, 1, 0, 0, '(Automático)', 'barra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
/*Se inserta grid de detalle de sets*/
INSERT INTO `sys_grid` (`id_grid`, `nombre`, `display`, `max_width`, `funcion_final`, `tabla_relacionada`, `funcion_nuevo`, `funcion_eliminar`, `scroll`, `alto`, `datosGrid`, `fileGrid`, `footer`, `listado`, `tabla_padre`, `no_tabla`, `orden`, `campo_llave`, `query`, `filas_inicial`, `funcion_despues_eliminar`, `buscador`, `campo_coinc`, `campo_enfoque`, `consulta_coinc`) VALUES
(55, 'setsDetail', 'Detalle de Set', 1000, NULL, 'ec_sets_detalles', 'false', 'false', 'S', 250, '../grid/datosGrid.php?tabla=ec_sets_detalles&id=', '../grid/guardaGrid.php?tabla=ec_sets_detalles&llave=', 'N', 'N', 'ec_sets', 0, 1, 'id_set', 'SELECT\r\nsd.id_set_detalle,\r\nsd.id_set,\r\nsd.id_producto,\r\nCONCAT(p.orden_lista, \' - \', p.nombre, \' - \', p.nombre_etiqueta) AS Producto,\r\nsd.precio_producto,\r\nsd.cantidad,\r\nsd.monto\r\nFROM ec_sets_detalles sd\r\nLEFT JOIN ec_productos p\r\nON p.id_productos = sd.id_producto\r\nWHERE sd.id_set=\'$llave\'', 0, NULL, b'0', '', '', '');
/*Se insertan columnas de grid de detalle de sets*/
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES
(408, 55, 'id_set_detalle', 'id_set_detalle', 'oculto', 'S', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 0, NULL, NULL, 1, 'N'),
(409, 55, 'id_set', 'id_detalle', 'oculto', 'S', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 0, NULL, NULL, 2, 'N'),
(410, 55, 'id_producto', 'id_producto', 'oculto', 'S', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 0, NULL, NULL, 3, 'N'),
(411, 55, 'Producto', 'NO', 'texto', 'S', NULL, 'left', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 300, NULL, NULL, 4, 'N'),
(412, 55, 'Precio x Prod', 'precio_producto', 'decimal', 'S', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 120, NULL, NULL, 5, 'N'),
(413, 55, 'Cantidad', 'cantidad', 'entero', 'S', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 120, NULL, NULL, 6, 'N'),
(414, 55, 'Monto', 'monto', 'decimal', 'S', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 120, NULL, NULL, 7, 'N');

/*Se agrega campo de descuento en la tabla de ventas*/
ALTER TABLE `ec_ventas` ADD `descuento` FLOAT(15,4) NOT NULL DEFAULT '0' AFTER `subtotal`;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('739', 'ec_ventas', '0', 'NO', 'descuento', 'Descuento : ', '11', 'FLOAT', '0', '1', '1', '0', NULL, 'barra_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

/*Se agrega el folio del sistema General al listado de ventas y se agrega buscador*/
UPDATE `sys_listados` SET `consulta` = 'SELECT \r\nv.id_venta AS ID,\r\nv.folio AS Folio,\r\nv.folio_sistema_general AS Folio_General,\r\nc.nombre AS Nombre,\r\nCONCAT(\'$\',FORMAT(v.total,2)) AS Total,\r\nv.fecha AS Fecha,\r\nv.hora AS Hora,\r\nv.folio_fiscal AS \'Folio fiscal\',\r\nIF(v.cancelado=1,\'SI\',\'NO\') AS Cancelado\r\nFROM ec_ventas v\r\nJOIN ec_clientes c ON v.id_cliente =c.id_cliente ', `anchos` = '0|80|100|200|100|80|80|200|100', `alineacion` = 'center|center|center|center|center|center|center|center|center', `campos` = 'v.id_venta|v.folio|v.folio_sistema_general|c.nombre|v.total|v.fecha|v.hora|v.folio_fiscal|IF(v.cancelado=1,\'SI\',\'NO\')' WHERE `sys_listados`.`id_listado` = 76;
UPDATE `sys_listados` SET `buscador` = b'1', `consulta_buscador` = 'v.folio_sistema_general' WHERE `sys_listados`.`id_listado` = 76;

/**/
UPDATE `sys_listados` SET `consulta` = 'SELECT\r\ns.id_set AS ID,\r\nCONCAT(\'Set de \', sd.cantidad, \' piezas de \', p.nombre_etiqueta) AS NOMBRE,\r\ns.monto AS MONTO,\r\nIF(s.tipo_set = 2, \'Un producto\', \'Mas de un producto\') AS TIPO,\r\nIF( s.habilitado = 1, \'HABILITADO\', \'DESHABILITADO\' ) AS STATUS,\r\ns.fecha_alta AS CREACION\r\nFROM ec_sets s\r\nLEFT JOIN ec_sets_detalles sd\r\nON s.id_set = sd.id_set\r\nLEFT JOIN ec_productos p\r\nON p.id_productos = sd.id_producto', `anchos` = '0|300|100|100|100|100', `alineacion` = 'center|left|center|center|center|center', `campos` = 's.id_set|CONCAT(\'Set de \', sd.cantidad, \'piezas de \', p.nombre_etiqueta)|s.monto|s.tipo_set|IF( s.habilitado = 1, \'HABILITADO\', \'DESHABILITADO\' )|fecha_alta' WHERE `sys_listados`.`id_listado` = 86;

/*Reporte de inventario*/
UPDATE `sys_reportes` SET `consulta_sum` = 'SELECT\r\n\'Total\',\r\n\'\',\r\nSUM(Compras),\r\nSUM(Ventas),\r\nSUM(InvFin),\r\n\'\',\r\n\'\',\r\nSUM(UltPreCom*InvFin)\r\nFROM\r\n(\r\nSELECT\r\np.orden_lista,\r\nCONCAT(p.nombre, \' - \' p.nombre_etiqueta),\r\nSUM(\r\n	IF(m.id_compra <> -1 AND m.fecha >= \'$fecIni\' AND m.fecha <= \'$fecFin\',\r\n		IF(md.cantidad IS NULL, 0, md.cantidad),\r\n		0\r\n	)\r\n) AS Compras,\r\nSUM(\r\n	IF(m.id_venta <> -1 AND m.fecha >= \'$fecIni\' AND m.fecha <= \'$fecFin\',\r\n		IF(md.cantidad IS NULL, 0, md.cantidad),\r\n		0\r\n	)\r\n) AS Ventas,\r\nSUM(\r\n	IF(m.fecha <= \'$fecFin\',\r\n		IF(md.cantidad IS NULL, 0, md.cantidad*tm.afecta),\r\n		0\r\n	)\r\n) AS InvFin,\r\n\'\' AS UltPreCom,\r\n\'\' AS PreVen\r\nFROM ec_productos p\r\nLEFT JOIN ec_detalle_movimiento md ON p.id_productos = md.id_producto\r\nLEFT JOIN ec_movimiento_inventario m ON md.id_movimiento_inventario = m.id_movimiento_inventario\r\nLEFT JOIN ec_tipos_movimiento tm ON m.id_tipo_movimiento = tm.id_movimiento\r\nLEFT JOIN ec_ventas pdo ON m.id_venta = pdo.id_venta\r\nLEFT JOIN ec_oc o ON m.id_compra = o.id_orden_compra\r\nWHERE m.fecha <= \'$fecFin\'\r\nXXX\r\nGROUP BY p.id_productos\r\n) p\r\nWHERE 1\r\nORDER BY Compras DESC, Ventas DESC, nombre' WHERE `sys_reportes`.`id_reporte` = 20;
UPDATE `sys_reportes` SET `consulta` = 'SELECT\r\norden_lista,\r\nnombre,\r\nCompras,\r\nVentas,\r\nInvFin,\r\nUltPreCom,\r\nprecio_venta,\r\nUltPreCom*InvFin\r\nFROM\r\n(\r\nSELECT\r\np.orden_lista,\r\nCONCAT(p.nombre, \' - \', p.nombre_etiqueta) AS nombre,\r\nSUM(\r\n	IF(m.id_compra <> -1 AND m.fecha >= \'$fecIni\' AND m.fecha <= \'$fecFin\',\r\n		IF(md.cantidad IS NULL, 0, md.cantidad),\r\n		0\r\n	)\r\n) AS Compras,\r\nSUM(\r\n	IF(m.id_venta <> -1 AND m.fecha >= \'$fecIni\' AND m.fecha <= \'$fecFin\',\r\n		IF(md.cantidad IS NULL, 0, md.cantidad),\r\n		0\r\n	)\r\n) AS Ventas,\r\nSUM(\r\n	IF(m.fecha <= \'$fecFin\',\r\n		IF(md.cantidad IS NULL, 0, md.cantidad*tm.afecta),\r\n		0\r\n	)\r\n) AS InvFin,\r\n(\r\n	SELECT\r\n	ROUND(ec_detalle_compra.precio,2)\r\n	FROM ec_detalle_compra\r\n	JOIN ec_oc ON ec_detalle_compra.id_orden_compra = ec_oc.id_orden_compra\r\n	WHERE ec_oc.fecha <= \'$fecFin\'\r\n        AND ec_detalle_compra.id_producto = p.id_productos\r\n        ORDER BY ec_oc.id_orden_compra DESC\r\n        LIMIT 1\r\n) AS UltPreCom,\r\np.precio_venta\r\nFROM ec_productos p\r\nLEFT JOIN ec_detalle_movimiento md ON p.id_productos = md.id_producto\r\nLEFT JOIN ec_movimiento_inventario m ON md.id_movimiento_inventario = m.id_movimiento_inventario\r\nLEFT JOIN ec_tipos_movimiento tm ON m.id_tipo_movimiento = tm.id_movimiento\r\nLEFT JOIN ec_ventas pdo ON m.id_venta = pdo.id_venta\r\nLEFT JOIN ec_oc o ON m.id_compra = o.id_orden_compra\r\nWHERE m.fecha <= \'$fecFin\'\r\nXXX\r\nGROUP BY p.id_productos\r\n) p\r\nWHERE 1\r\nORDER BY orden_lista' WHERE `sys_reportes`.`id_reporte` = 20;

/*Se agrega campo de folio facturacion en detalle de venta*/
ALTER TABLE `ec_detalle_venta` ADD `folio_facturacion` VARCHAR(40) NOT NULL AFTER `codigo_sat`;

/*Se agrega grid de detalle de movimeinto de almacen en ventas*/
INSERT INTO `sys_grid` (`id_grid`, `nombre`, `display`, `max_width`, `funcion_final`, `tabla_relacionada`, `funcion_nuevo`, `funcion_eliminar`, `scroll`, `alto`, `datosGrid`, `fileGrid`, `footer`, `listado`, `tabla_padre`, `no_tabla`, `orden`, `campo_llave`, `query`, `filas_inicial`, `funcion_despues_eliminar`, `buscador`, `campo_coinc`, `campo_enfoque`, `consulta_coinc`) VALUES
(54, 'detalleMovimientosVentas', 'Detalle de movientos', 1000, NULL, 'ec_detalle_movimiento', 'false', 'false', 'S', 250, '../grid/datosGrid.php?tabla=ec_detalle_movimiento&id=', '../grid/guardaGrid.php?tabla=ec_detalle_movimiento&llave=', 'N', 'N', 'ec_ventas', 0, 3, 'id_venta', 'SELECT\r\n	dm.id_detalle_movimiento,\r\n    dm.id_producto,\r\n    p.orden_lista,\r\n    p.nombre_etiqueta,\r\n    p.nombre,\r\n	dm.cantidad\r\nFROM ec_detalle_movimiento dm \r\nLEFT JOIN ec_movimiento_inventario mi\r\nON mi.id_movimiento_inventario = dm.id_movimiento_inventario\r\nLEFT JOIN ec_productos p\r\nON p.id_productos = dm.id_producto\r\nWHERE mi.id_venta = \'$llave\'', 0, NULL, b'0', '', '', '');
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES
(402, 54, 'id', 'id_detalle_movimiento', 'oculto', 'S', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 0, NULL, NULL, 1, 'N'),
(403, 54, 'id_producto', 'id_producto', 'oculto', 'S', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 0, NULL, NULL, 2, 'N'),
(404, 54, 'Orden Lista', 'NO', 'texto', 'N', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 100, NULL, NULL, 3, 'N'),
(405, 54, 'Nombre de Etiqueta', 'NO', 'texto', 'N', NULL, 'left', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 250, NULL, NULL, 4, 'N'),
(406, 54, 'Nombre', 'NO', 'texto', 'N', NULL, 'left', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 250, NULL, NULL, 5, 'N'),
(407, 54, 'Cantidad', 'cantidad', 'entero', 'N', NULL, 'center', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', 100, NULL, NULL, 6, 'N');


/*Se agregan campos nuevos en */
ALTER TABLE `ec_ventas` ADD `retencion_isr` FLOAT(15,2) NOT NULL DEFAULT '0' AFTER `iva`;
ALTER TABLE `ec_ventas` ADD `total_original` FLOAT(15,2) NOT NULL DEFAULT '0' AFTER `total`;
ALTER TABLE `ec_ventas` ADD `error_por_diferencia_en_montos` INT(1) NOT NULL DEFAULT '0' AFTER `folio_sistema_general`;
ALTER TABLE `ec_detalle_venta` ADD `precio_sin_redondeo` FLOAT(15,6) NOT NULL DEFAULT '0' AFTER `monto`, 
ADD `monto_sin_redondeo` FLOAT(15,6) NOT NULL DEFAULT '0' AFTER `precio_sin_redondeo`, 
ADD `isr_producto` FLOAT(15,6) NOT NULL DEFAULT '0' AFTER `monto_sin_redondeo`, 
ADD `iva_producto` FLOAT(15,6) NOT NULL DEFAULT '0' AFTER `isr_producto`;
ALTER TABLE `ec_detalle_venta` ADD `precio_original` FLOAT(15,6) NOT NULL DEFAULT '0' AFTER `cantidad`, 
ADD `monto_original` FLOAT(15,6) NOT NULL DEFAULT '0' AFTER `precio_original`;
/*Vista de nuevos campos*/
UPDATE `sys_grid` SET `query` = 'SELECT\r\ndv.id_detalle_venta,\r\ndv.id_venta,\r\ndv.id_producto, \r\nIF( dv.id_set != -1, CONCAT( \'Set \', p2.nombre_etiqueta ), p.nombre_etiqueta ),\r\nIF( dv.id_set != -1, CONCAT( \'Set \', p2.nombre ), p.nombre ),\r\ndv.cantidad,\r\ndv.precio,\r\ndv.monto,\r\n(SELECT\r\n SUM( IF( mi.id_movimiento_inventario IS NULL,0, (tm.afecta*dm.cantidad) ) )\r\nFROM ec_detalle_movimiento dm\r\nLEFT JOIN ec_movimiento_inventario mi\r\nON mi.id_movimiento_inventario = dm.id_movimiento_inventario\r\nLEFT JOIN ec_tipos_movimiento tm\r\nON tm.id_movimiento = mi.id_tipo_movimiento\r\nWHERE dm.id_producto = dv.id_producto),\r\ndv.precio_original,\r\ndv.monto_original,\r\ndv.precio_sin_redondeo,\r\ndv.monto_sin_redondeo,\r\ndv.isr_producto,\r\ndv.iva_producto\r\nFROM ec_detalle_venta dv\r\nJOIN ec_productos p \r\nON dv.id_producto = p.id_productos \r\nLEFT JOIN ec_sets_detalles sd\r\nON sd.id_set = dv.id_set\r\nJOIN ec_productos p2 \r\nON sd.id_producto = p2.id_productos \r\nWHERE dv.id_venta =\'$llave\'' WHERE `sys_grid`.`id_grid` = 47;
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES ('415', '47', 'Precio Orig', 'precio_original', 'decimal', 'N', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', '100', NULL, NULL, '10', 'N');
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES ('416', '47', 'Monto Orig', 'monto_original', 'decimal', 'N', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', '100', NULL, NULL, '11', 'N');
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES ('417', '47', 'Prec. s/red', 'precio_sin_redondeo', 'decimal', 'N', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', '100', NULL, NULL, '12', 'N');
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES ('418', '47', 'Monto s/red', 'monto_sin_redondeo', 'decimal', 'N', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', '100', NULL, NULL, '13', 'N');
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES ('419', '47', 'ISR', 'isr_producto', 'decimal', 'N', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', '100', NULL, NULL, '14', 'N');
INSERT INTO `sys_grid_detalle` (`id_grid_detalle`, `id_grid`, `display`, `campo_tabla`, `tipo`, `modificable`, `mascara`, `alineacion`, `formula`, `datosDB`, `depende`, `on_change`, `largo_combo`, `sumatoria`, `funcion_valida`, `on_key`, `valor_inicial`, `requerido`, `ancho`, `html_value`, `on_click`, `orden`, `multiseleccion`) VALUES ('420', '47', 'IVA', 'iva_producto', 'decimal', 'N', NULL, 'right', NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, 'N', '100', NULL, NULL, '15', 'N');
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('740', 'ec_ventas', '0', 'NO', 'total_original', 'Monto Original', '22', 'FLOAT', '0', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('741', 'ec_ventas', '0', 'NO', 'retencion_isr', 'ISR', '12', 'FLOAT', '0', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('742', 'ec_ventas', '0', 'NO', 'error_por_diferencia_en_montos', 'Error en montos', '23', 'BINARY', '0', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

/*Creacion de tabla de errores*/
CREATE TABLE `sys_catalogo_errores_timbrado` (
    `id_error_timbrado` INT NOT NULL AUTO_INCREMENT , 
    `status` INT NOT NULL , 
    `descripcion` VARCHAR(200) NOT NULL , 
    PRIMARY KEY (`id_error_timbrado`)
);/*ENGINE = MyISAM*/
INSERT INTO `sys_catalogo_errores_timbrado` (`id_error_timbrado`, `status`, `descripcion`) VALUES ('1', '301', 'Diferencia en montos');
INSERT INTO `sys_catalogo_errores_timbrado` (`id_error_timbrado`, `status`, `descripcion`) VALUES ('2', '302', 'Error al ejecutar consulta SQL');
INSERT INTO `sys_catalogo_errores_timbrado` (`id_error_timbrado`, `status`, `descripcion`) VALUES ('3', '303', 'Error de configuracion');
INSERT INTO `sys_catalogo_errores_timbrado` (`id_error_timbrado`, `status`, `descripcion`) VALUES ('4', '304', 'Error de diferencia en montos regresado por el SAT.');

/*Se quita la opcion de editar notas de venta*/
UPDATE `sys_listados` SET `modificar` = '0' WHERE `sys_listados`.`id_listado` = 76;
/*creacion de tablas de configuracion de set*/
CREATE TABLE `sys_configuraciones_sets` (
    `id_configuracion_set` INT NOT NULL AUTO_INCREMENT , 
    `limite_vueltas_asignacion_set_secundario` INT NOT NULL , 
    `limite_piezas_asignacion_set_secundario` INT NOT NULL , 
    PRIMARY KEY (`id_configuracion_set`)
);/* ENGINE = MyISAM*/
INSERT INTO `sys_configuraciones_sets` (`id_configuracion_set`, `limite_vueltas_asignacion_set_secundario`, `limite_piezas_asignacion_set_secundario`) VALUES (NULL, '100', '50');
/*Se agrega contador de vueltas para creacion de SET*/
ALTER TABLE `ec_sets` ADD `vueltas_para_su_creacion` INT NOT NULL DEFAULT '0' AFTER `fecha_alta`;
/*Se actualiza la consulta de listados de SET*/
UPDATE `sys_listados` SET `consulta` = 'SELECT\r\ns.id_set AS ID,\r\nGROUP_CONCAT(\'Set de \', sd.cantidad, \' piezas de \', p.nombre_etiqueta SEPARATOR \'//\') AS NOMBRE,\r\ns.monto AS MONTO,\r\nIF(s.tipo_set = 2, \'Un producto\', \'Mas de un producto\') AS TIPO,\r\nIF( s.habilitado = 1, \'HABILITADO\', \'DESHABILITADO\' ) AS STATUS,\r\ns.fecha_alta AS CREACION\r\nFROM ec_sets s\r\nLEFT JOIN ec_sets_detalles sd\r\nON s.id_set = sd.id_set\r\nLEFT JOIN ec_productos p\r\nON p.id_productos = sd.id_producto\r\n', `condicion` = 'AND s.id_set > 0\r\nGROUP BY s.id_set', `consulta_buscador` = 'GROUP_CONCAT(\'Set de \', sd.cantidad, \' piezas de \', p.nombre_etiqueta SEPARATOR \'//\')' WHERE `sys_listados`.`id_listado` = 86;
UPDATE `sys_grid_detalle` SET `sumatoria` = 'S' WHERE `sys_grid_detalle`.`id_grid_detalle` = 414;
UPDATE `sys_grid` SET `query` = 'SELECT\r\ndv.id_detalle_venta,\r\ndv.id_venta,\r\ndv.id_producto, \r\nIF( dv.id_set != -1, CONCAT( \'Set \', p2.nombre_etiqueta ), p.nombre_etiqueta ),\r\nIF( dv.id_set != -1, CONCAT( \'Set \', p2.nombre ), p.nombre ),\r\ndv.cantidad,\r\ndv.precio,\r\ndv.monto,\r\n(SELECT\r\n SUM( IF( mi.id_movimiento_inventario IS NULL,0, (tm.afecta*dm.cantidad) ) )\r\nFROM ec_detalle_movimiento dm\r\nLEFT JOIN ec_movimiento_inventario mi\r\nON mi.id_movimiento_inventario = dm.id_movimiento_inventario\r\nLEFT JOIN ec_tipos_movimiento tm\r\nON tm.id_movimiento = mi.id_tipo_movimiento\r\nWHERE dm.id_producto = dv.id_producto),\r\ndv.precio_original,\r\ndv.monto_original,\r\ndv.precio_sin_redondeo,\r\ndv.monto_sin_redondeo,\r\ndv.isr_producto,\r\ndv.iva_producto\r\nFROM ec_detalle_venta dv\r\nJOIN ec_productos p \r\nON dv.id_producto = p.id_productos \r\nLEFT JOIN ec_sets_detalles sd\r\nON sd.id_set = dv.id_set\r\nJOIN ec_productos p2 \r\nON sd.id_producto = p2.id_productos \r\nWHERE dv.id_venta =\'$llave\'\r\nGROUP BY dv.id_detalle_venta' WHERE `sys_grid`.`id_grid` = 47;


/*Scripts pendientes en DESARROLLO Y QA*/

/*Se agrega menu de configuracion de SETS*/
INSERT INTO `sys_menus` (`id_menu`, `nombre`, `es_listado`, `tabla_relacionada`, `liga`, `menu_padre`, `en_permisos`, `icono`, `orden`, `no_tabla`) VALUES ('138', '4.17 Configuracion de Sets', '1', 'sys_configuraciones_sets', NULL, '1', '1', NULL, '17', '0');
INSERT INTO `sys_listados` (`id_listado`, `titulo`, `tabla`, `no_tabla`, `consulta`, `anchos`, `alineacion`, `campos`, `ver`, `modificar`, `eliminar`, `condicion`, `nuevo`, `buscador`, `consulta_buscador`, `condiciones_buscador`) VALUES ('87', '4.17 Configuracion de Sets', 'sys_configuraciones_sets', '0', 'SELECT\r\nid_configuracion_set,\r\nlimite_vueltas_asignacion_set_secundario,\r\nlimite_piezas_asignacion_set_secundario\r\nFROM sys_configuraciones_sets', '0|200|200', 'center|right|right', 'id_configuracion_set|limite_vueltas_asignacion_set_secundario|limite_piezas_asignacion_set_secundario', '1', '1', '1', NULL, '', b'0', '', '');
UPDATE `sys_listados` SET `consulta` = 'SELECT\r\nid_configuracion_set,\r\nlimite_vueltas_asignacion_set_secundario AS \'Limite de vueltas\',\r\nlimite_piezas_asignacion_set_secundario AS limite_piezas\r\nFROM sys_configuraciones_sets' WHERE `sys_listados`.`id_listado` = 87;

INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('743', 'ec_sets', '0', 'NO', 'vueltas_para_su_creacion', 'Vueltas para crearlo : ', '7', 'INT', '0', '1', '1', '0', NULL, 'barra_tres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('744', 'sys_configuraciones_sets', '0', 'NO', 'id_configuracion_set', 'ID : ', '1', 'INT', '1', '1', '0', '0', '(Automático)', 'barra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('745', 'sys_configuraciones_sets', '0', 'NO', 'limite_vueltas_asignacion_set_secundario', 'Limite de vueltas : ', '2', 'INT', '0', '1', '1', '1', NULL, 'barra_tres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('746', 'sys_configuraciones_sets', '0', 'NO', 'limite_piezas_asignacion_set_secundario', 'Limite de piezas : ', '3', 'INT', '0', '1', '1', '1', NULL, 'barra_tres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

/*Sea grega porcentje de ajustes de set*/
ALTER TABLE `sys_configuraciones_sets` ADD `porcentaje_faltante` DECIMAL NOT NULL DEFAULT '0' AFTER `limite_piezas_asignacion_set_secundario`;
ALTER TABLE `sys_configuraciones_sets` CHANGE `limite_piezas_asignacion_set_secundario` `limite_piezas_asignacion_set_secundario_par` INT(11) NOT NULL;
ALTER TABLE `sys_configuraciones_sets` ADD `limite_piezas_asignacion_set_secundario_impar` INT NOT NULL DEFAULT '0' AFTER `limite_piezas_asignacion_set_secundario_par`;
UPDATE `sys_catalogos` SET `campo` = 'limite_piezas_asignacion_set_secundario_par' WHERE `sys_catalogos`.`id_catalogo` = 746;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('747', 'sys_configuraciones_sets', '0', 'NO', 'limite_piezas_asignacion_set_secundario_par', 'Limite de piezas impar : ', '4', 'INT', '0', '1', '1', '0', NULL, 'barra_tres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
UPDATE `sys_catalogos` SET `campo` = 'limite_vueltas_asignacion_set_secundario' WHERE `sys_catalogos`.`id_catalogo` = 745;
UPDATE `sys_catalogos` SET `campo` = 'limite_piezas_asignacion_set_secundario_impar' WHERE `sys_catalogos`.`id_catalogo` = 746;
UPDATE `sys_catalogos` SET `campo` = 'limite_piezas_asignacion_set_secundario_par' WHERE `sys_catalogos`.`id_catalogo` = 747;
UPDATE `sys_listados` SET `consulta` = 'SELECT\r\nid_configuracion_set,\r\nlimite_vueltas_asignacion_set_secundario AS \'Limite de vueltas\',\r\nlimite_piezas_asignacion_set_secundario_impar AS \'Limite de vueltas impar\',\r\nlimite_piezas_asignacion_set_secundario_par AS \'Limite de vueltas par\',\r\nporcentaje_faltante AS \'Porcentaje Faltante\'\r\nFROM sys_configuraciones_sets', `anchos` = '0|200|200|200|200', `alineacion` = 'center|right|right|right|right', `campos` = 'id_configuracion_set|limite_vueltas_asignacion_set_secundario|limite_piezas_asignacion_set_secundario_impar|limite_piezas_asignacion_set_secundario_par|porcentaje_faltante' WHERE `sys_listados`.`id_listado` = 87;
UPDATE `sys_catalogos` SET `display` = 'Limite de piezas impar : ' WHERE `sys_catalogos`.`id_catalogo` = 746;
UPDATE `sys_catalogos` SET `display` = 'Limite de piezas par : ' WHERE `sys_catalogos`.`id_catalogo` = 747;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('748', 'sys_configuraciones_sets', '0', 'NO', 'porcentaje_faltante', 'Margen porcentaje faltante : ', '5', 'FLOAT', '0', '1', '1', '1', NULL, 'barra_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
ALTER TABLE `sys_configuraciones_sets` CHANGE `porcentaje_faltante` `porcentaje_faltante` FLOAT(10,2) NOT NULL DEFAULT '0';

/*Se quitan las opciondes de eliminar de listados de venta, compra, movimientos de almacen*/
UPDATE sys_listados SET eliminar = 0 WHERE id_listado IN( 24,75,76 );

/*Se agrega campo de Log*/
ALTER TABLE `sys_configuraciones_sets` ADD `log_activado` INT(1) NOT NULL DEFAULT '1' AFTER `porcentaje_faltante`;
/*Se agrega campo de limite de porcentaje faltante*/
ALTER TABLE `sys_configuraciones_sets` ADD `limite_porcentaje_faltante` FLOAT(10,2) NOT NULL DEFAULT '0' AFTER `log_activado`;
UPDATE `sys_catalogos` SET `orden` = '7' WHERE `sys_catalogos`.`id_catalogo` = 749;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES
(749, 'sys_configuraciones_sets', 0, 'NO', 'log_activado', 'Log activo : ', 7, 'BINARY', 0, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('750', 'sys_configuraciones_sets', '0', 'NO', 'limite_porcentaje_faltante', 'Limite máximo porcentaje asignación faltante (por producto): ', '6', 'FLOAT', '0', '1', '1', '1', NULL, 'bara_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
/*Se agrega el id autoincrementable de las apis*/
ALTER TABLE `api_config` ADD `id` INT NOT NULL AUTO_INCREMENT FIRST, ADD PRIMARY KEY (`id`);
/*Se inserta el path de administracion de facturacion y sistema General Linea*/
INSERT INTO `api_config` (`id`, `key`, `name`, `value`, `description`) VALUES
(20, 'magento', 'token', 'xpnu12jgjefbe3t4jcf6hwv5r5eyf7f7', 'Token actual para integración con magento'),
(21, 'facturacion', 'path_facturacion', 'http://pruebascdll2024.space/desarrollo_administracion_facturacion', 'Path de api para consumir servicios de administración de facturación.');

/*Se modfica la precision del detalle de la nota a 6 decimales*/
ALTER TABLE `ec_detalle_venta` CHANGE `precio` `precio` FLOAT(15,6) NOT NULL, CHANGE `monto` `monto` FLOAT(15,6) NOT NULL;
/*Se agrega el campo de contacto para enlazar contacto a la nota de venta*/
ALTER TABLE `ec_ventas` ADD `id_cliente_contacto` INT NULL AFTER `error_por_diferencia_en_montos`;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('751', 'ec_ventas', '0', 'NO', 'id_cliente_contacto', 'Correo Destino : ', '24', 'COMBO', '0', '1', '1', '0', NULL, 'barra_tres', NULL, 'SELECT\r\nid_cliente_contacto,\r\ncorreo\r\nFROM ec_clientes_contacto\r\nWHERE 1', 'AND id_cliente_contacto = ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
/*Se agrega la tabla de prefijos de sets*/
CREATE TABLE `ec_prefijos_sets` (
    `id_prefijo_set` INT NOT NULL AUTO_INCREMENT , 
    `nombre` VARCHAR(100) NOT NULL , 
    `habilitado` INT(1) NOT NULL DEFAULT '1' , 
    `fecha_alta` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , 
    PRIMARY KEY (`id_prefijo_set`)
) ENGINE = InnoDB;
/*
Se agrega menu y listado de prefijos de sets*/
INSERT INTO `sys_menus` (`id_menu`, `nombre`, `es_listado`, `tabla_relacionada`, `liga`, `menu_padre`, `en_permisos`, `icono`, `orden`, `no_tabla`) VALUES ('139', '4.18 Prefijos de Sets', '1', 'ec_prefijos_sets', NULL, '1', '1', NULL, '18', '0');
INSERT INTO `sys_listados` (`id_listado`, `titulo`, `tabla`, `no_tabla`, `consulta`, `anchos`, `alineacion`, `campos`, `ver`, `modificar`, `eliminar`, `condicion`, `nuevo`, `buscador`, `consulta_buscador`, `condiciones_buscador`) VALUES ('88', '4.18 Prefijos de Sets', 'ec_prefijos_sets', '0', 'SELECT \r\nid_prefijo_set, \r\nnombre, `\r\nhabilitado,\r\nfecha_alta`\r\nFROM ec_prefijos_sets \r\nWHERE 1', '0|200|100|120', 'center|left|center|right', 'id_prefijo_set|nombre|habilitado|fecha_alta', '0', '0', '0', NULL, '0', b'0', 'nombre', '');
UPDATE `sys_listados` SET `consulta` = 'SELECT \r\nid_prefijo_set, \r\nnombre,\r\nhabilitado,\r\nfecha_alta\r\nFROM ec_prefijos_sets', `buscador` = b'0' WHERE `sys_listados`.`id_listado` = 88;
/*Se agreag campo de clave de sat en tabla de sets*/
ALTER TABLE `ec_sets` ADD `clave_sat` VARCHAR(20) NOT NULL AFTER `fecha_alta`;

/*Se habilita boton de editar en listado de ventas*/
UPDATE `sys_listados` SET `modificar` = '1', `buscador` = b'1' WHERE `sys_listados`.`id_listado` = 76;
/*Se inserta tabla, menu listado y campos de la tabla de permisos especiales*/
CREATE TABLE `ec_permisos_especiales` ( 
    `id_permiso_especial` INT NOT NULL AUTO_INCREMENT ,  
    `password_edicion_timbrado_ventas` VARCHAR(50) NOT NULL ,    
    PRIMARY KEY  (`id_permiso_especial`)
) ENGINE = InnoDB;
INSERT INTO `ec_permisos_especiales` (`id_permiso_especial`, `password_edicion_timbrado_ventas`) VALUES ('1', 'contrasena');
INSERT INTO `sys_menus` (`id_menu`, `nombre`, `es_listado`, `tabla_relacionada`, `liga`, `menu_padre`, `en_permisos`, `icono`, `orden`, `no_tabla`) VALUES ('140', '4.19 Permisos y accesos Especiales', '1', 'ec_permisos_especiales', NULL, '1', '1', NULL, '19', '0');
INSERT INTO `sys_listados` (`id_listado`, `titulo`, `tabla`, `no_tabla`, `consulta`, `anchos`, `alineacion`, `campos`, `ver`, `modificar`, `eliminar`, `condicion`, `nuevo`, `buscador`, `consulta_buscador`, `condiciones_buscador`) VALUES ('89', '4.19 Permisos y accesos Especiales', 'ec_permisos_especiales', '0', 'SELECT\r\nid_permiso_especial AS ID,\r\n\'Permisos especiales\' AS Nombre\r\nFROM ec_permisos_especiales', '0|300', 'center|left', 'id_permiso_especial|\'Permisos especiales\'', '1', '1', '0', NULL, '0', b'0', '', '');
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('752', 'ec_permisos_especiales', '0', 'NO', 'id_permiso_especial', 'ID : ', '1', 'INT', '1', '1', '0', '0', '(Automático)', 'barra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('753', 'ec_permisos_especiales', '0', 'NO', 'password_edicion_timbrado_ventas', 'Contraseña edidcion/timbrado ventas', '2', 'PASSWORD', '0', '1', '1', '1', NULL, 'barra_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

/*Se regresan los cambios*/
UPDATE `sys_listados` SET `modificar` = '0', `buscador` = b'1' WHERE `sys_listados`.`id_listado` = 76;
DROP TABLE ec_permisos_especiales;
DELETE FROM sys_menus WHERE id_menu = 140;
DELETE FROM sys_listados WHERE id_listado = 89;
DELETE FROM sys_catalogos WHERE id_catalogo IN(752, 753);

/*Se agrega noombre del set en grid de detalle de venta*/
UPDATE `sys_grid` SET `query` = 'SELECT\r\ndv.id_detalle_venta,\r\ndv.id_venta,\r\ndv.id_producto, \r\nIF( dv.id_set != -1, s.nombre, p.nombre_etiqueta ),\r\nIF( dv.id_set != -1, s.nombre, p.nombre ),\r\ndv.cantidad,\r\ndv.precio,\r\ndv.monto,\r\n(SELECT\r\n SUM( IF( mi.id_movimiento_inventario IS NULL,0, (tm.afecta*dm.cantidad) ) )\r\nFROM ec_detalle_movimiento dm\r\nLEFT JOIN ec_movimiento_inventario mi\r\nON mi.id_movimiento_inventario = dm.id_movimiento_inventario\r\nLEFT JOIN ec_tipos_movimiento tm\r\nON tm.id_movimiento = mi.id_tipo_movimiento\r\nWHERE dm.id_producto = dv.id_producto),\r\ndv.precio_original,\r\ndv.monto_original,\r\ndv.precio_sin_redondeo,\r\ndv.monto_sin_redondeo,\r\ndv.isr_producto,\r\ndv.iva_producto\r\nFROM ec_detalle_venta dv\r\nJOIN ec_productos p \r\nON dv.id_producto = p.id_productos \r\nLEFT JOIN ec_sets s\r\nON s.id_set = dv.id_set\r\nWHERE dv.id_venta =\'$llave\'\r\nGROUP BY dv.id_detalle_venta', `buscador` = b'1' WHERE `sys_grid`.`id_grid` = 47;

/************************************************************************
*                                                                       *
*                       </Scripts en Produccion>                        *
*                                                                       *
*************************************************************************/

/************************************************************************
*                                                                       *
*                            <Scripts en QA>                            *
*                                                                       *
*************************************************************************/
/*
Se agregan campos de monto_compras_actual, monto_ventas_atual en tabla de limites de razones sociales*/
ALTER TABLE `ec_limites_razon_social` ADD `monto_compras_actual` DOUBLE(10,2) NOT NULL DEFAULT '0' AFTER `limite_compras`;
ALTER TABLE `ec_limites_razon_social` ADD `monto_ventas_actual` DOUBLE(10,2) NOT NULL DEFAULT '0' AFTER `limite_ventas`;

/*
Se agrega el api de sistema General en Razones Sociales*/
INSERT INTO `api_config` (`id`, `key`, `name`, `value`, `description`) VALUES ('14', 'api', 'path', 'http://172.16.1.116/desarrollo/desarrollo_general_2025', 'Ruta de endpoints Sistema General');




INSERT INTO `sys_menus` (`id_menu`, `nombre`, `es_listado`, `tabla_relacionada`, `liga`, `menu_padre`, `en_permisos`, `icono`, `orden`, `no_tabla`) VALUES ('140', '6.3 Ingreso de ventas manual', '1', 'ec_ventas', NULL, '132', '1', NULL, '3', '1');
INSERT INTO `sys_listados` (`id_listado`, `titulo`, `tabla`, `no_tabla`, `consulta`, `anchos`, `alineacion`, `campos`, `ver`, `modificar`, `eliminar`, `condicion`, `nuevo`, `buscador`, `consulta_buscador`, `condiciones_buscador`) VALUES
(89, ' Notas de ventas', 'ec_ventas', 1, 'SELECT \r\nv.id_venta AS ID,\r\nv.folio AS Folio,\r\nv.folio_sistema_general AS Folio_General,\r\nc.nombre AS Nombre,\r\nCONCAT(\'$\',FORMAT(v.total,2)) AS Total,\r\nv.fecha AS Fecha,\r\nv.hora AS Hora,\r\nv.folio_fiscal AS \'Folio fiscal\',\r\nIF(v.cancelado=1,\'SI\',\'NO\') AS Cancelado\r\nFROM ec_ventas v\r\nJOIN ec_clientes c ON v.id_cliente =c.id_cliente ', '0|80|100|200|100|80|80|200|100', 'center|center|center|center|center|center|center|center|center', 'v.id_venta|v.folio|v.folio_sistema_general|c.nombre|v.total|v.fecha|v.hora|v.folio_fiscal|IF(v.cancelado=1,\'SI\',\'NO\')', 1, 0, 0, NULL, 0, b'1', 'v.folio_sistema_general', '');
UPDATE `sys_listados` SET `modificar` = '1', `eliminar` = '1', `buscador` = b'1' WHERE `sys_listados`.`id_listado` = 89;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES
(752, 'ec_ventas', 1, 'NO', 'id_cliente_contacto', 'Correo Destino : ', 24, 'COMBO', 0, 1, 1, 0, NULL, 'barra_tres', NULL, 'SELECT\r\nid_cliente_contacto,\r\ncorreo\r\nFROM ec_clientes_contacto\r\nWHERE 1', 'AND id_cliente_contacto = ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(753, 'ec_ventas', 1, 'NO', 'error_por_diferencia_en_montos', 'Error en montos', 23, 'BINARY', 0, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(754, 'ec_ventas', 1, 'NO', 'retencion_isr', 'ISR', 12, 'FLOAT', 0, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(755, 'ec_ventas', 1, 'NO', 'total_original', 'Monto Original', 22, 'FLOAT', 0, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(756, 'ec_ventas', 1, 'NO', 'descuento', 'Descuento : ', 11, 'FLOAT', 0, 1, 1, 0, NULL, 'barra_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(757, 'ec_ventas', 1, 'NO', 'folio_sistema_general', 'Folio Sistema General', 21, 'CHAR', 0, 1, 0, 0, NULL, 'barra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(758, 'ec_ventas', 1, 'NO', 'facturacion_productos_especificos', 'Facturacion con productos especificos', 20, 'BINARY', 0, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(759, 'ec_ventas', 1, 'NO', 'cfdi', 'CFDI:', 16, 'COMBO', 0, 1, 1, 1, NULL, 'barra_dos', NULL, 'SELECT id,\nCONCAT(nombre,\'(\',clave,\')\')\nFROM ec_cfdi\n\nWHERE 1', 'AND \nid=', 'ORDER BY orden ASC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(760, 'ec_ventas', 1, 'NO', 'clave_cliente', 'Numero de cuenta de pago', 19, 'CHAR', 0, 1, 1, 0, NULL, 'barra_dos', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000, NULL, NULL, NULL, NULL),
(761, 'ec_ventas', 1, 'NO', 'id_metodo_pago', 'Forma de pago', 16, 'COMBO', 0, 1, 1, 1, NULL, 'barra_dos', 0, 'SELECT\r\nid_metodo_pago,\r\nnombre \r\nFROM ec_metodos_pago\r\nWHERE 1', 'AND id_metodo_pago=', 'ORDER BY nombre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(762, 'ec_ventas', 1, 'NO', 'id_forma_pago', 'Método de pago', 15, 'COMBO', 0, 1, 1, 1, NULL, 'barra_dos', 0, 'SELECT\r\nid_forma_pago,\r\nnombre \r\nFROM ec_forma_pago\r\nWHERE 1', 'AND id_forma_pago=', 'ORDER BY orden ASC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(763, 'ec_ventas', 1, 'NO', 'numero_orden', 'No. de orden', 3, 'CHAR', 0, 1, 1, 0, '', 'barra_tres', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(764, 'ec_ventas', 1, 'NO', 'id_sucursal', 'id_sucursal', 18, 'INT', 0, 0, 0, 0, '$SUCURSAL', 'barra_dos', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 11, NULL, NULL, NULL, NULL),
(765, 'ec_ventas', 1, 'NO', 'id_usuario', 'id_usuario', 17, 'INT', 0, 0, 1, 1, '$USUARIO', 'barra_dos', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 11, NULL, NULL, NULL, NULL),
(766, 'ec_ventas', 1, 'NO', 'id_cliente', 'Cliente', 14, 'BUSCADOR', 0, 1, 1, 1, NULL, 'barra_dos', 0, 'SELECT\nid_cliente,\nCONCAT( nombre, \' - \', id_cliente ) AS nombre \nFROM ec_clientes\nWHERE id_cliente >= 10000 AND nombre LIKE \'%$LLAVE%\'', 'SELECT id_cliente, nombre FROM ec_clientes WHERE id_cliente=', 'ORDER BY nombre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(767, 'ec_ventas', 1, 'NO', 'total', 'Total', 13, 'FLOAT', 0, 1, 0, 0, '0', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(768, 'ec_ventas', 1, 'NO', 'iva', 'iva', 12, 'FLOAT', 0, 1, 0, 0, '0', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(769, 'ec_ventas', 1, 'NO', 'subtotal', 'Subtotal', 11, 'FLOAT', 0, 1, 0, 0, '0', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(770, 'ec_ventas', 1, 'NO', 'hora', 'Hora', 10, 'TIME', 0, 1, 0, 0, '$TIME', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, NULL, NULL),
(771, 'ec_ventas', 1, 'NO', 'fecha', 'Fecha', 9, 'DATE', 0, 1, 0, 0, '$DATE', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, NULL, NULL),
(772, 'ec_ventas', 1, 'NO', 'certificado_sat', 'Sello SAT', 8, 'CHAR', 0, 1, 0, 0, NULL, 'barra', 500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000, NULL, NULL, NULL, NULL),
(773, 'ec_ventas', 1, 'NO', 'cadena_original', 'Cadena original', 7, 'CHAR', 0, 1, 0, 0, NULL, 'barra', 500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000, NULL, NULL, NULL, NULL),
(774, 'ec_ventas', 1, 'NO', 'sello_digital', 'Sello CFD', 6, 'CHAR', 0, 1, 0, 0, NULL, 'barra', 500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000, NULL, NULL, NULL, NULL),
(775, 'ec_ventas', 1, 'NO', 'certificado_csd', 'Certificado', 5, 'CHAR', 0, 1, 0, 0, NULL, 'barra', 500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000, NULL, NULL, NULL, NULL),
(776, 'ec_ventas', 1, 'NO', 'folio_fiscal', 'Folio fiscal', 4, 'CHAR', 0, 1, 0, 0, NULL, 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000, NULL, NULL, NULL, NULL),
(777, 'ec_ventas', 1, 'NO', 'folio', 'Folio', 2, 'CHAR', 0, 1, 0, 0, '(Automático)', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60, NULL, NULL, NULL, NULL),
(778, 'ec_ventas', 1, 'NO', 'id_venta', 'ID', 1, 'INT', 1, 1, 0, 0, '(Automático)', 'barra', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 11, NULL, NULL, NULL, NULL);

/*
Se agrega endpoint de facturacion*/
INSERT INTO `api_config` (`id`, `key`, `name`, `value`, `description`) VALUES ('22', 'rs_facturacion', 'rs_facturacion', 'http://172.16.1.115/produccion_2025/razones_sociales/', 'Endpoint RS del sistema de facturacion');

/*
Se agrega menu de pantalla de ingreso manual de ventas*/
INSERT INTO `sys_menus` (`id_menu`, `nombre`, `es_listado`, `liga`, `menu_padre`, `en_permisos`, `icono`, `orden`, `no_tabla`) 
VALUES ('141', '6.3 Ingreso de ventas manual', '0', 'code/especiales/ventas_manuales/index.php?', '132', '1', NULL, '3', '0');
UPDATE `sys_menus` SET `nombre` = '1.7 Facturación de ventas manual', `menu_padre` = '4', `orden` = '7' WHERE `sys_menus`.`id_menu` = 140;


ALTER TABLE `sys_configuraciones_sets` ADD `procentaje_ajuste_precio_producto_candidato` VARCHAR(200) NOT NULL AFTER `limite_porcentaje_faltante`;
UPDATE `sys_configuraciones_sets` SET `procentaje_ajuste_precio_producto_candidato` = 'Sets.php//se agrega valor absoluto del margen de descuento de precio del 10% Oscar 2024-10-31' WHERE `sys_configuraciones_sets`.`id_configuracion_set` = 1;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) 
VALUES ('779', 'sys_configuraciones_sets', '0', 'NO', 'procentaje_ajuste_precio_producto_candidato', 'Porcentaje de ajuste de precio producto candidato', '8', 'CHAR', '0', '1', '0', '0', NULL, 'barra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

/************************************************************************
*                                                                       *
*                            </Scripts en QA>                           *
*                                                                       *
************************************************************************/

/************************************************************************
*                                                                       *
*                        <Scripts en Desarrollo>                        *
*                                                                       *
*************************************************************************/


/************************************************************************
*                                                                       *
*                       </Scripts en Desarrollo>                        *
*                                                                       *
*************************************************************************/

/*
Se agrega el campo de margen_porcentaje_precio_productos_candidatos en tabla de configuracion de SETS y su catalogo*/
ALTER TABLE `sys_configuraciones_sets` ADD `margen_porcentaje_precio_productos_candidatos` FLOAT(15,2) NOT NULL AFTER `limite_porcentaje_faltante`;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('780', 'sys_configuraciones_sets', '0', 'NO', 'margen_porcentaje_precio_productos_candidatos', 'Margen porcentaje precio productos candidatos', '9', 'FLOAT', '0', '1', '1', '1', NULL, 'barra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

ALTER TABLE `sys_configuraciones_sets` ADD `porcentaje_minimo_precio_primer_set` FLOAT(15,4) NOT NULL AFTER `margen_porcentaje_precio_productos_candidatos`, 
ADD `porcentaje_ajuste_precio_producto_candidato_primer_set` FLOAT(15,4) NOT NULL AFTER `porcentaje_minimo_precio_primer_set`;
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('781', 'sys_configuraciones_sets', '0', 'NO', 'porcentaje_minimo_precio_primer_set', 'Porcentaje minimo de precio en primer set', '10', 'FLOAT', '0', '1', '1', '1', '0', 'barra_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_catalogos` (`id_catalogo`, `tabla`, `no_tabla`, `tab`, `campo`, `display`, `orden`, `tipo`, `es_llave`, `visible`, `modificable`, `requerido`, `valor_inicial`, `clase`, `longitud`, `sql_combo`, `where_combo`, `order_combo`, `on_focus`, `on_blur`, `on_click`, `on_change`, `on_keypress`, `on_keydown`, `on_keyup`, `max_length`, `extensiones`, `especificacion`, `clase_esp`, `depende`) VALUES ('782', 'sys_configuraciones_sets', '0', 'NO', 'porcentaje_ajuste_precio_producto_candidato_primer_set', 'Porcentaje ajuste precio producto candidato primer set', '11', 'FLOAT', '0', '1', '1', '1', '0', 'barra_dos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
UPDATE `sys_catalogos` SET `campo` = 'porcentaje_ajuste_precio_producto_candidato' WHERE `sys_catalogos`.`id_catalogo` = 779;
UPDATE `sys_catalogos` SET `tabla` = 'sys_configuraciones_sets_' WHERE `sys_catalogos`.`id_catalogo` = 779;


cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/angel_maximo && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/antonia_estrada && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/casa_luces_bazar && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/checo && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/chema && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/jose_hernandez && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/jose_luis && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/maximo_hernandez && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/monica_estrada && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/pedro_estrada && git pull
cd /var/www/html/desarrollo_2025/desarrollo_razones_sociales/veronica_estrada && git pull

cd /var/www/html/qa_2025/qa_razones_sociales/angel_maximo && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/antonia_estrada && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/casa_luces_bazar && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/checo && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/chema && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/jose_hernandez && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/jose_luis && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/maximo_hernandez && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/monica_estrada && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/pedro_estrada && git pull
cd /var/www/html/qa_2025/qa_razones_sociales/veronica_estrada && git pull    

cd /var/www/html/produccion_2025/razones_sociales/angel_maximo && git pull
cd /var/www/html/produccion_2025/razones_sociales/antonia_estrada && git pull
cd /var/www/html/produccion_2025/razones_sociales/casa_luces_bazar && git pull
cd /var/www/html/produccion_2025/razones_sociales/checo && git pull
cd /var/www/html/produccion_2025/razones_sociales/chema && git pull
cd /var/www/html/produccion_2025/razones_sociales/jose_hernandez && git pull
cd /var/www/html/produccion_2025/razones_sociales/jose_luis && git pull
cd /var/www/html/produccion_2025/razones_sociales/maximo_hernandez && git pull
cd /var/www/html/produccion_2025/razones_sociales/monica_estrada && git pull
cd /var/www/html/produccion_2025/razones_sociales/pedro_estrada && git pull
cd /var/www/html/produccion_2025/razones_sociales/veronica_estrada && git pull

CREATE USER 'desarrollo_2025'@'%' IDENTIFIED BY 'Acc3s0.2023';
GRANT ALL PRIVILEGES ON *.* TO 'desarrollo_2025'@'%' WITH GRANT OPTION;
FLUSH PRIVILEGES;




/*Agregar productos sin sucursal_producto*/
INSERT INTO `ec_sucursal_producto`(`id_sucursal_producto`, `id_sucursal`, `id_producto`, `inventario`)
SELECT
	NULL,
    1,
    ax.id_productos,
    0
FROM(
	SELECT 
    	p.id_productos
    FROM ec_productos p
    LEFT JOIN ec_sucursal_producto sp
    ON p.id_productos = sp.id_producto
    WHERE sp.id_producto IS NULL
)ax;