<?php
include("fpdf.php");

class PDF extends FPDF
{
    // Función para verificar si la cadena está en UTF-8
    function is_utf8($str)
    {
        return mb_detect_encoding($str, 'UTF-8', true) !== false;
    }

    // Texto con verificación UTF-8
    function Texto($x, $y, $cadena)
    {
        if ($this->is_utf8($cadena)) {
            // No es necesario usar utf8_decode si ya está en UTF-8
            $cadena = mb_convert_encoding($cadena, 'ISO-8859-1', 'UTF-8');//utf8_decode($cadena);
        }
        parent::Text($x, $y, $cadena);
    }

    // Texto con tamaño de fuente personalizado y verificación UTF-8
    function TextoF($x, $y, $cadena, $tam)
    {
        if ($this->is_utf8($cadena)) {
            // No es necesario usar utf8_decode si ya está en UTF-8
            $cadena = mb_convert_encoding($cadena, 'ISO-8859-1', 'UTF-8');// utf8_decode($cadena);
        }
        $aux = $this->FontSizePt;
        parent::SetFont($this->FontFamily, "", $tam);
        parent::Text($x, $y, $cadena);
        parent::SetFont($this->FontFamily, "", $aux);
    }

    // Texto en negrita con verificación UTF-8
    function TexBold($x, $y, $cadena)
    {
        if ($this->is_utf8($cadena)) {
            // No es necesario usar utf8_decode si ya está en UTF-8
            $cadena = mb_convert_encoding($cadena, 'ISO-8859-1', 'UTF-8');//utf8_decode($cadena);
        }
        parent::SetFont($this->FontFamily, "B", $this->FontSizePt);
        parent::Text($x, $y, $cadena);
        parent::SetFont($this->FontFamily, "", $this->FontSizePt);
    }

    // Texto en negrita con tamaño de fuente personalizado y verificación UTF-8
    function TexBoldF($x, $y, $cadena, $tam)
    {
        if ($this->is_utf8($cadena)) {
            // No es necesario usar utf8_decode si ya está en UTF-8
            $cadena = mb_convert_encoding($cadena, 'ISO-8859-1', 'UTF-8');//utf8_decode($cadena);
        }
        $aux = $this->FontSizePt;
        parent::SetFont($this->FontFamily, "B", $tam);
        parent::Text($x, $y, $cadena);
        parent::SetFont($this->FontFamily, "", $aux);
    }

    // Establecer posición de coordenadas (x,y) a (1,1)
    function ya0()
    {
        $this->y = 1;
        $this->x = 1;
    }

    // Obtener posición Y actual
    function obty()
    {
        return $this->y;
    }

    // Celda con texto en UTF-8
    function celpos($xa, $ya, $ancho, $fuente, $cad, $border = 0, $align = "")
    {
        if ($this->is_utf8($cad)) {
            // No es necesario usar utf8_decode si ya está en UTF-8
            $cad = mb_convert_encoding($cad, 'ISO-8859-1', 'UTF-8');//utf8_decode($cad);
        }
        $aux = $this->FontSizePt;
        parent::SetFont($this->FontFamily, "", $fuente);
        $alto = ($fuente * 0.35) / 10;
        if ($xa > 0) $this->x = $xa;
        if ($ya > 0) $this->y = $ya;
        parent::MultiCell($ancho, $alto, $cad, $border, $align);
        parent::SetFont($this->FontFamily, "", $aux);
    }

    // Celda en negrita con texto en UTF-8
    function celposB($xa, $ya, $ancho, $fuente, $cad, $border = 0, $align = "")
    {
        if ($this->is_utf8($cad)) {
            // No es necesario usar utf8_decode si ya está en UTF-8
            $cad = mb_convert_encoding($cad, 'ISO-8859-1', 'UTF-8');//utf8_decode($cad);
        }
        $aux = $this->FontSizePt;
        parent::SetFont($this->FontFamily, "B", $fuente);
        $alto = ($fuente * 0.35) / 10;
        if ($xa > 0) $this->x = $xa;
        if ($ya > 0) $this->y = $ya;
        parent::MultiCell($ancho, $alto, $cad, $border, $align);
        parent::SetFont($this->FontFamily, "", $aux);
    }
}
?>
