
import events from './utils/constants.js';
import Queue from './utils/queue.js';

const connectWebSocketGetNet = (ws_ref) => {
  const PING_TIMEOUT_GETNET = 1000 * 5 + 1000 * 1;
  const QUEUE_INTERVAL_GETNET = 1000 * 30 + 1000 * 1;
  const RECONNECT_INTERVAL_GETNET = 1000 * 10 + 1000 * 1;
  const PING_VALUE_GETNET = 1;

  const ACKNOWLEDGEMENT_EVENTS_CLIENTS_GETNET = [
    events.INFORM_VIEWED_TRANSACTION,
    events.INFORM_FOLIO_GETNET,
  ];

  /*var ws = new WebSocket('ws://localhost:3000', [
    '7dff3c34-faee-11ea-a7be-3d014d7f956c',
    'true',
  ]);*/
  wsGetNet = new WebSocket( $url_websocket_getNet + `${$token_websocket}`);
  /*
    , [
    $token_websocket,
    $usuario_websocket,
    $sucursal_websocket
  ]
  */
  wsGetNet.isProcessing = false;
  wsGetNet.eventQueue = ws_ref ? ws_ref.eventQueue : new Queue();
  wsGetNet.actualTransaction = ws_ref ? ws_ref.actualTransaction : null;
  wsGetNet.actualFolio = ws_ref ? ws_ref.actualFolio : null;
  wsGetNet.currentTransaction = ws_ref ? ws_ref.currentTransaction : null;
  wsGetNet.viewedFolios = ws_ref ? ws_ref.actualTransaction : [];

  const isBinaryGetNet = (obj) => {
    return (
      typeof obj === 'object' &&
      Object.prototype.toString.call(obj) === '[object Blob]'
    );
  };

  const pingGetNet = () => {
    if (!wsGetNet) {
      return;
    } else if (!!wsGetNet.pingTimeout) {
      clearTimeout(wsGetNet.pingTimeout);
    }

    wsGetNet.pingTimeout = setTimeout(() => {
      wsGetNet.close();
      window.reconnectInterval = setInterval(
        reconnectInterval,
        RECONNECT_INTERVAL_GETNET,
      );
    }, PING_TIMEOUT_GETNET);

    const data = new Uint8Array(1);
    data[0] = PING_VALUE_GETNET;
    wsGetNet.send(data);
  };

  const reconnectInterval = () => {
    if (wsGetNet.readyState === wsGetNet.CLOSED) {
      connectWebSocketGetNet(ws);
    }
  };

  wsGetNet.queueInterval = setInterval(() => {
    console.log(
      'Ejecutando queue con processing: ',
      wsGetNet.isProcessing,
      ' queue: ',
      wsGetNet.eventQueue,
    );
    wsGetNet.eventQueue.get().forEach((event) => {
      if (!wsGetNet.isProcessing && wsGetNet.queueFunction) {
        wsGetNet.queueFunction(event);
      }
    });
  }, QUEUE_INTERVAL_GETNET);

  wsGetNet.sendAcknowledgmentGetNet = (eventType) => {
    wsGetNet.send(
      JSON.stringify({
        type: eventType,
      }),
    );
  };

  wsGetNet.addEventListener('open', (event) => {
    clearInterval(window.reconnectInterval);
    window.reconnectInterval = null;
    if (wsGetNet.onConnection) {
      wsGetNet.onConnection();
    }
    console.log(`Connection started GETNET`);
  });

  wsGetNet.addEventListener('error', (event) => {
    console.log('Error on WS GETNET : ', event);
  });

  wsGetNet.addEventListener('message', (event) => {
    if (isBinaryGetNet(event.data)) {
        pingGetNet();
    } else {
      let jsonMsg = JSON.parse(event.data);
      if (jsonMsg) {
        console.log(`Received msg: `, jsonMsg);
        if (wsGetNet.msgFunction) {
          wsGetNet.msgFunction(jsonMsg);
        }
      }
    }
  });

  wsGetNet.addEventListener('close', () => {
    console.log(`Connection closed`);

    if (!!wsGetNet.pingTimeout) {
      clearTimeout(wsGetNet.pingTimeout);
    }

    clearInterval(wsGetNet.queueInterval);
    if (!window.reconnectInterval) {
      reconnectInterval();
      window.reconnectInterval = setInterval(
        reconnectInterval,
        RECONNECT_INTERVAL_GETNET,
      );
    }
  });

  wsGetNet.queueFunction = (event) => {
    if (event === event.INFORM_VIEWED_TRANSACTION) {
      wsGetNet.sendViewedTransactions();
    } else if (event === event.GET_TRANSACTION_STATUS) {
      wsGetNet.refreshTransaction();
    }else if (event === event.INFORM_FOLIO_GETNET) {
      wsGetNet.informFolio();
    }
  };

  wsGetNet.sendViewedTransactions = () => {
    wsGetNet.isProcessing = true;
    wsGetNet.send(
      JSON.stringify({
        type: events.INFORM_VIEWED_TRANSACTION,
        folios: wsGetNet.viewedFolios,
      }),
    );
    wsGetNet.isProcessing = false;
    wsGetNet.eventQueue.add(events.INFORM_VIEWED_TRANSACTION);
  };

  wsGetNet.refreshTransaction = () => {
    wsGetNet.isProcessing = true;
    wsGetNet.send(
      JSON.stringify({
        type: events.GET_TRANSACTION_STATUS,
        payload: wsGetNet.currentTransaction,
      }),
    );
    wsGetNet.isProcessing = false;
    wsGetNet.eventQueue.add(events.GET_TRANSACTION_STATUS);
  };
  
  wsGetNet.informFolio = () => {
    wsGetNet.isProcessing = true;
    wsGetNet.send(
      JSON.stringify({
        type: events.INFORM_FOLIO_GETNET,
        folio: wsGetNet.actualFolio,
      }),
    );
    wsGetNet.isProcessing = false;
    wsGetNet.eventQueue.add(events.INFORM_FOLIO_GETNET);
  };

//aqui llega respuesta
  wsGetNet.msgFunction = (jsonMsg) => {
    console.log(jsonMsg);
    
    //ACKNOWLEDGEMENT_EVENTS_CLIENTS_GETNETif (jsonMsg.type == events.INFORM_VIEWED_TRANSACTION) {
    if (ACKNOWLEDGEMENT_EVENTS_CLIENTS_GETNET.includes(jsonMsg.type)) {
      wsGetNet.eventQueue.remove(jsonMsg.type);
    } else if (jsonMsg.type == events.INFORM_TRANSACTIONS) {//aqui llegan las transacciones
        console.log("Transaction : ");
        console.log(jsonMsg);
      let folios = [];
      jsonMsg.transactions.forEach((transaction) => {//aqui esta la respuesta de transacciones
/*habilitado por oscar 2024-07-01 para no ver en la vista las transacciones pendientes*/
      $( '#stop' ).click();
      //aqui brinca la emergente
      //aqui brinca la emergente
        $( ".emergent_content" ).html( `<div class="text-center bg-danger">
          <br>
          <br>
          <h2 class="text-light text-center">${transaction.message} ( ${transaction.traceability ? transaction.traceability.folio_venta : transaction.folio_venta } ) </h2>
          <h2 class="text-light text-center">Recargar la pagina y volver a escanear el ticket</h2>
          <br>
          <br>
          <div class="row text-center">
            <div class="col-3"></div>
            <div class="col-6">
              <button
                type="button"
                class="btn btn-warning form-control"
                style="font-size:200%;"
                onclick="marcar_notificacion_vista_getNet( '${transaction.TrxReference ? transaction.TrxReference : transaction.folio_unico }', ${transaction.TrxReference ? true : false } );"
              ><i class="icon-spin3">OK</i>
              </button>
              <br>
              <br>
              </div>
            </div>
          </div>` );
        $( ".emergent" ).css( "display", "block" );//deshabilitado por Oscar marcar_notificacion_vista( '${transaction.traceability ? transaction.traceability.folio_unico_transaccion : transaction.folio_unico }' );
//desarrollar boton para indicador de visto
        folios.push(transaction.folio_unico);
      });

      wsGetNet.sendAcknowledgmentGetNet(jsonMsg.type);
      //wsGetNet.viewedFolios = [...folios, ...wsGetNet.viewedFolios];
      //wsGetNet.sendViewedTransactions();
    } else if (jsonMsg.type == events.ACTUAL_TRANSACTION) {
      wsGetNet.sendAcknowledgmentGetNet(jsonMsg.type);
      wsGetNet.actualTransaction = jsonMsg.transaction;//aqui esta la respuesta de transacciones
      //aqui brinca la emergente
        $( '#stop' ).click();
        $( ".emergent_content" ).html( `<h2 class="text-success text-center">${wsGetNet.actualTransaction.TrxResult.trim() == 'APPROVED' ? "Transacción exitosa" : wsGetNet.actualTransaction.TrxDescription.trim()}</h2>
				<div class="text-center">
					<button
						type="button"
						class="btn btn-success"
						onclick="marcar_notificacion_vista( '${wsGetNet.actualTransaction.TrxReference ? wsGetNet.actualTransaction.TrxReference : wsGetNet.actualTransaction.folio_unico}', ${wsGetNet.actualTransaction.TrxResult.trim() == 'APPROVED' || jsonMsg.transaction.TrxResult.trim() == 'APPROVED' ? true : false } );"
					><i class="icon-ok=circle">Aceptar y marcar notificación como vista</i>
					</button>
          </div>` );
        $( ".emergent" ).css( "display", "block" );
    } else if (jsonMsg.type == events.SEND_TRANSACTION_STATUS) {
      wsGetNet.sendAcknowledgmentGetNetGetNet(jsonMsg.type);
      console.log( jsonMsg.transaction );
     //aqui brinca la emergente
      $( '#stop' ).click();
      $( ".emergent_content" ).html( `<h2 class="text-success text-center">${jsonMsg.transaction.message}</h2>
      <div class="text-center">
        <button
          type="button"
          class="btn btn-success"
          onclick="marcar_notificacion_vista( '${jsonMsg.transaction.folio_unico}', ${jsonMsg.transaction.message.trim() == 'Transacción exitosa' || jsonMsg.transaction.message.trim() == 'Transaccion exitosa' ? true : false } );"
        ><i class="icon-ok=circle">Aceptar y marcar notificación como vista</i>
        </button>
        </div>` );
      $( ".emergent" ).css( "display", "block" );
      //console.log(jsonMsg);
    }
  };
};

connectWebSocketGetNet();