    function buildSupplyList(rows){
		var resp = ``;
		var row_color_class = "";
		var supply_btn_status = "";
		var supply_btn_id = "";
		var supply_class = "";
        var supply_special_icon = "";
        var supply_status_edition = "";
        var supply_status_btn = "";
	//itera surtimientos
		for (const key in rows) {
			row_color_class = "bg-silver";
            supply_status_btn = "primary";
			if(key % 2 == 0 ){//par
				row_color_class = "bg-light";
			}
        //edicion de status cabecera de surtimiento
            if($('#user_profile_is_admin').val().trim() == 1){
                supply_status_edition = `show_supply_header_edition_form(${rows[key].id}, '${rows[key].supply_status_id}');`;
            }
            if(rows[key].supply_status_id == 5){
                supply_status_btn = "dark";
            }else if(rows[key].supply_status_id == 3){
                supply_status_btn = "warning text-dark";
            }else if(rows[key].supply_status_id == 2){
                supply_status_btn = "info";
            }
			resp += `<tr id="row_${key}" class="${row_color_class}">
                    <td class="h5">${rows[key].id}</td>
                    <td class="text-start h5">${rows[key].nombre_vendedor}</td>
                    <td class="text-center h5">
                        <span class="badge btn-${supply_status_btn}" onclick="${supply_status_edition}">${rows[key].estado}</span>
                    </td>
                </tr>
                <tr id="row_${key}_buttons" class="${row_color_class}">
                    <td colspan="3" class="m-0 p-0">
						<div class="row" style="max-width:100% !important;margin-left : 1px;">`;
		//itera rango de ubicaciones para generar botones
			for (const keyDetail in rows[key].supply_detail) {
				if(rows[key].supply_detail[keyDetail].detail == null){
					supply_btn_status = "disabled";
					supply_btn_id = null;
					supply_class = "btn-silver text-secondary";
                    supply_special_icon = "";
				}else{
					supply_btn_status = "";
                    supply_special_icon = "";
					supply_btn_id = rows[key].supply_detail[keyDetail].detail.id_surtimiento_por_rango;
					supply_class = "btn-success";
                    if(rows[key].supply_detail[keyDetail].detail.range_status == 3){//pausado
                        supply_class = "btn-warning";
                        supply_special_icon = "icon-play";
                    }else if(rows[key].supply_detail[keyDetail].detail.range_status == 4 ){
                        supply_btn_status = "disabled";
                        supply_class = "btn-transparent text-success border-success border-3";
                        supply_special_icon = "";
                    }else if(rows[key].supply_detail[keyDetail].detail.range_status == 5){
                        supply_btn_status = "disabled";
                        supply_class = "btn-dark";
                    }
				}
                var onclick = `onclick="startSupply(${supply_btn_id});"`;
               
				resp += `<div class="col-4 text-center mb-3">
							<button
								type="button"
								class="${supply_class} m-0 p-0 form-control"
								${onclick}
								${supply_btn_status}
							>
								<p class="text-center m-1 ${supply_special_icon}">${rows[key].supply_detail[keyDetail].location_range}</p>
							</button>`; 
                if($('#user_profile_is_admin').val().trim() == 1){
                    onclick = `onclick="editSupply(${supply_btn_id});"`;
                    resp += `<button
								type="button"
								class="${supply_class} mt-1 p-0 form-control"
								${onclick}
							>
								<p class="text-center m-1 icon-tools"></p>
							</button>`;
                }
                resp += `</div>`;
			}
            resp += `</div>
					</td>
            	</tr>`;
		}
		return resp;
	}
    
    function product_form (json_data){
        if(json_data.seller_id ==  "" || json_data.seller_id ==  null){
            localStorage.removeItem('supply_range_id');
            location.reload();
        }
        product_providers = json_data.product_providers;
        localStorage.setItem('supply_range_id', json_data.supply_range_id);
        json_data.supplied_quantity = (json_data.supplied_quantity == null ? 0 : json_data.supplied_quantity );
        quantity_difference = (json_data.supply_quantity-json_data.supplied_quantity);
        content = `<div class="row">
            <h3 class="text-center">Pedido # ${json_data.supply_id}</h3>
            <small class="text-center mb-2">Partida <b>${json_data.counters.current_supply_counter}</b> de <b>${json_data.counters.details_total}</b></small>
            <h4 class="text-center">${json_data.product_name}</h4>
            <div>
            <div class="text-center" id="claves_proveedor_">`;
        for (const key in json_data.product_providers) {
            content += `<span class="btn-secondary m-1 p-1">${json_data.product_providers[key].product_provider_model}</span>`;
        }
        content += `</div>
            </div>
            <p>Ubicacion : <b id="current_product_location">${json_data.product_location}</b></p>
            <p class="text-info">Piezas surtidas anteriormente: <b id="">${json_data.supplied_quantity}</b></p>
            <p>Piezas solicitadas: <b id="required_quantity">${quantity_difference}</b></p>
            <div class="input-group">
                <input type="text" id="barcode_input" placeholder="Escanear Producto" class="form-control" onkeyup="validateBarcode(event);">
                <button
                    class="btn btn-success"
                    onclick="validateBarcode('intro');"
                >
                    <i class="icon-barcode"></i>
                </button>
            </div>
            <div class="hidden" id="supply_quantity_container">
                Surtido :
                <input type="number" id="supply_quantity_input" class="form-control">
                <div class="text-center mb-2 p-3">
                    <button
                        class="btn btn-primary p-1 form-control"
                        onclick="updateSupplyDetail(${json_data.supply_detail_id}, ${json_data.supply_range_id}, ${json_data.seller_id}, null)"
                    >
                        <i class="icon-ok-circled">Siguiente</i>
                    </button>
                </div>
            </div>
            <div class="row mb-2 p-3">
                <div class="col-6 text-center p-0">
                    <button
                        class="btn btn-danger p-2"
                        onclick="updateSupplyDetail(${json_data.supply_detail_id}, ${json_data.supply_range_id}, ${json_data.seller_id}, 0);"
                    >
                        <i class="icon-minus text-small">Sin existencias</i>
                    </button>
                </div>
                <div class="col-6 text-center p-0">
                    <button
                        class="btn btn-warning p-2"
                        onclick="exit_supply_form(${json_data.supply_detail_id});"
                    >
                        <i class="icon-pause text-small">Pausar Surtimiento</i>
                    </button>
                </div>
            <div>
        </div>`;
        return content;
    }

    function exit_supply_form(supply_detail_id){
        var content = `<div class="text-center">
            <h3>Para salir del surtimiento pide al encargado que ingrese su contraseña :</h3>
            <div class="input-group">
                <input type="password" id="mannager_password" onkeyup="exit_supply(event, ${supply_detail_id});" placeholder="***Contrasena de encargado***" class="form-control">
                <button
                    type="button"
                    class="btn btn-success"
                    onclick="exit_supply('intro', ${supply_detail_id});"
                >
                    <i class="icon-barcode"></i>
                </button>
                <div id="password_response" class="text-danger m-2 hidden"></div>
            </div>
        </div>
        <div class="text-center m-3">
            <button
                type="button"
                class="btn btn-danger form-control"
                onclick="close_emergent_2();"
            >
                <i class="icon-cancel-circled">Cancelar y cerrar</i>
            </button>
        </div>`;
        $('.emergent_content_2').html(content);
        $('.emergent_2').css("display", "block");
        $('#mannager_password').focus();
    }

    function finished_supply_message(row){
        var content = `<div>
            <h2 class="text-center text-danger mt-2 h1">Surtimiento Finalizado</h2>
            <h4 class="text-center mt-2 h3">No hay mas productos por surtir</h4>
            <h4 class="text-center mt-2 mb-2 h3">Entrega la mercancia a : </h4>
            <input type="text" class="form-control text-primary" value="${row.seller_name}">
            <button
                type="button"
                class="btn btn-success form-control"
                onclick="close_finished_supply_message();"
            >
                <i class="icon-print">Aceptar e Imprimir</i>
            </button>
        </div>`;
        return content;
    }

    function supply_edition_form(json_data, supply_edition_form){//console.log(json_data);
        var button_pause = "";
        var button_cancel = "";
        var content = `<div>
            <div class="text-end">
                <button
                    type="button"
                    class="btn btn-white text-danger"
                    onclick="close_emergent();"
                >
                    X
                </button>
            </div>
            <h2 class="text-center text-danger">Detalles de surtimiento</h2>
            <div class="row p-1">
                <table class="table table-bordered mt-2">
                    <thead class="bg-danger text-light">
                        <tr>
                            <th class="text-center">Producto</th>
                            <th class="text-center">Surtidor</th>
                            <th class="text-center">Solicitado</th>
                            <th class="text-center">Surtido</th>
                        </tr>
                    </thead>
                    <tbody>`;
        for (const key in json_data.detail) {
            json_data.detail[key].suplied_quantity = (json_data.detail[key].suplied_quantity == null ? 0 : json_data.detail[key].suplied_quantity);
            content += `<tr>
                <td class="text-start">(${json_data.detail[key].product_list_order}) ${json_data.detail[key].product_name}</td>
                <td class="text-start">${json_data.detail[key].supplier_name}</td>
                <td class="text-end">${json_data.detail[key].solicited_quantity}</td>
                <td class="text-end">${json_data.detail[key].suplied_quantity}</td>
            </tr>`;
        }
        if(json_data.supply_status_id <= 2){//pendiente, surtiendo
            button_pause = `<button
                class="btn btn-warning form-control p-1"
                onclick="updateRangeSuppyStatus(${json_data.supply_range_id}, 3);"
            >
                <i class="icon-pause">Pausar</i>
            </button>`;
        }else if(json_data.supply_status_id == 3){//pausado
            button_pause = `<button
                class="btn btn-success form-control p-1"
                onclick="updateRangeSuppyStatus(${json_data.supply_range_id}, 1);"
            >
                <i class="icon-play">Reanudar</i>
            </button>`;
        }
    //condicion de boton para cancelar
        if(json_data.supply_status_id <= 3){//finalizado, cancelado
            button_cancel = `<button
                class="btn btn-dark form-control p-1"
                onclick="updateRangeSuppyStatus(${json_data.supply_range_id}, 5)"
            >
                <i class="icon-trash">No surtir</i>
            </button>`;
        }
        content += `</tbody>
                </table>
            </div>
            <div class="row p-1">
                <div class="col-6">
                    ${button_pause}
                </div>
                <div class="col-6">
                    ${button_cancel}
                </div>
            </div>
        </div>`;
        return content;
    }

    function supply_header_edition(supply_id, status){
        var btn_pause_action = ``;
        var btn_cancel_action = `<button
                type="button"
                class="btn btn-dark"
                onclick="update_all_supply(${supply_id}, 5);"
            >
                <i class="icon-trash">Cancelar todo el surtimiento</i>
            </button>`;
        if(status <= 2 ){
            btn_pause_action = `<button
                type="button"
                class="btn btn-warning"
                onclick="update_all_supply(${supply_id}, 3);"
            >
                <i class="icon-pause">Pausar todo el surtimiento</i>
            </button>`;
        }else if(status == 3){
            btn_pause_action = `<button
                type="button"
                class="btn btn-success"
                onclick="update_all_supply(${supply_id}, 1);"
            >
                <i class="icon-play">Reanudar Surtimiento</i>
            </button>`;
        }
        
        var content = `<div>
            <div class="text-end">
                <button
                    type="button"
                    class="btn btn-white text-danger"
                    onclick="close_emergent();"
                >
                    X
                </button>
                <div class="text-center">
                    <h3>Pausar / Cancelar Pedido</h3>
                    <br>
                    ${btn_pause_action}
                    <br>
                    <br>
                    ${btn_cancel_action}
                </div>
            </div>`;
        return content;
    }